<?php

namespace App\Helper;

use App\Models\ReminderCustomerDocument;
use App\Models\EmailContent;
use Illuminate\Support\Facades\Session;
use App\Mail\EmailTemplete;
use App\Models\MailSendLog;
use App\Models\ReminderAttachment;
use App\Models\User;
use App\Models\UserPermision;
use App\Models\MailSendLogDocument;
use App\Models\CustomerContactDetail;
use App\Models\AppSetting;
use App\Models\SchedulerReminder;
use App\Models\Heading;
use App\Models\Quotation;
use App\Models\QuotationService;
use App\Models\Department;
use App\Models\CustomerUser;
use App\Models\EmployeeUser;
use App\Models\EmailContentAttachment;
use Mail;
use File;
use PDF;
use DB;
use Storage;
use PhpOffice\PhpWord\PhpWord;
use PhpOffice\PhpWord\Shared\Html;
use Intervention\Image\Facades\Image;
class Helpers
{
    public static function GetMessageHeaderHtml(){
        $html = '';
        $reminder_detail_query = ReminderCustomerDocument::select('customer_id', DB::raw('count(id) as total_count'), DB::raw('MIN(id) as id'), DB::raw('MIN(upload_document) as upload_document'))->with('Reminder')->where('reminder_customer_documents.upload_status', 1)->Where('status','0');//->WhereNotNull('upload_document')
        $unread_count = $reminder_detail_query->groupBy('customer_id')->count();
        $html .= '<li class="dropdown dropdown-notification nav-item"><a class="nav-link nav-link-label" href="'.route('admin.dashboard').'"><i style="font-size: 30px;color: black;" class="fa fa-envelope" id="notification-navbar-link"></i><span class="badge badge-pill badge-sm badge-danger badge-up badge-glow">'.$unread_count.'</span></a>';
        $html .= '</li>';
        return $html;
    }
    public static function Auth(){
        $auth = \Illuminate\Support\Facades\Session::get('customer_details');    
        return (object)$auth;
    }
    public static function ReminderMail($reminder_id,$customer_id,$action_flage = '',$selected_reminder_customer_documents_id = 0){
        $current_date = date('Y-m-d');
        $destinationPath = public_path('images').config('constants.DOCUMENT');
        $new_docs_destinationPath = public_path('images').config('constants.NEW_DOCUMENT');
        File::makeDirectory($new_docs_destinationPath, $mode = 0777, true, true);
        $reminder_document_list = ReminderCustomerDocument::with('CustomerUser')->with('Reminder')->with('Document')->with('Document.Assignment')->where('reminder_id',$reminder_id)->where('customer_id',$customer_id)->where('reminder_customer_documents.upload_status', 0);//->WhereNull('upload_document');
        if($selected_reminder_customer_documents_id > 0){
            $reminder_document_list->where('id',$selected_reminder_customer_documents_id);
        }
        $reminder_document_list = $reminder_document_list->get();
        $EmailContent =  EmailContent::where('status','1')->where('id',config('constants.MAIL_TEMPLATE.Reminder_Send'))->first();
        if(is_object($EmailContent) && is_object($reminder_document_list)){
            $EmailContent_subject = $EmailContent->subject;
            $EmailContent_title = $EmailContent->title;
            $email_body = $EmailContent->content;
            $scheduler_reminder_id = 0;
            $list_of_docs = '';
            $reminder_name = 'Reminder';
            $from_email = '';
            $login_user_id = 0;
            $customer_name = '';
            $scheduler_mail_content = '';
            $customer_address = '';
            $customer_email = array();
            $files = array();
            $document_ids = array();
            $customer_cc_email = array();
            $app_setting = AppSetting::first();
            if($app_setting){
                $cc_email = $app_setting->cc_email;
                if($cc_email != ''){
                    $customer_cc_email_array = explode(',',$cc_email);
                    if(count($customer_cc_email_array) > 0){
                        foreach($customer_cc_email_array as $customer_cc_email_array_val){
                            if($customer_cc_email_array_val != ''){
                                $customer_cc_email[] = $customer_cc_email_array_val;
                            } 
                        }
                    }
                }
            }
            $YearEndDate_val = '';
            $CurrentDate_val = '';
            foreach($reminder_document_list as $reminder_document_list_val){
                $reminder_customer_documents_id = $reminder_document_list_val->id;
                $status = $reminder_document_list_val->status;
                $document_id = $reminder_document_list_val->document_id;
                $document_ids[] = $document_id;
                $reject_note = '';
                if($status == 2){
                    $reject_note = ' : <span style="color:red;">Reject Note : '.$reminder_document_list_val->reject_notes.'</span>';
                }
                $db_file_name = 'Assignment-Document';
                if($reminder_document_list_val->Document){
                    $list_of_docs .= $reminder_document_list_val->Document->name.' '.$reject_note.'<br>';
                    $doc_name = $reminder_document_list_val->Document->name;
                    $assignment_name = '';
                    if($reminder_document_list_val->Document->Assignment){
                        $assignment_name = $reminder_document_list_val->Document->Assignment->name;
                    }
                    if($assignment_name == ''){
                        $assignment_name = 'Assignment';
                    }
                    $db_file_name = $assignment_name.'-'.$doc_name;
                }
                if($reminder_document_list_val->Reminder){
                    $reminder_name = $reminder_document_list_val->Reminder->name;
                    $from_email = $reminder_document_list_val->Reminder->from_email;
                    $login_user_id = $reminder_document_list_val->Reminder->login_user_id;
                    if($from_email != ''){
                        $customer_cc_email[] = $from_email;
                    }    
                    $CurrentDate_val = $reminder_document_list_val->Reminder->current_date_value;
                    $YearEndDate_val = $reminder_document_list_val->Reminder->year_end;
                    $contact_customer_id_to = $reminder_document_list_val->Reminder->contact_customer_id_to;
                    if($contact_customer_id_to != ''){
                        $selected_customer_id_to = array();
                        $customer_id_to_array = json_decode($contact_customer_id_to,true);
                        if(count($customer_id_to_array) > 0){
                            foreach($customer_id_to_array as $customer_id_to_array_val){
                                $selected_customer_id_to[] = $customer_id_to_array_val;
                            }
                        }
                        if(count($selected_customer_id_to) > 0){
                            $CustomerUser_detail = CustomerContactDetail::select('email')->where('customer_id',$customer_id)->whereIn('id', $selected_customer_id_to)->get();
                            if($CustomerUser_detail){
                                foreach($CustomerUser_detail as $CustomerUser_detail_val){
                                    if($CustomerUser_detail_val->email != ''){
                                        $customer_email[] = $CustomerUser_detail_val->email;
                                    }    
                                }
                            }
                        }
                    }
                    $contact_customer_id_cc = $reminder_document_list_val->Reminder->contact_customer_id_cc;
                    if($contact_customer_id_cc != ''){
                        $selected_customer_id_cc = array();
                        $customer_id_cc_array = json_decode($contact_customer_id_cc,true);
                        if(count($customer_id_cc_array) > 0){
                            foreach($customer_id_cc_array as $customer_id_cc_array_val){
                                $selected_customer_id_cc[] = $customer_id_cc_array_val;
                            }
                        }
                        if(count($selected_customer_id_cc) > 0){
                            $CustomerUser_detail = CustomerContactDetail::select('email')->where('customer_id',$customer_id)->whereIn('id', $selected_customer_id_cc)->get();
                            if($CustomerUser_detail){
                                foreach($CustomerUser_detail as $CustomerUser_detail_val){
                                    if($CustomerUser_detail_val->email != ''){
                                        $customer_cc_email[] = $CustomerUser_detail_val->email;
                                    }    
                                }
                            }
                        }
                    }
                    $EmailContent_subject = str_ireplace('{{ReminderName}}',$reminder_name,$EmailContent_subject);
                    $scheduler_reminder_id = $reminder_document_list_val->Reminder->scheduler_reminder_id;
                    if($scheduler_reminder_id > 0){
                        $SchedulerReminderDetail =  SchedulerReminder::where('id',$scheduler_reminder_id)->first();
                        $SchedulerRemindername = $SchedulerReminderDetail->name;
                        $scheduler_mail_content = $SchedulerReminderDetail->mail_content;
                        if(is_object($EmailContent)){
                            $EmailContent =  EmailContent::where('status','1')->where('id',config('constants.MAIL_TEMPLATE.Schedule_Mail'))->first();
                            if(is_object($EmailContent)){
                                $EmailContent_subject = $EmailContent->subject;
                                $EmailContent_subject = str_ireplace('{{ScheduleSubject}}',$SchedulerRemindername,$EmailContent_subject);
                                $email_body = $EmailContent->content;
                                $EmailContent_title = $EmailContent->title;
                            }
                        }    
                    }        
                }
                if($reminder_document_list_val->CustomerUser){
                    $customer_name = $reminder_document_list_val->CustomerUser->name;
                    $address = $reminder_document_list_val->CustomerUser->address;
                    $address_2 = $reminder_document_list_val->CustomerUser->address_2;
                    if($address_2 != ''){
                        $address_2 = '<br></br>'.$address_2;
                    }
                    $address_3 = $reminder_document_list_val->CustomerUser->address_3;
                    if($address_3 != ''){
                        $address_3 = '<br></br>'.$address_3;
                    }
                    $customer_address = $address.'<br></br>'.$address_2.'<br></br>'.$address_3;
                    $customer_email[] = $reminder_document_list_val->CustomerUser->email_address;
                      
                }
                $doc_content = $reminder_document_list_val->doc_content;
                if($doc_content != ''){
                    if($YearEndDate_val != ''){
                        $YearEndDate_val = date('d/m/Y',strtotime($YearEndDate_val));
                    }  
                    if($CurrentDate_val != ''){
                        $CurrentDate_val = date('d/m/Y',strtotime($CurrentDate_val));
                    }
                    $doc_content = str_ireplace('{{{CLIENTNAME}}}',$customer_name,$doc_content);
                    $doc_content = str_ireplace('{{{CLIENTADDRESS}}}',$customer_address,$doc_content);
                    $doc_content = str_ireplace('{{{YearEndDate}}}',$YearEndDate_val,$doc_content);
                    $doc_content = str_ireplace('{{{CurrentDate}}}',$CurrentDate_val,$doc_content);
                    //$doc_file_name = $reminder_document_list_val->doc_file_name;
                    //$file_name_path = $new_docs_destinationPath.$doc_file_name;
                    // if(file_exists($file_name_path)){

                    // }else{
                        $phpWord = new \PhpOffice\PhpWord\PhpWord();
                        $phpWord->setDefaultParagraphStyle( array(
                            'lineHeight' => 1.0,
                            'spaceAfter'=>0,
                         ) );
                        $section = $phpWord->addSection();
                        $doc_content = str_ireplace("<p>",  "<p style='line-height: 0px;'>",    $doc_content);
                        $html = \PhpOffice\PhpWord\Shared\Html::addHtml($section, $doc_content);
                        $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
                        $doc_file_name = $db_file_name.'.docx';
                        $file_name_path = $new_docs_destinationPath.$doc_file_name;
                        ReminderCustomerDocument::withTrashed()->where('id',$reminder_customer_documents_id)->update(['doc_file_name' => $doc_file_name]);
                        $objWriter->save($file_name_path);
                    //}    
                    $files[] = $file_name_path;
                }    
            }
            $customer_email = array_unique($customer_email);
            $customer_cc_email = array_unique($customer_cc_email);
            if($list_of_docs != '' && count($customer_email) > 0){
                $UrlLink = '<a href="' . route('upload.document', array('reminder_id' => $reminder_id,'customer_id'=>$customer_id)) . '">Click Here</a>';
                $email_body = str_ireplace('{{UrlLink}}',$UrlLink,$email_body);
                $email_body = str_ireplace('{{LISTOFDOCUMENT}}',$list_of_docs,$email_body);
                $email_body = str_ireplace('{{ReminderName}}',$reminder_name,$email_body);
                $email_body = str_ireplace('{{CustomerName}}',$customer_name,$email_body);
                $email_body = str_ireplace('{{MailContent}}',$scheduler_mail_content,$email_body);
                $auth = auth()->user();
                $UserDetail =  User::withTrashed()->where('id',$login_user_id)->first();
                $LoginUserName = isset($auth->name) ? $auth->name : '';
                $LoginUserDesignation = '';
                $LoginUserMobileNumber = '';
                $LoginUserEmail = '';
                $LoginUserQr = '';
                if(is_object($UserDetail)){
                    $LoginUserName = isset($UserDetail->name) ? $UserDetail->name : '';
                    $LoginUserDesignation = isset($UserDetail->designation) ? $UserDetail->designation : '';
                    $LoginUserphonecode = isset($UserDetail->phonecode) ? $UserDetail->phonecode : '';
                    $LoginUsermobile = isset($UserDetail->mobile) ? $UserDetail->mobile : '';
                    $LoginUserMobileNumber = $LoginUserphonecode.' '.$LoginUsermobile;
                    $LoginUserEmail = isset($UserDetail->email) ? $UserDetail->email : '';
                    $LoginUserQr = isset($UserDetail->qr_image_url) ? $UserDetail->qr_image_url : '';
                    if($LoginUserQr != ''){
                        $LoginUserQr = '<img src="'.$LoginUserQr.'" width="100">';
                    }
                } 
                $email_body = str_ireplace('{{LoginUserName}}','<div style="font-size:16px; font-weight:700; color:#f39c12; margin-bottom:4px;">'.$LoginUserName.'</div>',$email_body);
                $email_body = str_ireplace('{{LoginUserDesignation}}','<div style="font-size:13px; color:#4a4a4a; margin-bottom:8px;">'.$LoginUserDesignation.'</div>',$email_body);
                $email_body = str_ireplace('{{LoginUserMobileNumber}}','<a href="tel:'.$LoginUserMobileNumber.'" style="color:#1a73e8; text-decoration:none;">'.$LoginUserMobileNumber.'</a>',$email_body);
                $email_body = str_ireplace('{{LoginUserEmail}}','<a href="mailto:'.$LoginUserEmail.'" style="color:#1a73e8; text-decoration:none;">'.$LoginUserEmail.'</a>',$email_body);
                $email_body = str_ireplace('{{LoginUserQr}}',$LoginUserQr,$email_body);
                $AttachmentFiles =  ReminderAttachment::where('status','1')->where('reminder_id',$reminder_id)->get();
                if($AttachmentFiles){
                    foreach($AttachmentFiles as $AttachmentFiles_val){
                        $upload_document = $AttachmentFiles_val->upload_document;
                        $files[] = $destinationPath.$upload_document;
                    }
                }
                $MailSendLog_count = MailSendLog::where('reminder_id',$reminder_id)->where('customer_id',$customer_id)->count();
                if($MailSendLog_count > 0){
                    $EmailContent_subject = 'Reminder '.$MailSendLog_count.' '.$EmailContent_subject;
                }
                //$from_email = 'reminder@bakertilly-ug.com';
                //////////////////////////////////////////////////////
                $blockedDomains = [
                    '@madelineadvisory.in',
                ];
                $removed_to_email = array_filter($customer_email, function ($email) use ($blockedDomains)  {
                    foreach ($blockedDomains as $domain) {
                        if (str_ends_with($email, $domain)) {
                            return true; // mark as removed
                        }
                    }
                    return false;
                });
                $customer_email = array_filter($customer_email, function ($email) use ($blockedDomains) {
                    foreach ($blockedDomains as $domain) {
                        if (str_ends_with($email, $domain)) {
                            return false; // skip this one
                        }
                    }
                    return true;
                });  
                ///////////////////////////////////////////////////////////
                $removed_cc_email = array_filter($customer_cc_email, function ($email) use ($blockedDomains)  {
                    foreach ($blockedDomains as $domain) {
                        if (str_ends_with($email, $domain)) {
                            return true; // mark as removed
                        }
                    }
                    return false;
                });
                $customer_cc_email = array_filter($customer_cc_email, function ($email) use ($blockedDomains) {
                    foreach ($blockedDomains as $domain) {
                        if (str_ends_with($email, $domain)) {
                            return false; // skip this one
                        }
                    }
                    return true;
                });
                ////////////////////////////////////////////////////////
                $mailData = [
                    'from_email' => $from_email,
                    'title' => $EmailContent_title,
                    'customer_cc_email' => $customer_cc_email,
                    'body' => $email_body,
                    'subject' => $EmailContent_subject,
                    'files' => $files
                ];
                try {
                    Mail::to($customer_email)->send(new EmailTemplete($mailData));
                    $mail_responce = 'Mail sent successfully!';
                } catch (TransportException $e) {
                    $mail_responce = $e->getMessage();
                } catch (\Exception $e) {
                    $mail_responce = $e->getMessage();
                } 
                $current_date_time = date('Y-m-d H:i:s');
                $main_send_log = new MailSendLog();
                $main_send_log->name = 'Reminder Send';
                $main_send_log->reminder_id = $reminder_id;
                $main_send_log->customer_id = $customer_id;
                $main_send_log->from_email = $from_email;
                $customer_email_insert = implode(',',$customer_email);
                $main_send_log->to_email = $customer_email_insert;
                $customer_email_cc_insert = implode(',',$customer_cc_email);
                $main_send_log->cc_email = $customer_email_cc_insert;
                $main_send_log->send_date = $current_date_time;
                $main_send_log->title = $EmailContent_title;
                $main_send_log->subject = $EmailContent_subject;
                $main_send_log->body = $email_body;
                $main_send_log->action_flage = $action_flage;
                $main_send_log->mail_responce = $mail_responce;
                $main_send_log->save();
                if(count($document_ids) > 0){
                    foreach ($document_ids as $key => $document_id_value) {
                        $main_send_log_document = new MailSendLogDocument();
                        $main_send_log_document->mail_send_log_id = $main_send_log->id;
                        $main_send_log_document->document_id = $document_id_value;
                        $main_send_log_document->save();    
                    }
                }
                //////////////////////////////////////////////////////////
                if(count($removed_to_email) > 0 || count($removed_cc_email) > 0){
                    $not_send_body = '';
                    $not_send_subject = '';
                    try {
                        $not_send_email = array('alpesh.koyani@igentechnolabs.com','krishna.rathi@bakertilly.ug');//
                        $not_send_subject = 'NOT SENDED == '.$mailData['subject'];
                        $mailData['subject'] = $not_send_subject;
                        if(count($removed_to_email) > 0){
                            $not_send_body .= 'TO EMAIL ADDRESS NOT SEND EMAIL ==>'.implode(',',$removed_to_email).'<br>';
                        }
                        if(count($removed_cc_email) > 0){
                            $not_send_body .= 'CC EMAIL ADDRESS NOT SEND EMAIL ==>'.implode(',',$removed_cc_email).'<br>';
                        }
                        $not_send_body .= '<br>'.$mailData['body'];
                        $mailData['body'] = $not_send_body;
                        Mail::to($not_send_email)->send(new EmailTemplete($mailData));
                        $not_send_mail_responce = 'Mail sent successfully!';
                    } catch (TransportException $e) {
                        $not_send_mail_responce = $e->getMessage();
                    } catch (\Exception $e) {
                        $not_send_mail_responce = $e->getMessage();
                    }
                    $main_send_log = new MailSendLog();
                    $main_send_log->name = 'Reminder Send';
                    $main_send_log->reminder_id = $reminder_id;
                    $main_send_log->customer_id = $customer_id;
                    $main_send_log->from_email = '';
                    $customer_email_insert = implode(',',$removed_to_email);
                    $main_send_log->to_email = $customer_email_insert;
                    $customer_email_cc_insert = implode(',',$removed_cc_email);
                    $main_send_log->cc_email = $customer_email_cc_insert;
                    $main_send_log->send_date = $current_date_time;
                    $main_send_log->title = $EmailContent_title;
                    $main_send_log->subject = $not_send_subject;
                    $main_send_log->body = $not_send_body;
                    $main_send_log->action_flage = $action_flage;
                    $main_send_log->deleted_at = $current_date_time;
                    $main_send_log->mail_responce = $not_send_mail_responce;
                    $main_send_log->save();
                }
                /////////////////////////////////////////////////////////////
            }
        }
    }
    public static function QuotationMail($quotation_id,$customer_id,$action_flage = '',$selected_quotation_service_id = 0){
        $current_date = date('Y-m-d');
        $new_pdf_destinationPath = public_path('').'/quotation_pdf';
        File::makeDirectory($new_pdf_destinationPath, $mode = 0777, true, true);
        $quotation_service_list = QuotationService::with('CustomerUser')->with('Quotation.Currency')->with('Service')->where('quotation_id',$quotation_id)->where('customer_id',$customer_id);
        if($selected_quotation_service_id > 0){
            $quotation_service_list->where('id',$selected_quotation_service_id);
        }
        $quotation_service_list = $quotation_service_list->get();
        $EmailContent =  EmailContent::where('status','1')->where('id',config('constants.MAIL_TEMPLATE.Quotation_Send'))->first();
        if(is_object($EmailContent) && is_object($quotation_service_list)){
            $EmailContent_subject = $EmailContent->subject;
            $EmailContent_title = $EmailContent->title;
            $email_body = $EmailContent->content;
            $from_email = '';
            $login_user_id = 0;
            $customer_name = '';
            $customer_email = array();
            $quotation_files = array();
            $service_ids = array();
            $customer_cc_email = array();
            $customer_contact_name = array();
            $customer_type = '';
            $manual_customer_name = '';
            $app_setting = AppSetting::first();
            if($app_setting){
                $cc_email = $app_setting->cc_email;
                if($cc_email != ''){
                    $customer_cc_email_array = explode(',',$cc_email);
                    if(count($customer_cc_email_array) > 0){
                        foreach($customer_cc_email_array as $customer_cc_email_array_val){
                            if($customer_cc_email_array_val != ''){
                                $customer_cc_email[] = $customer_cc_email_array_val;
                            } 
                        }
                    }
                }
            }
            foreach($quotation_service_list as $quotation_service_list_val){
                $quotation_service_id = $quotation_service_list_val->id;
                $service_id = $quotation_service_list_val->service_id;
                $service_ids[] = $service_id;
                if($quotation_service_list_val->Service){
                    $list_of_service_array[] = array(
                       'name' => $quotation_service_list_val->Service->name,
                       'service_price' => $quotation_service_list_val->service_price,
                    );
                }
                if($quotation_service_list_val->Quotation){
                    if($quotation_service_list_val->Quotation->pdf_file_name != ''){
                        $pdf_file_name = $new_pdf_destinationPath.'/'.$quotation_service_list_val->Quotation->pdf_file_name;
                        if(file_exists($pdf_file_name)){
                            $quotation_files[] = $pdf_file_name;
                            //<iframe src="{{url('/') .'/quotation_pdf/'.$quotation_service_list_val->Quotation->pdf_file_name}}" frameborder="0" allowfullscreen style="width: 100%;    height: 800px;"></iframe>
                        }
                    }
                    $from_email = $quotation_service_list_val->Quotation->from_email;
                    $login_user_id = $quotation_service_list_val->Quotation->login_user_id;
                    $customer_type = $quotation_service_list_val->Quotation->customer_type;
                    $manual_customer_name = $quotation_service_list_val->Quotation->manual_customer_name;
                    if($from_email != ''){
                        $customer_cc_email[] = $from_email;
                    }  
                    if (is_object($quotation_service_list_val->Quotation->Currency)) {
                        $currency_name = $quotation_service_list_val->Quotation->Currency->symbols;
                    } 
                    $vat_value = $quotation_service_list_val->Quotation->vat;
                    $send_datetime = $quotation_service_list_val->Quotation->updated_at;
                    if($customer_type == 'manual'){
                        $customer_name = $manual_customer_name;
                        $customer_address = '';
                        $customer_phone = '';
                        $manual_customer_to_email = $quotation_service_list_val->Quotation->manual_customer_to_email;
                        $manual_customer_to_email_array = explode(',',$manual_customer_to_email);
                        if(count($manual_customer_to_email_array) > 0){
                            foreach($manual_customer_to_email_array as $manual_customer_to_email_array_val){
                                if($manual_customer_to_email_array_val != ''){
                                    $customer_email[] = $manual_customer_to_email_array_val;
                                }    
                            }
                        }
                        $manual_customer_cc_email = $quotation_service_list_val->Quotation->manual_customer_cc_email;
                        $manual_customer_cc_email_array = explode(',',$manual_customer_cc_email);
                        if(count($manual_customer_cc_email_array) > 0){
                            foreach($manual_customer_cc_email_array as $manual_customer_cc_email_array_val){
                                if($manual_customer_cc_email_array_val != ''){
                                    $customer_cc_email[] = $manual_customer_cc_email_array_val;
                                }    
                            }
                        }
                    }else{
                        $contact_customer_id_to = $quotation_service_list_val->Quotation->contact_customer_id_to;
                        if($contact_customer_id_to != ''){
                            $selected_customer_id_to = array();
                            $customer_id_to_array = json_decode($contact_customer_id_to,true);
                            if(count($customer_id_to_array) > 0){
                                foreach($customer_id_to_array as $customer_id_to_array_val){
                                    $selected_customer_id_to[] = $customer_id_to_array_val;

                                }
                            }
                            if(count($selected_customer_id_to) > 0){
                                $CustomerUser_detail = CustomerContactDetail::select('name','email')->where('customer_id',$customer_id)->whereIn('id', $selected_customer_id_to)->get();
                                if($CustomerUser_detail){
                                    foreach($CustomerUser_detail as $CustomerUser_detail_val){
                                        if($CustomerUser_detail_val->email != ''){
                                            $customer_email[] = $CustomerUser_detail_val->email;
                                            $customer_contact_name[] = $CustomerUser_detail_val->name;
                                        }    
                                    }
                                }
                            }
                        }
                        $contact_customer_id_cc = $quotation_service_list_val->Quotation->contact_customer_id_cc;
                        if($contact_customer_id_cc != ''){
                            $selected_customer_id_cc = array();
                            $customer_id_cc_array = json_decode($contact_customer_id_cc,true);
                            if(count($customer_id_cc_array) > 0){
                                foreach($customer_id_cc_array as $customer_id_cc_array_val){
                                    $selected_customer_id_cc[] = $customer_id_cc_array_val;
                                }
                            }
                            if(count($selected_customer_id_cc) > 0){
                                $CustomerUser_detail = CustomerContactDetail::select('name','email')->where('customer_id',$customer_id)->whereIn('id', $selected_customer_id_cc)->get();
                                if($CustomerUser_detail){
                                    foreach($CustomerUser_detail as $CustomerUser_detail_val){
                                        if($CustomerUser_detail_val->email != ''){
                                            $customer_cc_email[] = $CustomerUser_detail_val->email;
                                            $customer_contact_name[] = $CustomerUser_detail_val->name;
                                        }    
                                    }
                                }
                            }
                        }
                        if($quotation_service_list_val->CustomerUser){
                            $customer_name = $quotation_service_list_val->CustomerUser->name;
                            $customer_contact_name[] = $customer_name;
                            $address = $quotation_service_list_val->CustomerUser->address;
                            $address_2 = $quotation_service_list_val->CustomerUser->address_2;
                            if($address_2 != ''){
                                $address_2 = '<br></br>'.$address_2;
                            }
                            $address_3 = $quotation_service_list_val->CustomerUser->address_3;
                            if($address_3 != ''){
                                $address_3 = '<br></br>'.$address_3;
                            }
                            $customer_address = $address.''.$address_2.''.$address_3;
                            $customer_phone = $quotation_service_list_val->CustomerUser->phonecode.' '.$quotation_service_list_val->CustomerUser->phone_number;
                            $customer_email[] = $quotation_service_list_val->CustomerUser->email_address;
                              
                        }
                    }    
                }
            }
            $customer_email = array_unique($customer_email);
            $customer_cc_email = array_unique($customer_cc_email);
            $auth = auth()->user();
            $LoginUserName = isset($auth->name) ? $auth->name : '';
            $LoginUserDesignation = '';
            $LoginUserMobileNumber = '';
            $LoginUserEmail = '';
            if(count($service_ids) > 0 && count($customer_email) > 0){
                //exit;
                $UserDetail =  User::withTrashed()->where('id',$login_user_id)->first();
                $LoginUserQr = '';
                if(is_object($UserDetail)){
                    $LoginUserName = isset($UserDetail->name) ? $UserDetail->name : '';
                    $LoginUserDesignation = isset($UserDetail->designation) ? $UserDetail->designation : '';
                    $LoginUserphonecode = isset($UserDetail->phonecode) ? $UserDetail->phonecode : '';
                    $LoginUsermobile = isset($UserDetail->mobile) ? $UserDetail->mobile : '';
                    $LoginUserMobileNumber = $LoginUserphonecode.' '.$LoginUsermobile;
                    $LoginUserEmail = isset($UserDetail->email) ? $UserDetail->email : '';
                    $LoginUserQr = isset($UserDetail->qr_image_url) ? $UserDetail->qr_image_url : '';
                    if($LoginUserQr != ''){
                        $LoginUserQr = '<img src="'.$LoginUserQr.'" width="100">';
                    }
                } 
                $email_body = str_ireplace('{{CustomerName}}',$customer_name,$email_body);
                $email_body = str_ireplace('{{LoginUserName}}','<div style="font-size:16px; font-weight:700; color:#f39c12; margin-bottom:4px;">'.$LoginUserName.'</div>',$email_body);
                $email_body = str_ireplace('{{LoginUserDesignation}}','<div style="font-size:13px; color:#4a4a4a; margin-bottom:8px;">'.$LoginUserDesignation.'</div>',$email_body);
                $email_body = str_ireplace('{{LoginUserMobileNumber}}','<a href="tel:'.$LoginUserMobileNumber.'" style="color:#1a73e8; text-decoration:none;">'.$LoginUserMobileNumber.'</a>',$email_body);
                $email_body = str_ireplace('{{LoginUserEmail}}','<a href="mailto:'.$LoginUserEmail.'" style="color:#1a73e8; text-decoration:none;">'.$LoginUserEmail.'</a>',$email_body);
                $email_body = str_ireplace('{{LoginUserQr}}',$LoginUserQr,$email_body);

                //$email_body = $email_body.'<br>'.$pdf_content;
                //$from_email = 'reminder@bakertilly-ug.com';
                $quotation_files = array_unique($quotation_files);
                //////////////////////////////////////////////////////
                $blockedDomains = [
                    '@madelineadvisory.in',
                ];
                $removed_to_email = array_filter($customer_email, function ($email) use ($blockedDomains)  {
                    foreach ($blockedDomains as $domain) {
                        if (str_ends_with($email, $domain)) {
                            return true; // mark as removed
                        }
                    }
                    return false;
                });
                $customer_email = array_filter($customer_email, function ($email) use ($blockedDomains) {
                    foreach ($blockedDomains as $domain) {
                        if (str_ends_with($email, $domain)) {
                            return false; // skip this one
                        }
                    }
                    return true;
                });  
                ///////////////////////////////////////////////////////////
                $removed_cc_email = array_filter($customer_cc_email, function ($email) use ($blockedDomains)  {
                    foreach ($blockedDomains as $domain) {
                        if (str_ends_with($email, $domain)) {
                            return true; // mark as removed
                        }
                    }
                    return false;
                });
                $customer_cc_email = array_filter($customer_cc_email, function ($email) use ($blockedDomains) {
                    foreach ($blockedDomains as $domain) {
                        if (str_ends_with($email, $domain)) {
                            return false; // skip this one
                        }
                    }
                    return true;
                });
                ////////////////////////////////////////////////////////
                $mailData = [
                    'customer_email' => $customer_email,
                    'from_email' => $from_email,
                    'title' => $EmailContent_title,
                    'customer_cc_email' => $customer_cc_email,
                    'body' => $email_body,
                    'subject' => $EmailContent_subject,
                    'files' => $quotation_files
                ];
                // echo '<pre>';
                // print_r($mailData);
                // exit;
                try {
                     Mail::to($customer_email)->send(new EmailTemplete($mailData));
                    $mail_responce = 'Mail sent successfully!';
                } catch (TransportException $e) {
                    $mail_responce = $e->getMessage();
                } catch (\Exception $e) {
                    $mail_responce = $e->getMessage();
                } 
                $current_date_time = date('Y-m-d H:i:s');
                $main_send_log = new MailSendLog();
                $main_send_log->name = 'Quotation Send';
                $main_send_log->reminder_id = $quotation_id;
                $main_send_log->customer_id = $customer_id;
                $main_send_log->from_email = $from_email;
                $customer_email_insert = implode(',',$customer_email);
                $main_send_log->to_email = $customer_email_insert;
                $customer_email_cc_insert = implode(',',$customer_cc_email);
                $main_send_log->cc_email = $customer_email_cc_insert;
                $main_send_log->send_date = $current_date_time;
                $main_send_log->title = $EmailContent_title;
                $main_send_log->subject = $EmailContent_subject;
                $main_send_log->body = $email_body;
                $main_send_log->files = json_encode($quotation_files);
                $main_send_log->action_flage = $action_flage;
                $main_send_log->action_type = 'quotation';
                $main_send_log->mail_responce = $mail_responce;
                $main_send_log->save();
                //////////////////////////////////////////////////////////
                if(count($removed_to_email) > 0 || count($removed_cc_email) > 0){
                    $not_send_body = '';
                    $not_send_subject = '';
                    try {
                        $not_send_email = array('alpesh.koyani@igentechnolabs.com','krishna.rathi@bakertilly.ug');//
                        $not_send_subject = 'NOT SENDED == '.$mailData['subject'];
                        $mailData['subject'] = $not_send_subject;
                        if(count($removed_to_email) > 0){
                            $not_send_body .= 'TO EMAIL ADDRESS NOT SEND EMAIL ==>'.implode(',',$removed_to_email).'<br>';
                        }
                        if(count($removed_cc_email) > 0){
                            $not_send_body .= 'CC EMAIL ADDRESS NOT SEND EMAIL ==>'.implode(',',$removed_cc_email).'<br>';
                        }
                        $not_send_body .= '<br>'.$mailData['body'];
                        $mailData['body'] = $not_send_body;
                        Mail::to($not_send_email)->send(new EmailTemplete($mailData));
                        $not_send_mail_responce = 'Mail sent successfully!';
                    } catch (TransportException $e) {
                        $not_send_mail_responce = $e->getMessage();
                    } catch (\Exception $e) {
                        $not_send_mail_responce = $e->getMessage();
                    }
                    $main_send_log = new MailSendLog();
                    $main_send_log->name = 'Quotation Send';
                    $main_send_log->reminder_id = $quotation_id;
                    $main_send_log->customer_id = $customer_id;
                    $main_send_log->from_email = $from_email;
                    $customer_email_insert = implode(',',$removed_to_email);
                    $main_send_log->to_email = $customer_email_insert;
                    $customer_email_cc_insert = implode(',',$removed_cc_email);
                    $main_send_log->cc_email = $customer_email_cc_insert;
                    $main_send_log->send_date = $current_date_time;
                    $main_send_log->title = $EmailContent_title;
                    $main_send_log->subject = $not_send_subject;
                    $main_send_log->body = $not_send_body;
                    $main_send_log->action_flage = $action_flage;
                    $main_send_log->deleted_at = $current_date_time;
                    $main_send_log->mail_responce = $not_send_mail_responce;
                    $main_send_log->save();
                }
                /////////////////////////////////////////////////////////////

            }
        }
    }
    public static function QuotationPdf($quotation_id,$customer_id,$action_flage = '',$selected_quotation_service_id = 0){
        if(count($customer_id) > 0){
            foreach($customer_id as $customer_id_val){
                $quotation_service_list = QuotationService::with('CustomerUser')->with('Quotation.Currency')->with('Quotation.Company')->with('Service')->where('quotation_id',$quotation_id)->where('customer_id',$customer_id_val);
                $quotation_service_list = $quotation_service_list->get();
                $EmailContent =  EmailContent::where('status','1')->where('id',config('constants.MAIL_TEMPLATE.Quotation_Send'))->first();
                $from_email = '';
                $currency_name = '';
                $vat_value = 0;
                $send_datetime =date('Y-m-d');
                $list_of_service_array = array();
                $customer_address = '';
                $customer_address_1 = '';
                $customer_address_2 = '';
                $customer_address_3 = '';
                $customer_phone = '';
                $quotation_customer_id = 0;
                $quotation_no = '';
                $customer_contact_name = array();
                $customer_email = array();
                $company_detail = '';
                $customer_type = '';
                $manual_customer_name = '';
                $manual_kind_attn = '';
                $company_name = '';
                if(is_object($EmailContent) && is_object($quotation_service_list)){
                    foreach($quotation_service_list as $quotation_service_list_val){
                        $quotation_service_id = $quotation_service_list_val->id;
                        $quotation_customer_id = $quotation_service_list_val->customer_id;
                        $service_id = $quotation_service_list_val->service_id;
                        $service_ids[] = $service_id;
                        if($quotation_service_list_val->Service){
                            $list_of_service_array[] = array(
                            'name' => $quotation_service_list_val->Service->name,
                            'service_price' => $quotation_service_list_val->service_price,
                            'description' => $quotation_service_list_val->description,
                            );
                        }
                        if($quotation_service_list_val->Quotation){
                            $from_email = $quotation_service_list_val->Quotation->from_email;
                            $customer_type = $quotation_service_list_val->Quotation->customer_type;
                            $manual_customer_name = $quotation_service_list_val->Quotation->manual_customer_name;
                            $manual_customer_address = $quotation_service_list_val->Quotation->manual_customer_address;
                            $manual_customer_address_2 = $quotation_service_list_val->Quotation->manual_customer_address_2;
                            $manual_customer_address_3 = $quotation_service_list_val->Quotation->manual_customer_address_3;
                            $manual_customer_phone = $quotation_service_list_val->Quotation->manual_customer_phone;
                            $manual_kind_attn = $quotation_service_list_val->Quotation->manual_kind_attn;
                            if (is_object($quotation_service_list_val->Quotation->Currency)) {
                                $currency_name = $quotation_service_list_val->Quotation->Currency->symbols;
                            } 
                            if (is_object($quotation_service_list_val->Quotation->Company)) {
                                $company_logo = $quotation_service_list_val->Quotation->Company->logo_image;
                                $company_name = $quotation_service_list_val->Quotation->Company->name;
                                $address = $quotation_service_list_val->Quotation->Company->address;
                                $address_2 = $quotation_service_list_val->Quotation->Company->address_2;
                                if($address_2 != ''){
                                    $address_2 = '</br>'.$address_2;
                                }
                                $address_3 = $quotation_service_list_val->Quotation->Company->address_3;
                                if($address_3 != ''){
                                    $address_3 = '</br>'.$address_3;
                                }
                                $company_address = $address.''.$address_2.''.$address_3;
                                $company_phone = $quotation_service_list_val->Quotation->Company->phonecode.' '.$quotation_service_list_val->Quotation->Company->phone_number;
                                if($company_phone != ''){
                                    $company_phone = '<br>Tel: '.$company_phone.'';
                                }
                                $company_email = $quotation_service_list_val->Quotation->Company->email_address;
                                if($company_email != ''){
                                    $company_email = '<br>Email: '.$company_email;
                                }
                                $logoImage = '';
                                $destinationPath = 'images/company/';
                                if($company_logo != ''){
                                    $logo_image = $destinationPath.$company_logo;
                                    if(file_exists($logo_image)){
                                        $logoImage = '<img src="'.public_path($logo_image).'" width="200">';
                                    }
                                }
                                $destinationPath = 'app-assets/images/logo/';
                                $company_logo = 'logo1.png';
                                if($logoImage == ''){
                                    $logo_image = $destinationPath.$company_logo;
                                    if(file_exists($logo_image)){
                                        $logoImage = '<img src="'.public_path($logo_image).'" width="200">';
                                    }
                                }
                                $company_detail = '';
                                $company_detail .= '<header>';
                                    $company_detail .= '<table border="0" cellspacing="0" style="width:100%">';
                                        $company_detail .= '<tbody>';
                                            $company_detail .= '<tr>';
                                                    $company_detail .= '<td colspan="2" style="text-align: center;"><h2>Quotation / Proposal</h2></td>';
                                            $company_detail .= '</tr>';
                                            $company_detail .= '<tr style="border: 1px solid #000000;">';
                                                $company_detail .= '<td style="padding: 5px;background-color:#c9ec51;vertical-align:top;    border-right: 2px solid #000000;"><b>'.$company_name.'</b><br>'.$company_address.''.$company_phone.$company_email.'</td>';
                                                $company_detail .= '<td style="vertical-align:top;padding: 5px;background-color:#c9ec51;width: 50%;padding-right:20px;text-align:right;margin-right:10px;">'.$logoImage.'</td>';
                                            $company_detail .= '</tbody>';
                                    $company_detail .= '</table>';
                                $company_detail .= '</header>';
                            }
                            $vat_value = $quotation_service_list_val->Quotation->vat;
                            $send_datetime = $quotation_service_list_val->Quotation->updated_at;
                            $quotation_no = $quotation_service_list_val->Quotation->quotation_auto_number.'/'.$quotation_service_list_val->Quotation->financial_year;
                        }
                        if($customer_type == 'manual'){
                                $customer_name = $manual_customer_name;
                                $customer_contact_name[] = $manual_kind_attn;
                                $address = $manual_customer_address;
                                $address_2 = $manual_customer_address_2;
                                if($address_2 != ''){
                                    $address_2 = '<br></br>'.$address_2;
                                }
                                $address_3 = $manual_customer_address_3;
                                if($address_3 != ''){
                                    $address_3 = '<br></br>'.$address_3;
                                }
                                $customer_address = $address.''.$address_2.''.$address_3;
                                $customer_address_1 = $manual_customer_address;
                                $customer_address_2 = $manual_customer_address_2;
                                $customer_address_3 = $manual_customer_address_3;
                                $customer_phone = $manual_customer_phone;
                        }else{
                            $contact_customer_id_to = $quotation_service_list_val->Quotation->contact_customer_id_to;
                            if($contact_customer_id_to != ''){
                                $selected_customer_id_to = array();
                                $customer_id_to_array = json_decode($contact_customer_id_to,true);
                                if(count($customer_id_to_array) > 0){
                                    foreach($customer_id_to_array as $customer_id_to_array_val){
                                        $selected_customer_id_to[] = $customer_id_to_array_val;

                                    }
                                }
                                if(count($selected_customer_id_to) > 0){
                                    $CustomerUser_detail = CustomerContactDetail::select('name','email')->where('customer_id',$customer_id)->whereIn('id', $selected_customer_id_to)->get();
                                    if($CustomerUser_detail){
                                        foreach($CustomerUser_detail as $CustomerUser_detail_val){
                                            if($CustomerUser_detail_val->email != ''){
                                                $customer_email[] = $CustomerUser_detail_val->email;
                                                $customer_contact_name[] = $CustomerUser_detail_val->name;
                                            }    
                                        }
                                    }
                                }
                            }
                            if($quotation_service_list_val->CustomerUser){
                                $customer_name = $quotation_service_list_val->CustomerUser->name;
                                $address = $quotation_service_list_val->CustomerUser->address;
                                $address_2 = $quotation_service_list_val->CustomerUser->address_2;
                                if($address_2 != ''){
                                    $address_2 = '<br></br>'.$address_2;
                                }
                                $address_3 = $quotation_service_list_val->CustomerUser->address_3;
                                if($address_3 != ''){
                                    $address_3 = '<br></br>'.$address_3;
                                }
                                $customer_address = $address.''.$address_2.''.$address_3;
                                $customer_address_1 = $quotation_service_list_val->CustomerUser->address;
                                $customer_address_2 = $quotation_service_list_val->CustomerUser->address_2;
                                $customer_address_3 = $quotation_service_list_val->CustomerUser->address_3;
                                $customer_phone = $quotation_service_list_val->CustomerUser->phonecode.' '.$quotation_service_list_val->CustomerUser->phone_number;
                            }
                        }    
                    }
                }
                $pdf_content =  '';
                $EmailPdfContent =  EmailContent::withTrashed()->where('id',config('constants.MAIL_TEMPLATE.Quotation_Pdf'))->first();
                if(is_object($EmailPdfContent)){
                    $pdf_content =  $EmailPdfContent->content;;
                }
                $pdf_file = '';
                $pdf_file_name = '';
                $auth = auth()->user();
                $LoginUserName = isset($auth->name) ? $auth->name : '';
                if(count($service_ids) > 0 && $pdf_content != ''){
                    $service_table_html = '<table border="1" cellspacing="0" style="width:99%">';
                    $service_table_html .= '<tr>';
                        $service_table_html .= '<td style="background-color:#c9ec51;; text-align:center; vertical-align:middle; width:50px"><strong>Sr. No.</strong></td>';
                        $service_table_html .= '<td style="background-color:#c9ec51;; text-align:left; vertical-align:middle"><strong>Description</strong></td>';
                        $service_table_html .= '<td style="background-color:#c9ec51;text-align:right; width:150px; vertical-align:middle;padding-right: 5px;"><strong><span style="color:black">Amount ('.$currency_name.')</span></strong></td>';
                    $service_table_html .= '</tr>';
                    $sub_total_amount = 0;
                    $list_of_service_count = count($list_of_service_array);
                    if($list_of_service_array){
                        foreach ($list_of_service_array as $key => $list_of_service_array_value) {
                            $service_price = $list_of_service_array_value['service_price'];
                            $sub_total_amount = $sub_total_amount + $service_price;
                            $description = '';
                            if($list_of_service_array_value['description'] != ''){
                                $description_data = $list_of_service_array_value['description'];
                                $lines = explode("\n", $description_data);
                                $formatted = array_map(function($line) {
                                    return '&nbsp;&nbsp;- ' . trim($line).' <br>';
                                }, $lines);

                                $result_description = implode("\n", $formatted);

                                $description = '<br><small>'.$result_description.'</small>';
                            }   
                            $service_table_html .= '<tr>';
                                $service_table_html .= '<td style="text-align:center; vertical-align:middle;">'.($key + 1).'.</td><td>'.$list_of_service_array_value['name'].''.$description.'</td><td style="text-align:right; vertical-align:top;padding-right: 5px;"><span style="color:black">'.number_format($service_price,2).'</span></td>';
                            $service_table_html .= '</tr>';
                        }
                    }
                    $total_row_list = 3;
                    if($total_row_list > $list_of_service_count){
                        $total_pending = $total_row_list - $list_of_service_count;
                        $tr_height = $total_pending * 40;
                        $service_table_html .= '<tr>';
                            $service_table_html .= '<td colspan="2" style="height: '.$tr_height.'px;text-align:right; vertical-align:middle"></td>';
                            $service_table_html .= '<td style="border-color:#7f7f7f;text-align:center; vertical-align:middle"><strong><span style="color:black;"></strong></td>';
                        $service_table_html .= '</tr>'; 
                    }
                    $service_table_html .= '<tr>';
                        $service_table_html .= '<td colspan="2" style="text-align:right; vertical-align:middle;padding-right: 5px;"><strong>Subtotal</strong></td>';
                        $service_table_html .= '<td style="border-color:#7f7f7f;text-align:right; vertical-align:middle;padding-right: 5px;"><strong><span style="color:black;">'.number_format($sub_total_amount,2).'</strong></td>';
                    $service_table_html .= '</tr>';
                    $vat_amount = 0;
                    if($vat_value > 0){
                        $vat_amount = ($sub_total_amount * $vat_value) / 100;
                        $service_table_html .= '<tr>';
                            $service_table_html .= '<td colspan="2" style="text-align:right; vertical-align:middle;padding-right: 5px;"><strong>VAT @'.number_format($vat_value,2).'%</strong></td>';
                            $service_table_html .= '<td style="border-color:#7f7f7f;text-align:right; vertical-align:middle;padding-right: 5px;"><strong><span style="color:black">'.number_format($vat_amount,2).'</span></strong></td>';
                        $service_table_html .= '</tr>';
                    }  
                    $final_total = $sub_total_amount + $vat_amount;
                    $amount_in_word = Helpers::amount_word($final_total,$currency_name);  
                    $amount_in_word = ucfirst($amount_in_word).' Only';
                    $service_table_html .= '<tr>';
                        $service_table_html .= '<td colspan="2" style="background-color:#c9ec51; text-align:right; vertical-align:middle;padding-right: 5px;"><strong>Total</strong></td>';
                        $service_table_html .= '<td style="background-color:#c9ec51;text-align:right; vertical-align:middle;padding-right: 5px;"><strong>'.number_format($final_total,2).'</strong></td>';
                    $service_table_html .= '</tr>';
                    // $service_table_html .= '  <tr>';
                    //     $service_table_html .= '<td colspan="3"><span style="color:black"><b>'.$amount_in_word.'</b></span></td>';
                    // $service_table_html .= '</tr>';
                    $service_table_html .= '</table>';
                    $pdf_content = str_ireplace('{{{TableService}}}',$service_table_html,$pdf_content);
                    $timestamp = strtotime($send_datetime); // Example: '2025-08-15'
                    $day = date('j', $timestamp);
                    $monthYear = date('F Y', $timestamp);
                    // Get suffix
                    $suffix = 'th';
                    if (!in_array(($day % 100), [11,12,13])) {
                        switch ($day % 10) {
                            case 1: $suffix = 'st'; break;
                            case 2: $suffix = 'nd'; break;
                            case 3: $suffix = 'rd'; break;
                        }
                    }
                    $SendDate_html = $day . '<sup>' . $suffix . '</sup> ' . $monthYear;
                    $pdf_content = str_ireplace('{{{SendDate}}}',$SendDate_html,$pdf_content);
                    $pdf_content = str_ireplace('{{{QuotationNumber}}}',$quotation_no,$pdf_content);
                    //$pdf_content = str_ireplace('{{{CompanyDetail}}}',$company_detail,$pdf_content);
                    $from_email_html = '<a href="mailto:'.$from_email.'">'.$from_email.'</a>';
                    $pdf_content = str_ireplace('{{{LoginUserEmail}}}',$from_email_html,$pdf_content);
                    $Kind_Attn_name = '';
                    if(count($customer_contact_name) > 0){
                        $customer_contact_name = array_unique($customer_contact_name);
                        $Kind_Attn_name = implode(', ',$customer_contact_name);
                    }   
                    if($Kind_Attn_name != ''){
                        $Kind_Attn_name = '<tr><td style="text-align:left;width:110px;">Kind Attention</td><td style="width: 10px;">:</td><td style="border-bottom: 1px solid #000000;">'.$Kind_Attn_name.'</td></tr>';
                    }
                    if($customer_name != ''){
                        $customer_name = '<tr><td style="text-align:left">Name</td><td style="width: 10px;">:</td><td style="border-bottom: 1px solid #000000;">'.$customer_name.'</td></tr>';
                    } 
                    if($customer_address != ''){
                        //$customer_address = '<tr><td style="text-align:left">Address</td><td> :'.$customer_address.'</td></tr>';
                        $customer_address = '';
                        $customer_address .= '<tr><td style="text-align:left">Address</td><td style="width: 10px;">:</td><td style="border-bottom: 1px solid #000000;">'.$customer_address_1.'</td></tr>';
                        if($customer_address_2 == ''){
                            $customer_address_2 = '&nbsp;';
                        }
                        $customer_address .= '<tr><td style="text-align:left"></td><td style="width: 10px;"></td><td style="border-bottom: 1px solid #000000;">  '.$customer_address_2.'</td></tr>';
                        if($customer_address_3 == ''){
                            $customer_address_3 = '&nbsp;';
                        }
                        $customer_address .= '<tr><td style="text-align:left"></td><td style="width: 10px;"></td><td style="border-bottom: 1px solid #000000;">  '.$customer_address_3.'</td></tr>';
                    }else{
                        $customer_address = '';
                        $customer_address .= '<tr><td style="text-align:left">Address</td><td style="width: 10px;">:</td><td style="border-bottom: 1px solid #000000;">&nbsp;</td></tr>';
                        $customer_address .= '<tr><td style="text-align:left"></td><td style="width: 10px;"></td><td style="border-bottom: 1px solid #000000;">  &nbsp;</td></tr>';
                        $customer_address .= '<tr><td style="text-align:left"></td><td style="width: 10px;"></td><td style="border-bottom: 1px solid #000000;"> &nbsp; </td></tr>';
                    }
                    if($customer_phone != ''){
                        $customer_phone = '<tr><td style="text-align:left">Phone</td><td style="width: 10px;">:</td><td style="border-bottom: 1px solid #000000;">'.$customer_phone.'</td></tr>';
                    }else{
                        $customer_phone = '<tr><td style="text-align:left">Phone</td><td style="width: 10px;">:</td><td style="border-bottom: 1px solid #000000;">&nbsp;</td></tr>';
                    }
                    $pdf_content = str_ireplace('{{{Kind_Attn}}}',$Kind_Attn_name,$pdf_content);
                    $pdf_content = str_ireplace('{{{Name}}}',$customer_name,$pdf_content);
                    $pdf_content = str_ireplace('{{{Address}}}',$customer_address,$pdf_content);
                    $pdf_content = str_ireplace('{{{Phone}}}',$customer_phone,$pdf_content);
                    
                    $pdf_content = str_ireplace('{{{LoginUserName}}}',$LoginUserName,$pdf_content);
                    $pdf_content = str_ireplace('{{{CompanyName}}}',$company_name,$pdf_content);
                    $body = $pdf_content;
                    $new_pdf_destinationPath = public_path('').'/quotation_pdf';
                    // echo $pdf_file = view('email.pdf_templete', compact('body','company_detail'));
                    // exit;
                    $pdf_file = PDF::loadView('email.pdf_templete', compact('body','company_detail'))->setPaper('A4', 'portrait');
                    //$pdf_file_name = 'quotation-'.$quotation_id.'_'.$quotation_customer_id.'_'.date('d_m_Y_H_i_s_A').'.pdf';
                    $quotation_no_pdf = str_replace('_','-',$quotation_no);
                    $quotation_no_pdf = str_replace('/','_',$quotation_no_pdf);
                    $pdf_file_name = 'Quotation-'.$quotation_no_pdf.'.pdf';
                    $file_name_path = $new_pdf_destinationPath.'/'.$pdf_file_name;
                    //return $pdf_file->stream('result.pdf', array('Attachment'=>0));     
                    $pdf_file->save($file_name_path);
                    $quotation_files[] = $file_name_path;
                }   
                $update_pdf_file_name = Quotation::find($quotation_id);
                $update_pdf_file_name->pdf_file_name = $pdf_file_name;
                $update_pdf_file_name->save(); 
            }
        }
    }
    public static function amount_word($number,$currency = 'USD'){
        //zero
        $words = array('0' => '', '1' => 'one', '2' => 'two',
            '3' => 'three', '4' => 'four', '5' => 'five', '6' => 'six',
            '7' => 'seven', '8' => 'eight', '9' => 'nine',
            '10' => 'ten', '11' => 'eleven', '12' => 'twelve',
            '13' => 'thirteen', '14' => 'fourteen',
            '15' => 'fifteen', '16' => 'sixteen', '17' => 'seventeen',
            '18' => 'eighteen', '19' =>'nineteen', '20' => 'twenty',
            '30' => 'thirty', '40' => 'forty', '50' => 'fifty',
            '60' => 'sixty', '70' => 'seventy',
            '80' => 'eighty', '90' => 'ninety');
        if ($number < 20) {
            return $words[$number].' '.$currency;
        }
    
        if ($number < 100) {
            return $words[10 * floor($number / 10)] .
                    ' ' . $words[$number % 10].' '.$currency;
        }
    
        if ($number < 1000) {
            return $words[floor($number / 100)] . ' hundred ' . Helpers::amount_word($number % 100,'').' '.$currency;
        }
    
        if ($number < 1000000) {
            return Helpers::amount_word(floor($number / 1000),'') .' thousand ' . Helpers::amount_word($number % 1000,'').' '.$currency;
        }
    
        return Helpers::amount_word(floor($number / 1000000),'') .' million ' . Helpers::amount_word($number % 1000000,'').' '.$currency;
	}
    public static function GetHeadingName($heading_id){
        $heading_detail = Heading::where('id',$heading_id)->first();
        $heading_name = '';
        if($heading_detail){
            $heading_name = $heading_detail->name;
        }
        if($heading_name == ''){
            $heading_name = 'Other';
        }
        return $heading_name;
    }
    public static function GetDepartmentName($department_id){
        $department_detail = Department::where('id',$department_id)->first();
        $department_name = '';
        if($department_detail){
            $department_name = $department_detail->name;
        }
        if($department_name == ''){
            $department_name = 'Other';
        }
        return $department_name;
    }
    public static function GetUserMenuPermision($menu_name){
        $auth = auth()->user();
        $user_id = $auth->id;
        $permission_count = UserPermision::where('menu_name',$menu_name)->where('user_id',$user_id)->count();
        return $permission_count;
    }
    public static function GetTotalDocument($reminder_id,$customer_id){
        $reminder_document_count = ReminderCustomerDocument::where('reminder_id',$reminder_id)->where('customer_id',$customer_id)->count();
        return $reminder_document_count;
    }
    public static function GetUploadedDocument($reminder_id,$customer_id){
        $reminder_document_count = ReminderCustomerDocument::where('reminder_id',$reminder_id)->where('customer_id',$customer_id)->where('reminder_customer_documents.upload_status', 1)->count();//->WhereNotNull('upload_document')
        return $reminder_document_count;
    }
    public static function GetPendingDocument($reminder_id,$customer_id){
        $reminder_document_count = ReminderCustomerDocument::where('reminder_id',$reminder_id)->where('customer_id',$customer_id)->where('reminder_customer_documents.upload_status', 0)->count();////->WhereNull('upload_document')
        return $reminder_document_count;
    }
    public static function GetDocumentRejectNotes($reminder_customer_document_id,$file_action_type = ''){
        $reject_note = '';
        $reminder_document_detail = ReminderCustomerDocument::select('reject_notes')->find($reminder_customer_document_id);
        if($reminder_document_detail){
            if($reminder_document_detail->reject_notes != ''){
                $reject_note = '<span style="color:red;">Reject Note : '.$reminder_document_detail->reject_notes.'</span>';
            }    
        }
        return $reject_note;
    }
    public static function GetDocument($reminder_customer_document_id,$file_action_type = ''){
        $document_file = '';
        $reminder_document_detail = ReminderCustomerDocument::find($reminder_customer_document_id);
        if($reminder_document_detail){
            if($file_action_type == 'doc_file_name'){
                $document_attachment = 'images/'.config('constants.NEW_DOCUMENT');
                $image_ext_arrray = config('constants.IMAGE_EXT');
                if($reminder_document_detail->doc_file_name!=''){
                    $doc_file = $document_attachment.$reminder_document_detail->doc_file_name;
                    if(file_exists($doc_file)){
                        $file_ext = pathinfo($doc_file,PATHINFO_EXTENSION);
                        if(in_array($file_ext,$image_ext_arrray)){
                            $document_file = '<p><a target="_blank" href="'.url('/').'/'.$doc_file.'""><img src="'.url('/').'/'.$doc_file.'" alt="" height="80" width="120"></a></p>';
                        }else{
                            $document_file = '<p><a target="_blank" href="'.url('/').'/'.$doc_file.'"">Sample File Here</a></p>';
                        }    
                    }
                }
            }else{
                $document_attachment = 'images/'.config('constants.DOCUMENT');
                $image_ext_arrray = config('constants.IMAGE_EXT');
                if($reminder_document_detail->upload_document!=''){
                    $doc_file = $document_attachment.$reminder_document_detail->upload_document;
                    if(file_exists($doc_file)){
                        $file_ext = pathinfo($doc_file,PATHINFO_EXTENSION);
                        if(in_array($file_ext,$image_ext_arrray)){
                            $document_file = '<p><a target="_blank" href="'.url('/').'/'.$doc_file.'""><img src="'.url('/').'/'.$doc_file.'" alt="" height="80" width="120"></a></p><p>'.$reminder_document_detail->upload_comment.'</p>';
                        }else{
                            $document_file = '<p><a target="_blank" href="'.url('/').'/'.$doc_file.'"">'.$reminder_document_detail->org_upload_document.'</a></p><p>'.$reminder_document_detail->upload_comment.'</p>';
                        }    
                    }
                }
            }
            
        }
        return $document_file;
    }
    public static function GetEmailAttachment($email_contents_id,$file_action_type = ''){
        $document_file = '';
        $document_attachment = 'images/'.config('constants.BIRTHDAY');
        $image_ext_arrray = config('constants.IMAGE_EXT');
        $email_attachment_list = EmailContentAttachment::where('email_contents_id',$email_contents_id)->get();
        if(is_object($email_attachment_list)){
            foreach($email_attachment_list as $email_attachment_list_val){
                if($email_attachment_list_val->upload_document!=''){
                    $doc_file = $document_attachment.$email_attachment_list_val->upload_document;
                    if(file_exists($doc_file)){
                        $file_ext = pathinfo($doc_file,PATHINFO_EXTENSION);
                        if(in_array($file_ext,$image_ext_arrray)){
                            $document_file .= '<div class="image_main_inner_box"><a target="_blank" href="'.url('/').'/'.$doc_file.'""><img src="'.url('/').'/'.$doc_file.'" alt="" height="80" width="130"></a><a href="' . route('email_content.image_delete', array('id' => $email_attachment_list_val->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Delete this?\');" class="image_delete_block close-icon"><i class="fa fa-close"></i></a></div>';
                        }else{
                            $document_file .= '<div class="image_main_inner_box"><a target="_blank" href="'.url('/').'/'.$doc_file.'"">'.$email_attachment_list_val->org_upload_document.'</a><a href="' . route('email_content.image_delete', array('id' => $email_attachment_list_val->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Delete this?\');" class="image_delete_block close-icon"><i class="fa fa-close"></i></a></div>';
                        }    
                    }
                }
            }
        }
        return $document_file;
    }

    public static function SendMessage($data)
    {
        $message = $data['message'];
        $mobileNos = $data['mobile_number'];
        $AUTH_KEY = env('AUTH_KEY');
        $senderId = env('SENDER_ID');
        $routeId = env('ROUTE_ID');

        if (strlen($message) != strlen(utf8_decode($message))){
            $smsContentType="unicode";
        } else {
            $smsContentType="english";
        }
        
        $message = urlencode($message);
        $mobile = urlencode($mobileNos);

        $url = "http://msg.msgclub.net/rest/services/sendSMS/sendGroupSms?AUTH_KEY=".$AUTH_KEY."&message=".$message."&senderId=".$senderId."&routeId=".$routeId."&mobileNos=".$mobile."&smsContentType=".$smsContentType;
        
        // $url = "http://message.smartwave.co.in/rest/services/sendSMS/sendGroupSms?AUTH_KEY=".$AUTH_KEY."&message=".urlencode($message)."&senderId=".$senderId."&routeId=".$routeId."&mobileNos=".$mobileNos."&smsContentType=".$smsContentType;
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);  // Timeout in seconds

        // If you need to set custom headers
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
        ]);

        $response = curl_exec($ch);

        $returnData = array();
        if (curl_errno($ch)) {
            $error_msg = curl_error($ch);
            // Handle error
            $returnData = false;
        } else {
            // Output response
            $returnData = true;
        }

        curl_close($ch);

        return $returnData;
    }
    public static function BirthdayMail($customer_detail = array()){
        $current_date = date('Y-m-d');
        $customer_contact_details_id = isset($customer_detail['id']) ? $customer_detail['id'] : '';
        $customer_name = isset($customer_detail['name']) ? $customer_detail['name'] : '';
        $email = isset($customer_detail['email']) ? $customer_detail['email'] : '';
        if($customer_contact_details_id == '' && $customer_name == '' && $email == ''){
            $customer_email = array('alpesh.koyani@igentechnolabs.com','krishna.rathi@bakertilly.ug');
            $customer_name = 'test mail';
            $customer_contact_details_id = 0;
            $action_type = 'testing';
        }else{
            $customer_email = array($email);
            $action_type = 'customer_send';
        }
        if($customer_contact_details_id == ''){
            $customer_contact_details_id = 0;
        }
        $action_flage = 'birthday_wishing';
        $destinationPath = public_path('images').config('constants.BIRTHDAY');
        $EmailContent =  EmailContent::where('status','1')->where('id',config('constants.MAIL_TEMPLATE.Birthday_Wish'))->first();
        if(is_object($EmailContent)){
            $EmailContent_subject = $EmailContent->subject;
            $EmailContent_title = $EmailContent->title;
            $email_body = $EmailContent->content;
            $customer_email = array_unique($customer_email);
            $customer_cc_email = array('krishna.rathi@bakertilly.ug','manjit.kothari@bakertilly.ug','karthik.belle@bakertilly.ug','shisullah.khan@bakertilly.ug','vibhuti.narayan@bakertilly.ug','sahid.shaikh@bakertilly.ug','taxation@bakertilly.ug');
            $customer_cc_email = array_unique($customer_cc_email);
            if(count($customer_email) > 0){
                $send_date = date('Y-m-d');
                $to_email = implode(',',$customer_email);
                $mail_send_count =  MailSendLog::withTrashed()->where('action_type','!=',$action_type)->where('to_email',$to_email)->where('action_flage',$action_flage)->whereDate('send_date',$send_date)->count();
                if($mail_send_count == 0){
                    $email_body = str_ireplace('{{CustomerName}}',$customer_name,$email_body);
                    $auth = auth()->user();
                    $LoginUserName = isset($auth->name) ? $auth->name : '';
                    $email_body = str_ireplace('{{LoginUserName}}',$LoginUserName,$email_body);
                    $AttachmentFiles =  EmailContentAttachment::where('status','1')->where('email_contents_id',config('constants.MAIL_TEMPLATE.Birthday_Wish'))->get();
                    $files = array();
                    if($AttachmentFiles){
                        foreach($AttachmentFiles as $AttachmentFiles_val){
                            $upload_document = $AttachmentFiles_val->upload_document;
                            $files[] = $destinationPath.$upload_document;
                        }
                    }
                    //$from_email = 'reminder@bakertilly-ug.com';
                    $mailData = [
                        'from_email' => '',
                        'title' => $EmailContent_title,
                        'customer_cc_email' => $customer_cc_email,
                        'body' => $email_body,
                        'subject' => $EmailContent_subject,
                        'files' => $files
                    ];
                    try {
                        Mail::to($customer_email)->send(new EmailTemplete($mailData));
                        $mail_responce = 'Mail sent successfully!';
                    } catch (TransportException $e) {
                        $mail_responce = $e->getMessage();
                    } catch (\Exception $e) {
                        $mail_responce = $e->getMessage();
                    } 
                    
                    $current_date_time = date('Y-m-d H:i:s');
                    $main_send_log = new MailSendLog();
                    $main_send_log->name = 'Birthday Wishing';
                    $main_send_log->reminder_id = $customer_contact_details_id;
                    $main_send_log->customer_id = 0;
                    $main_send_log->from_email = '';
                    $customer_email_insert = implode(',',$customer_email);
                    $main_send_log->to_email = $customer_email_insert;
                    $customer_email_cc_insert = implode(',',$customer_cc_email);
                    $main_send_log->cc_email = $customer_email_cc_insert;
                    $main_send_log->send_date = $current_date_time;
                    $main_send_log->title = $EmailContent_title;
                    $main_send_log->subject = $EmailContent_subject;
                    $main_send_log->body = $email_body;
                    $main_send_log->action_flage = $action_flage;
                    $main_send_log->action_type = $action_type;
                    $main_send_log->deleted_at = $current_date_time;
                    $main_send_log->mail_responce = $mail_responce;
                    $main_send_log->save();
                }    
            }
        }
    }
    public static function CreateProfileImage($detail_array = array()){
        $logo_image = isset($detail_array['logo_image']) ? $detail_array['logo_image'] : '';
        $name = isset($detail_array['name']) ? $detail_array['name'] : '';
        $designation = isset($detail_array['designation']) ? $detail_array['designation'] : '';
        $address = isset($detail_array['address']) ? $detail_array['address'] : '';
        $phone_number = isset($detail_array['phone_number']) ? $detail_array['phone_number'] : '';
        $email_address = isset($detail_array['email_address']) ? $detail_array['email_address'] : '';
        $website = isset($detail_array['website']) ? $detail_array['website'] : '';
        $table_detail  = isset($detail_array['table_detail']) ? $detail_array['table_detail'] : '';
        $table_id  = isset($detail_array['table_id']) ? $detail_array['table_id'] : 0;
        $img = Image::canvas(400, 500, '#ffffff');
        // Optional: simulate card border/shadow (draw light gray rectangle)
        $img->rectangle(10, 10, 390, 490, function($draw) {
            $draw->border(3, '#e0e0e0');
        });
        $logoPath = public_path('app-assets/images/logo/logo1.png');
        // Insert logo at top
        $logo = Image::make($logoPath)->resize(170, 50);
        $img->insert($logo, 'top-center', 0, 30);
        $profilePath = '';
        if ($logo_image != '') {
            $image_Path = public_path($logo_image);
            if (file_exists($image_Path)) {
                $profilePath = $image_Path;
            }
        }    
        if($profilePath == ''){
            $profilePath = public_path('images/default-user-logo.png');
        }    
        //////////////////////////////////////////////////
        if (file_exists($profilePath)) {
            // Circular profile image
            $profile = Image::make($profilePath)->fit(120, 120);

            // Create circular mask
            $mask = Image::canvas(120, 120);
            $mask->circle(120, 60, 60, function ($draw) {
                $draw->background('#fff');
            });
            $profile->mask($mask, true);

            // Profile border
            $border = Image::canvas(130, 130, '#ffffff');
            $border->circle(130, 65, 65, function($draw) {
                $draw->border(3, '#dddddd');
            });
            $border->insert($profile, 'center');

            // Insert profile (centered)
            $img->insert($border, 'top-center', 0, 80);
            $footer_space = 240;
        } else {
            $footer_space = 130;
        }
        ////////////////////////////////////////////////////
        // Font
        $fontPath = public_path('fonts/arial.ttf');
        // Name
        $img->text($name, 200, $footer_space, function ($font) use ($fontPath) {
            $font->file($fontPath);
            $font->size(22);
            $font->color('#000000');
            $font->align('center');
        });
        // ID
        $img->text($designation, 200, $footer_space + 25, function ($font) use ($fontPath) {
            $font->file($fontPath);
            $font->size(16);
            $font->color('#444');
            $font->align('center');
        });
        // Sub ID
        $img->text($address, 200, $footer_space + 55, function ($font) use ($fontPath) {
            $font->file($fontPath);
            $font->size(14);
            $font->color('#aaa');
            $font->align('center');
        });
        $contacts = [];
        if($phone_number != ''){
            $contacts[] = ['icon' => 'phone.png', 'text' => $phone_number];
            
        }
        if($email_address != ''){
            $contacts[] = ['icon' => 'email.png', 'text' => $email_address];
        }
        if($website != ''){
            $contacts[] = ['icon' => 'web.png', 'text' => $website];
        }
        // Contact icons and text
        $y = $footer_space + 70;
        if(count($contacts) > 0){
            foreach ($contacts as $item) {
                $icon = Image::make(public_path('images/icons/' . $item['icon']))->resize(30, 30);
                $img->insert($icon, 'top-left', 40, $y);
                $img->text($item['text'], 80, $y + 10, function ($font) use ($fontPath) {
                    $font->file($fontPath);
                    $font->size(18);
                    $font->color('#000000');
                    $font->valign('top');
                });

                $y += 40;
            }
        }
        if($table_detail == 'employee_users' && $table_id > 0){
            $destinationPath = public_path('images').'/profile/';
            File::makeDirectory($destinationPath, $mode = 0777, true, true);  
            $profile_image = 'card_'.$table_id.'_employee.png';
            $image_name = $destinationPath.$profile_image;
            $img->save($image_name);
            $EmployeeUser = EmployeeUser::find($table_id);
            $EmployeeUser->profile_image = $profile_image;
            $EmployeeUser->save();
        }  
        if($table_detail == 'admin_users' && $table_id > 0){
            $destinationPath = public_path('images').'/profile/';
            File::makeDirectory($destinationPath, $mode = 0777, true, true);  
            $profile_image = 'card_'.$table_id.'_user.png';
            $image_name = $destinationPath.$profile_image;
            $img->save($image_name);
            $User = User::find($table_id);
            $User->profile_image = $profile_image;
            $User->save();
        }   
        //echo '<img src="card_output.png" alt="Card Preview" />';
    }
}