<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Country;
use App\Models\UserPermision;
use Datatables;
use App\Helper\Helpers;
use Illuminate\Support\Facades\Hash;
use Endroid\QrCode\Builder\Builder;
use Endroid\QrCode\Writer\PngWriter;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use File;
use Str;


class AdminUserController extends Controller
{
    public function index(Request $request)
    {
       if ($request->ajax()) {
            $adminUser = User::get();
            return datatables()->of($adminUser)
                ->addColumn('action', function ($row) {
                    $html = '';
                    $html .= '<a href="' . route('admin.user.edit', $row->id) . '" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a> ';
                    $html .= '&nbsp;<a href="' . route('admin.user.show', $row->id) . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View</a> ';
                    $html .= '&nbsp;<a href="javascript:;" class="btn btn-danger btn-delete btn-sm" data-toggle="tooltip" data-original-title="Delete" data-container="body" title="" onclick="return record_delete(\'' . route('admin.user.destroy', $row->id) . '\');" ><i class="fa fa-trash" aria-hidden="true"></i> Delete</a>';
                    // if ($row->status == 1) {
                    //     $html .= '<a href="' . route('admin.user.inactive', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Inactive this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-success"></i></a>';
                    // } else {
                    //     $html .= '<a href="' . route('admin.user.active', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Activate this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-muted"></i></a>';
                    // }
                    $html .= '';

                    $html .= '<a href="" class="</a>';
                    return $html;
                })->addColumn('qr_image_url', function ($row) {
                    $html = '';
                    $id = $row->id;
                    $emp_id = base64_encode($id);
                    $emp_url = route('admin_detail.get', array('id' => $emp_id));
                    $admin_qr_download_url = route('admin_qr_download.get', array('id' => $emp_id));
                    if($row->qr_image_url == ''){
                        $destinationPath = public_path('images').'/admin_user_qr/';
                        File::makeDirectory($destinationPath, $mode = 0777, true, true);
                        $vcard = "BEGIN:VCARD
VERSION:3.0
N:".$row->name."
FN:".$row->name."
TEL:".$row->phonecode."".$row->mobile."
EMAIL:".$row->email."
END:VCARD";
                        $result = Builder::create()->writer(new PngWriter())->data($vcard)->size(300)->build();
                        $imageData = $result->getString();
                        if (!empty($imageData)) {
                            $qr_image = $id.'.png';
                            $filePath = $destinationPath.$qr_image;
                            file_put_contents($filePath, $imageData);
                            $destinationPathShow = url('/').'/'.'images'.'/admin_user_qr/'.$qr_image;
                            $User = User::find($id);
                            $User->qr_image = $qr_image;
                            $User->save();
                            $html = '<a target="_blank" href="' . $admin_qr_download_url . '" class=""><img src="'.$destinationPathShow.'" width="100"></a>';
                        }
                    }else{
                        $html = '<a target="_blank" href="' . $admin_qr_download_url . '" class=""><img src="'.$row->qr_image_url.'" width="100"></a>';
                    }
                    $view_html = '';
                    //$view_html = '<a target="_blank" href="' . $emp_url . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View Detail</a> ';
                    //$view_html .= '<br><a target="_blank" href="' . $admin_qr_download_url . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-solid fa-download"></i>Qr Download</a> ';
                    return $html.'<br>'.$view_html;
                })->addColumn('mobile', function ($row) {
                    $html = $row->phonecode.$row->mobile;
                    return $html;
                })->addColumn('name', function ($row) {
                    $html = $row->name;
                    if($row->designation != ''){
                        $html .= '<br>'.$row->designation;
                    }
                    return $html;
                })->addColumn('logo_image_url', function ($row) {
                    $view_html = '';
                    if($row->logo_image_url != ''){
                        $view_html .= '<a target="_blank" href="' . $row->logo_image_url . '" class=""><img src="'.$row->logo_image_url.'" width="100"></a>';
                    }
                    return $view_html;
                })->addColumn('profile_image_url', function ($row) {
                    // $view_html = '';
                    // if($row->profile_image_url == ''){
                    //     $detail_array = array();
                    //     $logo_image = isset($row->logo_image) ? $row->logo_image : '';
                    //     if($logo_image != ''){
                    //         $logo_image = 'images/admin_user/'.$logo_image;
                    //     }
                    //     $detail_array['logo_image'] = $logo_image;
                    //     $detail_array['name'] = $row->name;
                    //     $detail_array['phone_number'] = $row->phonecode.''.$row->mobile;
                    //     $detail_array['email_address'] = $row->email;
                    //     $detail_array['table_detail'] = 'admin_users';
                    //     $detail_array['table_id'] = $row->id;
                    //     Helpers::CreateProfileImage($detail_array);
                    // }
                    // $view_html .= '<a target="_blank" href="' . $row->profile_image_url . '" class=""><img src="'.$row->profile_image_url.'" width="100"></a>';
                    $id = $row->id;
                    $emp_id = base64_encode($id);
                    $emp_url = route('admin_detail.get', array('id' => $emp_id));
                    $view_html = '<a target="_blank" href="' . $emp_url . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View Profile</a> ';
                    ////////////////////////////////////////
                    return $view_html;
                })->rawColumns(['name','action','logo_image_url','qr_image_url','profile_image_url'])->toJson();
        }
        $return_data = array();
        $return_data['page_condition'] = 'admin_user_page';
        $return_data['site_title'] = 'Admin User | ' . config('constants.SITE_NAME');
        return view('admin.admin_user.index', array_merge($return_data));
    }

    public function create()
    {
        $return_data = array();
        $countryphonecode = Country::select('id','name','phonecode')->whereNotNull('phonecode')->where('phonecodedigit','!=','0')->where('status','1')->where('phonecodestatus','1')->get();
        $return_data['countryphonecode'] = $countryphonecode;
        $return_data['selected_permision'] = array();
        $return_data['page_condition'] = 'admin_user_page';
        $return_data['site_title'] = 'Admin User | ' . config('constants.SITE_NAME');
        return view('admin.admin_user.form', array_merge($return_data));
    }

    public function store(Request $request)
    {
        $id = 0;
        $countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode',$request->phonecode)->first();
        $phonecodedigit = 0;
        if($countryphonecode_detail){
            $phonecodedigit = $countryphonecode_detail->phonecodedigit;
        }
        $validate = $request->validate(
            [
                'role_name' => "required",
                'name' => "required",
                'designation' => "required",
                'phonecode' => "required",
                'mobile' => "required|digits:".$phonecodedigit,
                'email' => "required|email:rfc,dns|unique:users,email," . $id . ",id,deleted_at,NULL",
                'password' => "required|min:6|without_spaces",
                'logo_image' => 'mimes:jpeg,png,jpg'
            ],
            [
                'role_name.required' => 'The role is required.',
                'name.required' => 'The name is required.',
                'email' => 'The email is required.',
                'email.email' => 'Please enter valid email.',
                'email.unique' => 'The email has been already taken.',
                'phonecode.required' => 'The phone code is required.',
                'mobile.required' => 'The mobile number is required.',
                'mobile.digits' => 'The mobile number must be '.$phonecodedigit.' digits.',
                'mobile.min' => 'The mobile number should be 10 digits.',
                'mobile.max' => 'The mobile number should be 10 digits.',
                'password.required' => 'The password is required.',
                'password.without_spaces' => 'The password does not allowed white space.',
            ]
        );
        if ($validate) {
            $adminuser = new User();
            $adminuser->role_name = $request->role_name;
            $adminuser->name = $request->name;
            $adminuser->designation = $request->designation;
            $adminuser->phonecode = $request->phonecode;
            $adminuser->mobile = $request->mobile;
            $adminuser->email = $request->email;
            $adminuser->password = Hash::make($request->password);
            $adminuser->status = 1;
            if($request->logo_image != ''){
                $destinationPath = public_path('images').'/admin_user/';
                File::makeDirectory($destinationPath, $mode = 0777, true, true);
                $original_name = $request->logo_image->getClientOriginalName();
                $file_size = $request->logo_image->getSize();
                $extension = $request->logo_image->extension();
                $random_number = Str::random(3);
                $logo_image = $random_number.'_'.$original_name;
                $request->logo_image->move($destinationPath, $logo_image);
                $adminuser->logo_image = $logo_image;
            }
            $adminuser->save();
            $id = $adminuser->id;
            $detail_array = array();
            $logo_image = isset($adminuser->logo_image) ? $adminuser->logo_image : '';
            if($logo_image != ''){
                $logo_image = 'images/admin_user/'.$logo_image;
            }
            $detail_array['logo_image'] = $logo_image;
            $detail_array['name'] = $adminuser->name;
            $detail_array['phone_number'] = $adminuser->phonecode.''.$adminuser->mobile;
            $detail_array['email_address'] = $adminuser->email;
            $detail_array['table_detail'] = 'admin_users';
            $detail_array['table_id'] = $adminuser->id;
            Helpers::CreateProfileImage($detail_array);
            $permision = isset($_POST['permision']) ? $_POST['permision'] : array();
            if(count($permision) > 0){
                foreach($permision as $menu_name){
                    $old_count = UserPermision::withTrashed()->where('user_id',$id)->where('menu_name',$menu_name)->count();
                    if($old_count == 0){
                        $permision_detail = new UserPermision();
                        $permision_detail->user_id = $id;
                        $permision_detail->menu_name = $menu_name;
                        $permision_detail->status = 1;
                        $permision_detail->save();
                    }else{
                        UserPermision::withTrashed()->where('user_id',$id)->where('menu_name',$menu_name)->update(['deleted_at' => null]);
                    } 
                }
            } 
            if ($request->save) {
                return redirect(route('admin.user.edit', $adminuser->id))->with('success_message', trans('Added Successfully'));
            } else {
                return redirect(route('admin.user.index'))->with('success_message', trans('Added Successfully'));
            }
        }
    }

    public function show($id)
    {
        $adminUser = User::find($id);
        $return_data = array();
        $return_data['data'] = $adminUser;
        $return_data['page_condition'] = 'admin_user_page';
        $return_data['site_title'] = 'Admin User | ' . config('constants.SITE_NAME');
        return view('admin.admin_user.view', array_merge($return_data));
    }

    public function edit($id)
    {
        $data = User::find($id);
        $return_data = array();
        $return_data['data'] = $data;
        $countryphonecode = Country::select('id','name','phonecode')->whereNotNull('phonecode')->where('phonecodedigit','!=','0')->where('status','1')->where('phonecodestatus','1')->get();
        $return_data['countryphonecode'] = $countryphonecode;
        $permisions_list = UserPermision::where('user_id',$id)->get();
        $selected_permision = array();
        if($permisions_list){
            foreach($permisions_list as $permisions_list_val){
                $selected_permision[] = $permisions_list_val->menu_name;
            }
        }
        $return_data['selected_permision'] = $selected_permision;
        $return_data['page_condition'] = 'admin_user_page';
        $return_data['site_title'] = 'Admin User | ' . config('constants.SITE_NAME');
        return view('admin.admin_user.form', array_merge($return_data));
    }
    public function update(Request $request)
    {
        $id = $request->id;
        $countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode',$request->phonecode)->first();
        $phonecodedigit = 0;
        if($countryphonecode_detail){
            $phonecodedigit = $countryphonecode_detail->phonecodedigit;
        }
        $validate = $request->validate(
            [
                'role_name' => "required",
                'name' => "required",
                'designation' => "required",
                'phonecode' => "required",
                'mobile' => "required|digits:".$phonecodedigit,
                'email' => "required|email:rfc,dns|unique:users,email," . $id . ",id,deleted_at,NULL",
                'password' => !empty($request->password) ? 'without_spaces|min:6' : '',
                'logo_image' => 'mimes:jpeg,png,jpg'
            ],
            [
                'role_name.required' => 'The role is required.',
                'name.required' => 'The name is required.',
                'email' => 'The email is required.',
                'email.email' => 'Please enter valid email.',
                'email.unique' => 'The email has been already taken.',
                'phonecode.required' => 'The phone code is required.',
                'mobile.required' => 'The mobile number is required.',
                'mobile.digits' => 'The mobile number must be '.$phonecodedigit.' digits.',
                'mobile.min' => 'The mobile number should be 10 digits.',
                'mobile.max' => 'The mobile number should be 10 digits.',
                'password.without_spaces' => 'The password does not allowed white space.',
            ]
        );
        if ($validate) {

            $adminuser = User::find($id);
            $adminuser->role_name = $request->role_name;
            $adminuser->name = $request->name;
            $adminuser->designation = $request->designation;
            $adminuser->mobile = $request->mobile;
            $adminuser->phonecode = $request->phonecode;
            $adminuser->email = $request->email;
            if($request->password){
               $adminuser->password = Hash::make($request->password);
            }
            if($request->logo_image != ''){
                $destinationPath = public_path('images').'/admin_user/';
                File::makeDirectory($destinationPath, $mode = 0777, true, true);
                $original_name = $request->logo_image->getClientOriginalName();
                $file_size = $request->logo_image->getSize();
                $extension = $request->logo_image->extension();
                $random_number = Str::random(3);
                $logo_image = $random_number.'_'.$original_name;
                $request->logo_image->move($destinationPath, $logo_image);
                $adminuser->logo_image = $logo_image;
            }
            $adminuser->save();
            $detail_array = array();
            $logo_image = isset($adminuser->logo_image) ? $adminuser->logo_image : '';
            if($logo_image != ''){
                $logo_image = 'images/admin_user/'.$logo_image;
            }
            $detail_array['logo_image'] = $logo_image;
            $detail_array['name'] = $adminuser->name;
            $detail_array['phone_number'] = $adminuser->phonecode.''.$adminuser->mobile;
            $detail_array['email_address'] = $adminuser->email;
            $detail_array['table_detail'] = 'admin_users';
            $detail_array['table_id'] = $adminuser->id;
            Helpers::CreateProfileImage($detail_array);
            $permisions_delete = UserPermision::where('user_id',$id);
            $permisions_delete->delete();
            $permision = isset($_POST['permision']) ? $_POST['permision'] : array();
            if(count($permision) > 0){
                foreach($permision as $menu_name){
                    $old_count = UserPermision::withTrashed()->where('user_id',$id)->where('menu_name',$menu_name)->count();
                    if($old_count == 0){
                        $permision_detail = new UserPermision();
                        $permision_detail->user_id = $id;
                        $permision_detail->menu_name = $menu_name;
                        $permision_detail->status = 1;
                        $permision_detail->save();
                    }else{
                        UserPermision::withTrashed()->where('user_id',$id)->where('menu_name',$menu_name)->update(['deleted_at' => null]);
                    } 
                }
            }    
            if ($request->save) {
                return redirect(route('admin.user.edit', $adminuser->id))->with('success_message', trans('Update Successfully'));
            } else {
                return redirect(route('admin.user.index'))->with('success_message', trans('Update Successfully'));
            }
        }
    }
    public function destroy($id)
    {
        $adminUser = User::find($id);
        $adminUser->delete();
        return redirect()->route("admin.user.index")->with('success_message', 'Delete Successfully!');
    }

    public function setActivate($id)
    {
        $update_status = User::find($id);
        $update_status->status = 1;
        $update_status->save();
        return redirect(route('admin.user.index'))->with('success_message', trans('Active Successfully'));
    }

    public function setInactivate($id)
    {
        $update_status = User::find($id);
        $update_status->status = 0;
        $update_status->save();
        return redirect(route('admin.user.index'))->with('success_message', trans('Inactive Successfully'));
    }
}
