<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\AppSetting;
use Datatables;

class AppSettingController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $app_setting = AppSetting::all();
            return datatables()->of($app_setting)
                ->addColumn('action', function ($row) {
                    $html = '';
                    $html .= '<a href="'.route('app_setting.edit',$row->id).'" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a> ';
					$html .= '&nbsp;<a href="javascript:;" class="btn btn-danger btn-delete btn-sm" data-toggle="tooltip" data-original-title="Delete" data-container="body" title="" onclick="return record_delete(\''.route('app_setting.destroy', $row->id).'\');" ><i class="fa fa-trash" aria-hidden="true"></i> Delete</a>';
					if($row->status == 1){
                		$html .= '<a href="'.route('inactive.app_setting',array('id'=>$row->id)).'" onClick="return alertconfirm(\'Are you sure you want to inactivate this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-success"></i></a>';
                	}else{
                        $html .= '<a href="'.route('active.app_setting',array('id'=>$row->id)).'" onClick="return alertconfirm(\'Are you sure you want to activate this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-muted"></i></a>';
                    }
					$html .= '';
					
					$html .= '<a href="" class="</a>';
                    return $html;
                })->toJson();
        }
        $return_data = array();
        $return_data['page_condition'] = 'app_setting_page';
		$return_data['site_title'] = 'App Setting | ' . config('constants.SITE_NAME');
		return view('admin.app_setting.index', array_merge($return_data));
    }
    public function create(){
        $categories=AppSetting::all();
		$return_data = array();
        $return_data['categories'] = $categories;
		$return_data['page_condition'] = 'app_setting_page';
		$return_data['site_title'] = 'App Setting | ' . config('constants.SITE_NAME');
		return view('admin.app_setting.form', $return_data);
	}
    public function store(Request $request)
    {
		// dd($request);
        $id = 0;
		$validate = $request->validate([
			'name' => "required|unique:categories,name,".$id.",id,deleted_at,NULL",
			'type' => "required",
			'parent_category' => "required",
			'sequnce' => "required",
		]);
  
		if($validate){
			$all_data = $request->all();
			if($request->file('image')){
				$image = $request->file('image');
				// dd($image);
				$imageName = 'app_setting-image'.time().'.'.$image->getClientOriginalExtension();
				$destinationPath = public_path('images');
				$image->move($destinationPath, $imageName);
				$all_data['image']=$imageName;
				}else{
				   $all_data['image']=""; 
				}
            $app_setting = AppSetting::create($all_data);
            //$request_data = array('new_data' => $_REQUEST);
			//$this->log_insert("AppSetting Created" , $request_data);
			if ($request->save) {	
				return redirect(route('app_setting.edit',$app_setting->id))->with('success_message', trans('Added Successfully'));
			}else{
	            return redirect(route('app_setting.index'))->with('success_message', trans('Added Successfully'));
	        }
		}
    }

    public function show($id)
    {
        return;
    }

    public function edit(){
		$app_setting = AppSetting::first();
		$return_data = array();
        $return_data['app_setting'] = $app_setting;
		$return_data['page_condition'] = 'app_setting_page';
		$return_data['site_title'] = 'App Setting | ' . config('constants.SITE_NAME');
		return view('admin.app_setting.form', array_merge($return_data));
	}
	public function update(Request $request)
	{
		$app_setting = AppSetting::first();
		$all_data = $request->all();
		$app_setting->update($all_data); 
        if ($request->save) {
			return redirect(route('app_setting.index',$app_setting->id))->with('success_message', trans('Update Successfully'));
		}
		
	}
	public function destroy($id){
		$app_setting = AppSetting::find($id);
		//$request_data = array('old_data' => $app_setting,'new_data' => $_REQUEST);
		//$this->log_insert("AppSetting Deleted" , $request_data);
		$app_setting->delete();
		return redirect()->route("app_setting.index")->with('success_message', 'Delete Successfully!');
	}
    public function setActivate($id){
        $update_status = AppSetting::find($id);
        $update_status->status = 1;
        $update_status->save();
        //$request_data = array('old_data' => $update_status,'new_data' => $_REQUEST);
		//$this->log_insert("AppSetting Status Active" , $request_data);
        return redirect(route('app_setting.index'))->with('success_message', trans('Active Successfully'));
    }
    public function setInactivate($id) {
        $update_status = AppSetting::find($id);
        $update_status->status = 0;
        $update_status->save();
        //$request_data = array('old_data' => $update_status,'new_data' => $_REQUEST);
		//$this->log_insert("app_setting Status InActive" , $request_data);
        return redirect(route('app_setting.index'))->with('success_message', trans('InActive Successfully'));
    }
}
