<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Assignment;
use Datatables;

class AssignmentController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $assignment = Assignment::all();
            return datatables()->of($assignment)
                ->addColumn('action', function ($row) {
                    $html = '';
                    $html .= '<a href="' . route('assignment.edit', $row->id) . '" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a> ';
                    $html .= '&nbsp;<a href="' . route('assignment.show', $row->id) . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View</a> ';
                    if(count($row->documents) > 0){
                        $html .= '&nbsp;<a href="javascript:;" class="btn btn-danger btn-delete btn-sm" data-toggle="tooltip" data-original-title="Delete" data-container="body" title="" onclick="return alert(\'Please remove all the documents assigned to this assignment.\');" ><i class="fa fa-trash" aria-hidden="true"></i> Delete</a>';
                    }else{
                        $html .= '&nbsp;<a href="javascript:;" class="btn btn-danger btn-delete btn-sm" data-toggle="tooltip" data-original-title="Delete" data-container="body" title="" onclick="return record_delete(\'' . route('assignment.destroy', $row->id) . '\');" ><i class="fa fa-trash" aria-hidden="true"></i> Delete</a>';
                    }    
                    if ($row->status == 1) {
                       // $html .= '<a href="' . route('assignment.inactive', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Inactive this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-success"></i></a>';
                    } else {
                        //$html .= '<a href="' . route('assignment.active', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Activate this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-muted"></i></a>';
                    }
                    $html .= '';

                    $html .= '<a href="" class="</a>';
                    return $html;
                })->toJson();
        }
        $return_data = array();
        $return_data['page_condition'] = 'assignment_page';
        $return_data['site_title'] = 'Assignment | ' . config('constants.SITE_NAME');
        return view('admin.assignment.index', array_merge($return_data));
    }

    public function create()
    {
        $return_data = array();
        $return_data['page_condition'] = 'assignment_page';
        $return_data['site_title'] = 'Assignment | ' . config('constants.SITE_NAME');
        return view('admin.assignment.form', array_merge($return_data));
    }

    public function store(Request $request)
    {
        $id = 0;
        $validate = $request->validate(
            [
                'name' => "required|unique:assignments,name," . $id . ",id,deleted_at,NULL",
                //'description' => "required"
            ],
            [
                'name.required' => 'The Name is required.',
                'name.unique' => 'The Name has been already taken.',
                'description' => 'The Description is required.',
            ]
        );

        if ($validate) {

            $assignment = new Assignment();
            $assignment->name = $request->name;
            $assignment->description = $request->description;
            $assignment->status = 1;
            $assignment->save();
            if ($request->save) {
                return redirect(route('assignment.edit', $assignment->id))->with('success_message', trans('Added Successfully'));
            } else {
                return redirect(route('assignment.index'))->with('success_message', trans('Added Successfully'));
            }
        }
    }

    public function show($id)
    {
        $assignment = Assignment::find($id);
        $return_data = array();
        $return_data['data'] = $assignment;
        $return_data['page_condition'] = 'assignment_page';
        $return_data['site_title'] = 'Assignment | ' . config('constants.SITE_NAME');
        return view('admin.assignment.view', array_merge($return_data));
    }

    public function edit($id)
    {
        $data = Assignment::find($id);
        $return_data = array();
        $return_data['data'] = $data;
        $return_data['page_condition'] = 'assignment_page';
        $return_data['site_title'] = 'Assignment | ' . config('constants.SITE_NAME');
        return view('admin.assignment.form', array_merge($return_data));
    }
    public function update(Request $request)
    {
        $id = $request->id;
        $validate = $request->validate(
            [
                'name' => "required|unique:assignments,name," . $id . ",id,deleted_at,NULL",
                //'description' => "required"
            ],
            [
                'name.required' => 'The Name is required.',
                'name.unique' => 'The Name has been already taken.',
                'description' => 'The Description is required.',
            ]

        );
        if ($validate) {

            $assignment = Assignment::find($id);
            $assignment->name = $request->name;
            $assignment->description = $request->description;
            $assignment->save();

            if ($request->save) {
                return redirect(route('assignment.edit', $assignment->id))->with('success_message', trans('Update Successfully'));
            } else {
                return redirect(route('assignment.index'))->with('success_message', trans('Update Successfully'));
            }
        }
    }
    public function destroy($id)
    {
        $assignment = Assignment::find($id);
        $assignment->delete();
        return redirect()->route("assignment.index")->with('success_message', 'Delete Successfully!');
    }

    public function setActivate($id)
    {
        $update_status = Assignment::find($id);
        $update_status->status = 1;
        $update_status->save();
        return redirect(route('assignment.index'))->with('success_message', trans('Active Successfully'));
    }

    public function setInactivate($id)
    {
        $update_status = Assignment::find($id);
        $update_status->status = 0;
        $update_status->save();
        return redirect(route('assignment.index'))->with('success_message', trans('Inactive Successfully'));
    }
}
