<?php 
  
namespace App\Http\Controllers\Admin\Auth; 
  
use App\Http\Controllers\Controller;
use Illuminate\Http\Request; 
use Illuminate\Support\Facades\DB; 
use Carbon\Carbon; 
use App\Mail\DemoMail;
use App\Models\User; 
use App\Models\EmailContent; 
use Illuminate\Support\Facades\Mail; 
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\session;
use Illuminate\Support\Str;
use Illuminate\Auth\Events\PasswordReset;
  
class ForgotPasswordController extends Controller
{
      
      /**
       * Write code on Method
       *
       * @return response()
       */
      public function emailView() { 
         return view('admin.auth.passwords.email');
      }
      public function password_email(Request $request) { 
          
        $validate = $request->validate([
			'email' => "required|email:rfc,dns|exists:users",
			'username' => "required",
			'mobile' => "required|max:10|min:10",
		],[
            'email.required' => 'The email is required.',
            'email.email' => 'Please enter valid email',
            'email.exists' => 'The email has not found.',
            'username.required' => 'The username is required.',
            'mobile.required' => 'The mobile is required.',
            'mobile.max' => 'The mobile should be 10 digits.',
            'mobile.min' => 'The mobile should be 10 digits.'
        ]);
  
        $user_check = User::where('email', $request->email)->where('name',$request->username);
        if($request->mobile){
            $user_check->where('mobile',$request->mobile);
        }
        $check = $user_check->first();
        if(empty($check)){
            return redirect('admin/forget')->with('error', 'Invalid user!');
        }
		if($validate){
		        $email=$request->email;
                $user = User::where('email', $request->email)->first();
                $EmailContent =  EmailContent::where('status','1')->where('id',config('constants.MAIL_TEMPLATE.ADMIN_FORGOT_PASSWORD'))->first();
                $username = !empty($user->name) ? $user->name : '';
                $url = route('reset.password.get', $request->_token);
                if(is_object($EmailContent)){
                       $content = $EmailContent->content;
                       $content = str_replace('{{USER}}',$username,$content);
                       $content = str_replace('{{LINK}}',$url,$content);
                       $mailData = [
                            'title' => $EmailContent->title,
                            'body' => $content,
                            'subject' => $EmailContent->subject
                        ];
                } else {
                        $mailData = [
                            'title' => 'Mail from EHS.com',
                            'body' => 'You can reset password from bellow link: <a href="'.$url.'">Reset Password</a>',
                            'subject' => 'Forget Password Email',
                        ];
                }
             if(!$user){
                  return redirect('admin/forget')->with('error', 'Invalid user!');
              }
             Mail::to($email)->send(new DemoMail($mailData));
            $user_data = User::where('email', $request->email)
                          ->update(['remember_token' => $request->_token]);
                          
         return redirect('/admin/login')->with('success', 'email sucessfully send!');   
		} else {
            return redirect('/admin/login')->with('error', 'Something went wrong.');   
		}
        //return redirect()->route('reset.password.get',$request->_token);
      }
      
      public function showResetPasswordForm($token) {
        //   dd($token);
          $email=User::where('remember_token',$token)->pluck('email')->first();
         return view('admin.auth.passwords.forgetPasswordLink', compact('email'));
      }
  
      /**
       * Write code on Method
       *
       * @return response()
       */
      public function submitResetPasswordForm(Request $request)
      {
        //   dd($request);
          $request->validate([
              'email' => 'required|email|exists:users',
              'password' => 'required|min:6|without_spaces|string|confirmed',
              'password_confirmation' => 'required'
          ],
          [
              'email' => 'The email is required.',
              'password.required' => 'The password is required.',
              'password.without_spaces' => 'The password does not allowed white space.',
          ]);
  
          $updatePassword = DB::table('users')
                              ->where([
                                'email' => $request->email, 
                                // 'token' => $request->token
                              ])
                              ->first();
  
          if(!$updatePassword){
              return redirect()->back()->with('error', 'Invalid user!');
            //   return back()->withInput()->with('error', 'Invalid user!');
          }
  
          /*$user = User::where('email', $request->email)
                      ->update(['password' => Hash::make($request->password)]);
          $user = User::find($updatePassword->id);
          $user->setRememberToken(Str::random(60));
          $user->save();*/
          
          $user =  User::find($updatePassword->id);
          $user->password =  Hash::make($request->password);
          $user->save();
          event(new PasswordReset($user));
        
        //   DB::table('users')->where(['email'=> $request->email])->delete();
  
          return redirect('/admin/login')->with('success', 'Your password has been changed!');
      }
}