<?php

namespace App\Http\Controllers\Admin\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB; 

class LoginController extends Controller
{

    public function showLoginForm()
    {
        return view('admin.auth.login');
    }
    public function login_old(Request $request)
    {
        $credentials = $request->only('name', 'password');
		$user = DB::table('users')->where(['name' => $request->name])->first();
		if($user){
			//if (Auth::attempt($credentials)) {
			if(Hash::check($request->password,$user->password)){
				// Check if the authenticated user has the 'admin' role
				if ($user->role === 'admin') {
					session_start();
					$_SESSION['adminlogin'] = $user->id;
					$_SESSION['admin_name'] = $user->name;
					$_SESSION['admin_email'] = $user->email;
					return redirect()->intended('/admin/dashboard');
				} else {
					// If the user does not have the 'admin' role, log them out
					//Auth::logout();
					unset($_SESSION['adminlogin']);
					unset($_SESSION['admin_name']);
					unset($_SESSION['admin_email']);
					return redirect('/admin/login')->with('error', 'Invalid credentials');
				}
			}
		}

        return redirect()->back()->withInput($request->only('name'))->with('error', 'Invalid credentials');
    }
    
    public function login(Request $request)
    {
        $validate = $request->validate([
			'email' => "required",
			'password' => "required",
		],[
            'email.required' => 'The Email is required.',
            'password.required' => 'The password is required.',
        ]);
        $credentials = $request->only('email', 'password');

        if (Auth::attempt($credentials)) { 
            // Check if the authenticated user has the 'admin' role
                
            if (Auth::user()->role === 'admin') {
                return redirect()->intended('/admin/dashboard');
            } else {
                // If the user does not have the 'admin' role, log them out
                Auth::logout();
                return redirect('/admin/login')->with('error', 'Invalid credentials');
            }
        }

        return redirect()->back()->withInput($request->only('name'))->with('error', 'Invalid credentials');
    }
    public function logout(Request $request)
    {
        Auth::guard('admin')->logout();
        $request->session()->invalidate();
// 		session_start();
// 		unset($_SESSION['adminlogin']);
// 		unset($_SESSION['admin_name']);
// 		unset($_SESSION['admin_email']);
        return redirect('/admin/login');
    }

    
}








