<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\City;
use App\Models\Country;
use App\Models\State;
use Datatables;

class CityController extends Controller
{
	public function index(Request $request)
	{
		if ($request->ajax()) {
			$city = City::with('State')->get();
			return datatables()->of($city)
			    ->addColumn('state', function ($row) {
					$state = '';
					if(is_object($row->State)){
						$state = $row->State->name;
					}
					return $state;
				})
				->addColumn('action', function ($row) {
					$html = '';
					$html .= '<a href="' . route('city.edit', $row->id) . '" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a> ';
					$html .= '&nbsp;<a href="' . route('city.show', $row->id) . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View</a> ';
					$html .= '&nbsp;<a href="javascript:;" class="btn btn-danger btn-delete btn-sm" data-toggle="tooltip" data-original-title="Delete" data-container="body" title="" onclick="return record_delete(\'' . route('city.destroy', $row->id) . '\');" ><i class="fa fa-trash" aria-hidden="true"></i> Delete</a>';
					if ($row->status == 1) {
						$html .= '<a href="' . route('inactive.city', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Inactive this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-success"></i></a>';
					} else {
						$html .= '<a href="' . route('active.city', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Activate this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-muted"></i></a>';
					}
					$html .= '';

					$html .= '<a href="" class="</a>';
					return $html;
				})->toJson();
		}
		$return_data = array();
		$return_data['page_condition'] = 'city_page';
		$return_data['site_title'] = 'City | ' . config('constants.SITE_NAME');
		return view('admin.city.index', array_merge($return_data));
	}
	public function create()
	{
		$return_data = array();
		$cities = City::get();
		$country = Country::where('status','1')->get();
		$state = State::where('status','1')->get();
		$return_data['cities'] = $cities;
		$return_data['country'] = $country;
		$return_data['state'] = $state;
		$return_data['page_condition'] = 'city_page';
		$return_data['site_title'] = 'City | ' . config('constants.SITE_NAME');
		return view('admin.city.form', array_merge($return_data));
	}
	public function store(Request $request)
	{
		$id = 0;
		$validate = $request->validate(
			[
				'name' => "required",
				'country_id' => "required",
				'state_id' => "required",
				'sequence' => "required|max:8",
			],
			[
				'name.required' => 'The city name is required.',
				'country_id.required' => 'The country is required.',
				'state_id.required' => 'The state is required.',
				// 'name.unique' => 'The city name has already been taken.',
				'sequence.required' => 'The sort order is required.',
				'sequence.max' => 'The sort order should be a valid 8-digit number.',
			]
		);

		$stateCheck = 0;
		if($request->country_id && $request->name && $request->state_id){
			$stateCheck = City::where('id','!=',$id)->where('state_id',$request->state_id)->where('country_id',$request->country_id)->where('name',$request->name)->count();
		}
		if($stateCheck){
			return redirect()->back()->withErrors(['name' => 'The city name already exists in this state and country.'])->withInput();
		}

		if ($validate) {
			$all_data = $request->all();
			$all_data['status'] = 1;
			$city = City::create($all_data);
			//$request_data = array('new_data' => $_REQUEST);
			//$this->log_insert("City Created" , $request_data);
			if ($request->save) {
				return redirect(route('city.edit', $city->id))->with('success_message', trans('Added Successfully'));
			} else {
				return redirect(route('city.index'))->with('success_message', trans('Added Successfully'));
			}
		}
	}

	public function show($id)
	{
		$city = City::with('Country','State')->find($id);
		$return_data = array();
		$return_data['city'] = $city;
		$return_data['page_condition'] = 'city_page';
		$return_data['site_title'] = 'City | ' . config('constants.SITE_NAME');
		return view('admin.city.view', array_merge($return_data));
	}

	public function edit($id)
	{
		$cities = City::get();
		$city = City::find($id);
		$country = Country::where('status','1')->get();
		$state = State::where('status','1')->get();
		$return_data = array();
		$return_data['country'] = $country;
		$return_data['state'] = $state;
		$return_data['city'] = $city;
		$return_data['cities'] = $cities;
		$return_data['page_condition'] = 'city_page';
		$return_data['site_title'] = 'City | ' . config('constants.SITE_NAME');
		return view('admin.city.form', array_merge($return_data));
	}
	public function update(Request $request, $id)
	{
		$validate = $request->validate(
			[
				'name' => "required",
				'sequence' => "required|max:8",
				'country_id' => "required",
				'state_id' => "required",
			],
			[
				'name.required' => 'The city name is required.',
				// 'name.unique' => 'The city name has already been taken.',
				'country_id.required' => 'The country is required.',
				'state_id.required' => 'The state is required.',
				'sequence.required' => 'The sort order is required.',
				'sequence.max' => 'The sort order should be a valid 8-digit number.',
			]
		);
				
		$stateCheck = 0;
		if($request->country_id && $request->name && $request->state_id){
			$stateCheck = City::where('id','!=',$id)->where('state_id',$request->state_id)->where('country_id',$request->country_id)->where('name',$request->name)->count();
		}
		if($stateCheck){
			return redirect()->back()->withErrors(['name' => 'The city name already exists in this state and country.'])->withInput();
		}
		
		if ($validate) {
			$city = City::find($id);
			$all_data = $request->all();
			//$request_data = array('old_data' => $city,'new_data' => $_REQUEST);
			//$this->log_insert("City Updated" , $request_data);
			$city->update($all_data);
			if ($request->save) {
				return redirect(route('city.edit', $city->id))->with('success_message', trans('Update Successfully'));
			} else {
				return redirect(route('city.index'))->with('success_message', trans('Update Successfully'));
			}
		}
	}
	public function destroy($id)
	{
		$city = City::find($id);
		//$request_data = array('old_data' => $city,'new_data' => $_REQUEST);
		//$this->log_insert("City Deleted" , $request_data);
		$city->delete();
		return redirect()->route("city.index")->with('success_message', 'Delete Successfully!');
	}
	public function setActivate($id)
	{
		$update_status = City::find($id);
		$update_status->status = 1;
		$update_status->save();
		//$request_data = array('old_data' => $update_status,'new_data' => $_REQUEST);
		//$this->log_insert("City Status Active" , $request_data);
		return redirect(route('city.index'))->with('success_message', trans('Active Successfully'));
	}
	public function setInactivate($id)
	{
		$update_status = City::find($id);
		$update_status->status = 0;
		$update_status->save();
		//$request_data = array('old_data' => $update_status,'new_data' => $_REQUEST);
		//$this->log_insert("city Status Inactive" , $request_data);
		return redirect(route('city.index'))->with('success_message', trans('Inactive Successfully'));
	}
}
