<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\City;
use App\Models\Country;
use App\Models\Company;
use Datatables;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use File;
use Illuminate\Support\Str;

class CompanyController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $company = Company::get();
            return datatables()->of($company)
                ->addColumn('action', function ($row) {
                    $html = '';
                    $html .= '<a href="' . route('company.edit', $row->id) . '" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a> ';
                    //$html .= '&nbsp;<a href="' . route('company.show', $row->id) . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View</a> ';
                    //$html .= '&nbsp;<a href="javascript:;" class="btn btn-danger btn-delete btn-sm" data-toggle="tooltip" data-original-title="Delete" data-container="body" title="" onclick="return record_delete(\'' . route('company.destroy', $row->id) . '\');" ><i class="fa fa-trash" aria-hidden="true"></i> Delete</a>';
                    // if ($row->status == 1) {
                    //     $html .= '<a href="' . route('company.inactive', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Inactive this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-success"></i></a>';
                    // } else {
                    //     $html .= '<a href="' . route('company.active', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Activate this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-muted"></i></a>';
                    // }
                    $html .= '';

                    $html .= '<a href="" class="</a>';
                    return $html;
                })->toJson();
        }
        $return_data = array();
        $return_data['page_condition'] = 'company_page';
        $return_data['site_title'] = 'Company | ' . config('constants.SITE_NAME');
        return view('admin.company.index', array_merge($return_data));
    }

    public function create()
    {
        $return_data = array();
        $country = Country::where('status','1')->get();
        $countryphonecode = Country::select('id','name','phonecode')->whereNotNull('phonecode')->where('phonecodedigit','!=','0')->where('status','1')->where('phonecodestatus','1')->get();
        $return_data['countryphonecode'] = $countryphonecode;
        $return_data['page_condition'] = 'company_page';
        $destinationPath_company = public_path('images').'/company';
        $return_data['destinationPath_company'] = $destinationPath_company;
        $return_data['site_title'] = 'Company | ' . config('constants.SITE_NAME');
        $return_data['country'] = $country;
        return view('admin.company.form', array_merge($return_data));
    }

    public function store(Request $request)
    {
        $id = 0;
        $countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('id',$request->phonecode)->first();
        $phonecodedigit = 0;
        if($countryphonecode_detail){
            $phonecodedigit = $countryphonecode_detail->phonecodedigit;
        }
        $validate = $request->validate(
            [
                'name' => "required",
                'sequence' => "required|max:8",
                'phonecode' => "required",
                'phone_number' => "required|digits:".$phonecodedigit,
                'email_address' => "required|email",
                'address' => "required",
                'state_id' => "required",
                'country_id' => "required",
                'logo_image' => "required|mimes:jpeg,jpg,png",//'nullable
            ],
            [
                'name.required' => 'The name is required.',
                'email_address' => 'The email is required.',
                'email_address.email' => 'Please enter valid email.',
                'email_address.unique' => 'The email has been already taken.',
                'phonecode.required' => 'The phone code is required.',
                'phone_number.required' => 'The mobile number is required.',
                'phone_number.digits' => 'The mobile number must be '.$phonecodedigit.' digits.',
                'sequence.required' => 'The sort order is required.',
                'sequence.max' => 'The sort order should be a valid 8-digit number.',
                'state_id.required' => 'The state is required.',
                'country_id.required' => 'The country is required.',
                'address.required' => 'The address is required.',
            ]
        );
        
        // Manually check the second table
        $email = $request->input('email_address');
        $existsIncompanys = Company::where('email_address', $email)->exists();
        
        if ($existsIncompanys) {
            return redirect()->back()->withErrors(['email_address' => 'The email has been already taken.'])->withInput();
        }
        
        if ($validate) {

            $company = new Company();
            $company->name = $request->name;
            $company->address = $request->address;
            $company->address_2 = $request->address_2;
            $company->address_3 = $request->address_3;
            $company->country_id = $request->country_id;
            $company->state_id = $request->state_id;
            $company->phonecode_id = $request->phonecode;
            $destinationPath = public_path('images').'/company';
            File::makeDirectory($destinationPath, $mode = 0777, true, true);
            if($request->logo_image != ''){
                $original_name = $request->logo_image->getClientOriginalName();
                $file_size = $request->logo_image->getSize();
                $extension = $request->logo_image->extension();
                $random_number = Str::random(3);
                $logo_image = $random_number.'_'.$original_name;
                $request->logo_image->move($destinationPath, $logo_image);
                $company->logo_image = $logo_image;
            }    
            $phonecode = '';
            $countryphonecode_detail = Country::select('id','name','phonecode')->where('id',$request->phonecode)->whereNotNull('phonecode')->first();
            if($countryphonecode_detail){
                $phonecode = $countryphonecode_detail->phonecode;
            }
            $company->phonecode = $phonecode;
            $company->phone_number = $request->phone_number;
            $company->email_address = $request->email_address;
            $company->password = Hash::make('123456');
            $company->sequence = $request->sequence;
            $company->status = 1;
            $company->save();
            $id = $company->id;
            if ($request->save) {
                return redirect(route('company.edit', $company->id))->with('success_message', trans('Added Successfully'));
            } else {
                return redirect(route('company.index'))->with('success_message', trans('Added Successfully'));
            }
        }
    }

    public function show($id)
    {
        $company = Company::with('City','Country','State')->find($id);
        $return_data = array();
        $return_data['data'] = $company;
        $return_data['id'] = $id;
        $return_data['page_condition'] = 'company_page';
        $return_data['site_title'] = 'Company | ' . config('constants.SITE_NAME');
        return view('admin.company.view', array_merge($return_data));
    }
    public function edit($id)
    {
        $data = Company::find($id);
        $country = Country::where('status','1')->get();
        $return_data = array();
        $return_data['data'] = $data;
        $return_data['country'] = $country;
        $destinationPath = 'images/company/';
        $return_data['destinationPath'] = $destinationPath;
        $countryphonecode = Country::select('id','name','phonecode')->whereNotNull('phonecode')->where('phonecodedigit','!=','0')->where('status','1')->where('phonecodestatus','1')->get();
        $return_data['countryphonecode'] = $countryphonecode;
        $return_data['page_condition'] = 'company_page';
        $return_data['site_title'] = 'Company | ' . config('constants.SITE_NAME');
        return view('admin.company.form', array_merge($return_data));
    }
    public function update(Request $request)
    {
        $id = $request->id;
        $countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('id',$request->phonecode)->first();
        $phonecodedigit = 0;
        if($countryphonecode_detail){
            $phonecodedigit = $countryphonecode_detail->phonecodedigit;
        }
        $destinationPath = public_path('images').'/company/';
        $company_detail = Company::find($id);
        $logo_image_flage = 'required';
        if($company_detail){
            $logo_image = $company_detail->logo_image;
            if($logo_image != ''){
                $logo_image = $destinationPath.$company_detail->logo_image;
                if(file_exists($logo_image)){
                    $logo_image_flage = 'nullable';
                }
            }    
        }
        $validate = $request->validate(
            [
                'name' => "required",
                'sequence' => "required|max:8",
                'phonecode' => "required",
                'phone_number' => "required|digits:".$phonecodedigit,
                'email_address' => "required|email",
                'state_id' => "required",
                'country_id' => "required",
                'address' => "required",
                'logo_image' => $logo_image_flage."|mimes:jpeg,jpg,png",//'nullable
            ],
            [
                'name.required' => 'The name is required.',
                // 'name.unique' => 'The Name has already been taken.',
                'email_address' => 'The email is required.',
                'email_address.email' => 'Please enter valid email.',
                'email_address.unique' => 'The email has been already taken.',
                'phonecode.required' => 'The phone code is required.',
                'phone_number.required' => 'The mobile number is required.',
                'phone_number.digits' => 'The mobile number must be '.$phonecodedigit.' digits.',
                'sequence.required' => 'The sort order is required.',
                'sequence.max' => 'The sort order should be a valid 8-digit number.',
                'state_id.required' => 'The state is required.',
                'country_id.required' => 'The country is required.',
                'address.required' => 'The address is required.',
            ]
        );
        if ($validate) {
            $company = Company::find($id);
            $company->name = $request->name;
            $company->address = $request->address;
            $company->address_2 = $request->address_2;
            $company->address_3 = $request->address_3;
            $company->country_id = $request->country_id;
            $company->state_id = $request->state_id;
            $company->phonecode_id = $request->phonecode;
            $phonecode = '';
            $countryphonecode_detail = Country::select('id','name','phonecode')->where('id',$request->phonecode)->whereNotNull('phonecode')->first();
            if($countryphonecode_detail){
                $phonecode = $countryphonecode_detail->phonecode;
            }
            $company->phonecode = $phonecode;
            $company->phone_number = $request->phone_number;
            $company->email_address = $request->email_address;
            if($request->password){
                $company->password = Hash::make($request->password);
            }
            File::makeDirectory($destinationPath, $mode = 0777, true, true);
            if($request->logo_image != ''){
                $original_name = $request->logo_image->getClientOriginalName();
                $file_size = $request->logo_image->getSize();
                $extension = $request->logo_image->extension();
                $random_number = Str::random(3);
                $logo_image = $random_number.'_'.$original_name;
                $request->logo_image->move($destinationPath, $logo_image);
                $company->logo_image = $logo_image;
            } 
            $company->sequence = $request->sequence;
            $company->pincode_number = $request->pincode_number;
            $company->save();

            if ($request->save) {
                return redirect(route('company.edit', $company->id))->with('success_message', trans('Update Successfully'));
            } else {
                return redirect(route('company.index'))->with('success_message', trans('Update Successfully'));
            }
        }
    }
    public function destroy($id)
    {
        $company = Company::find($id);
        $company->delete();
        return redirect()->route("company.index")->with('success_message', 'Delete Successfully!');
    }

    public function setActivate($id)
    {
        $update_status = Company::find($id);
        $update_status->status = 1;
        $update_status->save();
        return redirect(route('company.index'))->with('success_message', trans('Active Successfully'));
    }

    public function setInactivate($id)
    {
        $update_status = Company::find($id);
        $update_status->status = 0;
        $update_status->save();
        return redirect(route('company.index'))->with('success_message', trans('Inactive Successfully'));
    }
}
