<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\City;
use App\Models\Content;
use Datatables;

class ContentController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $Content = Content::all();
            return datatables()->of($Content)
                ->addColumn('action', function ($row) {
                    $html = '';
                    $html .= '<a href="' . route('content.edit', $row->id) . '" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a> ';
                    $html .= '&nbsp;<a href="' . route('content.show', $row->id) . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View</a> ';
                    //$html .= '&nbsp;<a href="javascript:;" class="btn btn-danger btn-delete btn-sm" data-toggle="tooltip" data-original-title="Delete" data-container="body" title="" onclick="return record_delete(\'' . route('content.destroy', $row->id) . '\');" ><i class="fa fa-trash" aria-hidden="true"></i> Delete</a>';
                    if ($row->status == 1) {
                        $html .= '<a href="' . route('content.inactive', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Inactive this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-success"></i></a>';
                    } else {
                        $html .= '<a href="' . route('content.active', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Activate this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-muted"></i></a>';
                    }
                    $html .= '';

                    $html .= '<a href="" class="</a>';
                    return $html;
                })->toJson();
        }
        $return_data = array();
        $return_data['page_condition'] = 'content_page';
        $return_data['site_title'] = 'Content | ' . config('constants.SITE_NAME');
        return view('admin.content.index', array_merge($return_data));
    }

    public function create()
    {
        $return_data = array();
        $city = City::where('status', '1')->get();
        $return_data['page_condition'] = 'content_page';
        $return_data['site_title'] = 'Content | ' . config('constants.SITE_NAME');
        $return_data['city'] = $city;
        return view('admin.content.form', array_merge($return_data));
    }

    public function store(Request $request)
    {
        $id = 0;
        $validate = $request->validate(
            [
                'page_name' => "required|unique:contents,page_name," . $id . ",id,deleted_at,NULL",
               
                'page_title' => "required"
            ],
            [
                'page_name.required' => 'The page name is required.',
                'page_name.unique' => 'The page name has been already taken.',
                'page_title' => 'The page title is required.',
            ]
        );

        if ($validate) {

            $Content = new Content();
            $Content->page_name = $request->page_name;
            $Content->page_title = $request->page_title;
            $Content->content = $request->content;
            $Content->status = 1;
            $Content->save();

            if ($request->save) {
                return redirect(route('content.edit', $Content->id))->with('success_message', trans('Added Successfully'));
            } else {
                return redirect(route('content.index'))->with('success_message', trans('Added Successfully'));
            }
        }
    }

    public function show($id)
    {
        $Content = Content::find($id);
        $return_data = array();
        $return_data['data'] = $Content;
        $return_data['page_condition'] = 'content_page';
        $return_data['site_title'] = 'Content | ' . config('constants.SITE_NAME');
        return view('admin.content.view', array_merge($return_data));
    }

    public function edit($id)
    {
        $data = Content::find($id);
        $city = City::where('status', '1')->get();
        $return_data = array();
        $return_data['data'] = $data;
        $return_data['city'] = $city;
        $return_data['page_condition'] = 'content_page';
        $return_data['site_title'] = 'Content | ' . config('constants.SITE_NAME');
        return view('admin.content.form', array_merge($return_data));
    }
    public function update(Request $request)
    {
        $id = $request->id;
        $validate = $request->validate(
            [
                // 'page_name' => "required|unique:contents,page_name," . $id . ",id,deleted_at,NULL",
                'page_title' => "required"
            ],
            [
                // 'page_name.required' => 'The page name field is required.',
                // 'page_name.unique' => 'The page name has already been taken..',
                'page_title' => 'The page title is required.',
            ]

        );
        if ($validate) {

            $Content = Content::find($id);
            // $Content->page_name = $request->page_name;
            $Content->page_title = $request->page_title;
            $Content->content = $request->content;
            $Content->save();

            if ($request->save) {
                return redirect(route('content.edit', $Content->id))->with('success_message', trans('Update Successfully'));
            } else {
                return redirect(route('content.index'))->with('success_message', trans('Update Successfully'));
            }
        }
    }
    public function destroy($id)
    {
        $Content = Content::find($id);
        $Content->delete();
        return redirect()->route("content.index")->with('success_message', 'Delete Successfully!');
    }

    public function setActivate($id)
    {
        $update_status = Content::find($id);
        $update_status->status = 1;
        $update_status->save();
        return redirect(route('content.index'))->with('success_message', trans('Active Successfully'));
    }

    public function setInactivate($id)
    {
        $update_status = Content::find($id);
        $update_status->status = 0;
        $update_status->save();
        return redirect(route('content.index'))->with('success_message', trans('Inactive Successfully'));
    }
}
