<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Country;
use Datatables;

class CountryController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $country = Country::all();
            return datatables()->of($country)
                ->addColumn('action', function ($row) {
                    $html = '';
                    $html .= '<a href="'.route('country.edit',$row->id).'" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a> ';
                    $html .= '&nbsp;<a href="'.route('country.show',$row->id).'" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View</a> ';
					$html .= '&nbsp;<a href="javascript:;" class="btn btn-danger btn-delete btn-sm" data-toggle="tooltip" data-original-title="Delete" data-container="body" title="" onclick="return record_delete(\''.route('country.destroy', $row->id).'\');" ><i class="fa fa-trash" aria-hidden="true"></i> Delete</a>';
					if($row->status == 1){
                		$html .= '<a href="'.route('inactive.country',array('id'=>$row->id)).'" onClick="return alertconfirm(\'Are you sure you want to Inactive this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-success"></i></a>';
                	}else{
                        $html .= '<a href="'.route('active.country',array('id'=>$row->id)).'" onClick="return alertconfirm(\'Are you sure you want to Activate this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-muted"></i></a>';
                    }
					
					$html .= '';
					
					$html .= '<a href="" class="</a>';
                    return $html;
                })->addColumn('phonecode', function ($row) {
                    $name = '';
					$name = '<span style="color:red;">'.$row->phonecode.'</span>';
                    if ($row->phonecodestatus == 1) {
                        $name = '<span style="color:green;">'.$row->phonecode.'</span>';
                    }
                    return $name;
                })->rawColumns(['phonecode','action'])->toJson();
        }
        $return_data = array();
        $return_data['page_condition'] = 'country_page';
		$return_data['site_title'] = 'Country | ' . config('constants.SITE_NAME');
		return view('admin.country.index', array_merge($return_data));
    }
    public function create(){
		$countryGet = Country::get();
		$return_data = array();
		$return_data['countries'] = $countryGet;
		$return_data['page_condition'] = 'country_page';
		$return_data['site_title'] = 'Country | ' . config('constants.SITE_NAME');
		return view('admin.country.form', array_merge($return_data));
	}
    public function store(Request $request)
    {
        $id = 0;
		$validate = $request->validate([
			'name' => "required|unique:country,name,".$id.",id,deleted_at,NULL",
			//'phonecode' => "required",
			// 'sequence' => "required|max:8",
		],[
            'name.required' => 'The country name is required.',
            'name.unique' => 'The country name has already been taken.',
			'phonecode' => "The Phone Code is required.",
            // 'sequence.required' => 'The sort order is required.',
            // 'sequence.max' => 'The sort order should be a valid 8-digit number.',
        ]
		);
  
		if($validate){
			$all_data = $request->all();
			$all_data['status'] = 1;
			$phonecodestatus = isset($_POST['phonecodestatus']) ? $_POST['phonecodestatus'] : 0;
			$all_data['phonecodestatus'] = $phonecodestatus;
            $country = Country::create($all_data);
            //$request_data = array('new_data' => $_REQUEST);
			//$this->log_insert("Country Created" , $request_data);
			if ($request->save) {	
				return redirect(route('country.edit',$country->id))->with('success_message', trans('Added Successfully'));
			}else{
	            return redirect(route('country.index'))->with('success_message', trans('Added Successfully'));
	        }
		}
    }

    public function show($id)
    {
        $country = Country::find($id);
		$return_data = array();
        $return_data['country'] = $country;
		$return_data['page_condition'] = 'country_page';
		$return_data['site_title'] = 'Country | ' . config('constants.SITE_NAME');
		return view('admin.country.view', array_merge($return_data));
    }

    public function edit($id){
		$countryGet = Country::get();
		$country = Country::find($id);
		$return_data = array();
        $return_data['country'] = $country;
        $return_data['countries'] = $countryGet;
		$return_data['page_condition'] = 'country_page';
		$return_data['site_title'] = 'Country | ' . config('constants.SITE_NAME');
		return view('admin.country.form', array_merge($return_data));
	}
	public function update(Request $request, $id){
		$validate = $request->validate([
			'name' => "required|unique:country,name,".$id.",id,deleted_at,NULL",
			//'phonecode' => "required",
			// 'sequence' => "required|max:8",
		],[
    'name.required' => 'The country name is required.',
    'name.unique' => 'The country name has already been taken.',
	'phonecode' => "The Phone Code is required.",
    // 'sequence.required' => 'The sort order is required.',
    // 'sequence.max' => 'The sort order should be a valid 8-digit number.',
]
	
		);
		if($validate){
			$country = Country::find($id);
			$all_data = $request->all();
			//$request_data = array('old_data' => $country,'new_data' => $_REQUEST);
			//$this->log_insert("Country Updated" , $request_data);
			$phonecodestatus = isset($_POST['phonecodestatus']) ? $_POST['phonecodestatus'] : 0;
			$all_data['phonecodestatus'] = $phonecodestatus;
			$country->update($all_data); 
	        if ($request->save) {
				return redirect(route('country.edit',$country->id))->with('success_message', trans('Update Successfully'));
			}else{
	            return redirect(route('country.index'))->with('success_message', trans('Update Successfully'));
	        }
		}
	}
	public function destroy($id){
		$country = Country::find($id);
		//$request_data = array('old_data' => $country,'new_data' => $_REQUEST);
		//$this->log_insert("Country Deleted" , $request_data);
		$country->delete();
		return redirect()->route("country.index")->with('success_message', 'Delete Successfully!');
	}
    public function setActivate($id){
        $update_status = Country::find($id);
        $update_status->status = 1;
        $update_status->save();
        //$request_data = array('old_data' => $update_status,'new_data' => $_REQUEST);
		//$this->log_insert("country Status Active" , $request_data);
        return redirect(route('country.index'))->with('success_message', trans('Active Successfully'));
    }
    public function setInactivate($id) {
        $update_status = Country::find($id);
        $update_status->status = 0;
        $update_status->save();
        //$request_data = array('old_data' => $update_status,'new_data' => $_REQUEST);
		//$this->log_insert("Country Status Inactive" , $request_data);
        return redirect(route('country.index'))->with('success_message', trans('Inactive Successfully'));
    }
}
