<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\City;
use App\Models\Country;
use App\Models\Group;
use App\Models\CustomerUser;
use App\Models\CustomerContactDetail;
use App\Helper\Helpers;
use App\Models\Reminder;
use App\Models\Document;
use App\Models\ReminderCustomerDocument;
use App\Models\MailSendLog;
use App\Models\MailSendLogDocument;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\CustomerUserImport;
use Datatables;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;

class CustomerUserController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $CustomerUser = CustomerUser::with('City','Group')->get();
            return datatables()->of($CustomerUser)
                ->addColumn('city', function ($row) {
                    $city = '';
                    if(is_object($row->city)){
                        $city = $row->city->name;
                    }
                    return $city;
                })
                ->addColumn('group_name', function ($row) {
                    $name = '';
                    if (is_object($row->Group)) {
                        $name = $row->Group->name;
                    }
                    return $name;
                })
                ->addColumn('action', function ($row) {
                    $html = '';
                    $html .= '<a href="' . route('customer.user.edit', $row->id) . '" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a> ';
                    $html .= '&nbsp;<a href="' . route('customer.user.show', $row->id) . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View</a> ';
                    $html .= '&nbsp;<a href="' . route('customer.user.emailtrack', $row->id) . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> Track</a> ';
                    $html .= '&nbsp;<a href="' . route('customer.user.reminder', $row->id) . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> Reminder</a> ';
                    $html .= '&nbsp;<a href="javascript:;" class="btn btn-danger btn-delete btn-sm" data-toggle="tooltip" data-original-title="Delete" data-container="body" title="" onclick="return record_delete(\'' . route('customer.user.destroy', $row->id) . '\');" ><i class="fa fa-trash" aria-hidden="true"></i> Delete</a>';
                    // if ($row->status == 1) {
                    //     $html .= '<a href="' . route('customer.user.inactive', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Inactive this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-success"></i></a>';
                    // } else {
                    //     $html .= '<a href="' . route('customer.user.active', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Activate this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-muted"></i></a>';
                    // }
                    $html .= '';

                    $html .= '<a href="" class="</a>';
                    return $html;
                })->toJson();
        }
        $return_data = array();
        $return_data['page_condition'] = 'customer_user_page';
        $return_data['site_title'] = 'Customer User | ' . config('constants.SITE_NAME');
        return view('admin.customer_user.index', array_merge($return_data));
    }

    public function create()
    {
        $return_data = array();
        $country = Country::where('status','1')->get();
        $city = City::where('status', '1')->orderBy('sequence','asc')->get();
        $countryphonecode = Country::select('id','name','phonecode')->whereNotNull('phonecode')->where('phonecodedigit','!=','0')->where('status','1')->where('phonecodestatus','1')->get();
        $return_data['countryphonecode'] = $countryphonecode;
        $return_data['page_condition'] = 'customer_user_page';
        $return_data['site_title'] = 'Customer User | ' . config('constants.SITE_NAME');
        $return_data['city'] = $city;
        $return_data['country'] = $country;
        $group = Group::where('status','1')->get();
        $return_data['group'] = $group;
        return view('admin.customer_user.form', array_merge($return_data));
    }

    public function store(Request $request)
    {
        $id = 0;
        $countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('id',$request->phonecode)->first();
        $phonecodedigit = 0;
        if($countryphonecode_detail){
            $phonecodedigit = $countryphonecode_detail->phonecodedigit;
        }
        $validate = $request->validate(
            [
                'name' => "required",
                'group_id' => "required",
                'sequence' => "required|max:8",
                'phonecode' => "required",
                'phone_number' => "required|digits:".$phonecodedigit,
                'email_address' => "required|email|unique:customer_users,email_address," . $id . ",id,deleted_at,NULL",
                'password' => "required|min:6|without_spaces",
                //'city_id' => "required",
                'address' => "required",
                'state_id' => "required",
                'country_id' => "required",
                'district' => 'max:255',//required|
                //'pincode_number' => 'required|max:6|min:6',
                'contact_name.*' => 'required',
                //'contact_email.*' => 'required',
                'contact_email.*' => ['required','email', 'distinct'],
                //'contact_email.*' => ['required','email', 'distinct', Rule::unique('customer_contact_details', 'email')->whereNot('customer_id', $id)->where('deleted_at',null)],
                //'contact_mobile_number.*' => ['nullable', 'distinct', Rule::unique('customer_contact_details', 'mobile_number')->whereNot('customer_id', $id)->where('deleted_at',null)],
            ],
            [
                'name.required' => 'The name is required.',
                // 'name.unique' => 'The Name has already been taken.',
                'group_id.required' => 'The group is required.',
                'email_address' => 'The email is required.',
                'email_address.email' => 'Please enter valid email.',
                'email_address.unique' => 'The email has been already taken.',
                'phonecode.required' => 'The phone code is required.',
                'phone_number.required' => 'The mobile number is required.',
                'phone_number.digits' => 'The mobile number must be '.$phonecodedigit.' digits.',
                'phone_number.min' => 'The mobile number should be 10 digits.',
                'phone_number.max' => 'The mobile number should be 10 digits.',
                'password.required' => 'The password is required.',
                'password.without_spaces' => 'The password does not allowed white space.',
                'sequence.required' => 'The sort order is required.',
                'sequence.max' => 'The sort order should be a valid 8-digit number.',
                'city_id.required' => 'The city is required.',
                'state_id.required' => 'The state is required.',
                'country_id.required' => 'The country is required.',
                'address.required' => 'The address is required.',
                'district.required' => 'The district is required.',
                'pincode_number.required' => 'The pin code number is required.',
                'pincode_number.min' => 'The pin code number should be 6 digits.',
                'pincode_number.max' => 'The pin code number should be 6 digits.', 
                
                'contact_name.*.required' => 'The Contact Name is required.',
                'contact_email.*.required' => 'The Contact Email is required.',
                'contact_email.*.email' => 'Please enter valid email.',
                'contact_email.*.distinct' => 'Contact Email is has a duplicate value.',
                'contact_email.*.unique' => 'Contact Email has already been taken.',
                'contact_mobile_number.*.required' => 'The Contact Mobile Number is required.',
                'contact_mobile_number.*.distinct' => 'Contact Mobile Number is has a duplicate value.',
                'contact_mobile_number.*.unique' => 'Contact Mobile Number has already been taken.',
            ]
        );
        
        // Manually check the second table
        $email = $request->input('email_address');
        $existsIncustomerUsers = CustomerUser::where('email_address', $email)->exists();
        
        if ($existsIncustomerUsers) {
            return redirect()->back()->withErrors(['email_address' => 'The email has been already taken.'])->withInput();
        }
        
        if ($validate) {

            $customerUser = new CustomerUser();
            $customerUser->name = $request->name;
            $customerUser->group_id = $request->group_id;
            $customerUser->address = $request->address;
            $customerUser->address_2 = $request->address_2;
            $customerUser->address_3 = $request->address_3;
            $customerUser->country_id = $request->country_id;
            $customerUser->state_id = $request->state_id;
            $customerUser->city_id = $request->city_id;
            $customerUser->phonecode_id = $request->phonecode;
            $phonecode = '';
            $countryphonecode_detail = Country::select('id','name','phonecode')->where('id',$request->phonecode)->whereNotNull('phonecode')->first();
            if($countryphonecode_detail){
                $phonecode = $countryphonecode_detail->phonecode;
            }
            $customerUser->phonecode = $phonecode;
            $customerUser->phone_number = $request->phone_number;
            $customerUser->email_address = $request->email_address;
            $customerUser->password = Hash::make($request->password);
            $customerUser->pincode_number = $request->pincode_number;
            $customerUser->district = $request->district;
            $customerUser->sequence = $request->sequence;
            $customerUser->year_end = $request->year_end;
            $customerUser->status = 1;
            $customerUser->save();
            $id = $customerUser->id;
            $contact_detail_delete = CustomerContactDetail::where('customer_id',$id);
            $contact_detail_delete->delete();
            $more_name = isset($_POST['more_name']) ? $_POST['more_name'] : '';
            $more_email = isset($_POST['more_email']) ? $_POST['more_email'] : '';
            $more_birth_date = isset($_POST['more_birth_date']) ? $_POST['more_birth_date'] : '';
            if($more_birth_date == ''){
                $more_birth_date = NULL;
            }
            $more_phonecode = isset($_POST['more_phonecode']) ? $_POST['more_phonecode'] : 0;
            if($more_phonecode == ''){
                $more_phonecode = 0;
            }
            $more_mobile_number = isset($_POST['more_mobile_number']) ? $_POST['more_mobile_number'] : '';
            if($more_name != '' && $more_email != '' && $more_mobile_number != ''){
                $phonecode = '';
                $countryphonecode_detail = Country::select('id','name','phonecode')->where('id',$more_phonecode)->whereNotNull('phonecode')->first();
                if($countryphonecode_detail){
                    $phonecode = $countryphonecode_detail->phonecode;
                }
                $contact_detail_detail = new CustomerContactDetail();
                $contact_detail_detail->customer_id = $id;
                $contact_detail_detail->name = $more_name;
                $contact_detail_detail->email = $more_email;
                $contact_detail_detail->birth_date = $more_birth_date;
                $contact_detail_detail->phonecode_id = $more_phonecode;
                $contact_detail_detail->phonecode = $phonecode;
                $contact_detail_detail->mobile_number = $more_mobile_number;
                $contact_detail_detail->save();
            }
            $custmer_contact_detail_id = isset($_POST['custmer_contact_detail_id']) ? $_POST['custmer_contact_detail_id'] : array();
            $contact_email = isset($_POST['contact_email']) ? $_POST['contact_email'] : array();
            $contact_birth_date = isset($_POST['contact_birth_date']) ? $_POST['contact_birth_date'] : array();
            $contact_phonecode = isset($_POST['contact_phonecode']) ? $_POST['contact_phonecode'] : array();
            $contact_mobile_number = isset($_POST['contact_mobile_number']) ? $_POST['contact_mobile_number'] : array();
            $contact_name = isset($_POST['contact_name']) ? $_POST['contact_name'] : array();
            if(is_array($contact_name) && count($contact_name) > 0){
                foreach($contact_name as $key=>$contact_name_val){
                    $custmer_contact_detail_id_val = isset($custmer_contact_detail_id[$key]) ? $custmer_contact_detail_id[$key] : 0;
                    $contact_email_val = isset($contact_email[$key]) ? $contact_email[$key] : '';
                    $contact_birth_date_val = isset($contact_birth_date[$key]) ? $contact_birth_date[$key] : '';
                    if($contact_birth_date_val == ''){
                        $contact_birth_date_val = NULL;
                    }
                    $contact_phonecode_val = isset($contact_phonecode[$key]) ? $contact_phonecode[$key] : 0;
                    if($contact_phonecode_val == ''){
                        $contact_phonecode_val = 0;
                    }
                    $contact_mobile_number_val = isset($contact_mobile_number[$key]) ? $contact_mobile_number[$key] : '';
                    $old_count = CustomerContactDetail::withTrashed()->where('customer_id',$id)->where('id',$custmer_contact_detail_id_val)->count();
                    $phonecode = '';
                    $countryphonecode_detail = Country::select('id','name','phonecode')->where('id',$contact_phonecode_val)->whereNotNull('phonecode')->first();
                    if($countryphonecode_detail){
                        $phonecode = $countryphonecode_detail->phonecode;
                    }
                    if($old_count == 0){
                        $contact_detail_detail = new CustomerContactDetail();
                        $contact_detail_detail->customer_id = $id;
                        $contact_detail_detail->name = $contact_name_val;
                        $contact_detail_detail->email = $contact_email_val;
                        $contact_detail_detail->birth_date = $contact_birth_date_val;
                        $contact_detail_detail->phonecode_id = $contact_phonecode_val;
                        $contact_detail_detail->phonecode = $phonecode;
                        $contact_detail_detail->mobile_number = $contact_mobile_number_val;
                        $contact_detail_detail->save();
                    }else{
                        CustomerContactDetail::withTrashed()->where('customer_id',$id)->where('id',$custmer_contact_detail_id_val)->update(['deleted_at' => null,'name' => $contact_name_val,'email' => $contact_email_val,'birth_date' => $contact_birth_date_val,'phonecode_id' => $contact_phonecode_val,'phonecode' => $phonecode,'mobile_number' => $contact_mobile_number_val]);
                    } 
                }
            }
            if ($request->save) {
                return redirect(route('customer.user.edit', $customerUser->id))->with('success_message', trans('Added Successfully'));
            } else {
                return redirect(route('customer.user.index'))->with('success_message', trans('Added Successfully'));
            }
        }
    }

    public function show($id)
    {
        $customerUser = CustomerUser::with('City','Country','State','Group')->find($id);
        $return_data = array();
        $return_data['data'] = $customerUser;
        $return_data['id'] = $id;
        $return_data['page_condition'] = 'customer_user_page';
        $return_data['site_title'] = 'Customer User | ' . config('constants.SITE_NAME');
        return view('admin.customer_user.view', array_merge($return_data));
    }
    public function EmailTrack(Request $request,$customer_id)
    {
        if ($request->ajax()) {
            $filter_reminder_id = isset($_GET['filter_reminder_id']) ? $_GET['filter_reminder_id'] : '';
            $filter_reminder_type = isset($_GET['filter_reminder_type']) ? $_GET['filter_reminder_type'] : '';
            $filter_document_id = isset($_GET['filter_document_id']) ? $_GET['filter_document_id'] : '';
            $name_array = array('Reminder Send','Customer Doument Upload');
            //->whereIn('name', $name_array)
            $reminder_detail_query = MailSendLog::with('Reminder')->with('DocumentList.Document')->where('customer_id', $customer_id)->orderBy('id','DESC');
            if($filter_reminder_id != ''){
                $reminder_detail_query->where('reminder_id',$filter_reminder_id);
            }
            if($filter_reminder_type != ''){
                $reminder_detail_query->where('name',$filter_reminder_type);
            }
            if($filter_document_id != ''){
                //$reminder_detail_query->where('document_id',$filter_document_id);
            }
            $reminder_detail = $reminder_detail_query->get();
            return datatables()->of($reminder_detail)
                ->addColumn('action', function ($row) {
                    $html_data = '';
                    if($row->action_flage == 'reminder_add'){
                        $html_data = 'Reminder Add';
                    }else if($row->action_flage == 'reminder_update'){
                        $html_data = 'Reminder Update';
                    }else if($row->action_flage == 'Customer_Doument_Upload'){
                        $html_data = 'Customer Upload';
                    }else if($row->action_flage == 'reminder_reject'){
                        $html_data = 'Reject';
                    }else if($row->action_flage == 'reminder_resend'){
                        $html_data = 'Resend';
                    }else if($row->action_flage == 'admin_Doument_Upload'){
                        $html_data = 'Admin Upload';
                    }
                    return $html_data;
                })->addColumn('mail_type', function ($row) {
                    $html_data = '';
                    $html_data .= $row->name;
                    if($row->action_flage == 'reminder_reject'){
                        $html_data .= '<span style="color:red;"> - Reject</span>';
                    }else if($row->action_flage == 'admin_Doument_Upload'){
                        $body = $row->body;
                        $body_array = json_decode($body,true);
                        $login_user_name = isset($body_array['login_user_name']) ? $body_array['login_user_name'] : '';
                        if($login_user_name != ''){
                            $html_data .= '<strong> - '.$login_user_name.'</strong>';
                        }    
                    }
                    return $html_data;
                })
                ->addColumn('reminder_name', function ($row) {
                    $name = '';
                    if (is_object($row->Reminder)) {
                        $name = $row->Reminder->name;
                    }
                    return $name;
                })
                ->addColumn('list_of_document', function ($row) use($customer_id) {
                    $list_of_document_html = '';
                    $counter = 1;
                    foreach ($row->DocumentList as $documents_val){
                        if($row->action_flage == 'Customer_Doument_Upload' || $row->action_flage == 'admin_Doument_Upload'){
                            $document_name = '<a target="_blank" href="' . route('reminder.document.index', array('search_customer_id'=>$customer_id,'search_reminder_id'=>$row->reminder_id,'search_document_id'=>$documents_val->Document->id)) . '" class="">'.$documents_val->Document->name.'</a>';
                        }else{
                            $document_name = $documents_val->Document->name;
                        }
                        $list_of_document_html .= $counter.') '.$document_name.'<br>';
                        $counter++;
                    }
                    return $list_of_document_html;
                })
                ->addColumn('send_date', function ($row) {
                    $date = '';
                    if (!empty($row->send_date)) {
                        $date = date('Y-m-d H:i:s', strtotime($row->send_date));
                    } 
                    return $date;
                })->rawColumns(['action','list_of_document','mail_type'])->toJson();
        }
        $reminder_type_list = MailSendLog::select('name')->groupBy('name')->get();
        $return_data['reminder_type_list'] = $reminder_type_list;
        $reminder_list = Reminder::all();
        $return_data['reminder_list'] = $reminder_list;
        $document_list = Document::all();
        $return_data['document_list'] = $document_list;
        $return_data['customer_id'] = $customer_id;
        $search_reminder_id = isset($_GET['search_reminder_id']) ? $_GET['search_reminder_id'] : '';
        $return_data['search_reminder_id'] = $search_reminder_id;
        $search_document_id = isset($_GET['search_document_id']) ? $_GET['search_document_id'] : '';
        $return_data['search_document_id'] = $search_document_id;
        $search_reminder_type = isset($_GET['search_reminder_type']) ? $_GET['search_reminder_type'] : '';
        $return_data['search_reminder_type'] = $search_reminder_type;
        $return_data['page_condition'] = 'customer_user_page';
        $return_data['site_title'] = 'Customer User | ' . config('constants.SITE_NAME');
        return view('admin.customer_user.emailtrack', array_merge($return_data));
    }
    public function documentUploaded(Request $request,$customer_id)
    {
        if ($request->ajax()) {
            $reminder_detail = ReminderCustomerDocument::with('Reminder')->with('Document')->with('CustomerUser')->where('reminder_customer_documents.upload_status', 1)->Where('customer_id',$customer_id)->get();//->WhereNotNull('upload_document')
            return datatables()->of($reminder_detail)
                ->addColumn('action', function ($row) {
                    $html = '<h5 style="color:green;">Not Verify</h5>';
                    if (!empty($row->status == 1)) {
                        $html = '<h5 style="color:green;">Verify</h5>';
                    }
                    return $html;
                })->addColumn('document_file', function ($row) {
                    $html = Helpers::GetDocument($row->id);
                    if($html == ''){
                        $html = $row->upload_comment;
                    }
                    return $html;
                })->addColumn('datetime', function ($row) {
                    $date = '';
                    if (!empty($row->updated_at)) {
                        $date = date('Y-m-d H:i:s', strtotime($row->updated_at));
                    }
                    return $date;
                })->addColumn('document_name', function ($row) {
                    $name = '';
                    if (is_object($row->Document)) {
                        $name = $row->Document->name;
                    }
                    return $name;
                })->addColumn('reminder_name', function ($row) {
                    $name = '';
                    if (is_object($row->Reminder)) {
                        $name = $row->Reminder->name;
                    }
                    return $name;
                })->rawColumns(['document_file','action'])->toJson();
        }
    }
    public function edit($id)
    {
        $data = CustomerUser::find($id);
        $country = Country::where('status','1')->get();
        $city = City::where('status', '1')->orderBy('sequence','asc')->get();
        $return_data = array();
        $return_data['data'] = $data;
        $return_data['city'] = $city;
        $return_data['country'] = $country;
        $group = Group::where('status','1')->get();
        $return_data['group'] = $group;
        $countryphonecode = Country::select('id','name','phonecode')->whereNotNull('phonecode')->where('phonecodedigit','!=','0')->where('status','1')->where('phonecodestatus','1')->get();
        $return_data['countryphonecode'] = $countryphonecode;
        $contact_detail_list = CustomerContactDetail::where('customer_id',$id)->get();
        $return_data['contact_detail_list'] = $contact_detail_list;
        $return_data['page_condition'] = 'customer_user_page';
        $return_data['site_title'] = 'Customer User | ' . config('constants.SITE_NAME');
        return view('admin.customer_user.form', array_merge($return_data));
    }
    public function update(Request $request)
    {
        $id = $request->id;
        $countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('id',$request->phonecode)->first();
        $phonecodedigit = 0;
        if($countryphonecode_detail){
            $phonecodedigit = $countryphonecode_detail->phonecodedigit;
        }
        $validate = $request->validate(
            [
                'name' => "required",
                'group_id' => "required",
                'sequence' => "required|max:8",
                'phonecode' => "required",
                'phone_number' => "required|digits:".$phonecodedigit,
                'email_address' => "required|email|unique:customer_users,email_address," . $id . ",id,deleted_at,NULL",
                'password' => !empty($request->password) ? 'without_spaces|min:6' : '',
                //'city_id' => "required",
                'address' => "required",
                'district' => 'max:255',//required|
                //'pincode_number' => 'required|max:6|min:6',
                'contact_name.*' => 'required',
                //'contact_email.*' => 'required|email|,'.Rule::unique('customer_contact_details','email')->whereNot('customer_id',$id),
                //'contact_email.*' => 'required|email',
                'contact_email.*' => ['required','email', 'distinct'],
                //'contact_email.*' => ['required','email', 'distinct', Rule::unique('customer_contact_details', 'email')->whereNot('customer_id', $id)->where('deleted_at',null)],
                //'contact_mobile_number.*' => 'required',
                //'contact_mobile_number.*' => ['nullable', 'distinct', Rule::unique('customer_contact_details', 'mobile_number')->whereNot('customer_id', $id)->where('deleted_at',null)],
            ],
            [
                'name.required' => 'The name is required.',
                // 'name.unique' => 'The Name has already been taken.',
                'group_id.required' => 'The group is required.',
                'email_address' => 'The email is required.',
                'email_address.email' => 'Please enter valid email.',
                'email_address.unique' => 'The email has been already taken.',
                'phonecode.required' => 'The phone code is required.',
                'phone_number.required' => 'The mobile number is required.',
                'phone_number.digits' => 'The mobile number must be '.$phonecodedigit.' digits.',
                'phone_number.min' => 'The mobile number should be 10 digits.',
                'phone_number.max' => 'The mobile number should be 10 digits.',
                'password.without_spaces' => 'The password does not allowed white space.',
                'sequence.required' => 'The sort order is required.',
                'sequence.max' => 'The sort order should be a valid 8-digit number.',
                'city_id.required' => 'The city is required.',
                'state_id.required' => 'The state is required.',
                'country_id.required' => 'The country is required.',
                'address.required' => 'The address is required.',
                'district.required' => 'The district is required.',
                'pincode_number.required' => 'The pin code number is required.',
                'pincode_number.min' => 'The pin code number should be 6 digits.',
                'pincode_number.max' => 'The pin code number should be 6 digits.', 

                'contact_name.*.required' => 'The Contact Name is required.',
                'contact_email.*.required' => 'The Contact Email is required.',
                'contact_email.*.email' => 'Please enter valid email.',
                'contact_email.*.distinct' => 'Contact Email is has a duplicate value.',
                'contact_email.*.unique' => 'Contact Email has already been taken.',
                'contact_mobile_number.*.required' => 'The Contact Mobile Number is required.',
                'contact_mobile_number.*.distinct' => 'Contact Mobile Number is has a duplicate value.',
                'contact_mobile_number.*.unique' => 'Contact Mobile Number has already been taken.',
            ]
        );
        $contact_name = isset($_POST['contact_name']) ? $_POST['contact_name'] : array();
        if(count($contact_name) == 0){
            return redirect()->back()->withErrors(['contact_detail' => 'Contact Detail is required.'])->withInput();
        }
        if ($validate) {
            $customerUser = CustomerUser::find($id);
            $customerUser->name = $request->name;
            $customerUser->group_id = $request->group_id;
            $customerUser->address = $request->address;
            $customerUser->address_2 = $request->address_2;
            $customerUser->address_3 = $request->address_3;
            $customerUser->country_id = $request->country_id;
            $customerUser->state_id = $request->state_id;
            $customerUser->city_id = $request->city_id;
            $customerUser->phonecode_id = $request->phonecode;
            $phonecode = '';
            $countryphonecode_detail = Country::select('id','name','phonecode')->where('id',$request->phonecode)->whereNotNull('phonecode')->first();
            if($countryphonecode_detail){
                $phonecode = $countryphonecode_detail->phonecode;
            }
            $customerUser->phonecode = $phonecode;
            $customerUser->phone_number = $request->phone_number;
            $customerUser->email_address = $request->email_address;
            if($request->password){
                $customerUser->password = Hash::make($request->password);
            }
            $customerUser->sequence = $request->sequence;
            $customerUser->pincode_number = $request->pincode_number;
            $customerUser->district = $request->district;
            $customerUser->year_end = $request->year_end;
            $customerUser->save();

            $contact_detail_delete = CustomerContactDetail::where('customer_id',$id);
            $contact_detail_delete->delete();
            $more_name = isset($_POST['more_name']) ? $_POST['more_name'] : '';
            $more_email = isset($_POST['more_email']) ? $_POST['more_email'] : '';
            $more_birth_date = isset($_POST['more_birth_date']) ? $_POST['more_birth_date'] : '';
            if($more_birth_date == ''){
                $more_birth_date = NULL;
            }
            $more_phonecode = isset($_POST['more_phonecode']) ? $_POST['more_phonecode'] : 0;
            if($more_phonecode == ''){
                $more_phonecode = 0;
            }
            $more_mobile_number = isset($_POST['more_mobile_number']) ? $_POST['more_mobile_number'] : '';
            if($more_name != '' && $more_email != '' && $more_mobile_number != ''){
                $phonecode = '';
                $countryphonecode_detail = Country::select('id','name','phonecode')->where('id',$more_phonecode)->whereNotNull('phonecode')->first();
                if($countryphonecode_detail){
                    $phonecode = $countryphonecode_detail->phonecode;
                }
                $customerUser->phonecode = $phonecode;
                $contact_detail_detail = new CustomerContactDetail();
                $contact_detail_detail->customer_id = $id;
                $contact_detail_detail->name = $more_name;
                $contact_detail_detail->email = $more_email;
                $contact_detail_detail->birth_date = $more_birth_date;
                $contact_detail_detail->phonecode_id = $more_phonecode;
                $contact_detail_detail->phonecode = $phonecode;
                $contact_detail_detail->mobile_number = $more_mobile_number;
                $contact_detail_detail->save();
            }
            $custmer_contact_detail_id = isset($_POST['custmer_contact_detail_id']) ? $_POST['custmer_contact_detail_id'] : array();
            $contact_email = isset($_POST['contact_email']) ? $_POST['contact_email'] : array();
            $contact_birth_date = isset($_POST['contact_birth_date']) ? $_POST['contact_birth_date'] : array();
            $contact_phonecode = isset($_POST['contact_phonecode']) ? $_POST['contact_phonecode'] : array();
            $contact_mobile_number = isset($_POST['contact_mobile_number']) ? $_POST['contact_mobile_number'] : array();
            foreach($contact_name as $key=>$contact_name_val){
                $custmer_contact_detail_id_val = isset($custmer_contact_detail_id[$key]) ? $custmer_contact_detail_id[$key] : 0;
                $contact_email_val = isset($contact_email[$key]) ? $contact_email[$key] : '';
                $contact_birth_date_val = isset($contact_birth_date[$key]) ? $contact_birth_date[$key] : '';
                if($contact_birth_date_val == ''){
                    $contact_birth_date_val = NULL;
                }
                $contact_phonecode_val = isset($contact_phonecode[$key]) ? $contact_phonecode[$key] : 0;
                if($contact_phonecode_val == ''){
                    $contact_phonecode_val = 0;
                }
                $contact_mobile_number_val = isset($contact_mobile_number[$key]) ? $contact_mobile_number[$key] : '';
                $old_count = CustomerContactDetail::withTrashed()->where('customer_id',$id)->where('id',$custmer_contact_detail_id_val)->count();
                $phonecode = '';
                $countryphonecode_detail = Country::select('id','name','phonecode')->where('id',$contact_phonecode_val)->whereNotNull('phonecode')->first();
                if($countryphonecode_detail){
                    $phonecode = $countryphonecode_detail->phonecode;
                }
                if($old_count == 0){
                    $contact_detail_detail = new CustomerContactDetail();
                    $contact_detail_detail->customer_id = $id;
                    $contact_detail_detail->name = $contact_name_val;
                    $contact_detail_detail->email = $contact_email_val;
                    $contact_detail_detail->birth_date = $contact_birth_date_val;
                    $contact_detail_detail->phonecode_id = $contact_phonecode_val;
                    $contact_detail_detail->phonecode = $phonecode;
                    $contact_detail_detail->mobile_number = $contact_mobile_number_val;
                    $contact_detail_detail->save();
                }else{
                    CustomerContactDetail::withTrashed()->where('customer_id',$id)->where('id',$custmer_contact_detail_id_val)->update(['deleted_at' => null,'name' => $contact_name_val,'email' => $contact_email_val,'birth_date' => $contact_birth_date_val,'phonecode_id' => $contact_phonecode_val,'phonecode' => $phonecode,'mobile_number' => $contact_mobile_number_val]);
                } 
            }
            if ($request->save) {
                return redirect(route('customer.user.edit', $customerUser->id))->with('success_message', trans('Update Successfully'));
            } else {
                return redirect(route('customer.user.index'))->with('success_message', trans('Update Successfully'));
            }
        }
    }
    public function destroy($id)
    {
        $customerUser = CustomerUser::find($id);
        $customerUser->delete();
        
        // Also Customer Contact Detail destroyed
        CustomerContactDetail::where('customer_id',$id)->delete();
        
        return redirect()->route("customer.user.index")->with('success_message', 'Delete Successfully!');
    }

    public function setActivate($id)
    {
        $update_status = CustomerUser::find($id);
        $update_status->status = 1;
        $update_status->save();
        return redirect(route('customer.user.index'))->with('success_message', trans('Active Successfully'));
    }

    public function setInactivate($id)
    {
        $update_status = CustomerUser::find($id);
        $update_status->status = 0;
        $update_status->save();
        return redirect(route('customer.user.index'))->with('success_message', trans('Inactive Successfully'));
    }
    public function importcreate()
    {
        $return_data = array();
        $return_data['page_condition'] = 'customer_user_page';
        $return_data['site_title'] = 'Customer User | ' . config('constants.SITE_NAME');
        return view('admin.customer_user.import', array_merge($return_data));
    }

    public function importstore(Request $request)
    {
        $validate = $request->validate(
            [
                'import_file' => "required|mimes:xlsx,xls",
            ],
            [
                'import_file.required' => 'The import file is required.',
            ]
        );
        if ($validate) {
            $file = $request->file('import_file')->store('files');
            Excel::import(new CustomerUserImport, $file);
            return redirect(route('customer.user.index'))->with('success_message', trans('Added Successfully'));
        }
    }
    public function reminder(Request $request,$customer_id)
    {
        if ($request->ajax()) {

            //$reminder_detail = ReminderCustomerDocument::with('Reminder')->where('reminder_customer_documents.customer_id', $customer_id)->get();//->orderBy('reminder_customer_documents.id', 'DESC')->groupBy('reminder_id')
            //$reminder_ids = ReminderCustomerDocument::orderByDesc('created_at')->get()->toArray()->groupBy('reminder_id')->map(fn($type) => $type->pluck('reminder_id'));
            $reminder_ids = ReminderCustomerDocument::where('customer_id', $customer_id)->get()->pluck('reminder_id')->toArray();//->groupBy('reminder_id')
            //print_r($reminder_ids);
            $reminder_ids = array_unique($reminder_ids);
            $reminder_detail = Reminder::whereIn('id', $reminder_ids)->get();
            return datatables()->of($reminder_detail)
                ->addColumn('action', function ($row) use($customer_id) {
                    $html = '';
                    $html .= '<a href="' . route('customer.user.reminder_detail', array('customer_id'=>$customer_id,'reminder_id'=>$row->id)) . '" class="btn badge-info text-white btn-sm"><i class="fa fa-eye"></i> View</a> ';
                    $html .= '<a href="' . route('customer.user.emailtrack',$customer_id) . '?search_reminder_id='.$row->id.'" class="btn badge-info text-white btn-sm"><i class="fa fa-eye"></i> Track</a> ';
                    $Pending_document = Helpers::GetPendingDocument($row->id,$customer_id);
                    if($Pending_document > 0){
                        $html .= '<a href="' . route('customer.user.reminder_send', array('customer_id'=>$customer_id,'reminder_id'=>$row->id)) . '" class="btn badge-primary text-white btn-sm"><i class="fa fa-envelope"></i> Send</a> ';
                    }    
                    return $html;
                })->addColumn('date', function ($row) {
                    $date = '';
                    if (!empty($row->updated_at)) {
                        $date = date('Y-m-d', strtotime($row->updated_at));
                    }
                    return $date;
                })->addColumn('status', function ($row) use($customer_id) {
                    $total_document = Helpers::GetTotalDocument($row->id,$customer_id);
                    $Uploaded_document = Helpers::GetUploadedDocument($row->id,$customer_id);
                    $Pending_document = Helpers::GetPendingDocument($row->id,$customer_id);
                    return '<b>Total</b>:'.$total_document.'<br>'.'<b>Uploaded</b>:'.$Uploaded_document.'<br>'.'<b>Pending</b>:'.$Pending_document;
                })->addColumn('reminder_name', function ($row) {
                    $name = $row->name;
                    $description = $row->description;
                    return $name.'<br><small>'.$description.'</small>';
                }) ->rawColumns(['status','action','reminder_name'])->toJson();
        }
        $return_data = array();
        $return_data['page_condition'] = 'customer_user_page';
        $return_data['customer_id'] = $customer_id;
        $return_data['site_title'] = 'Customer User Reminder | ' . config('constants.SITE_NAME');
        return view('admin.customer_user.reminder', array_merge($return_data));
    }
    public function reminderDetail ($customer_id,$reminder_id)
    {
        $return_data = array();
        $reminder_detail = Reminder::find($reminder_id);
        $return_data['reminder_detail'] = $reminder_detail;
        $document_list = ReminderCustomerDocument::with('Document')->where('customer_id',$customer_id)->where('reminder_id',$reminder_id)->get();
        $return_data['document_list'] = $document_list;
        $return_data['page_condition'] = 'customer_user_page';
        $return_data['reminder_id'] = $reminder_id;
        $return_data['customer_id'] = $customer_id;
        $return_data['document_attachment'] = 'images/'.config('constants.DOCUMENT');
        $return_data['site_title'] = 'Customer User Reminder Detail | ' . config('constants.SITE_NAME');
        return view('admin.customer_user.reminderdetail', array_merge($return_data));
    }
    public function storeReminderDetail (Request $request,$customer_id,$reminder_id){
        $upload_comment = isset($_POST['upload_comment']) ? $_POST['upload_comment'] : array();
        if($upload_comment){
            foreach($upload_comment as $key=>$comment_val){
                if($comment_val != ''){
                    ReminderCustomerDocument::withTrashed()->where('id',$key)->where('customer_id',$customer_id)->update(['upload_comment' => $comment_val,'upload_datetime' => date('Y-m-d H:i:s'),'upload_status' => 1]);
                }    
            }
        }
        $upload_document = $request->file('upload_document');            
        $destinationPath = public_path('images').config('constants.DOCUMENT');
        if($upload_document){
            $ids = array();
            foreach($upload_document as $key=>$image){
                $org_upload_document = $image->getClientOriginalName();
                if($org_upload_document != ''){
                    $ids[] = $key;
                    $upload_document = 'document-'.$key.'-'.time().'.'.$image->getClientOriginalExtension();
                    $image->move($destinationPath, $upload_document);
                    ReminderCustomerDocument::withTrashed()->where('id',$key)->where('customer_id',$customer_id)->update(['org_upload_document' => $org_upload_document,'upload_document' => $upload_document,'upload_datetime' => date('Y-m-d H:i:s'),'upload_status' => 1]);
                }    
            }
            $current_date_time = date('Y-m-d H:i:s');
            $auth = auth()->user();
            $login_user_id = $auth->id;
            $login_user_name = $auth->name;
            $login_user_email = $auth->email;
            $login_user_detail = array('login_user_id' => $login_user_id,'login_user_name' => $login_user_name,'login_user_email' => $login_user_email);
            $main_send_log = new MailSendLog();
            $main_send_log->name = 'Admin Doument Upload';
            $main_send_log->reminder_id = $reminder_id;
            $main_send_log->customer_id = $customer_id;
            $main_send_log->from_email = '';
            $main_send_log->to_email = '';
            $main_send_log->send_date = $current_date_time;
            $main_send_log->title = '';
            $main_send_log->subject = '';
            $main_send_log->body = json_encode($login_user_detail);
            $main_send_log->action_flage = 'admin_Doument_Upload';
            $main_send_log->save();
            $reminder_document_detail = ReminderCustomerDocument::with('CustomerUser')->with('Reminder')->with('Document')->whereIn('id', $ids)->where('customer_id',$customer_id)->get();//->where('id',$key)
            $document_ids = array();
            if(is_object($reminder_document_detail)){
                foreach($reminder_document_detail as $reminder_document_list_val){
                    $document_id = $reminder_document_list_val->document_id;
                    $document_ids[] = $document_id;
                }
            }
            if(count($document_ids) > 0){
                foreach ($document_ids as $key => $document_id_value) {
                    $main_send_log_document = new MailSendLogDocument();
                    $main_send_log_document->mail_send_log_id = $main_send_log->id;
                    $main_send_log_document->document_id = $document_id_value;
                    $main_send_log_document->save();    
                }
            }
        }
        return redirect(route('customer.user.reminder_detail',array('customer_id'=>$customer_id,'reminder_id'=>$reminder_id)))->with('success_message', trans('Update Successfully'));
    }
    public function reminderSend($customer_id,$reminder_id)
    {
        Helpers::ReminderMail($reminder_id,$customer_id,'reminder_resend');
        return redirect(route('customer.user.reminder',$customer_id))->with('success_message', trans('Send Successfully'));
    }
}
