<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ReminderCustomerDocument;
use App\Helper\Helpers;
use App\Models\Reminder;
use App\Models\CustomerUser;
use App\Models\Document;
use DB;
use Redirect;
class DashboardController extends Controller
{

    public function dashboard()
    {
        $return_data = array();
        $reminder_list = Reminder::all();
        $return_data['reminder_list'] = $reminder_list;
        $customer_user_list = CustomerUser::all();
        $return_data['customer_user_list'] = $customer_user_list;
        $document_list = Document::all();
        $return_data['document_list'] = $document_list;
        $return_data['page_condition'] = 'admin_dashboard';
		$return_data['site_title'] = 'Admin Dashboard | ' . config('constants.SITE_NAME');
		return view('admin.index', array_merge($return_data));
    }
    public function documentUploaded(Request $request)
    {
        if ($request->ajax()) {
            $filter_reminder_id = isset($_GET['filter_reminder_id']) ? $_GET['filter_reminder_id'] : '';
            $filter_customer_id = isset($_GET['filter_customer_id']) ? $_GET['filter_customer_id'] : '';
            $filter_document_id = isset($_GET['filter_document_id']) ? $_GET['filter_document_id'] : '';
            $reminder_detail_query = ReminderCustomerDocument::select('customer_id', DB::raw('count(id) as total_count'), DB::raw('MIN(id) as id'), DB::raw('MIN(upload_document) as upload_document'))->with('Reminder')->with('Document')->with('CustomerUser')->where('reminder_customer_documents.upload_status', 1)->Where('status','0');//->WhereNotNull('upload_document')
            if($filter_reminder_id != ''){
                $reminder_detail_query->where('reminder_id',$filter_reminder_id);
            }
            if($filter_customer_id != ''){
                $reminder_detail_query->where('customer_id',$filter_customer_id);
            }
            if($filter_document_id != ''){
                $reminder_detail_query->where('document_id',$filter_document_id);
            }
            $reminder_detail = $reminder_detail_query->groupBy('customer_id')->get();
            return datatables()->of($reminder_detail)
                ->addColumn('action', function ($row) {
                    $html = '';
                    //$html .= '<a href="' . route('admin.dashboard.document_accept', $row->id) . '" onClick="return alertconfirm(\'Are you sure you want to Accept this?\');" class="btn badge-success text-white btn-sm"><i class="fa fa-check"></i> Accept</a>';
                    //$html .= '&nbsp;<a onClick="return confirm_document_reject('.$row->id.');" href="javascript:;" class="btn badge-danger text-white btn-sm"><i class="fa fa-ban"></i> Reject</a>';
                    $html .= '<a href="' . route('reminder.document.index', array('search_customer_id'=>$row->customer_id,'search_status'=>0)) . '" class="btn badge-info text-white btn-sm"><i class="fa fa-eye"></i> View</a>';
                    return $html;
                })->addColumn('document_file', function ($row) {
                    $html = Helpers::GetDocument($row->id);
                    if($html == ''){
                        $html = $row->upload_comment;
                    }
                    return $html;
                })->addColumn('datetime', function ($row) {
                    $date = '';
                    if (!empty($row->updated_at)) {
                        $date = date('Y-m-d H:i:s', strtotime($row->updated_at));
                    }
                    return $date;
                })->addColumn('customer_name', function ($row) {
                    $name = '';
                    if (is_object($row->CustomerUser)) {
                        $name = $row->CustomerUser->name;
                    }
                    return $name;
                })->addColumn('document_name', function ($row) {
                    $name = '';
                    if (is_object($row->Document)) {
                        $name = $row->Document->name;
                    }
                    return $name;
                })->addColumn('reminder_name', function ($row) {
                    $name = '';
                    if (is_object($row->Reminder)) {
                        $name = $row->Reminder->name;
                    }
                    return $name;
                })->rawColumns(['document_file','action'])->toJson();
        }
    }
    public function documentAccept($id)
    {
        $update_status = ReminderCustomerDocument::find($id);
        $update_status->status = 1;
        $update_status->save();
        //return redirect(route('admin.dashboard'))->with('success_message', trans('Accept Successfully'));
        return Redirect::back()->withErrors(['success_message' => trans('Accept Successfully')]);
    }
    public function documentReject(Request $request,$id)
    {
        $document_reject_id = isset($_POST['document_reject_id']) ? $_POST['document_reject_id'] : '';
        $reject_notes = isset($_POST['reject_notes']) ? $_POST['reject_notes'] : '';
        $ReminderCustomerDocumentDetail = ReminderCustomerDocument::find($document_reject_id);
        if($ReminderCustomerDocumentDetail){
            $reminder_id = $ReminderCustomerDocumentDetail->reminder_id;
            $customer_id = $ReminderCustomerDocumentDetail->customer_id;
            $update_status = ReminderCustomerDocument::find($document_reject_id);
            $update_status->status = 2;
            $update_status->reject_notes = $reject_notes;
            $update_status->upload_document = null;
            $update_status->org_upload_document = null;
            $update_status->upload_datetime = null;
            $update_status->upload_status = 0; 
            $update_status->save();
            Helpers::ReminderMail($reminder_id,$customer_id,'reminder_reject',$document_reject_id);
            return response()->json([
                'status' => 'success',
                'message' => 'Reject Successfully',
            ], 200);
        }else{
            return response()->json([
                'status' => 'error',
                'message' => 'Reject Not Successfully',
            ], 200);
        }    
    }
}