<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Department;
use Datatables;

class DepartmentController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $department = Department::all();
            return datatables()->of($department)
                ->addColumn('action', function ($row) {
                    $html = '';
                    $html .= '<a href="' . route('department.edit', $row->id) . '" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a> ';
                    $html .= '&nbsp;<a href="' . route('department.show', $row->id) . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View</a> ';
                    if ($row->status == 1) {
                       // $html .= '<a href="' . route('department.inactive', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Inactive this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-success"></i></a>';
                    } else {
                        //$html .= '<a href="' . route('department.active', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Activate this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-muted"></i></a>';
                    }
                    $html .= '';

                    $html .= '<a href="" class="</a>';
                    return $html;
                })->toJson();
        }
        $return_data = array();
        $return_data['page_condition'] = 'department_page';
        $return_data['site_title'] = 'Department | ' . config('constants.SITE_NAME');
        return view('admin.department.index', array_merge($return_data));
    }

    public function create()
    {
        $return_data = array();
        $return_data['page_condition'] = 'department_page';
        $return_data['site_title'] = 'Department | ' . config('constants.SITE_NAME');
        return view('admin.department.form', array_merge($return_data));
    }

    public function store(Request $request)
    {
        $id = 0;
        $validate = $request->validate(
            [
                'name' => "required|unique:departments,name," . $id . ",id,deleted_at,NULL",
                //'description' => "required"
            ],
            [
                'name.required' => 'The Name is required.',
                'name.unique' => 'The Name has been already taken.',
                'description' => 'The Description is required.',
            ]
        );

        if ($validate) {

            $department = new Department();
            $department->name = $request->name;
            $department->description = $request->description;
            $department->status = 1;
            $department->save();
            if ($request->save) {
                return redirect(route('department.edit', $department->id))->with('success_message', trans('Added Successfully'));
            } else {
                return redirect(route('department.index'))->with('success_message', trans('Added Successfully'));
            }
        }
    }

    public function show($id)
    {
        $department = Department::find($id);
        $return_data = array();
        $return_data['data'] = $department;
        $return_data['page_condition'] = 'department_page';
        $return_data['site_title'] = 'Department | ' . config('constants.SITE_NAME');
        return view('admin.department.view', array_merge($return_data));
    }

    public function edit($id)
    {
        $data = Department::find($id);
        $return_data = array();
        $return_data['data'] = $data;
        $return_data['page_condition'] = 'department_page';
        $return_data['site_title'] = 'Department | ' . config('constants.SITE_NAME');
        return view('admin.department.form', array_merge($return_data));
    }
    public function update(Request $request)
    {
        $id = $request->id;
        $validate = $request->validate(
            [
                'name' => "required|unique:departments,name," . $id . ",id,deleted_at,NULL",
                //'description' => "required"
            ],
            [
                'name.required' => 'The Name is required.',
                'name.unique' => 'The Name has been already taken.',
                'description' => 'The Description is required.',
            ]

        );
        if ($validate) {

            $department = Department::find($id);
            $department->name = $request->name;
            $department->description = $request->description;
            $department->save();

            if ($request->save) {
                return redirect(route('department.edit', $department->id))->with('success_message', trans('Update Successfully'));
            } else {
                return redirect(route('department.index'))->with('success_message', trans('Update Successfully'));
            }
        }
    }
    public function destroy($id)
    {
        $department = Department::find($id);
        $department->delete();
        return redirect()->route("department.index")->with('success_message', 'Delete Successfully!');
    }

    public function setActivate($id)
    {
        $update_status = Department::find($id);
        $update_status->status = 1;
        $update_status->save();
        return redirect(route('department.index'))->with('success_message', trans('Active Successfully'));
    }

    public function setInactivate($id)
    {
        $update_status = Department::find($id);
        $update_status->status = 0;
        $update_status->save();
        return redirect(route('department.index'))->with('success_message', trans('Inactive Successfully'));
    }
}
