<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Document;
use App\Models\Assignment;
use App\Models\Heading;
use App\Models\CustomerUser;
use Datatables;
use PhpOffice\PhpWord\PhpWord;
use PhpOffice\PhpWord\Shared\Html;

class DocumentController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $document = Document::with('Assignment')->get();
            return datatables()->of($document)
                ->addColumn('action', function ($row) {
                    $html = '';
                    $html .= '<a href="' . route('document.edit', $row->id) . '" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a> ';
                    $html .= '&nbsp;<a href="' . route('document.show', $row->id) . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View</a> ';
                    if($row->doc_content != ''){
                        $html .= '&nbsp;<a href="' . route('document.docs_sample', $row->id) . '" class="btn btn-success btn-edit btn-sm"><i class="fa fa-eye"></i> Doc Sample</a> ';
                    }    
                    //$html .= '&nbsp;<a href="javascript:;" class="btn btn-danger btn-delete btn-sm" data-toggle="tooltip" data-original-title="Delete" data-container="body" title="" onclick="return record_delete(\'' . route('document.destroy', $row->id) . '\');" ><i class="fa fa-trash" aria-hidden="true"></i> Delete</a>';
                    if ($row->status == 1) {
                       // $html .= '<a href="' . route('document.inactive', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Inactive this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-success"></i></a>';
                    } else {
                        //$html .= '<a href="' . route('document.active', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Activate this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-muted"></i></a>';
                    }
                    $html .= '';

                    $html .= '<a href="" class="</a>';
                    return $html;
                })->addColumn('assignment_name', function ($row) {
                    $name = '';
                    if (is_object($row->Assignment)) {
                        $name = $row->Assignment->name;
                    }
                    return $name;
                })->toJson();
        }
        $return_data = array();
        $return_data['page_condition'] = 'document_page';
        $return_data['site_title'] = 'Document | ' . config('constants.SITE_NAME');
        return view('admin.document.index', array_merge($return_data));
    }

    public function create()
    {
        $return_data = array();
        $assignment = Assignment::where('status','1')->get();
        $return_data['assignment'] = $assignment;
        $heading = Heading::where('status','1')->get();
        $return_data['heading'] = $heading;
        $return_data['page_condition'] = 'document_page';
        $return_data['site_title'] = 'Document | ' . config('constants.SITE_NAME');
        return view('admin.document.form', array_merge($return_data));
    }

    public function store(Request $request)
    {
        $id = 0;
        $assignment_id = $request->assignment_id;
        $validate = $request->validate(
            [
                'name' => "required|unique:documents,name," . $id . ",id,deleted_at,NULL,assignment_id,".$assignment_id,
                'assignment_id' => "required",
                'heading_id' => "required",
                //'description' => "required"
            ],
            [
                'name.required' => 'The Name is required.',
                'name.unique' => 'The Name has been already taken selected assignment.',
                'description' => 'The Description is required.',
                'assignment_id.required' => 'The assignment is required.',
                'heading_id.required' => 'The Heading is required.',
            ]
        );

        if ($validate) {

            $document = new Document();
            $document->assignment_id = $request->assignment_id;
            $document->heading_id = $request->heading_id;
            $document->name = $request->name;
            $document->description = $request->description;
            $document->templete_flage = isset($_POST['templete_flage']) ? $_POST['templete_flage'] : 0;
            $document->doc_content = $request->doc_content;
            $document->status = 1;
            $document->save();
            if ($request->save) {
                return redirect(route('document.edit', $document->id))->with('success_message', trans('Added Successfully'));
            } else {
                return redirect(route('document.index'))->with('success_message', trans('Added Successfully'));
            }
        }
    }

    public function show($id)
    {
        $document = Document::find($id);
        $return_data = array();
        $return_data['data'] = $document;
        $return_data['page_condition'] = 'document_page';
        $return_data['site_title'] = 'Document | ' . config('constants.SITE_NAME');
        return view('admin.document.view', array_merge($return_data));
    }
    public function DocSample($id)
    {
        $document = Document::with('Assignment')->find($id);
        $action_call = isset($_GET['action_call']) ? $_GET['action_call'] : '';
        /*
        $string = "{{name}} is my name.\nBirth date: {{BirthDate}}";
        // Regular expression to match the content within {{ }}
        preg_match_all('/{{(.*?)}}/', $string, $matches);
        // $matches[1] will contain all the placeholder names
        $placeholderNames = $matches[1];
        // Output the placeholder names
        foreach ($placeholderNames as $placeholder) {
            echo $placeholder . "\n";
        }
        */
        $documents_id = $document->id; 
        $doc_name = $document->name;
        $assignment_name = '';
        if($document->Assignment){
            $assignment_name = $document->Assignment->name;
        }
        if($assignment_name == ''){
            $assignment_name = 'Assignment';
        }
        $db_file_name = $assignment_name.'-'.$doc_name;
        $db_doc_content = $document->doc_content;
        if($db_doc_content != '' && $action_call == 'ajax_call'){
            $customer_id = isset($_GET['customer_id']) ? $_GET['customer_id'] : 0;
            $current_date_value = isset($_GET['current_date_value']) ? $_GET['current_date_value'] : '';
            $YearEndDate_val = isset($_GET['year_end']) ? $_GET['year_end'] : '';
            $Customer_detail = CustomerUser::where('id',$customer_id)->first();
            $customer_name = '';
            $customer_address = '';
            if($Customer_detail){
                $customer_name = $Customer_detail->name;
                $address = $Customer_detail->address;
                $address_2 = $Customer_detail->address_2;
                $address_3 = $Customer_detail->address_3;
                $customer_address = $address.'<br></br>'.$address_2.'<br></br>'.$address_3;
            }
            if($YearEndDate_val != ''){
                $YearEndDate_val = date('d/m/Y',strtotime($YearEndDate_val));
            }  
            if($current_date_value != ''){
                $current_date_value = date('d/m/Y',strtotime($current_date_value));
            }
            $db_doc_content = str_ireplace('{{{CLIENTNAME}}}',$customer_name,$db_doc_content);
            $db_doc_content = str_ireplace('{{{CLIENTADDRESS}}}',$customer_address,$db_doc_content);
            //if($current_date_value != ''){
                $db_doc_content = str_ireplace('{{{CurrentDate}}}',$current_date_value,$db_doc_content);
            //}    
            $db_doc_content = str_ireplace('{{{YearEndDate}}}',$YearEndDate_val,$db_doc_content);
        }
        $new_docs_destinationPath = public_path('images').config('constants.NEW_DOCUMENT');
        $phpWord = new \PhpOffice\PhpWord\PhpWord();
        //$phpWord->addParagraphStyle('P-listStyle', array('spaceAfter'=>0,'lineHeight'=>1.0));
        $phpWord->setDefaultParagraphStyle( array(
            'lineHeight' => 1.0,
            'spaceAfter'=>0,
         ) );
        $section = $phpWord->addSection();
        $description = $db_doc_content;
        //$result = preg_replace('/\s?<p>(\s|&nbsp;)*<\/p>/', 'xxx', $description);
        //$description = preg_replace('/\s*<p(.*?)>(.*?)<\/p>\s*/is', '<p>$2</p>', $description);
        // print_r($description);
        // echo '<hr>';
        //$description = str_replace("<p>",  "<p style='line-height: 0px;margin: 5px;'>",    $description);
        //padding: 0px;margin: 0px;
        //echo $description;
       // exit;
        $html = \PhpOffice\PhpWord\Shared\Html::addHtml($section, $description);
        //$section->addText($description);
        $objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
        $file_name_path = $new_docs_destinationPath.$db_file_name.'.docx';
        $document_attachment = 'images'.config('constants.NEW_DOCUMENT');
        $file_name_url = url('/').'/'.$document_attachment.$db_file_name.'.docx';
        try {
            $objWriter->save($file_name_path);
        } catch (Exception $e) {
        }
        if($action_call == 'ajax_call'){
            $return_array = array();
            $return_array['status'] = 'success';
            $return_array['file_name_url'] = $file_name_url;
            echo json_encode($return_array);
        }else{
            return response()->download($file_name_path);
        }    
    }

    public function edit($id)
    {
        $data = Document::find($id);
        $return_data = array();
        $return_data['data'] = $data;
        $assignment = Assignment::where('status','1')->get();
        $return_data['assignment'] = $assignment;
        $heading = Heading::where('status','1')->get();
        $return_data['heading'] = $heading;
        $return_data['page_condition'] = 'document_page';
        $return_data['site_title'] = 'Document | ' . config('constants.SITE_NAME');
        return view('admin.document.form', array_merge($return_data));
    }
    public function update(Request $request)
    {
        $id = $request->id;
        $assignment_id = $request->assignment_id;
        $validate = $request->validate(
            [
                'name' => "required|unique:documents,name," . $id . ",id,deleted_at,NULL,assignment_id,".$assignment_id,
                'assignment_id' => "required",
                'heading_id' => "required",
                //'description' => "required"
            ],
            [
                'name.required' => 'The Name is required.',
                'name.unique' => 'The Name has been already taken selected assignment.',
                'description' => 'The Description is required.',
                'assignment_id.required' => 'The assignment is required.',
                'heading_id.required' => 'The Heading is required.',
            ]

        );
        if ($validate) {

            $document = Document::find($id);
            $document->assignment_id = $request->assignment_id;
            $document->heading_id = $request->heading_id;
            $document->name = $request->name;
            $document->description = $request->description;
            $document->templete_flage = isset($_POST['templete_flage']) ? $_POST['templete_flage'] : 0;
            $document->doc_content = $request->doc_content;
            $document->save();

            if ($request->save) {
                return redirect(route('document.edit', $document->id))->with('success_message', trans('Update Successfully'));
            } else {
                return redirect(route('document.index'))->with('success_message', trans('Update Successfully'));
            }
        }
    }
    public function destroy($id)
    {
        $document = Document::find($id);
        $document->delete();
        return redirect()->route("document.index")->with('success_message', 'Delete Successfully!');
    }

    public function setActivate($id)
    {
        $update_status = Document::find($id);
        $update_status->status = 1;
        $update_status->save();
        return redirect(route('document.index'))->with('success_message', trans('Active Successfully'));
    }

    public function setInactivate($id)
    {
        $update_status = Document::find($id);
        $update_status->status = 0;
        $update_status->save();
        return redirect(route('document.index'))->with('success_message', trans('Inactive Successfully'));
    }
    public function templeteindex(Request $request)
    {
        if ($request->ajax()) {
            $document = Document::with('Assignment')->WhereNotNull('doc_content')->Where('templete_flage','1')->get();
            return datatables()->of($document)
                ->addColumn('action', function ($row) {
                    $html = '';
                    if($row->doc_content != ''){
                        $html .= '&nbsp;<a href="javascript:;" onclick="fun_templete_create('.$row->id.')" id="templete_row_'.$row->id.'" data-href="' . route('document.docs_sample', $row->id) . '" class="btn btn-success btn-edit btn-sm"><i class="fa fa-download"></i> Download</a> ';
                    }    
                    return $html;
                })->addColumn('assignment_name', function ($row) {
                    $name = '';
                    if (is_object($row->Assignment)) {
                        $name = $row->Assignment->name;
                    }
                    return $name;
                })->toJson();
        }
        $return_data = array();
        $customer_list = CustomerUser::with('Group')->where('status','1')->get();
        $return_data['customer_list'] = $customer_list;
        $return_data['page_condition'] = 'templete_page';
        $return_data['site_title'] = 'Templete | ' . config('constants.SITE_NAME');
        return view('admin.document.templeteindex', array_merge($return_data));
    }
}
?>
