<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\City;
use App\Models\EmailContent;
use App\Models\EmailContentAttachment;
use Datatables;
use App\Helper\Helpers;

class EmailContentController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $EmailContent = EmailContent::all();
            return datatables()->of($EmailContent)
                ->addColumn('action', function ($row) {
                    $html = '';
                    $html .= '<a href="' . route('email_content.edit', $row->id) . '" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a> ';
                    $html .= '&nbsp;<a href="' . route('email_content.show', $row->id) . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View</a> ';
                    if ($row->status == 1) {
                        $html .= '<a href="' . route('email_content.inactive', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Inactive this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-success"></i></a>';
                    } else {
                        $html .= '<a href="' . route('email_content.active', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Activate this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-muted"></i></a>';
                    }
                    $html .= '';

                    $html .= '<a href="" class="</a>';
                    return $html;
                })->toJson();
        }
        $return_data = array();
        $return_data['page_condition'] = 'email_content_page';
        $return_data['site_title'] = 'Email Content | ' . config('constants.SITE_NAME');
        return view('admin.email_content.index', array_merge($return_data));
    }

    public function create()
    {
        $return_data = array();
        $city = City::where('status', '1')->get();
        $return_data['page_condition'] = 'email_content_page';
        $return_data['site_title'] = 'Email Content | ' . config('constants.SITE_NAME');
        $return_data['city'] = $city;
        return view('admin.email_content.form', array_merge($return_data));
    }

    public function store(Request $request)
    {
        $id = 0;
        $validate = $request->validate(
            [
                'title' => "required|unique:email_contents,title," . $id . ",id,deleted_at,NULL|max:255",
                'subject' => 'required|max:255',
                'content' => "required"
            ],
            [
                'title.required' => 'The title is required.',
                'title.unique' => 'The title has been already taken.',
                'subject.required' => 'The subject is required.',
                'content.required' => 'The content is required.',
            ]
        );

        if ($validate) {

            $EmailContent = new EmailContent();
            $EmailContent->title = $request->title;
            $EmailContent->subject = $request->subject;
            $EmailContent->content = $request->content;
            $EmailContent->status = 1;
            $EmailContent->save();
            $destinationPath = public_path('images').config('constants.BIRTHDAY');
            $attachment = $request->file('attachment');            
            if($attachment){
                foreach($attachment as $key=>$image){
                    $org_upload_document = $image->getClientOriginalName();
                    if($org_upload_document != ''){
                        $upload_document = 'birthday-'.$key.'-'.time().'.'.$image->getClientOriginalExtension();
                        $image->move($destinationPath, $upload_document);
                        $file_attachment = new EmailContentAttachment();
                        $file_attachment->email_contents_id = $EmailContent->id;
                        $file_attachment->org_upload_document = $org_upload_document;
                        $file_attachment->upload_document = $upload_document;
                        $file_attachment->status = 1;
                        $file_attachment->save();
                    }    
                }
            }
            if ($request->save) {
                return redirect(route('email_content.edit', $EmailContent->id))->with('success_message', trans('Added Successfully'));
            } else {
                return redirect(route('email_content.index'))->with('success_message', trans('Added Successfully'));
            }
        }
    }

    public function show($id)
    {
        $EmailContent = EmailContent::find($id);
        $return_data = array();
        $return_data['data'] = $EmailContent;
        $return_data['page_condition'] = 'email_content_page';
        $return_data['site_title'] = 'Email Content | ' . config('constants.SITE_NAME');
        return view('admin.email_content.view', array_merge($return_data));
    }

    public function edit($id)
    {
        $data = EmailContent::find($id);
        $city = City::where('status', '1')->get();
        $return_data = array();
        $return_data['data'] = $data;
        $return_data['city'] = $city;
        $return_data['page_condition'] = 'email_content_page';
        $return_data['site_title'] = 'Email Content | ' . config('constants.SITE_NAME');
        return view('admin.email_content.form', array_merge($return_data));
    }
    public function update(Request $request)
    {
        $id = $request->id;
        $validate = $request->validate(
            [
                'subject' => 'required|max:255',
                'content' => "required"
            ],
            [
                'subject.required' => 'The subject is required.',
                'content.required' => 'The content is required.',
            ]

        );
        if ($validate) {

            $EmailContent = EmailContent::find($id);
            $EmailContent->subject = $request->subject;
            $EmailContent->content = $request->content;
            $EmailContent->save();
            $destinationPath = public_path('images').config('constants.BIRTHDAY');
            $attachment = $request->file('attachment');            
            if($attachment){
                foreach($attachment as $key=>$image){
                    $org_upload_document = $image->getClientOriginalName();
                    if($org_upload_document != ''){
                        $upload_document = 'birthday-'.$key.'-'.time().'.'.$image->getClientOriginalExtension();
                        $image->move($destinationPath, $upload_document);
                        $file_attachment = new EmailContentAttachment();
                        $file_attachment->email_contents_id = $EmailContent->id;
                        $file_attachment->org_upload_document = $org_upload_document;
                        $file_attachment->upload_document = $upload_document;
                        $file_attachment->status = 1;
                        $file_attachment->save();
                    }    
                }
            }
            if ($request->save) {
                return redirect(route('email_content.edit', $EmailContent->id))->with('success_message', trans('Update Successfully'));
            }elseif ($request->save_send) {
                Helpers::BirthdayMail();
                return redirect(route('email_content.edit', $EmailContent->id))->with('success_message', trans('Send And Update Successfully'));
            } else {
                return redirect(route('email_content.index'))->with('success_message', trans('Update Successfully'));
            }
        }
    }
    public function destroy($id)
    {
        $EmailContent = EmailContent::find($id);
        $EmailContent->delete();
        return redirect()->route("email_content.index")->with('success_message', 'Delete Successfully!');
    }

    public function setActivate($id)
    {
        $update_status = EmailContent::find($id);
        $update_status->status = 1;
        $update_status->save();
        return redirect(route('email_content.index'))->with('success_message', trans('Active Successfully'));
    }

    public function setInactivate($id)
    {
        $update_status = EmailContent::find($id);
        $update_status->status = 0;
        $update_status->save();
        return redirect(route('email_content.index'))->with('success_message', trans('Inactive Successfully'));
    }
    public function ImageDelete($id)
    {
        $EmailContentAttachment = EmailContentAttachment::find($id);
        if($EmailContentAttachment){
            $EmailContentAttachment->delete();
            return redirect()->route('email_content.edit', $EmailContentAttachment->email_contents_id)->with('success_message', 'Delete Successfully!');
        }
        return redirect()->route("email_content.index")->with('success_message', 'Delete Successfully!');
    }
    
}
