<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\City;
use App\Models\Country;
use App\Models\Group;
use App\Models\EmployeeUser;
use App\Helper\Helpers;
use Datatables;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Endroid\QrCode\Builder\Builder;
use File;
use Str;

class EmployeeUserController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $EmployeeUser = EmployeeUser::get();
            return datatables()->of($EmployeeUser)
                ->addColumn('action', function ($row) {
                    $html = '';
                    $html .= '<a href="' . route('employee.user.edit', $row->id) . '" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a> ';
                    //$html .= '&nbsp;<a href="' . route('employee.user.show', $row->id) . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View</a> ';
                    // if ($row->status == 1) {
                    //     $html .= '<a href="' . route('employee.user.inactive', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Inactive this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-success"></i></a>';
                    // } else {
                    //     $html .= '<a href="' . route('employee.user.active', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Activate this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-muted"></i></a>';
                    // }
                    return $html;
                })->addColumn('qr_image_url', function ($row) {
                    $html = '';
                    $id = $row->id;
                    $emp_id = base64_encode($id);
                    $emp_url = route('employee_detail.get', array('id' => $emp_id));
                    if($row->qr_image_url == ''){
                        $destinationPath = public_path('images').'/employee_user_qr/';
                        File::makeDirectory($destinationPath, $mode = 0777, true, true);
                        $result = Builder::create()->data($emp_url)->size(300)->build();
                        $imageData = $result->getString();
                        if (!empty($imageData)) {
                            $qr_image = $id.'.png';
                            $filePath = $destinationPath.$qr_image;
                            file_put_contents($filePath, $imageData);
                            $destinationPathShow = url('/').'/'.'images'.'/employee_user_qr/'.$qr_image;
                            $EmployeeUser = EmployeeUser::find($id);
                            $EmployeeUser->qr_image = $qr_image;
                            $EmployeeUser->save();
                            $html = '<img src="'.$destinationPathShow.'" width="100">';
                        }    
                    }else{
                        $html = '<img src="'.$row->qr_image_url.'" width="100">';
                    }
                    $view_html = '';
                    $employee_qr_download_url = route('employee_qr_download.get', array('id' => $emp_id));
                    //$view_html = '<a target="_blank" href="' . $emp_url . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View Detail</a> ';
                    
                    $view_html .= '<br><a target="_blank" href="' . $employee_qr_download_url . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-solid fa-download"></i>Qr Download</a> ';
                    return $html.'<br>'.$view_html;
                })->addColumn('logo_image_url', function ($row) {
                    $view_html = '';
                    if($row->logo_image_url != ''){
                        $view_html .= '<a target="_blank" href="' . $row->logo_image_url . '" class=""><img src="'.$row->logo_image_url.'" width="100"></a>';
                    }
                    return $view_html;
                })->addColumn('profile_image_url', function ($row) {
                    // $view_html = '';
                    // if($row->profile_image_url == ''){
                    //     $detail_array = array();
                    //     $logo_image = isset($row->logo_image) ? $row->logo_image : '';
                    //     if($logo_image != ''){
                    //         $logo_image = 'images/employee_user/'.$logo_image;
                    //     }
                    //     $detail_array['logo_image'] = $logo_image;
                    //     $detail_array['name'] = $row->name;
                    //     $detail_array['designation'] = $row->designation;
                    //     $detail_array['address'] = $row->address.''.$row->address_2.''.$row->address_3;
                    //     $detail_array['phone_number'] = $row->phonecode.''.$row->phone_number;
                    //     $detail_array['email_address'] = $row->email_address;
                    //     $detail_array['website'] = $row->website;
                    //     $detail_array['table_detail'] = 'employee_users';
                    //     $detail_array['table_id'] = $row->id;
                    //     Helpers::CreateProfileImage($detail_array);
                    // }
                    // $view_html .= '<a target="_blank" href="' . $row->profile_image_url . '" class=""><img src="'.$row->profile_image_url.'" width="100"></a>';
                    $id = $row->id;
                    $emp_id = base64_encode($id);
                    $emp_url = route('employee_detail.get', array('id' => $emp_id));
                    $view_html = '<a target="_blank" href="' . $emp_url . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View Profile</a> ';
                    ////////////////////////////////////////
                    return $view_html;
                })->rawColumns(['action','logo_image_url','qr_image_url','profile_image_url'])->toJson();
        }
        $return_data = array();
        $return_data['page_condition'] = 'employee_user_page';
        $return_data['site_title'] = 'Employee User | ' . config('constants.SITE_NAME');
        return view('admin.employee_user.index', array_merge($return_data));
    }

    public function create()
    {
        $return_data = array();
        $countryphonecode = Country::select('id','name','phonecode')->whereNotNull('phonecode')->where('phonecodedigit','!=','0')->where('status','1')->where('phonecodestatus','1')->get();
        $return_data['countryphonecode'] = $countryphonecode;
        $return_data['page_condition'] = 'employee_user_page';
        $return_data['site_title'] = 'Employee User | ' . config('constants.SITE_NAME');
        return view('admin.employee_user.form', array_merge($return_data));
    }

    public function store(Request $request)
    {
        $id = 0;
        $countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('id',$request->phonecode)->first();
        $phonecodedigit = 0;
        if($countryphonecode_detail){
            $phonecodedigit = $countryphonecode_detail->phonecodedigit;
        }
        $validate = $request->validate(
            [
                'name' => "required",
                'phonecode' => "required",
                'phone_number' => "required|digits:".$phonecodedigit,
                'email_address' => "required|email|unique:employee_users,email_address," . $id . ",id,deleted_at,NULL",
                'designation' => "required",
                'address' => "required",
                'logo_image' => 'required|mimes:jpeg,png,jpg'
            ],
            [
                'name.required' => 'The name is required.',
                'designation.required' => 'The designation is required.',
                'email_address' => 'The email is required.',
                'email_address.email' => 'Please enter valid email.',
                'email_address.unique' => 'The email has been already taken.',
                'phonecode.required' => 'The phone code is required.',
                'phone_number.required' => 'The mobile number is required.',
                'phone_number.digits' => 'The mobile number must be '.$phonecodedigit.' digits.',
                'phone_number.min' => 'The mobile number should be 10 digits.',
                'phone_number.max' => 'The mobile number should be 10 digits.',
                'address.required' => 'The address is required.',
            ]
        );
        
        // Manually check the second table
        $email = $request->input('email_address');
        $existsInEmployeeUsers = EmployeeUser::where('email_address', $email)->exists();
        
        if ($existsInEmployeeUsers) {
            return redirect()->back()->withErrors(['email_address' => 'The email has been already taken.'])->withInput();
        }
        
        if ($validate) {

            $EmployeeUser = new EmployeeUser();
            $EmployeeUser->name = $request->name;
            $EmployeeUser->designation = $request->designation;
            $EmployeeUser->address = $request->address;
            $EmployeeUser->address_2 = $request->address_2;
            $EmployeeUser->address_3 = $request->address_3;
            $EmployeeUser->phonecode_id = $request->phonecode;
            $phonecode = '';
            $countryphonecode_detail = Country::select('id','name','phonecode')->where('id',$request->phonecode)->whereNotNull('phonecode')->first();
            if($countryphonecode_detail){
                $phonecode = $countryphonecode_detail->phonecode;
            }
            $EmployeeUser->phonecode = $phonecode;
            $EmployeeUser->phone_number = $request->phone_number;
            $EmployeeUser->email_address = $request->email_address;
            $EmployeeUser->website = $request->website;
            $EmployeeUser->status = 1;
            if($request->logo_image != ''){
                $destinationPath = public_path('images').'/employee_user/';
                File::makeDirectory($destinationPath, $mode = 0777, true, true);
                $original_name = $request->logo_image->getClientOriginalName();
                $file_size = $request->logo_image->getSize();
                $extension = $request->logo_image->extension();
                $random_number = Str::random(3);
                $logo_image = $random_number.'_'.$original_name;
                $request->logo_image->move($destinationPath, $logo_image);
                $EmployeeUser->logo_image = $logo_image;
            }
            $EmployeeUser->save();
            $id = $EmployeeUser->id;
            $detail_array = array();
            $logo_image = isset($EmployeeUser->logo_image) ? $EmployeeUser->logo_image : '';
            if($logo_image != ''){
                $logo_image = 'images/employee_user/'.$logo_image;
            }
            $detail_array['logo_image'] = $logo_image;
            $detail_array['name'] = $request->name;
            $detail_array['designation'] = $request->designation;
            $detail_array['address'] = $request->address.''.$request->address_2.''.$request->address_3;
            $detail_array['phone_number'] = $phonecode.''.$request->phone_number;
            $detail_array['email_address'] = $request->email_address;
            $detail_array['website'] = $request->website;
            $detail_array['table_detail'] = 'employee_users';
            $detail_array['table_id'] = $EmployeeUser->id;
            Helpers::CreateProfileImage($detail_array);
            if ($request->save) {
                return redirect(route('employee.user.edit', $EmployeeUser->id))->with('success_message', trans('Added Successfully'));
            } else {
                return redirect(route('employee.user.index'))->with('success_message', trans('Added Successfully'));
            }
        }
    }

    public function show($id)
    {
        $EmployeeUser = EmployeeUser::with('City','Country','State','Group')->find($id);
        $return_data = array();
        $return_data['data'] = $EmployeeUser;
        $return_data['id'] = $id;
        $return_data['page_condition'] = 'employee_user_page';
        $return_data['site_title'] = 'Employee User | ' . config('constants.SITE_NAME');
        return view('admin.employee_user.view', array_merge($return_data));
    }
    public function edit($id)
    {
        $data = EmployeeUser::find($id);
        $return_data = array();
        $return_data['data'] = $data;
        $countryphonecode = Country::select('id','name','phonecode')->whereNotNull('phonecode')->where('phonecodedigit','!=','0')->where('status','1')->where('phonecodestatus','1')->get();
        $return_data['countryphonecode'] = $countryphonecode;
        $return_data['page_condition'] = 'employee_user_page';
        $return_data['site_title'] = 'Employee User | ' . config('constants.SITE_NAME');
        return view('admin.employee_user.form', array_merge($return_data));
    }
    public function update(Request $request)
    {
        $id = $request->id;
        $countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('id',$request->phonecode)->first();
        $phonecodedigit = 0;
        if($countryphonecode_detail){
            $phonecodedigit = $countryphonecode_detail->phonecodedigit;
        }
        $validate = $request->validate(
            [
                'name' => "required",
                'phonecode' => "required",
                'phone_number' => "required|digits:".$phonecodedigit,
                'email_address' => "required|email|unique:employee_users,email_address," . $id . ",id,deleted_at,NULL",
                'designation' => "required",
                'address' => "required",
                'logo_image' => 'mimes:jpeg,png,jpg'
            ],
            [
                'name.required' => 'The name is required.',
                'designation.required' => 'The designation is required.',
                'email_address' => 'The email is required.',
                'email_address.email' => 'Please enter valid email.',
                'email_address.unique' => 'The email has been already taken.',
                'phonecode.required' => 'The phone code is required.',
                'phone_number.required' => 'The mobile number is required.',
                'phone_number.digits' => 'The mobile number must be '.$phonecodedigit.' digits.',
                'phone_number.min' => 'The mobile number should be 10 digits.',
                'phone_number.max' => 'The mobile number should be 10 digits.',
                'address.required' => 'The address is required.',
            ]
        );
        if ($validate) {
            $EmployeeUser = EmployeeUser::find($id);
            $EmployeeUser->name = $request->name;
            $EmployeeUser->designation = $request->designation;
            $EmployeeUser->address = $request->address;
            $EmployeeUser->address_2 = $request->address_2;
            $EmployeeUser->address_3 = $request->address_3;
            $EmployeeUser->phonecode_id = $request->phonecode;
            $phonecode = '';
            $countryphonecode_detail = Country::select('id','name','phonecode')->where('id',$request->phonecode)->whereNotNull('phonecode')->first();
            if($countryphonecode_detail){
                $phonecode = $countryphonecode_detail->phonecode;
            }
            $EmployeeUser->phonecode = $phonecode;
            $EmployeeUser->phone_number = $request->phone_number;
            $EmployeeUser->email_address = $request->email_address;
            $EmployeeUser->website = $request->website;
            if($request->logo_image != ''){
                $destinationPath = public_path('images').'/employee_user/';
                File::makeDirectory($destinationPath, $mode = 0777, true, true);
                $original_name = $request->logo_image->getClientOriginalName();
                $file_size = $request->logo_image->getSize();
                $extension = $request->logo_image->extension();
                $random_number = Str::random(3);
                $logo_image = $random_number.'_'.$original_name;
                $request->logo_image->move($destinationPath, $logo_image);
                $EmployeeUser->logo_image = $logo_image;
            }
            $EmployeeUser->save();
            $detail_array = array();
            $logo_image = isset($EmployeeUser->logo_image) ? $EmployeeUser->logo_image : '';
            if($logo_image != ''){
                $logo_image = 'images/employee_user/'.$logo_image;
            }
            $detail_array['logo_image'] = $logo_image;
            $detail_array['name'] = $request->name;
            $detail_array['designation'] = $request->designation;
            $detail_array['address'] = $request->address.''.$request->address_2.''.$request->address_3;
            $detail_array['phone_number'] = $phonecode.''.$request->phone_number;
            $detail_array['email_address'] = $request->email_address;
            $detail_array['website'] = $request->website;
            $detail_array['table_detail'] = 'employee_users';
            $detail_array['table_id'] = $EmployeeUser->id;
            Helpers::CreateProfileImage($detail_array);
            if ($request->save) {
                return redirect(route('employee.user.edit', $EmployeeUser->id))->with('success_message', trans('Update Successfully'));
            } else {
                return redirect(route('employee.user.index'))->with('success_message', trans('Update Successfully'));
            }
        }
    }
    public function destroy($id)
    {
        $EmployeeUser = EmployeeUser::find($id);
        $EmployeeUser->delete();
       
        return redirect()->route("employee.user.index")->with('success_message', 'Delete Successfully!');
    }

    public function setActivate($id)
    {
        $update_status = EmployeeUser::find($id);
        $update_status->status = 1;
        $update_status->save();
        return redirect(route('employee.user.index'))->with('success_message', trans('Active Successfully'));
    }

    public function setInactivate($id)
    {
        $update_status = EmployeeUser::find($id);
        $update_status->status = 0;
        $update_status->save();
        return redirect(route('employee.user.index'))->with('success_message', trans('Inactive Successfully'));
    }
}
