<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Heading;
use Datatables;

class HeadingController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $heading = Heading::all();
            return datatables()->of($heading)
                ->addColumn('action', function ($row) {
                    $html = '';
                    $html .= '<a href="' . route('heading.edit', $row->id) . '" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a> ';
                    $html .= '&nbsp;<a href="' . route('heading.show', $row->id) . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View</a> ';
                    if(count($row->documents) > 0){
                        $html .= '&nbsp;<a href="javascript:;" class="btn btn-danger btn-delete btn-sm" data-toggle="tooltip" data-original-title="Delete" data-container="body" title="" onclick="return alert(\'Please remove all the documents under this heading.\');" ><i class="fa fa-trash" aria-hidden="true"></i> Delete</a>';
                    }else{
                        $html .= '&nbsp;<a href="javascript:;" class="btn btn-danger btn-delete btn-sm" data-toggle="tooltip" data-original-title="Delete" data-container="body" title="" onclick="return record_delete(\'' . route('heading.destroy', $row->id) . '\');" ><i class="fa fa-trash" aria-hidden="true"></i> Delete</a>';
                    } 
                    if ($row->status == 1) {
                       // $html .= '<a href="' . route('heading.inactive', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Inactive this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-success"></i></a>';
                    } else {
                        //$html .= '<a href="' . route('heading.active', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Activate this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-muted"></i></a>';
                    }
                    $html .= '';

                    $html .= '<a href="" class="</a>';
                    return $html;
                })->toJson();
        }
        $return_data = array();
        $return_data['page_condition'] = 'heading_page';
        $return_data['site_title'] = 'Heading | ' . config('constants.SITE_NAME');
        return view('admin.heading.index', array_merge($return_data));
    }

    public function create()
    {
        $return_data = array();
        $return_data['page_condition'] = 'heading_page';
        $return_data['site_title'] = 'Heading | ' . config('constants.SITE_NAME');
        return view('admin.heading.form', array_merge($return_data));
    }

    public function store(Request $request)
    {
        $id = 0;
        $validate = $request->validate(
            [
                'name' => "required|unique:headings,name," . $id . ",id,deleted_at,NULL",
                //'description' => "required"
            ],
            [
                'name.required' => 'The Name is required.',
                'name.unique' => 'The Name has been already taken.',
                'description' => 'The Description is required.',
            ]
        );

        if ($validate) {

            $heading = new Heading();
            $heading->name = $request->name;
            $heading->description = $request->description;
            $heading->status = 1;
            $heading->save();
            if ($request->save) {
                return redirect(route('heading.edit', $heading->id))->with('success_message', trans('Added Successfully'));
            } else {
                return redirect(route('heading.index'))->with('success_message', trans('Added Successfully'));
            }
        }
    }

    public function show($id)
    {
        $heading = Heading::find($id);
        $return_data = array();
        $return_data['data'] = $heading;
        $return_data['page_condition'] = 'heading_page';
        $return_data['site_title'] = 'Heading | ' . config('constants.SITE_NAME');
        return view('admin.heading.view', array_merge($return_data));
    }

    public function edit($id)
    {
        $data = Heading::find($id);
        $return_data = array();
        $return_data['data'] = $data;
        $return_data['page_condition'] = 'heading_page';
        $return_data['site_title'] = 'Heading | ' . config('constants.SITE_NAME');
        return view('admin.heading.form', array_merge($return_data));
    }
    public function update(Request $request)
    {
        $id = $request->id;
        $validate = $request->validate(
            [
                'name' => "required|unique:headings,name," . $id . ",id,deleted_at,NULL",
                //'description' => "required"
            ],
            [
                'name.required' => 'The Name is required.',
                'name.unique' => 'The Name has been already taken.',
                'description' => 'The Description is required.',
            ]

        );
        if ($validate) {

            $heading = Heading::find($id);
            $heading->name = $request->name;
            $heading->description = $request->description;
            $heading->save();

            if ($request->save) {
                return redirect(route('heading.edit', $heading->id))->with('success_message', trans('Update Successfully'));
            } else {
                return redirect(route('heading.index'))->with('success_message', trans('Update Successfully'));
            }
        }
    }
    public function destroy($id)
    {
        $heading = Heading::find($id);
        $heading->delete();
        return redirect()->route("heading.index")->with('success_message', 'Delete Successfully!');
    }

    public function setActivate($id)
    {
        $update_status = Heading::find($id);
        $update_status->status = 1;
        $update_status->save();
        return redirect(route('heading.index'))->with('success_message', trans('Active Successfully'));
    }

    public function setInactivate($id)
    {
        $update_status = Heading::find($id);
        $update_status->status = 0;
        $update_status->save();
        return redirect(route('heading.index'))->with('success_message', trans('Inactive Successfully'));
    }
}
