<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CustomerUser;
use App\Models\CustomerContactDetail;
use App\Models\MassEmail;
use App\Models\MassEmailAttachment;
use App\Mail\MassMail;
use App\Models\EmailContent;
use App\Models\Group;
use App\Models\User;
use Datatables;
use Auth;
use Mail;

class MassEmailController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $login_user_id = Auth::check() ? Auth::user()->id : 0;
            $MassEmail = MassEmail::where('login_user_id',$login_user_id)->get();
            return datatables()->of($MassEmail)
                ->addColumn('action', function ($row) {
                    $html = '';
                    $html .= '&nbsp;<a href="' . route('mass_email.show', $row->id) . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View</a> ';
                    $html .= '&nbsp;<a href="' . route('mass_email.re_send', array('id'=>$row->id)) . '" class="btn badge-primary text-white btn-sm"><i class="fa fa-envelope"></i> Resend</a> ';
                    $html .= '';

                    $html .= '<a href="" class="</a>';
                    return $html;
                })->toJson();
        }
        $return_data = array();
        $return_data['page_condition'] = 'mass_email_page';
        $return_data['site_title'] = 'Mass Email | ' . config('constants.SITE_NAME');
        return view('admin.mass_email.index', array_merge($return_data));
    }

    public function create()
    {
        $return_data = array();
        $group = Group::where('status','1')->get();
        $return_data['group'] = $group;
        $customer_list = array();
        if(old('group_id') != ''){
            $customer_list = CustomerUser::with('Group')->where('status','1')->whereIn('group_id',old('group_id'))->get();
        }
        $customer_contact_list = array();
        if(old('customer_email') != ''){
            $customer_contact_list = CustomerContactDetail::select('customer_contact_details.*','customer_users.name as customer_users_name')->where('customer_contact_details.id','!=','0')->whereIn('customer_users.email_address',old('customer_email'));
            $customer_contact_list->join('customer_users', 'customer_users.id', '=', 'customer_contact_details.customer_id');
            $customer_contact_list = $customer_contact_list->orderBy('customer_contact_details.id', 'ASC')->orderBy('customer_contact_details.name', 'ASC')->get();
        }
        $return_data['customer_contact_list'] = $customer_contact_list;
        $return_data['page_condition'] = 'mass_email_page';
        $return_data['site_title'] = 'Mass Email | ' . config('constants.SITE_NAME');
        $return_data['customer_list'] = $customer_list;
        return view('admin.mass_email.form', array_merge($return_data));
    }

    public function store(Request $request)
    {
        $id = 0;
        $validate = $request->validate(
            [
                'title' => "required",
                'customer_email' => "required",
                'subject' => 'required|max:255',
                'content' => "required"
            ],
            [
                'title.required' => 'The title is required.',
                'customer_email.required' => 'The customer is required.',
                'subject.required' => 'The subject is required.',
                'content.required' => 'The content is required.',
            ]
        );
        // $this->MailSend();
        // exit;
        if ($validate) {
            $content = $request->content;
            $EmailContent =  EmailContent::where('status','1')->where('id',config('constants.MAIL_TEMPLATE.Mass_Mail_Footer'))->first();
            if(is_object($EmailContent)){
                $email_content = $EmailContent->content;
                $content = $content.'<br>'.$email_content;
            }
            $login_user_id = Auth::check() ? Auth::user()->id : 0;
            $from_email = Auth::check() ? Auth::user()->email : '';
            //$from_email = 'reminder@bakertilly-ug.com';
            $auth = auth()->user();
            $LoginUserName = isset($auth->name) ? $auth->name : '';
            $UserDetail =  User::withTrashed()->where('id',$login_user_id)->first();
            $LoginUserQr = '';
            $LoginUserDesignation = '';
            $LoginUserMobileNumber = '';
            $LoginUserEmail = '';
            if(is_object($UserDetail)){
                $LoginUserName = isset($UserDetail->name) ? $UserDetail->name : '';
                $LoginUserDesignation = isset($UserDetail->designation) ? $UserDetail->designation : '';
                $LoginUserphonecode = isset($UserDetail->phonecode) ? $UserDetail->phonecode : '';
                $LoginUsermobile = isset($UserDetail->mobile) ? $UserDetail->mobile : '';
                $LoginUserMobileNumber = $LoginUserphonecode.' '.$LoginUsermobile;
                $LoginUserEmail = isset($UserDetail->email) ? $UserDetail->email : '';
                $LoginUserQr = isset($UserDetail->qr_image_url) ? $UserDetail->qr_image_url : '';
                if($LoginUserQr != ''){
                    $LoginUserQr = '<img src="'.$LoginUserQr.'" width="100">';
                }
            } 
            $content = str_ireplace('{{LoginUserName}}','<div style="font-size:16px; font-weight:700; color:#f39c12; margin-bottom:4px;">'.$LoginUserName.'</div>',$content);
            $content = str_ireplace('{{LoginUserDesignation}}','<div style="font-size:13px; color:#4a4a4a; margin-bottom:8px;">'.$LoginUserDesignation.'</div>',$content);
            $content = str_ireplace('{{LoginUserMobileNumber}}','<a href="tel:'.$LoginUserMobileNumber.'" style="color:#1a73e8; text-decoration:none;">'.$LoginUserMobileNumber.'</a>',$content);
            $content = str_ireplace('{{LoginUserEmail}}','<a href="mailto:'.$LoginUserEmail.'" style="color:#1a73e8; text-decoration:none;">'.$LoginUserEmail.'</a>',$content);
            $content = str_ireplace('{{LoginUserQr}}',$LoginUserQr,$content);
            
            $MassEmail = new MassEmail();
            $MassEmail->login_user_id = $login_user_id;
            $MassEmail->from_email = $from_email;
            $MassEmail->title = $request->title;
            $MassEmail->subject = $request->subject;
            $MassEmail->content = $content;
            $customer_email = $request->customer_email;
            $email='no';
            if(count($customer_email) > 0){
                $email = implode(',',$customer_email);
            }
            $MassEmail->email = $email;
            $MassEmail->save();
            $files = array();
            $attachment = $request->file('attachment');            
            $destinationPath = public_path('images').config('constants.DOCUMENT');
            if($attachment){
                foreach($attachment as $key=>$image){
                    $org_upload_document = $image->getClientOriginalName();
                    if($org_upload_document != ''){
                        $upload_document = 'attachment-'.$key.'-'.time().'.'.$image->getClientOriginalExtension();
                        $image->move($destinationPath, $upload_document);
                        $file_attachment = new MassEmailAttachment();
                        $file_attachment->mass_email_id = $MassEmail->id;
                        $file_attachment->org_upload_document = $org_upload_document;
                        $file_attachment->upload_document = $upload_document;
                        $file_attachment->status = 1;
                        $file_attachment->save();
                        $files[] = $destinationPath.$upload_document;
                    }    
                }
            }
            if(count($customer_email) > 0){
                $email = implode(',',$customer_email);
                $mailData = [
                    'from_email' => $from_email,
                    'title' => $request->title,
                    'body' => $content,
                    'subject' => $request->subject,
                    'files' => $files
                ];
                Mail::to($customer_email)->send(new MassMail($mailData));
            }
            return redirect(route('mass_email.index'))->with('success_message', trans('Send Successfully'));
        }
    }
    public function show($id)
    {
        $MassEmail = MassEmail::find($id);
        $return_data = array();
        $return_data['data'] = $MassEmail;
        $return_data['page_condition'] = 'mass_email_page';
        $return_data['site_title'] = 'Mass Email | ' . config('constants.SITE_NAME');
        return view('admin.mass_email.view', array_merge($return_data));
    }
    public function Resend($id)
    {
        $MassEmail = MassEmail::find($id);
        if(!empty($MassEmail)){
            $customer_email = $MassEmail->email;
            $email = explode(',',$customer_email);
            if(count($email) > 0){
                $from_email = $MassEmail->from_email;
                //$from_email = 'reminder@bakertilly-ug.com';
                $mailData = [
                    'from_email' => $from_email,
                    'title' => $MassEmail->title,
                    'body' => $MassEmail->content,
                    'subject' => $MassEmail->subject
                ];
                Mail::to($email)->send(new MassMail($mailData));
            }    
        }
        return redirect(route('mass_email.index'))->with('success_message', trans('Send Successfully'));
    }
}
