<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CustomerUser;
use App\Models\CustomerContactDetail;
use App\Models\Quotation;
use App\Models\QuotationService;
use App\Models\Company;
use App\Models\Currency;
use App\Models\Service;
use App\Helper\Helpers;
use App\Models\Department;
use App\Models\EmailContent;
use Datatables;
use Auth;
use PDF;

class QuotationController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            //$quotation = QuotationService::select('quotation_id', 'customer_id')->groupBy('quotation_service.customer_id')->get();
            //$quotation = QuotationService::with('CustomerUser')->selectRaw('customer_id, MAX(id) as id, MAX(created_at) as latest_date','quotation_id')->groupBy('customer_id','quotation_id')->get();
            $quotation = Quotation::with('QuotationServiceList.CustomerUser')->with('Company')->get();
            return datatables()->of($quotation)
                ->addColumn('customer_name', function ($row) {
                    $customer_name_array = array();
                    if($row->customer_type == 'manual'){
                        $customer_name_array[] = $row->manual_customer_name; 
                    }
                    if (is_object($row->QuotationServiceList))  {
                        foreach($row->QuotationServiceList as $quotation_service_list_val){
                            if (is_object($quotation_service_list_val->CustomerUser))  {
                                $customer_name_array[] = $quotation_service_list_val->CustomerUser->name; 
                            }    
                        }
                    }
                    $customer_name_array = array_unique($customer_name_array);
                    return $customer_name = implode(',',$customer_name_array);
                })
                ->addColumn('company_name', function ($row) {
                    $name = '';
                    if (is_object($row->Company)) {
                        $name = $row->Company->name;
                    }
                    return $name;
                })->addColumn('send_datetime', function ($row) {
                    $date = '';
                    if (!empty($row->updated_at)) {
                        $date = date('Y-m-d H:i:s', strtotime($row->updated_at));
                    }
                    return $date;
                })->addColumn('quotation_no', function ($row) {
                    $quotation_no = $row->financial_year.'-'.$row->quotation_auto_number;
                    return $quotation_no;
                })
                ->addColumn('action', function ($row) {
                    $html = '';
                    $html .= '<a href="' . route('quotation.edit', $row->id) . '" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a> ';
                    $html .= '&nbsp;<a href="' . route('quotation.show', $row->id) . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View</a> ';
                    $html .= '';
                    $html .= '<a href="" class="</a>';
                    return $html;
                })->toJson();
        }
        $return_data = array();
        $return_data['page_condition'] = 'quotation_page';
        $return_data['site_title'] = 'Quotation | ' . config('constants.SITE_NAME');
        return view('admin.quotation.index', array_merge($return_data));
    }

    public function create()
    {
        $return_data = array();
        $customer_list = CustomerUser::with('Group')->where('status','1')->get();
        $return_data['customer_list'] = $customer_list;
        $return_data['selected_customer_id'] = array();
        $return_data['selected_customer_id_to'] = array();
        $return_data['selected_customer_id_cc'] = array();
        $return_data['selected_service_id'] = array();
        $return_data['selected_service_price'] = array();
        $return_data['selected_service_description'] = array();
        $company = Company::where('status','1')->get();
        $return_data['company'] = $company;
        $currency = Currency::where('status','1')->get();
        $return_data['currency'] = $currency;
        $service_list = Service::where('status','1')->get();
        $return_data['service_list'] = $service_list;
        $customer_contact_list = array();
        if(old('customer_id') != ''){
            $customer_contact_list = CustomerContactDetail::select('customer_contact_details.*','customer_users.name as customer_users_name')->where('customer_contact_details.id','!=','0')->whereIn('customer_contact_details.customer_id',old('customer_id'));
            $customer_contact_list->join('customer_users', 'customer_users.id', '=', 'customer_contact_details.customer_id');
            $customer_contact_list = $customer_contact_list->orderBy('customer_contact_details.id', 'ASC')->orderBy('customer_contact_details.name', 'ASC')->get();
        }
        $return_data['customer_contact_list'] = $customer_contact_list;
        $customer_type_automatic = 'checked';
        $customer_type_manual = '';
        if(old('customer_type') != ''){
            if(old('customer_type') == 'manual'){
                $customer_type_automatic = '';
                $customer_type_manual = 'checked';
            }
        } 
        $return_data['customer_type_automatic'] = $customer_type_automatic;
        $return_data['customer_type_manual'] = $customer_type_manual;
        $return_data['page_condition'] = 'quotation_page';
        $return_data['site_title'] = 'Quotation | ' . config('constants.SITE_NAME');
        return view('admin.quotation.form', array_merge($return_data));
    }

    public function store(Request $request)
    {
        $id = 0;
        $messages = [
            'from_email.required' => 'The from email is required.',
            'description.required' => 'The Description is required.',
            'customer_id.required' => 'The customer is required.',
            'manual_customer_name.required' => 'The Kind Attn is required.',
            'manual_kind_attn.required' => 'The customer is required.',
            'manual_customer_to_email.required' => 'The customer to email is required.',
            'service_id.required' => 'The Service is required.',
            'customer_type.required' => 'The customer type is required.',
            'company_id.required' => 'The Company is required.',
            'currency_id.required' => 'The Currency is required.',
            'vat.required' => 'The Vat is required.',
        ];
        $customer_type = $request->customer_type;
        $customer_id = $request->customer_id;
        if($customer_type == 'manual'){
            $validate = $request->validate(
                [
                    //'name' => "required|unique:quotations,name," . $id . ",id,deleted_at,NULL",
                    'company_id' => "required",
                    'currency_id' => "required",
                    'vat' => "required|integer|between:0,100",
                    'manual_customer_name' => "required",
                    'manual_kind_attn' => "required",
                    'manual_customer_to_email' => "required",
                    'service_id' => "required",
                    'customer_type' => "required",
                ],
                $messages
            );
        }else{
            $validate = $request->validate(
                [
                    //'name' => "required|unique:quotations,name," . $id . ",id,deleted_at,NULL",
                    'company_id' => "required",
                    'currency_id' => "required",
                    'vat' => "required|integer|between:0,100",
                    'customer_id' => "required",
                    'service_id' => "required",
                    'customer_type' => "required",
                ],
                $messages
            );
            if(count($customer_id) > 0){
                $customer_id_array = array();
                foreach($customer_id as $customer_id_val){
                    if($customer_id_val == NULL){
    
                    }elseif($customer_id_val == ''){
    
                    }else{
                        $customer_id_array[] = $customer_id_val;
                    }
                }
                if(count($customer_id_array) == 0){
                    return redirect()->back()->withErrors(['customer_id' => 'The customer is required'])->withInput();
                }
            }else{
                return redirect()->back()->withErrors(['customer_id' => 'The customer is required'])->withInput();
            }
        }
        $service_id = isset($_POST['service_id']) ? $_POST['service_id'] : array();
        if (count($service_id) == 0) {
            return redirect()->back()->withErrors(['service_id' => 'The Service is required'])->withInput();
        }
        if ($validate) {
            $inputDate = date('Y-m-d');
            $format = 'Y';
            $date=date_create($inputDate);
            if (date_format($date,"m") >= 4) {//On or After April (FY is current year - next year)
                $financial_year = (date_format($date,$format)) . '-' . (date_format($date,$format)+1);
            } else {//On or Before March (FY is previous year - current year)
                $financial_year = (date_format($date,$format)-1) . '-' . date_format($date,$format);
            }
            $financial_year_detail = Quotation::where('financial_year',$financial_year)->latest('quotation_auto_number')->first();
            if($financial_year_detail){
                $db_quotation_auto_number = $financial_year_detail->quotation_auto_number;
                $quotation_auto_number = $db_quotation_auto_number + 1;
            }else{
                $quotation_auto_number = 1;
            }
            $login_user_id = Auth::check() ? Auth::user()->id : 0;
            $from_email = Auth::check() ? Auth::user()->email : '';
            $quotation = new Quotation();
            $quotation->name = $request->name;
            $quotation->login_user_id = $login_user_id;
            $quotation->from_email = $from_email;
            $quotation->company_id = $request->company_id;
            $quotation->vat = $request->vat;
            $quotation->financial_year = $financial_year;
            $quotation->quotation_auto_number = $quotation_auto_number;
            $quotation->currency_id = $request->currency_id;
            $quotation->customer_type = $customer_type;
            if($customer_type == 'manual'){
                ///////////////////////////////////////////////////////////
                $manual_customer_name_insert =  $request->manual_customer_name;
                $quotation->manual_customer_name = $manual_customer_name_insert;
                ///////////////////////////////////////////////////////////
                $manual_kind_attn_insert =  $request->manual_kind_attn;
                $quotation->manual_kind_attn = $manual_kind_attn_insert;
                ///////////////////////////////////////////////////////////
                ///////////////////////////////////////////////////////////
                $manual_customer_address_insert =  $request->manual_customer_address;
                $quotation->manual_customer_address = $manual_customer_address_insert;
                ///////////////////////////////////////////////////////////
                ///////////////////////////////////////////////////////////
                $manual_customer_address_2_insert =  $request->manual_customer_address_2;
                $quotation->manual_customer_address_2 = $manual_customer_address_2_insert;
                ///////////////////////////////////////////////////////////
                ///////////////////////////////////////////////////////////
                $manual_customer_address_3_insert =  $request->manual_customer_address_3;
                $quotation->manual_customer_address_3 = $manual_customer_address_3_insert;
                ///////////////////////////////////////////////////////////
                ///////////////////////////////////////////////////////////
                $manual_customer_phone_insert =  $request->manual_customer_phone;
                $quotation->manual_customer_phone = $manual_customer_phone_insert;
                ///////////////////////////////////////////////////////////
                $manual_customer_to_email_insert =  $request->manual_customer_to_email;
                $quotation->manual_customer_to_email = $manual_customer_to_email_insert;
                ///////////////////////////////////////////////////////////
                $manual_customer_cc_email_insert =  $request->manual_customer_cc_email;
                $quotation->manual_customer_cc_email = $manual_customer_cc_email_insert;
                ///////////////////////////////////////////////////////////
                $quotation->contact_customer_id_to = '';
                $quotation->contact_customer_id_cc = '';
                $customer_id = array(0);
            }else{
                $customer_to_email = $request->customer_to_email;
                $customer_to_email_insert = '';
                if($customer_to_email == NULL){
                    $customer_to_email = array();
                }
                if(count($customer_to_email) > 0){
                    $customer_to_email_insert = json_encode($customer_to_email);
                }
                $quotation->contact_customer_id_to = $customer_to_email_insert;
                $customer_cc_email = $request->customer_cc_email;
                $customer_cc_email_insert = '';
                if($customer_cc_email == NULL){
                    $customer_cc_email = array();
                }
                if(count($customer_cc_email) > 0){
                    $customer_cc_email_insert = json_encode($customer_cc_email);
                }
                $quotation->contact_customer_id_cc = $customer_cc_email_insert;
                $customer_id = isset($_POST['customer_id']) ? $_POST['customer_id'] : array();
                $quotation->manual_customer_name = '';
                $quotation->manual_kind_attn = '';
                $quotation->manual_customer_to_email = '';
                $quotation->manual_customer_cc_email = '';
                $quotation->manual_customer_address = '';
                $quotation->manual_customer_address_2 = '';
                $quotation->manual_customer_address_3 = '';
                $quotation->manual_customer_phone = '';
            }
            $quotation->status = 1;
            $quotation->save();
            $destinationPath = public_path('images').config('constants.DOCUMENT');
            $service_price = isset($_POST['service_price']) ? $_POST['service_price'] : array();
            $service_description = isset($_POST['service_description']) ? $_POST['service_description'] : array();
            if(count($customer_id) > 0 && count($service_id) > 0){
                foreach($customer_id as $customer_id_val){
                    foreach($service_id as $service_id_val){
                        $service_price_val = isset($service_price[$service_id_val]) ? $service_price[$service_id_val] : 0;
                        if($service_price_val == ''){
                            $service_price_val = 0;
                        }
                        $service_description_val = isset($service_description[$service_id_val]) ? $service_description[$service_id_val] : 0;
                        $quotation_detail = new QuotationService();
                        $quotation_detail->quotation_id = $quotation->id;
                        $quotation_detail->login_user_id = $login_user_id;
                        $quotation_detail->customer_id = $customer_id_val;
                        $quotation_detail->service_id = $service_id_val;
                        $quotation_detail->service_price = $service_price_val;
                        $quotation_detail->description = $service_description_val;
                        $quotation_detail->save();
                    }   
                }
            }
            $quotation_id = $quotation->id;
            Helpers::QuotationPdf($quotation_id,$customer_id,'quotation_pdf');
            if ($request->save_send) {
                if(count($customer_id) > 0){
                    foreach($customer_id as $customer_id_val){
                        Helpers::QuotationMail($quotation->id,$customer_id_val,'quotation_add');
                    }
                }
            }  
            if ($request->save_view) {
                return redirect(route('quotation.show', $quotation->id));
            } 
            if ($request->save) {
                return redirect(route('quotation.edit', $quotation->id))->with('success_message', trans('Added Successfully'));
            } else {
                return redirect(route('quotation.index'))->with('success_message', trans('Added Successfully'));
            }
        }
    }

    public function show($id)
    {
        $quotation = Quotation::find($id);
        if(empty(($quotation))){
            return redirect(route('quotation.index'));
        }
        $return_data = array();
        $return_data['data'] = $quotation;
        $selected_customer = '';
        $selected_customer_id_to = '';
        $selected_customer_id_cc = '';
        $customer_type = $quotation->customer_type;
        $Quotation_Service_detail = QuotationService::where('quotation_id',$id)->get();
        $selected_customer_id = array();
        if($Quotation_Service_detail){
            foreach($Quotation_Service_detail as $Quotation_Service_detail_val){
                $selected_customer_id[] = $Quotation_Service_detail_val->customer_id;
            }
        }
        if($customer_type == 'manual'){
            $customer_id = 0;
            $selected_customer = $quotation->manual_customer_name;
            $manual_customer_to_email = $quotation->manual_customer_to_email;
            $manual_customer_to_email_array = explode(',',$manual_customer_to_email);
            if(count($manual_customer_to_email_array) > 0){
                foreach($manual_customer_to_email_array as $contact_customer_id_to_array_val){
                    $selected_customer_id_to .= $contact_customer_id_to_array_val.'<br>';
                }
            }
            $manual_customer_cc_email = $quotation->manual_customer_cc_email;
            $manual_customer_cc_email_array = explode(',',$manual_customer_cc_email);
            if(count($manual_customer_cc_email_array) > 0){
                foreach($manual_customer_cc_email_array as $contact_customer_id_to_array_val){
                    $selected_customer_id_cc .= $contact_customer_id_to_array_val.'<br>';
                }
            }
        }else{
            $customer_id = isset($selected_customer_id[0]) ? $selected_customer_id[0] : 0;;
            $selected_customer = $quotation->manual_customer_name;
            if(count($selected_customer_id) > 0){
                $customer_contact_list = CustomerContactDetail::select('customer_contact_details.*','customer_users.name as customer_users_name')->where('customer_contact_details.id','!=','0')->whereIn('customer_contact_details.customer_id',$selected_customer_id);
                $customer_contact_list->join('customer_users', 'customer_users.id', '=', 'customer_contact_details.customer_id');
                $customer_contact_list = $customer_contact_list->orderBy('customer_contact_details.id', 'ASC')->orderBy('customer_contact_details.name', 'ASC')->get();
                if($customer_contact_list){
                    foreach($customer_contact_list as $customer_contact_list_val){
                        $selected_customer = $customer_contact_list_val->customer_users_name;
                    }
                }
                
            }
            $contact_customer_id_to = $quotation->contact_customer_id_to;
            if($contact_customer_id_to != ''){
                $contact_customer_id_to_array = json_decode($contact_customer_id_to,true);
                if(count($contact_customer_id_to_array) > 0){
                    $selected_customer_id_to_array = array();
                    foreach($contact_customer_id_to_array as $contact_customer_id_to_array_val){
                        $selected_customer_id_to_array[] = $contact_customer_id_to_array_val;
                    }
                }
                if(count($selected_customer_id_to_array) > 0){
                    $CustomerUser_detail = CustomerContactDetail::select('name','email')->whereIn('id', $selected_customer_id_to_array)->get();
                    if($CustomerUser_detail){
                        foreach($CustomerUser_detail as $CustomerUser_detail_val){
                            if($CustomerUser_detail_val->email != ''){
                                $selected_customer_id_to .= $CustomerUser_detail_val->name.' - '.$CustomerUser_detail_val->email.'<br>';
                            }    
                        }
                    }
                }
            }
            $contact_customer_id_cc = $quotation->contact_customer_id_cc;
            if($contact_customer_id_cc != ''){
                $contact_customer_id_cc_array = json_decode($contact_customer_id_cc,true);
                if(count($contact_customer_id_cc_array) > 0){
                    $selected_customer_id_cc_array = array();
                    foreach($contact_customer_id_cc_array as $contact_customer_id_cc_array_val){
                        $selected_customer_id_cc_array[] = $contact_customer_id_cc_array_val;
                    }
                }
                if(count($selected_customer_id_cc_array) > 0){
                    $CustomerUser_detail = CustomerContactDetail::select('name','email')->whereIn('id', $selected_customer_id_cc_array)->get();
                    if($CustomerUser_detail){
                        foreach($CustomerUser_detail as $CustomerUser_detail_val){
                            if($CustomerUser_detail_val->email != ''){
                                $selected_customer_id_cc .= $CustomerUser_detail_val->name.' - '.$CustomerUser_detail_val->email.'<br>';
                            }    
                        }
                    }
                }
            }
        }    
        $return_data['customer_id'] = $customer_id;
        $return_data['selected_customer'] = $selected_customer;
        $return_data['selected_customer_id_to'] = $selected_customer_id_to;
        $return_data['selected_customer_id_cc'] = $selected_customer_id_cc;
        $destinationPath = public_path('').'/quotation_pdf/';
        $return_data['destinationPath'] = $destinationPath;
        $return_data['page_condition'] = 'quotation_page';
        $return_data['site_title'] = 'Quotation | ' . config('constants.SITE_NAME');
        return view('admin.quotation.view', array_merge($return_data));
    }

    public function edit($id)
    {
        $data = Quotation::find($id);
        if(empty(($data))){
            return redirect(route('quotation.index'));
        }
        $return_data = array();
        $return_data['data'] = $data;
        $customer_list = CustomerUser::with('Group')->where('status','1')->get();
        $return_data['customer_list'] = $customer_list;
        $selected_customer_id = array();
        $selected_customer_id_to = array();
        $selected_customer_id_cc = array();
        $selected_service_id = array();
        $selected_service_id = array();
        $selected_service_price = array();
        $selected_service_description = array();
        $Quotation_Service_detail = QuotationService::where('quotation_id',$id)->get();
        if($Quotation_Service_detail){
            foreach($Quotation_Service_detail as $Quotation_Service_detail_val){
                $selected_customer_id[] = $Quotation_Service_detail_val->customer_id;
                $selected_service_id[] = $Quotation_Service_detail_val->service_id;
                $selected_service_price[$Quotation_Service_detail_val->service_id] = $Quotation_Service_detail_val->service_price;
                $selected_service_description[$Quotation_Service_detail_val->service_id] = $Quotation_Service_detail_val->description;
            }
        }
        $contact_customer_id_to = $data->contact_customer_id_to;
        if($contact_customer_id_to != ''){
            $contact_customer_id_to_array = json_decode($contact_customer_id_to,true);
            if(count($contact_customer_id_to_array) > 0){
                foreach($contact_customer_id_to_array as $contact_customer_id_to_array_val){
                    $selected_customer_id_to[] = $contact_customer_id_to_array_val;
                }
            }
        }
        $contact_customer_id_cc = $data->contact_customer_id_cc;
        if($contact_customer_id_cc != ''){
            $contact_customer_id_cc_array = json_decode($contact_customer_id_cc,true);
            if(count($contact_customer_id_cc_array) > 0){
                foreach($contact_customer_id_cc_array as $contact_customer_id_cc_array_val){
                    $selected_customer_id_cc[] = $contact_customer_id_cc_array_val;
                }
            }
        }
        $customer_contact_list = array();
        if(count($selected_customer_id) > 0){
            $customer_contact_list = CustomerContactDetail::select('customer_contact_details.*','customer_users.name as customer_users_name')->where('customer_contact_details.id','!=','0')->whereIn('customer_contact_details.customer_id',$selected_customer_id);
            $customer_contact_list->join('customer_users', 'customer_users.id', '=', 'customer_contact_details.customer_id');
            $customer_contact_list = $customer_contact_list->orderBy('customer_contact_details.id', 'ASC')->orderBy('customer_contact_details.name', 'ASC')->get();
        }
        $return_data['customer_contact_list'] = $customer_contact_list;
        $return_data['selected_customer_id'] = $selected_customer_id;
        $return_data['selected_customer_id_to'] = $selected_customer_id_to;
        $return_data['selected_customer_id_cc'] = $selected_customer_id_cc;
        $return_data['selected_service_id'] = $selected_service_id;
        $return_data['selected_service_price'] = $selected_service_price;
        $return_data['selected_service_description'] = $selected_service_description;
        $company = Company::where('status','1')->get();
        $return_data['company'] = $company;
        $currency = Currency::where('status','1')->get();
        $return_data['currency'] = $currency;
        $service_list = Service::where('status','1')->get();
        $return_data['service_list'] = $service_list;
        $customer_type_automatic = 'checked';
        $customer_type_manual = '';
        if(old('customer_type') != ''){
            if(old('customer_type') == 'manual'){
                $customer_type_automatic = '';
                $customer_type_manual = 'checked';
            }
        } elseif(isset($data)){
            $customer_type = $data->customer_type;
            if($customer_type == 'manual'){
                $customer_type_automatic = '';
                $customer_type_manual = 'checked';
            }
        }
        $return_data['customer_type_automatic'] = $customer_type_automatic;
        $return_data['customer_type_manual'] = $customer_type_manual;
        $return_data['page_condition'] = 'quotation_page';
        $return_data['site_title'] = 'Quotation | ' . config('constants.SITE_NAME');
        return view('admin.quotation.form', array_merge($return_data));
    }
    public function update(Request $request)
    {
        $id = $request->id;
        $messages = [
            'from_email.required' => 'The from email is required.',
            'description.required' => 'The Description is required.',
            'customer_id.required' => 'The customer is required.',
            'manual_customer_name.required' => 'The customer is required.',
            'manual_kind_attn.required' => 'The Kind Attn is required.',
            'manual_customer_to_email.required' => 'The customer to email is required.',
            'service_id.required' => 'The Service is required.',
            'customer_type.required' => 'The customer type is required.',
            'company_id.required' => 'The Company is required.',
            'currency_id.required' => 'The Currency is required.',
            'vat.required' => 'The Vat is required.',
        ];
        $customer_type = $request->customer_type;
        $customer_id = $request->customer_id;
        if($customer_type == 'manual'){
            $validate = $request->validate(
                [
                    //'name' => "required|unique:quotations,name," . $id . ",id,deleted_at,NULL",
                    'company_id' => "required",
                    'currency_id' => "required",
                    'vat' => "required|integer|between:0,100",
                    'manual_customer_name' => "required",
                    'manual_kind_attn' => "required",
                    'manual_customer_to_email' => "required",
                    'service_id' => "required",
                    'customer_type' => "required",
                ],
                $messages
            );
        }else{
            $validate = $request->validate(
                [
                    //'name' => "required|unique:quotations,name," . $id . ",id,deleted_at,NULL",
                    'company_id' => "required",
                    'currency_id' => "required",
                    'vat' => "required|integer|between:0,100",
                    'customer_id' => "required",
                    'service_id' => "required",
                    'customer_type' => "required",
                ],
                $messages
            );
            if(count($customer_id) > 0){
                $customer_id_array = array();
                foreach($customer_id as $customer_id_val){
                    if($customer_id_val == NULL){
    
                    }elseif($customer_id_val == ''){
    
                    }else{
                        $customer_id_array[] = $customer_id_val;
                    }
                }
                if(count($customer_id_array) == 0){
                    return redirect()->back()->withErrors(['customer_id' => 'The customer is required'])->withInput();
                }
            }else{
                return redirect()->back()->withErrors(['customer_id' => 'The customer is required'])->withInput();
            }
        }
        $service_id = isset($_POST['service_id']) ? $_POST['service_id'] : array();
        if (count($service_id) == 0) {
            return redirect()->back()->withErrors(['service_id' => 'The Document is required'])->withInput();
        }
        if ($validate) {
            $login_user_id = Auth::check() ? Auth::user()->id : 0;
            $from_email = Auth::check() ? Auth::user()->email : '';
            $current_date = date('Y-m-d');
            $quotation = Quotation::find($id);
            $quotation->name = $request->name;
            $quotation->company_id = $request->company_id;
            $quotation->vat = $request->vat;
            $quotation->currency_id = $request->currency_id;
            $quotation->customer_type = $customer_type;
            if($customer_type == 'manual'){
                ///////////////////////////////////////////////////////////
                $manual_customer_name_insert =  $request->manual_customer_name;
                $quotation->manual_customer_name = $manual_customer_name_insert;
                ///////////////////////////////////////////////////////////
                ///////////////////////////////////////////////////////////
                $manual_customer_address_insert =  $request->manual_customer_address;
                $quotation->manual_customer_address = $manual_customer_address_insert;
                ///////////////////////////////////////////////////////////
                ///////////////////////////////////////////////////////////
                $manual_customer_address_2_insert =  $request->manual_customer_address_2;
                $quotation->manual_customer_address_2 = $manual_customer_address_2_insert;
                ///////////////////////////////////////////////////////////
                ///////////////////////////////////////////////////////////
                $manual_customer_address_3_insert =  $request->manual_customer_address_3;
                $quotation->manual_customer_address_3 = $manual_customer_address_3_insert;
                ///////////////////////////////////////////////////////////
                ///////////////////////////////////////////////////////////
                $manual_customer_phone_insert =  $request->manual_customer_phone;
                $quotation->manual_customer_phone = $manual_customer_phone_insert;
                ///////////////////////////////////////////////////////////
                $manual_kind_attn_insert =  $request->manual_kind_attn;
                $quotation->manual_kind_attn = $manual_kind_attn_insert;
                ///////////////////////////////////////////////////////////
                $manual_customer_to_email_insert =  $request->manual_customer_to_email;
                $quotation->manual_customer_to_email = $manual_customer_to_email_insert;
                ///////////////////////////////////////////////////////////
                $manual_customer_cc_email_insert =  $request->manual_customer_cc_email;
                $quotation->manual_customer_cc_email = $manual_customer_cc_email_insert;
                ///////////////////////////////////////////////////////////
                $quotation->contact_customer_id_to = '';
                $quotation->contact_customer_id_cc = '';
                $customer_id = array(0);
            }else{
                $customer_to_email = $request->customer_to_email;
                $customer_to_email_insert = '';
                if($customer_to_email == NULL){
                    $customer_to_email = array();
                }
                if(count($customer_to_email) > 0){
                    $customer_to_email_insert = json_encode($customer_to_email);
                }
                $quotation->contact_customer_id_to = $customer_to_email_insert;
                $customer_cc_email = $request->customer_cc_email;
                $customer_cc_email_insert = '';
                if($customer_cc_email == NULL){
                    $customer_cc_email = array();
                }
                if(count($customer_cc_email) > 0){
                    $customer_cc_email_insert = json_encode($customer_cc_email);
                }
                $quotation->contact_customer_id_cc = $customer_cc_email_insert;
                $customer_id = isset($_POST['customer_id']) ? $_POST['customer_id'] : array();
                $quotation->manual_customer_name = '';
                $quotation->manual_customer_to_email = '';
                $quotation->manual_kind_attn = '';
                $quotation->manual_customer_address = '';
                $quotation->manual_customer_address_2 = '';
                $quotation->manual_customer_address_3 = '';
                $quotation->manual_customer_phone = '';
                $quotation->manual_customer_cc_email = '';
            }    
            $quotation->description = $request->description;
            $quotation->save();
            $QuotationService_delete = QuotationService::where('quotation_id',$id);
            $QuotationService_delete->delete();
            $service_price = isset($_POST['service_price']) ? $_POST['service_price'] : array();
            $service_description = isset($_POST['service_description']) ? $_POST['service_description'] : array();
            if(count($customer_id) > 0 && count($service_id) > 0){
                foreach($customer_id as $customer_id_val){
                    foreach($service_id as $service_id_val){
                        $service_price_val = isset($service_price[$service_id_val]) ? $service_price[$service_id_val] : 0;
                        if($service_price_val == ''){
                            $service_price_val = 0;
                        }
                        $service_description_val = isset($service_description[$service_id_val]) ? $service_description[$service_id_val] : 0;
                        $old_count = QuotationService::withTrashed()->where('quotation_id',$id)->where('customer_id',$customer_id_val)->where('service_id',$service_id_val)->count();
                        if($old_count == 0){
                            $quotation_detail = new QuotationService();
                            $quotation_detail->quotation_id = $quotation->id;
                            $quotation_detail->login_user_id = $login_user_id;
                            $quotation_detail->customer_id = $customer_id_val;
                            $quotation_detail->service_id = $service_id_val;
                            $quotation_detail->service_price = $service_price_val;
                            $quotation_detail->description = $service_description_val;
                        $quotation_detail->save();
                        }else{
                            QuotationService::withTrashed()->where('quotation_id',$id)->where('customer_id',$customer_id_val)->where('service_id',$service_id_val)->update(['deleted_at' => null,'service_price' => $service_price_val,'description' => $service_description_val]);
                        }     
                    }   
                }
            }
            /////////////////////////////////////////////////////////////////////
            $quotation_id = $quotation->id;
            Helpers::QuotationPdf($quotation_id,$customer_id,'quotation_pdf');
            /////////////////////////////////////////////////////////////////////
            if ($request->save_send) {
                if(count($customer_id) > 0){
                    foreach($customer_id as $customer_id_val){
                        Helpers::QuotationMail($quotation->id,$customer_id_val,'quotation_update');
                    }
                }
            } 
            if ($request->save_view) {
                return redirect(route('quotation.show', $quotation->id));
            } 
            if ($request->save) {
                return redirect(route('quotation.edit', $quotation->id))->with('success_message', trans('Update Successfully'));
            } else {
                return redirect(route('quotation.index'))->with('success_message', trans('Update Successfully'));
            }
        }
    }
    public function destroy($id)
    {
        $quotation = Quotation::find($id);
        $quotation->delete();
        return redirect()->route("quotation.index")->with('success_message', 'Delete Successfully!');
    }

    public function setActivate($id)
    {
        $update_status = Quotation::find($id);
        $update_status->status = 1;
        $update_status->save();
        return redirect(route('quotation.index'))->with('success_message', trans('Active Successfully'));
    }

    public function setInactivate($id)
    {
        $update_status = Quotation::find($id);
        $update_status->status = 0;
        $update_status->save();
        return redirect(route('quotation.index'))->with('success_message', trans('Inactive Successfully'));
    }
    public function QuotationSend($quotation_id,$customer_id)
    {
        Helpers::QuotationMail($quotation_id,$customer_id,'quotation_send');
        //return redirect(route('quotation.show',$quotation_id))->with('success_message', trans('Send Successfully'));
        return redirect()->back()->with('success_message', trans('Send Successfully'));
    }
}
