<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CustomerUser;
use App\Models\Document;
use App\Models\Reminder;
use App\Models\Group;
use App\Models\Assignment;
use App\Models\CustomerContactDetail;
use App\Models\ReminderCustomerDocument;
use App\Models\ReminderAttachment;
use App\Helper\Helpers;
use Datatables;
use Auth;

class ReminderController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $reminder = Reminder::all();
            return datatables()->of($reminder)
                ->addColumn('action', function ($row) {
                    $html = '';
                    $html .= '<a href="' . route('reminder.edit', $row->id) . '" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a> ';
                    $html .= '&nbsp;<a href="' . route('reminder.show', $row->id) . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View</a> ';
                    //$html .= '&nbsp;<a href="javascript:;" class="btn btn-danger btn-delete btn-sm" data-toggle="tooltip" data-original-title="Delete" data-container="body" title="" onclick="return record_delete(\'' . route('reminder.destroy', $row->id) . '\');" ><i class="fa fa-trash" aria-hidden="true"></i> Delete</a>';
                    if ($row->status == 1) {
                        $html .= '<a href="' . route('reminder.inactive', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Stop this?\');" rel="tooltip" title="" class="btn btn-danger ml-1 btn-sm"><i class="fa fa-circle text-muted"></i> Stop</a>';
                    } else {
                        $html .= '<a href="' . route('reminder.active', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Start this?\');" rel="tooltip" title="" class="btn btn-success ml-1 btn-sm"><i class="fa fa-circle text-success"></i> Start</a>';
                    }
                    $html .= '';

                    $html .= '<a href="" class="</a>';
                    return $html;
                })->addColumn('name', function ($row) {
                    $name = '';
                    $name .= $row->name;
                    if($row->scheduler_reminder_id > 0){
                        $name .= ' [Schedule]';
                    }
                    return $name;
                })->addColumn('send_date', function ($row) {
                    $name = '-';
                    if ($row->status == 1) {
                        $name = date('d-m-Y',strtotime($row->send_date));
                    }
                    return $name;
                })->addColumn('next_send_date', function ($row) {
                    $name = '-';
                    if ($row->status == 1) {
                        $name = date('d-m-Y',strtotime($row->next_send_date));
                    }    
                    return $name;
                })->addColumn('reminder_period', function ($row) {
                    $name = '-';
                    if ($row->status == 1) {
                        $reminder_period = $row->reminder_period;
                        $Reminder_Period_array = config('constants.Reminder_Period');
                        $name = isset($Reminder_Period_array[$reminder_period]) ? $Reminder_Period_array[$reminder_period] : '';
                    }    
                    return $name;
                })->toJson();
        }
        $return_data = array();
        $return_data['page_condition'] = 'reminder_page';
        $return_data['site_title'] = 'Reminder | ' . config('constants.SITE_NAME');
        return view('admin.reminder.index', array_merge($return_data));
    }

    public function create()
    {
        $return_data = array();
        $customer_list = CustomerUser::with('Group')->where('status','1')->get();
        $return_data['customer_list'] = $customer_list;
        $return_data['selected_customer_id'] = array();
        $return_data['selected_customer_id_to'] = array();
        $return_data['selected_customer_id_cc'] = array();
        $return_data['selected_document_id'] = array();
        $group = Group::where('status','1')->get();
        $return_data['group'] = $group;
        $document_list = Document::where('status','1')->get();
        if(old('assignment_id') != ''){
            $document_list = Document::where('status','1')->where('assignment_id',old('assignment_id'))->get();
        }
        $assignment = Assignment::where('status','1')->get();
        $return_data['assignment'] = $assignment;
        $return_data['document_list'] = $document_list;
        $customer_contact_list = array();
        if(old('customer_id') != ''){
            $customer_contact_list = CustomerContactDetail::select('customer_contact_details.*','customer_users.name as customer_users_name')->where('customer_contact_details.id','!=','0')->whereIn('customer_contact_details.customer_id',old('customer_id'));
            $customer_contact_list->join('customer_users', 'customer_users.id', '=', 'customer_contact_details.customer_id');
            $customer_contact_list = $customer_contact_list->orderBy('customer_contact_details.id', 'ASC')->orderBy('customer_contact_details.name', 'ASC')->get();
        }
        $return_data['customer_contact_list'] = $customer_contact_list;
        $return_data['page_condition'] = 'reminder_page';
        $return_data['site_title'] = 'Reminder | ' . config('constants.SITE_NAME');
        return view('admin.reminder.form', array_merge($return_data));
    }

    public function store(Request $request)
    {
        $id = 0;
        $validate = $request->validate(
            [
                //'name' => "required|unique:reminders,name," . $id . ",id,deleted_at,NULL",
                'name' => "required",
                //'description' => "required",
                //'from_email' => "required",
                'reminder_period' => "required",
                'customer_id' => "required",
                'document_id' => "required",
                'assignment_id' => "required"
            ],
            [
                'name.required' => 'The Subject is required.',
                'name.unique' => 'The Subject has been already taken.',
                'from_email.required' => 'The from email is required.',
                'reminder_period.required' => 'The reminder period is required.',
                'description.required' => 'The Description is required.',
                'customer_id.required' => 'The customer is required.',
                'document_id.required' => 'The Document is required.',
                'assignment_id.required' => 'The Assignment is required.',
            ]
        );
        $customer_id = $request->customer_id;
        if(count($customer_id) > 0){
            $customer_id_array = array();
            foreach($customer_id as $customer_id_val){
                if($customer_id_val == NULL){

                }elseif($customer_id_val == ''){

                }else{
                    $customer_id_array[] = $customer_id_val;
                }
            }
            if(count($customer_id_array) == 0){
                return redirect()->back()->withErrors(['customer_id' => 'The customer is required'])->withInput();
            }
        }else{
            return redirect()->back()->withErrors(['customer_id' => 'The customer is required'])->withInput();
        }
        $assignment_id = $request->assignment_id;
        $document_id = isset($_POST['document_id'][$assignment_id]) ? $_POST['document_id'][$assignment_id] : array();
        if (count($document_id) == 0) {
            return redirect()->back()->withErrors(['document_id' => 'The Document is required'])->withInput();
        }
        $existsIncustomerUsers_query = Reminder::where('name', $request->name)->whereIn('reminder_customer_documents.customer_id',$customer_id_array)->where('reminder_customer_documents.upload_status',0);
        $existsIncustomerUsers_query->join('reminder_customer_documents', 'reminder_customer_documents.reminder_id', '=', 'reminders.id');
        $existsIncustomerUsers = $existsIncustomerUsers_query->exists();
        if ($existsIncustomerUsers) {
            return redirect()->back()->withErrors(['name' => 'The Subject has been already taken.'])->withInput();
        }
        if ($validate) {
            $login_user_id = Auth::check() ? Auth::user()->id : 0;
            $from_email = Auth::check() ? Auth::user()->email : '';
            $current_date = date('Y-m-d');
            $reminder = new Reminder();
            $reminder->name = $request->name;
            $reminder->login_user_id = $$login_user_id;
            $reminder->from_email = $from_email;
            $reminder->current_date_value = $request->current_date_value;
            $reminder->year_end = $request->year_end;
            $reminder->reminder_period = $request->reminder_period;
            if($request->reminder_period == 1){//Weekly
                $next_send_date = date('Y-m-d',strtotime("+ 8 day"));       
            }elseif($request->reminder_period == 2){//Monthly
                $next_send_date = date('Y-m-d',strtotime("+ 1 month"));       
            }else{//Daily
                $next_send_date = date('Y-m-d',strtotime("+ 1 day"));
            }
            $reminder->send_date = $current_date;
            $reminder->next_send_date = $next_send_date;
            $reminder->description = $request->description;
            $reminder->assignment_id = $request->assignment_id;
            $customer_to_email = $request->customer_to_email;
            $customer_to_email_insert = '';
            if($customer_to_email == NULL){
                $customer_to_email = array();
            }
            if(count($customer_to_email) > 0){
                $customer_to_email_insert = json_encode($customer_to_email);
            }
            $reminder->contact_customer_id_to = $customer_to_email_insert;
            $customer_cc_email = $request->customer_cc_email;
            $customer_cc_email_insert = '';
            if($customer_cc_email == NULL){
                $customer_cc_email = array();
            }
            if(count($customer_cc_email) > 0){
                $customer_cc_email_insert = json_encode($customer_cc_email);
            }
            $reminder->contact_customer_id_cc = $customer_cc_email_insert;
            $reminder->status = 1;
            $reminder->save();
            $destinationPath = public_path('images').config('constants.DOCUMENT');
            $attachment = $request->file('attachment');            
            if($attachment){
                foreach($attachment as $key=>$image){
                    $org_upload_document = $image->getClientOriginalName();
                    if($org_upload_document != ''){
                        $upload_document = 'attachment-'.$key.'-'.time().'.'.$image->getClientOriginalExtension();
                        $image->move($destinationPath, $upload_document);
                        $file_attachment = new ReminderAttachment();
                        $file_attachment->reminder_id = $reminder->id;
                        $file_attachment->org_upload_document = $org_upload_document;
                        $file_attachment->upload_document = $upload_document;
                        $file_attachment->status = 1;
                        $file_attachment->save();
                    }    
                }
            }
            $customer_id = isset($_POST['customer_id']) ? $_POST['customer_id'] : array();
            $main_doc_content_column_array = isset($_POST['doc_content_column']) ? $_POST['doc_content_column'] : array();
            if(count($customer_id) > 0 && count($document_id) > 0){
                foreach($customer_id as $customer_id_val){
                    foreach($document_id as $document_id_val){
                        $doc_content_column_array = isset($main_doc_content_column_array[$document_id_val]) ? $main_doc_content_column_array[$document_id_val] : array();
                        $doc_content_column = json_encode($doc_content_column_array);
                        $doc_content = '';
                        $document_detail = Document::where('id',$document_id_val)->first();
                        if($document_detail){
                            $doc_content = $document_detail->doc_content;
                        }
                        $search_array = array();
                        $replace_array = array();
                        if(count($doc_content_column_array) > 0){
                            foreach($doc_content_column_array as $doc_content_column_key=>$doc_content_column_val){
                                $search_array[] = '{{{'.$doc_content_column_key.'}}}';
                                $replace_array[] = $doc_content_column_val;
                            }
                        }
                        $doc_content_result = str_replace($search_array, $replace_array, $doc_content);

                        $reminder_detail = new ReminderCustomerDocument();
                        $reminder_detail->reminder_id = $reminder->id;
                        $reminder_detail->login_user_id = $login_user_id;
                        $reminder_detail->customer_id = $customer_id_val;
                        $reminder_detail->document_id = $document_id_val;
                        $reminder_detail->doc_content = $doc_content_result;
                        $reminder_detail->doc_content_column = $doc_content_column;
                        $reminder_detail->save();
                    }   
                }
            }
            if ($request->save_send) {
                if(count($customer_id) > 0){
                    foreach($customer_id as $customer_id_val){
                        Helpers::ReminderMail($reminder->id,$customer_id_val,'reminder_add');
                    }
                }
            }  
            if ($request->save) {
                return redirect(route('reminder.edit', $reminder->id))->with('success_message', trans('Added Successfully'));
            } else {
                return redirect(route('reminder.index'))->with('success_message', trans('Added Successfully'));
            }
        }
    }

    public function show($id)
    {
        $return_data = array();
        $data = Reminder::find($id);
        $return_data['data'] = $data;
        $customer_list = CustomerUser::with('Group')->where('status','1')->get();
        $return_data['customer_list'] = $customer_list;
        $selected_customer_id = array();
        $selected_customer_id_to = array();
        $selected_customer_id_cc = array();
        $selected_document_id = array();
        $fill_doc_content_column = array();
        $reminder_detail = ReminderCustomerDocument::where('reminder_id',$id)->get();
        if($reminder_detail){
            foreach($reminder_detail as $reminder_detail_val){
                $selected_customer_id[] = $reminder_detail_val->customer_id;
                $selected_document_id[] = $reminder_detail_val->document_id;
                $fill_doc_content_column[$reminder_detail_val->document_id] = json_decode($reminder_detail_val->doc_content_column,true);
            }
        }
        $contact_customer_id_to = $data->contact_customer_id_to;
        if($contact_customer_id_to != ''){
            $contact_customer_id_to_array = json_decode($contact_customer_id_to,true);
            if(count($contact_customer_id_to_array) > 0){
                foreach($contact_customer_id_to_array as $contact_customer_id_to_array_val){
                    $selected_customer_id_to[] = $contact_customer_id_to_array_val;
                }
            }
        }
        $contact_customer_id_cc = $data->contact_customer_id_cc;
        if($contact_customer_id_cc != ''){
            $contact_customer_id_cc_array = json_decode($contact_customer_id_cc,true);
            if(count($contact_customer_id_cc_array) > 0){
                foreach($contact_customer_id_cc_array as $contact_customer_id_cc_array_val){
                    $selected_customer_id_cc[] = $contact_customer_id_cc_array_val;
                }
            }
        }
        $customer_contact_list = array();
        if(count($selected_customer_id) > 0){
            $customer_contact_list = CustomerContactDetail::select('customer_contact_details.*','customer_users.name as customer_users_name')->where('customer_contact_details.id','!=','0')->whereIn('customer_contact_details.customer_id',$selected_customer_id);
            $customer_contact_list->join('customer_users', 'customer_users.id', '=', 'customer_contact_details.customer_id');
            $customer_contact_list = $customer_contact_list->orderBy('customer_contact_details.id', 'ASC')->orderBy('customer_contact_details.name', 'ASC')->get();
        }
        $return_data['customer_contact_list'] = $customer_contact_list;
        $return_data['selected_customer_id'] = $selected_customer_id;
        $return_data['selected_customer_id_to'] = $selected_customer_id_to;
        $return_data['selected_customer_id_cc'] = $selected_customer_id_cc;
        $return_data['selected_document_id'] = $selected_document_id;
        $return_data['fill_doc_content_column'] = $fill_doc_content_column;
        $document_list = array();
        if(count($selected_document_id) > 0){
            $document_list = Document::whereIn('id',$selected_document_id)->get();
        }
        $return_data['document_list'] = $document_list;
        /*elseif($data->document_id != ''){
            $document_list = Document::where('status','1')->where('assignment_id',old('assignment_id'))->get();
        }*/
        $assignment = Assignment::where('status','1')->get();
        $return_data['assignment'] = $assignment;
        
        $return_data['page_condition'] = 'reminder_page';
        $return_data['site_title'] = 'Reminder | ' . config('constants.SITE_NAME');
        return view('admin.reminder.view', array_merge($return_data));
    }

    public function edit($id)
    {
        $data = Reminder::find($id);
        if(empty(($data))){
            return redirect(route('reminder.index'));
        }
        $return_data = array();
        $return_data['data'] = $data;
        $customer_list = CustomerUser::with('Group')->where('status','1')->get();
        $return_data['customer_list'] = $customer_list;
        $selected_customer_id = array();
        $selected_customer_id_to = array();
        $selected_customer_id_cc = array();
        $selected_document_id = array();
        $fill_doc_content_column = array();
        $reminder_detail = ReminderCustomerDocument::where('reminder_id',$id)->get();
        if($reminder_detail){
            foreach($reminder_detail as $reminder_detail_val){
                $selected_customer_id[] = $reminder_detail_val->customer_id;
                $selected_document_id[] = $reminder_detail_val->document_id;
                $fill_doc_content_column[$reminder_detail_val->document_id] = json_decode($reminder_detail_val->doc_content_column,true);
            }
        }
        $contact_customer_id_to = $data->contact_customer_id_to;
        if($contact_customer_id_to != ''){
            $contact_customer_id_to_array = json_decode($contact_customer_id_to,true);
            if(count($contact_customer_id_to_array) > 0){
                foreach($contact_customer_id_to_array as $contact_customer_id_to_array_val){
                    $selected_customer_id_to[] = $contact_customer_id_to_array_val;
                }
            }
        }
        $contact_customer_id_cc = $data->contact_customer_id_cc;
        if($contact_customer_id_cc != ''){
            $contact_customer_id_cc_array = json_decode($contact_customer_id_cc,true);
            if(count($contact_customer_id_cc_array) > 0){
                foreach($contact_customer_id_cc_array as $contact_customer_id_cc_array_val){
                    $selected_customer_id_cc[] = $contact_customer_id_cc_array_val;
                }
            }
        }
        $customer_contact_list = array();
        if(count($selected_customer_id) > 0){
            $customer_contact_list = CustomerContactDetail::select('customer_contact_details.*','customer_users.name as customer_users_name')->where('customer_contact_details.id','!=','0')->whereIn('customer_contact_details.customer_id',$selected_customer_id);
            $customer_contact_list->join('customer_users', 'customer_users.id', '=', 'customer_contact_details.customer_id');
            $customer_contact_list = $customer_contact_list->orderBy('customer_contact_details.id', 'ASC')->orderBy('customer_contact_details.name', 'ASC')->get();
        }
        $return_data['customer_contact_list'] = $customer_contact_list;
        $return_data['selected_customer_id'] = $selected_customer_id;
        $return_data['selected_customer_id_to'] = $selected_customer_id_to;
        $return_data['selected_customer_id_cc'] = $selected_customer_id_cc;
        $return_data['selected_document_id'] = $selected_document_id;
        $return_data['fill_doc_content_column'] = $fill_doc_content_column;
        $group = Group::where('status','1')->get();
        $return_data['group'] = $group;
        $document_list = Document::where('status','1')->get();
        if(old('assignment_id') != ''){
            $document_list = Document::where('status','1')->where('assignment_id',old('assignment_id'))->get();
        }
        /*elseif($data->document_id != ''){
            $document_list = Document::where('status','1')->where('assignment_id',old('assignment_id'))->get();
        }*/
        $assignment = Assignment::where('status','1')->get();
        $return_data['assignment'] = $assignment;
        $return_data['document_list'] = $document_list;
        $return_data['page_condition'] = 'reminder_page';
        $return_data['site_title'] = 'Reminder | ' . config('constants.SITE_NAME');
        return view('admin.reminder.form', array_merge($return_data));
    }
    public function update(Request $request)
    {
        $id = $request->id;
        $validate = $request->validate(
            [
                //'name' => "required|unique:reminders,name," . $id . ",id,deleted_at,NULL",
                'name' => "required",
                //'description' => "required",
                'customer_id' => "required",
                //'from_email' => "required",
                'reminder_period' => "required",
                'document_id' => "required",
                'assignment_id' => "required",
            ],
            [
                'name.required' => 'The Subject is required.',
                'name.unique' => 'The Subject has been already taken.',
                'from_email.required' => 'The from email is required.',
                'reminder_period.required' => 'The reminder period is required.',
                'description' => 'The Description is required.',
                'customer_id' => 'The To Email is required.',
                'document_id' => 'The Document is required.',
                'assignment_id.required' => 'The Assignment is required.',
            ]

        );
        $customer_id = $request->customer_id;
        if(count($customer_id) > 0){
            $customer_id_array = array();
            foreach($customer_id as $customer_id_val){
                if($customer_id_val == NULL){

                }elseif($customer_id_val == ''){

                }else{
                    $customer_id_array[] = $customer_id_val;
                }
            }
            if(count($customer_id_array) == 0){
                return redirect()->back()->withErrors(['customer_id' => 'The customer is required'])->withInput();
            }
        }else{
            return redirect()->back()->withErrors(['customer_id' => 'The customer is required'])->withInput();
        }
        $assignment_id = $request->assignment_id;
        $document_id = isset($_POST['document_id'][$assignment_id]) ? $_POST['document_id'][$assignment_id] : array();
        if (count($document_id) == 0) {
            return redirect()->back()->withErrors(['document_id' => 'The Document is required'])->withInput();
        }
        if ($validate) {
            $login_user_id = Auth::check() ? Auth::user()->id : 0;
            $from_email = Auth::check() ? Auth::user()->email : '';
            $current_date = date('Y-m-d');
            $reminder = Reminder::find($id);
            $reminder->name = $request->name;
            $reminder->current_date_value = $request->current_date_value;
            $reminder->year_end = $request->year_end;
            //$reminder->from_email = $request->from_email;
            $reminder->reminder_period = $request->reminder_period;
            $reminder->assignment_id = $request->assignment_id;
            $customer_to_email = $request->customer_to_email;
            $customer_to_email_insert = '';
            if($customer_to_email == NULL){
                $customer_to_email = array();
            }
            if(count($customer_to_email) > 0){
                $customer_to_email_insert = json_encode($customer_to_email);
            }
            $reminder->contact_customer_id_to = $customer_to_email_insert;
            $customer_cc_email = $request->customer_cc_email;
            $customer_cc_email_insert = '';
            if($customer_cc_email == NULL){
                $customer_cc_email = array();
            }
            if(count($customer_cc_email) > 0){
                $customer_cc_email_insert = json_encode($customer_cc_email);
            }
            $reminder->contact_customer_id_cc = $customer_cc_email_insert;
            $reminder_detail = Reminder::select('reminder_period','send_date')->find($id);
            if($reminder_detail){
                $db_reminder_period = $reminder_detail->reminder_period;
                $db_send_date = strtotime($reminder_detail->send_date);
                if($db_reminder_period != $request->reminder_period){
                    if($request->reminder_period == 1){//Weekly
                        $next_send_date = date('Y-m-d',strtotime("+ 8 day", $db_send_date));       
                    }else if($request->reminder_period == 2){//Monthly
                        $next_send_date = date('Y-m-d',strtotime("+ 1 month", $db_send_date));       
                    }else{//Daily
                        $next_send_date = date('Y-m-d',strtotime("+ 1 day", $db_send_date));
                    }
                    //$reminder->send_date = $current_date;
                    $reminder->next_send_date = $next_send_date;
                }
            }
            $reminder->description = $request->description;
            $reminder->save();
            $attachment = $request->file('attachment'); 
            $destinationPath = public_path('images').config('constants.DOCUMENT');
            if($attachment){
                foreach($attachment as $key=>$image){
                    $org_upload_document = $image->getClientOriginalName();
                    if($org_upload_document != ''){
                        $upload_document = 'attachment-'.$key.'-'.time().'.'.$image->getClientOriginalExtension();
                        $image->move($destinationPath, $upload_document);
                        $file_attachment = new ReminderAttachment();
                        $file_attachment->reminder_id = $reminder->id;
                        $file_attachment->org_upload_document = $org_upload_document;
                        $file_attachment->upload_document = $upload_document;
                        $file_attachment->status = 1;
                        $file_attachment->save();
                    }    
                }
            } 
            $reminder_delete = ReminderCustomerDocument::where('reminder_id',$id);
            $reminder_delete->delete();
            $customer_id = isset($_POST['customer_id']) ? $_POST['customer_id'] : array();
            $main_doc_content_column_array = isset($_POST['doc_content_column']) ? $_POST['doc_content_column'] : array();
            if(count($customer_id) > 0 && count($document_id) > 0){
                foreach($customer_id as $customer_id_val){
                    foreach($document_id as $document_id_val){
                        $old_count = ReminderCustomerDocument::withTrashed()->where('reminder_id',$id)->where('customer_id',$customer_id_val)->where('document_id',$document_id_val)->count();
                        $doc_content_column_array = isset($main_doc_content_column_array[$document_id_val]) ? $main_doc_content_column_array[$document_id_val] : array();
                        $doc_content_column = json_encode($doc_content_column_array);
                        $doc_content = '';
                        $document_detail = Document::where('id',$document_id_val)->first();
                        if($document_detail){
                            $doc_content = $document_detail->doc_content;
                        }
                        $search_array = array();
                        $replace_array = array();
                        if(count($doc_content_column_array) > 0){
                            foreach($doc_content_column_array as $doc_content_column_key=>$doc_content_column_val){
                                $search_array[] = '{{{'.$doc_content_column_key.'}}}';
                                $replace_array[] = $doc_content_column_val;
                            }
                        }
                        $doc_content_result = str_replace($search_array, $replace_array, $doc_content);
                        if($old_count == 0){
                            $reminder_detail = new ReminderCustomerDocument();
                            $reminder_detail->reminder_id = $id;
                            $reminder_detail->login_user_id = $login_user_id;
                            $reminder_detail->customer_id = $customer_id_val;
                            $reminder_detail->document_id = $document_id_val;
                            $reminder_detail->doc_content = $doc_content_result;
                            $reminder_detail->doc_content_column = $doc_content_column;
                            $reminder_detail->save();
                        }else{
                            
                            ReminderCustomerDocument::withTrashed()->where('reminder_id',$id)->where('customer_id',$customer_id_val)->where('document_id',$document_id_val)->update(['deleted_at' => null,'doc_content' => $doc_content_result,'doc_content_column' => $doc_content_column]);
                        } 
                    }   
                }
            }
            if ($request->save_send) {
                if(count($customer_id) > 0){
                    foreach($customer_id as $customer_id_val){
                        Helpers::ReminderMail($reminder->id,$customer_id_val,'reminder_update');
                    }
                }
            } 
            if ($request->save) {
                return redirect(route('reminder.edit', $reminder->id))->with('success_message', trans('Update Successfully'));
            } else {
                return redirect(route('reminder.index'))->with('success_message', trans('Update Successfully'));
            }
        }
    }
    public function destroy($id)
    {
        $reminder = Reminder::find($id);
        $reminder->delete();
        return redirect()->route("reminder.index")->with('success_message', 'Delete Successfully!');
    }

    public function setActivate($id)
    {
        $update_status = Reminder::find($id);
        $update_status->status = 1;
        $update_status->save();
        return redirect(route('reminder.index'))->with('success_message', trans('Active Successfully'));
    }

    public function setInactivate($id)
    {
        $update_status = Reminder::find($id);
        $update_status->status = 0;
        $update_status->save();
        return redirect(route('reminder.index'))->with('success_message', trans('Inactive Successfully'));
    }
    public function documentUploaded(Request $request)
    {
        if ($request->ajax()) {
            $customer_id = isset($_GET['customer_id']) ? $_GET['customer_id'] : '';
            $filter_reminder_id = isset($_GET['filter_reminder_id']) ? $_GET['filter_reminder_id'] : '';
            $filter_customer_id = isset($_GET['filter_customer_id']) ? $_GET['filter_customer_id'] : '';
            $filter_document_id = isset($_GET['filter_document_id']) ? $_GET['filter_document_id'] : '';
            $filter_status = isset($_GET['filter_status']) ? $_GET['filter_status'] : '';
            $reminder_detail_query = ReminderCustomerDocument::with('Reminder')->with('Document')->with('CustomerUser')->where('reminder_customer_documents.upload_status', 1);//->WhereNotNull('upload_document');
            if($customer_id != ''){
                $reminder_detail_query->Where('customer_id',$customer_id);
            }
            if($filter_reminder_id != ''){
                $reminder_detail_query->where('reminder_id',$filter_reminder_id);
            }
            if($filter_customer_id != ''){
                $reminder_detail_query->where('customer_id',$filter_customer_id);
            }
            if($filter_document_id != ''){
                $reminder_detail_query->where('document_id',$filter_document_id);
            }
            if($filter_status != ''){
                $reminder_detail_query->where('status',$filter_status);
            }
            $reminder_detail = $reminder_detail_query->get();
            return datatables()->of($reminder_detail)
                ->addColumn('action', function ($row) {
                    $html = '';
                    $html .= '<h5 style="color:black;">Pending</h5>';
                    $html .= '<a href="' . route('admin.dashboard.document_accept', $row->id) . '" onClick="return alertconfirm(\'Are you sure you want to Accept this?\');" class="btn badge-success text-white btn-sm"><i class="fa fa-check"></i> Accept</a>';
                    $html .= '&nbsp;<a onClick="return confirm_document_reject('.$row->id.');" href="javascript:;" class="btn badge-danger text-white btn-sm"><i class="fa fa-ban"></i> Reject</a>';
                    if (!empty($row->status == 1)) {
                        $html = '<h5 style="color:green;">Accepted</h5>';
                    }elseif (!empty($row->status == 2)) {
                        $html = '<h5 style="color:red;">Rejected</h5>';
                    }
                    return $html;
                })->addColumn('document_file', function ($row) {
                    $html = Helpers::GetDocument($row->id);
                    if($html == ''){
                        $html = $row->upload_comment;
                    }
                    return $html;
                })->addColumn('datetime', function ($row) {
                    $date = '';
                    if (!empty($row->updated_at)) {
                        $date = date('Y-m-d H:i:s', strtotime($row->updated_at));
                    }
                    return $date;
                })->addColumn('customer_name', function ($row) {
                    $name = '';
                    if (is_object($row->CustomerUser)) {
                        $name = $row->CustomerUser->name;
                    }
                    return $name;
                })->addColumn('document_name', function ($row) {
                    $name = '';
                    if (is_object($row->Document)) {
                        $name = $row->Document->name;
                    }
                    return $name;
                })->addColumn('reminder_name', function ($row) {
                    $name = '';
                    if (is_object($row->Reminder)) {
                        $name = $row->Reminder->name;
                    }
                    return $name;
                })->rawColumns(['document_file','action'])->toJson();
        }
        $return_data = array();
        $reminder_list = Reminder::all();
        $return_data['reminder_list'] = $reminder_list;
        $customer_user_list = CustomerUser::all();
        $return_data['customer_user_list'] = $customer_user_list;
        $document_list = Document::all();
        $return_data['document_list'] = $document_list;
        $search_reminder_id = isset($_GET['search_reminder_id']) ? $_GET['search_reminder_id'] : '';
        $return_data['search_reminder_id'] = $search_reminder_id;
        $search_document_id = isset($_GET['search_document_id']) ? $_GET['search_document_id'] : '';
        $return_data['search_document_id'] = $search_document_id;
        $search_customer_id = isset($_GET['search_customer_id']) ? $_GET['search_customer_id'] : '';
        $return_data['search_customer_id'] = $search_customer_id;
        $search_status = isset($_GET['search_status']) ? $_GET['search_status'] : '';
        $return_data['search_status'] = $search_status;
        $return_data['page_condition'] = 'reminder_document_page';
        $return_data['site_title'] = 'Document | ' . config('constants.SITE_NAME');
        return view('admin.reminder.document', array_merge($return_data));
    }
}
