<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CustomerUser;
use App\Models\Document;
use App\Models\SchedulerReminder;
use App\Models\Group;
use App\Models\Assignment;
use App\Models\CustomerContactDetail;
use App\Models\SchedulerReminderCustomerDocument;
use App\Models\SchedulerReminderAttachment;
use App\Helper\Helpers;
use Datatables;
use Auth;

class SchedulerReminderController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $scheduler_reminder = SchedulerReminder::all();
            return datatables()->of($scheduler_reminder)
                ->addColumn('action', function ($row) {
                    $html = '';
                    $html .= '<a href="' . route('scheduler_reminder.edit', $row->id) . '" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a> ';
                    $html .= '&nbsp;<a href="javascript:;" class="btn btn-danger btn-delete btn-sm" data-toggle="tooltip" data-original-title="Delete" data-container="body" title="" onclick="return record_delete(\'' . route('scheduler_reminder.destroy', $row->id) . '\');" ><i class="fa fa-trash" aria-hidden="true"></i> Delete</a>';
                    $html .= '';
                    $html .= '<a href="" class="</a>';
                    return $html;
                })->toJson();
        }
        $return_data = array();
        $return_data['page_condition'] = 'scheduler_reminder_page';
        $return_data['site_title'] = 'Schedule Mail | ' . config('constants.SITE_NAME');
        return view('admin.scheduler_reminder.index', array_merge($return_data));
    }

    public function create()
    {
        $return_data = array();
        $group = Group::where('status','1')->get();
        $return_data['group'] = $group;
        $customer_list = array();
        if(old('group_id') != ''){
            $customer_list = CustomerUser::with('Group')->where('status','1')->whereIn('group_id',old('group_id'))->get();
        }
        $return_data['customer_list'] = $customer_list;
        $return_data['selected_customer_id'] = array();
        $return_data['selected_customer_id_to'] = array();
        $return_data['selected_customer_id_cc'] = array();
        $return_data['selected_document_id'] = array();
        $group = Group::where('status','1')->get();
        $return_data['group'] = $group;
        $document_list = Document::where('status','1')->get();
        if(old('assignment_id') != ''){
            $document_list = Document::where('status','1')->where('assignment_id',old('assignment_id'))->get();
        }
        $assignment = Assignment::where('status','1')->get();
        $return_data['assignment'] = $assignment;
        $return_data['document_list'] = $document_list;
        $customer_contact_list = array();
        if(old('customer_id') != ''){
            $customer_contact_list = CustomerContactDetail::select('customer_contact_details.*','customer_users.name as customer_users_name')->where('customer_contact_details.id','!=','0')->whereIn('customer_contact_details.customer_id',old('customer_id'));
            $customer_contact_list->join('customer_users', 'customer_users.id', '=', 'customer_contact_details.customer_id');
            $customer_contact_list = $customer_contact_list->orderBy('customer_contact_details.id', 'ASC')->orderBy('customer_contact_details.name', 'ASC')->get();
        }
        $return_data['customer_contact_list'] = $customer_contact_list;
        $return_data['page_condition'] = 'scheduler_reminder_page';
        $return_data['site_title'] = 'Schedule Mail | ' . config('constants.SITE_NAME');
        return view('admin.scheduler_reminder.form', array_merge($return_data));
    }

    public function store(Request $request)
    {
        $id = 0;
        $validate = $request->validate(
            [
                //'name' => "required|unique:reminders,name," . $id . ",id,deleted_at,NULL",
                'group_id' => "required",
                'name' => "required",
                //'description' => "required",
                'send_date_value' => "required",
                'reminder_period' => "required",
                'customer_id' => "required",
                'document_id' => "required",
                'assignment_id' => "required"
            ],
            [
                'group_id.required' => 'The Group is required.',
                'name.required' => 'The Subject is required.',
                'name.unique' => 'The Subject has been already taken.',
                'from_email.required' => 'The from email is required.',
                'send_date_value.required' => 'The Send Date is required.',
                'reminder_period.required' => 'The reminder period is required.',
                'description.required' => 'The Description is required.',
                'customer_id.required' => 'The customer is required.',
                'document_id.required' => 'The Document is required.',
                'assignment_id.required' => 'The Assignment is required.',
            ]
        );
        $customer_id = $request->customer_id;
        if(count($customer_id) > 0){
            $customer_id_array = array();
            foreach($customer_id as $customer_id_val){
                if($customer_id_val == NULL){

                }elseif($customer_id_val == ''){

                }else{
                    $customer_id_array[] = $customer_id_val;
                }
            }
            if(count($customer_id_array) == 0){
                return redirect()->back()->withErrors(['customer_id' => 'The customer is required'])->withInput();
            }
        }else{
            return redirect()->back()->withErrors(['customer_id' => 'The customer is required'])->withInput();
        }
        $assignment_id = $request->assignment_id;
        $document_id = isset($_POST['document_id'][$assignment_id]) ? $_POST['document_id'][$assignment_id] : array();
        if (count($document_id) == 0) {
            return redirect()->back()->withErrors(['document_id' => 'The Document is required'])->withInput();
        }
        if ($validate) {
            $login_user_id = Auth::check() ? Auth::user()->id : 0;
            $from_email = Auth::check() ? Auth::user()->email : '';
            $current_date = date('Y-m-d');
            $scheduler_reminder = new SchedulerReminder();
            $group_id = $request->group_id;
            $group_id_insert = '';
            if($group_id == NULL){
                $group_id = array();
            }
            if(count($group_id) > 0){
                $group_id_insert = json_encode($group_id);
            }
            $scheduler_reminder->group_id = $group_id_insert;
            $scheduler_reminder->name = $request->name;
            $scheduler_reminder->login_user_id = $$login_user_id;
            $scheduler_reminder->from_email = $from_email;
            $scheduler_reminder->send_date_value = $request->send_date_value;
            $scheduler_reminder->reminder_period = $request->reminder_period;
            $send_date_value = $request->send_date_value;
            /*if($request->reminder_period == 1){//Every Month
                $next_send_date = date('Y-m-d',strtotime("+ 1 month",strtotime($send_date_value)));       
            }else{//Once
                $next_send_date = date('Y-m-d',strtotime($send_date_value));
            }*/
            $next_send_date = date('Y-m-d',strtotime($send_date_value));
            $scheduler_reminder->send_date = $send_date_value;
            $scheduler_reminder->next_send_date = $next_send_date;
            $scheduler_reminder->mail_content = $request->mail_content;
            $scheduler_reminder->description = $request->description;
            $scheduler_reminder->assignment_id = $request->assignment_id;
            $customer_to_email = $request->customer_to_email;
            $customer_to_email_insert = '';
            if($customer_to_email == NULL){
                $customer_to_email = array();
            }
            if(count($customer_to_email) > 0){
                $customer_to_email_insert = json_encode($customer_to_email);
            }
            $scheduler_reminder->contact_customer_id_to = $customer_to_email_insert;
            $customer_cc_email = $request->customer_cc_email;
            $customer_cc_email_insert = '';
            if($customer_cc_email == NULL){
                $customer_cc_email = array();
            }
            if(count($customer_cc_email) > 0){
                $customer_cc_email_insert = json_encode($customer_cc_email);
            }
            $scheduler_reminder->contact_customer_id_cc = $customer_cc_email_insert;
            $scheduler_reminder->status = 1;
            $scheduler_reminder->save();
            $destinationPath = public_path('images').config('constants.DOCUMENT');
            $attachment = $request->file('attachment');            
            if($attachment){
                foreach($attachment as $key=>$image){
                    $org_upload_document = $image->getClientOriginalName();
                    if($org_upload_document != ''){
                        $upload_document = 'attachment-'.$key.'-'.time().'.'.$image->getClientOriginalExtension();
                        $image->move($destinationPath, $upload_document);
                        $file_attachment = new SchedulerReminderAttachment();
                        $file_attachment->scheduler_reminder_id = $scheduler_reminder->id;
                        $file_attachment->org_upload_document = $org_upload_document;
                        $file_attachment->upload_document = $upload_document;
                        $file_attachment->status = 1;
                        $file_attachment->save();
                    }    
                }
            }
            $customer_id = isset($_POST['customer_id']) ? $_POST['customer_id'] : array();
            $main_doc_content_column_array = isset($_POST['doc_content_column']) ? $_POST['doc_content_column'] : array();
            if(count($customer_id) > 0 && count($document_id) > 0){
                foreach($customer_id as $customer_id_val){
                    foreach($document_id as $document_id_val){
                        $doc_content_column_array = isset($main_doc_content_column_array[$document_id_val]) ? $main_doc_content_column_array[$document_id_val] : array();
                        $doc_content_column = json_encode($doc_content_column_array);
                        $doc_content = '';
                        $document_detail = Document::where('id',$document_id_val)->first();
                        if($document_detail){
                            $doc_content = $document_detail->doc_content;
                        }
                        $search_array = array();
                        $replace_array = array();
                        if(count($doc_content_column_array) > 0){
                            foreach($doc_content_column_array as $doc_content_column_key=>$doc_content_column_val){
                                $search_array[] = '{{{'.$doc_content_column_key.'}}}';
                                $replace_array[] = $doc_content_column_val;
                            }
                        }
                        $doc_content_result = str_replace($search_array, $replace_array, $doc_content);

                        $scheduler_reminder_detail = new SchedulerReminderCustomerDocument();
                        $scheduler_reminder_detail->scheduler_reminder_id = $scheduler_reminder->id;
                        $scheduler_reminder_detail->login_user_id = $login_user_id;
                        $scheduler_reminder_detail->customer_id = $customer_id_val;
                        $scheduler_reminder_detail->document_id = $document_id_val;
                        $scheduler_reminder_detail->doc_content = $doc_content_result;
                        $scheduler_reminder_detail->doc_content_column = $doc_content_column;
                        $scheduler_reminder_detail->save();
                    }   
                }
            }
            if ($request->save) {
                return redirect(route('scheduler_reminder.edit', $scheduler_reminder->id))->with('success_message', trans('Added Successfully'));
            } else {
                return redirect(route('scheduler_reminder.index'))->with('success_message', trans('Added Successfully'));
            }
        }
    }

    public function show($id)
    {
        $scheduler_reminder = SchedulerReminder::find($id);
        $return_data = array();
        $return_data['data'] = $scheduler_reminder;
        $return_data['page_condition'] = 'scheduler_reminder_page';
        $return_data['site_title'] = 'Schedule Mail | ' . config('constants.SITE_NAME');
        return view('admin.scheduler_reminder.view', array_merge($return_data));
    }

    public function edit($id)
    {
        $data = SchedulerReminder::find($id);
        if(empty(($data))){
            return redirect(route('scheduler_reminder.index'));
        }
        $return_data = array();
        $return_data['data'] = $data;
        $customer_list = array();
        if(old('group_id') != ''){
            $customer_list = CustomerUser::with('Group')->where('status','1')->whereIn('group_id',old('group_id'))->get();
        }elseif($data->group_id){
            $all_group_id_selected = array();
            if($data->group_id != NULL){
                $all_group_id_selected = json_decode($data->group_id,true);
            }  
            $customer_list = CustomerUser::with('Group')->where('status','1')->whereIn('group_id',$all_group_id_selected)->get();
        }
        $return_data['customer_list'] = $customer_list;
        $selected_customer_id = array();
        $selected_customer_id_to = array();
        $selected_customer_id_cc = array();
        $selected_document_id = array();
        $fill_doc_content_column = array();
        $scheduler_reminder_detail = SchedulerReminderCustomerDocument::where('scheduler_reminder_id',$id)->get();
        if($scheduler_reminder_detail){
            foreach($scheduler_reminder_detail as $scheduler_reminder_detail_val){
                $selected_customer_id[] = $scheduler_reminder_detail_val->customer_id;
                $selected_document_id[] = $scheduler_reminder_detail_val->document_id;
                $fill_doc_content_column[$scheduler_reminder_detail_val->document_id] = json_decode($scheduler_reminder_detail_val->doc_content_column,true);
            }
        }
        $contact_customer_id_to = $data->contact_customer_id_to;
        if($contact_customer_id_to != ''){
            $contact_customer_id_to_array = json_decode($contact_customer_id_to,true);
            if(count($contact_customer_id_to_array) > 0){
                foreach($contact_customer_id_to_array as $contact_customer_id_to_array_val){
                    $selected_customer_id_to[] = $contact_customer_id_to_array_val;
                }
            }
        }
        $contact_customer_id_cc = $data->contact_customer_id_cc;
        if($contact_customer_id_cc != ''){
            $contact_customer_id_cc_array = json_decode($contact_customer_id_cc,true);
            if(count($contact_customer_id_cc_array) > 0){
                foreach($contact_customer_id_cc_array as $contact_customer_id_cc_array_val){
                    $selected_customer_id_cc[] = $contact_customer_id_cc_array_val;
                }
            }
        }
        $customer_contact_list = array();
        if(count($selected_customer_id) > 0){
            $customer_contact_list = CustomerContactDetail::select('customer_contact_details.*','customer_users.name as customer_users_name')->where('customer_contact_details.id','!=','0')->whereIn('customer_contact_details.customer_id',$selected_customer_id);
            $customer_contact_list->join('customer_users', 'customer_users.id', '=', 'customer_contact_details.customer_id');
            $customer_contact_list = $customer_contact_list->orderBy('customer_contact_details.id', 'ASC')->orderBy('customer_contact_details.name', 'ASC')->get();
        }
        $return_data['customer_contact_list'] = $customer_contact_list;
        $return_data['selected_customer_id'] = $selected_customer_id;
        $return_data['selected_customer_id_to'] = $selected_customer_id_to;
        $return_data['selected_customer_id_cc'] = $selected_customer_id_cc;
        $return_data['selected_document_id'] = $selected_document_id;
        $return_data['fill_doc_content_column'] = $fill_doc_content_column;
        $group = Group::where('status','1')->get();
        $return_data['group'] = $group;
        $document_list = Document::where('status','1')->get();
        if(old('assignment_id') != ''){
            $document_list = Document::where('status','1')->where('assignment_id',old('assignment_id'))->get();
        }
        /*elseif($data->document_id != ''){
            $document_list = Document::where('status','1')->where('assignment_id',old('assignment_id'))->get();
        }*/
        $assignment = Assignment::where('status','1')->get();
        $return_data['assignment'] = $assignment;
        $return_data['document_list'] = $document_list;
        $return_data['page_condition'] = 'scheduler_reminder_page';
        $return_data['site_title'] = 'Schedule Mail | ' . config('constants.SITE_NAME');
        return view('admin.scheduler_reminder.form', array_merge($return_data));
    }
    public function update(Request $request)
    {
        $id = $request->id;
        $validate = $request->validate(
            [
                //'name' => "required|unique:reminders,name," . $id . ",id,deleted_at,NULL",
                'group_id' => "required",
                'name' => "required",
                //'description' => "required",
                'customer_id' => "required",
                'send_date_value' => "required",
                'reminder_period' => "required",
                'document_id' => "required",
                'assignment_id' => "required",
            ],
            [
                'group_id.required' => 'The Group is required.',
                'name.required' => 'The Subject is required.',
                'name.unique' => 'The Subject has been already taken.',
                'from_email.required' => 'The from email is required.',
                'send_date_value.required' => 'The Send Date is required.',
                'reminder_period.required' => 'The reminder period is required.',
                'description' => 'The Description is required.',
                'customer_id' => 'The To Email is required.',
                'document_id' => 'The Document is required.',
                'assignment_id.required' => 'The Assignment is required.',
            ]

        );
        $customer_id = $request->customer_id;
        if(count($customer_id) > 0){
            $customer_id_array = array();
            foreach($customer_id as $customer_id_val){
                if($customer_id_val == NULL){

                }elseif($customer_id_val == ''){

                }else{
                    $customer_id_array[] = $customer_id_val;
                }
            }
            if(count($customer_id_array) == 0){
                return redirect()->back()->withErrors(['customer_id' => 'The customer is required'])->withInput();
            }
        }else{
            return redirect()->back()->withErrors(['customer_id' => 'The customer is required'])->withInput();
        }
        $assignment_id = $request->assignment_id;
        $document_id = isset($_POST['document_id'][$assignment_id]) ? $_POST['document_id'][$assignment_id] : array();
        if (count($document_id) == 0) {
            return redirect()->back()->withErrors(['document_id' => 'The Document is required'])->withInput();
        }
        if ($validate) {
            $login_user_id = Auth::check() ? Auth::user()->id : 0;
            $from_email = Auth::check() ? Auth::user()->email : '';
            $current_date = date('Y-m-d');
            $scheduler_reminder = SchedulerReminder::find($id);
            $group_id = $request->group_id;
            $group_id_insert = '';
            if($group_id == NULL){
                $group_id = array();
            }
            if(count($group_id) > 0){
                $group_id_insert = json_encode($group_id);
            }
            $scheduler_reminder->group_id = $group_id_insert;
            $scheduler_reminder->name = $request->name;
            $scheduler_reminder->send_date_value = $request->send_date_value;
            //$reminder->from_email = $request->from_email;
            $scheduler_reminder->reminder_period = $request->reminder_period;
            $scheduler_reminder->assignment_id = $request->assignment_id;
            $customer_to_email = $request->customer_to_email;
            $customer_to_email_insert = '';
            if($customer_to_email == NULL){
                $customer_to_email = array();
            }
            if(count($customer_to_email) > 0){
                $customer_to_email_insert = json_encode($customer_to_email);
            }
            $scheduler_reminder->contact_customer_id_to = $customer_to_email_insert;
            $customer_cc_email = $request->customer_cc_email;
            $customer_cc_email_insert = '';
            if($customer_cc_email == NULL){
                $customer_cc_email = array();
            }
            if(count($customer_cc_email) > 0){
                $customer_cc_email_insert = json_encode($customer_cc_email);
            }
            $scheduler_reminder->contact_customer_id_cc = $customer_cc_email_insert;
            $send_date_value = $request->send_date_value;
            /*if($request->reminder_period == 1){//Every Month
                $next_send_date = date('Y-m-d',strtotime("+ 1 month",strtotime($send_date_value)));       
            }else{//Once
                $next_send_date = date('Y-m-d',strtotime($send_date_value));
            }*/
            $next_send_date = date('Y-m-d',strtotime($send_date_value));
            //$scheduler_reminder->send_date = $send_date_value;
            $scheduler_reminder->next_send_date = $next_send_date;
            $scheduler_reminder->mail_content = $request->mail_content;
            $scheduler_reminder->description = $request->description;
            $scheduler_reminder->save();
            $attachment = $request->file('attachment'); 
            $destinationPath = public_path('images').config('constants.DOCUMENT');
            if($attachment){
                foreach($attachment as $key=>$image){
                    $org_upload_document = $image->getClientOriginalName();
                    if($org_upload_document != ''){
                        $upload_document = 'attachment-'.$key.'-'.time().'.'.$image->getClientOriginalExtension();
                        $image->move($destinationPath, $upload_document);
                        $file_attachment = new SchedulerReminderAttachment();
                        $file_attachment->scheduler_reminder_id = $scheduler_reminder->id;
                        $file_attachment->org_upload_document = $org_upload_document;
                        $file_attachment->upload_document = $upload_document;
                        $file_attachment->status = 1;
                        $file_attachment->save();
                    }    
                }
            } 
            $scheduler_reminder_delete = SchedulerReminderCustomerDocument::where('scheduler_reminder_id',$id);
            $scheduler_reminder_delete->delete();
            $customer_id = isset($_POST['customer_id']) ? $_POST['customer_id'] : array();
            $main_doc_content_column_array = isset($_POST['doc_content_column']) ? $_POST['doc_content_column'] : array();
            if(count($customer_id) > 0 && count($document_id) > 0){
                foreach($customer_id as $customer_id_val){
                    foreach($document_id as $document_id_val){
                        $old_count = SchedulerReminderCustomerDocument::withTrashed()->where('scheduler_reminder_id',$id)->where('customer_id',$customer_id_val)->where('document_id',$document_id_val)->count();
                        $doc_content_column_array = isset($main_doc_content_column_array[$document_id_val]) ? $main_doc_content_column_array[$document_id_val] : array();
                        $doc_content_column = json_encode($doc_content_column_array);
                        $doc_content = '';
                        $document_detail = Document::where('id',$document_id_val)->first();
                        if($document_detail){
                            $doc_content = $document_detail->doc_content;
                        }
                        $search_array = array();
                        $replace_array = array();
                        if(count($doc_content_column_array) > 0){
                            foreach($doc_content_column_array as $doc_content_column_key=>$doc_content_column_val){
                                $search_array[] = '{{{'.$doc_content_column_key.'}}}';
                                $replace_array[] = $doc_content_column_val;
                            }
                        }
                        $doc_content_result = str_replace($search_array, $replace_array, $doc_content);
                        if($old_count == 0){
                            $scheduler_reminder_detail = new SchedulerReminderCustomerDocument();
                            $scheduler_reminder_detail->scheduler_reminder_id = $id;
                            $scheduler_reminder_detail->login_user_id = $login_user_id;
                            $scheduler_reminder_detail->customer_id = $customer_id_val;
                            $scheduler_reminder_detail->document_id = $document_id_val;
                            $scheduler_reminder_detail->doc_content = $doc_content_result;
                            $scheduler_reminder_detail->doc_content_column = $doc_content_column;
                            $scheduler_reminder_detail->save();
                        }else{
                            
                            SchedulerReminderCustomerDocument::withTrashed()->where('scheduler_reminder_id',$id)->where('customer_id',$customer_id_val)->where('document_id',$document_id_val)->update(['deleted_at' => null,'doc_content' => $doc_content_result,'doc_content_column' => $doc_content_column]);
                        } 
                    }   
                }
            }
            if ($request->save) {
                return redirect(route('scheduler_reminder.edit', $scheduler_reminder->id))->with('success_message', trans('Update Successfully'));
            } else {
                return redirect(route('scheduler_reminder.index'))->with('success_message', trans('Update Successfully'));
            }
        }
    }
    public function destroy($id)
    {
        $scheduler_reminder = SchedulerReminder::find($id);
        $scheduler_reminder->delete();
        return redirect()->route("scheduler_reminder.index")->with('success_message', 'Delete Successfully!');
    }

    public function setActivate($id)
    {
        $update_status = SchedulerReminder::find($id);
        $update_status->status = 1;
        $update_status->save();
        return redirect(route('scheduler_reminder.index'))->with('success_message', trans('Active Successfully'));
    }

    public function setInactivate($id)
    {
        $update_status = SchedulerReminder::find($id);
        $update_status->status = 0;
        $update_status->save();
        return redirect(route('scheduler_reminder.index'))->with('success_message', trans('Inactive Successfully'));
    }
}
