<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Service;
use App\Models\Department;
use Datatables;

class ServiceController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $service = Service::with('Department')->get();
            return datatables()->of($service)
                ->addColumn('action', function ($row) {
                    $html = '';
                    $html .= '<a href="' . route('service.edit', $row->id) . '" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a> ';
                    $html .= '&nbsp;<a href="' . route('service.show', $row->id) . '" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View</a> ';
                    if ($row->status == 1) {
                       // $html .= '<a href="' . route('service.inactive', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Inactive this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-success"></i></a>';
                    } else {
                        //$html .= '<a href="' . route('service.active', array('id' => $row->id)) . '" onClick="return alertconfirm(\'Are you sure you want to Activate this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-muted"></i></a>';
                    }
                    $html .= '';

                    $html .= '<a href="" class="</a>';
                    return $html;
                })->addColumn('department_name', function ($row) {
                    $name = '';
                    if (is_object($row->Department)) {
                        $name = $row->Department->name;
                    }
                    return $name;
                })->toJson();
        }
        $return_data = array();
        $return_data['page_condition'] = 'service_page';
        $return_data['site_title'] = 'Service | ' . config('constants.SITE_NAME');
        return view('admin.service.index', array_merge($return_data));
    }

    public function create()
    {
        $return_data = array();
        $department = Department::where('status','1')->get();
        $return_data['department'] = $department;
        $return_data['page_condition'] = 'service_page';
        $return_data['site_title'] = 'Service | ' . config('constants.SITE_NAME');
        return view('admin.service.form', array_merge($return_data));
    }

    public function store(Request $request)
    {
        $id = 0;
        $validate = $request->validate(
            [
                'name' => "required|unique:services,name," . $id . ",id,deleted_at,NULL",
                'department_id' => "required"
            ],
            [
                'name.required' => 'The Name is required.',
                'name.unique' => 'The Name has been already taken.',
                'department_id.required' => 'The Department is required.',
            ]
        );

        if ($validate) {

            $service = new Service();
            $service->department_id = $request->department_id;
            $service->name = $request->name;
            $service->description = $request->description;
            $service->status = 1;
            $service->save();
            if ($request->save) {
                return redirect(route('service.edit', $service->id))->with('success_message', trans('Added Successfully'));
            } else {
                return redirect(route('service.index'))->with('success_message', trans('Added Successfully'));
            }
        }
    }

    public function show($id)
    {
        $service = Service::find($id);
        $return_data = array();
        $return_data['data'] = $service;
        $return_data['page_condition'] = 'service_page';
        $return_data['site_title'] = 'Service | ' . config('constants.SITE_NAME');
        return view('admin.service.view', array_merge($return_data));
    }

    public function edit($id)
    {
        $data = Service::find($id);
        $return_data = array();
        $department = Department::where('status','1')->get();
        $return_data['department'] = $department;
        $return_data['data'] = $data;
        $return_data['page_condition'] = 'service_page';
        $return_data['site_title'] = 'Service | ' . config('constants.SITE_NAME');
        return view('admin.service.form', array_merge($return_data));
    }
    public function update(Request $request)
    {
        $id = $request->id;
        $validate = $request->validate(
            [
                'name' => "required|unique:services,name," . $id . ",id,deleted_at,NULL",
                'department_id' => "required"
            ],
            [
                'name.required' => 'The Name is required.',
                'name.unique' => 'The Name has been already taken.',
                'department_id.required' => 'The Department is required.',
            ]

        );
        if ($validate) {

            $service = Service::find($id);
            $service->department_id = $request->department_id;
            $service->name = $request->name;
            $service->description = $request->description;
            $service->save();

            if ($request->save) {
                return redirect(route('service.edit', $service->id))->with('success_message', trans('Update Successfully'));
            } else {
                return redirect(route('service.index'))->with('success_message', trans('Update Successfully'));
            }
        }
    }
    public function destroy($id)
    {
        $service = Service::find($id);
        $service->delete();
        return redirect()->route("service.index")->with('success_message', 'Delete Successfully!');
    }

    public function setActivate($id)
    {
        $update_status = Service::find($id);
        $update_status->status = 1;
        $update_status->save();
        return redirect(route('service.index'))->with('success_message', trans('Active Successfully'));
    }

    public function setInactivate($id)
    {
        $update_status = Service::find($id);
        $update_status->status = 0;
        $update_status->save();
        return redirect(route('service.index'))->with('success_message', trans('Inactive Successfully'));
    }
}
