<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\State;
use App\Models\Country;
use Datatables;

class StateController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $state = State::all();
            return datatables()->of($state)
				->addColumn('country', function ($row) {
					$country = '';
					if(is_object($row->Country)){
						$country = $row->Country->name;
					}
					return $country;
				})
                ->addColumn('action', function ($row) {
                    $html = '';
                    $html .= '<a href="'.route('state.edit',$row->id).'" class="btn btn-secondary btn-edit btn-sm"><i class="fa fa-edit"></i> Edit</a> ';
                    $html .= '&nbsp;<a href="'.route('state.show',$row->id).'" class="btn btn-info btn-edit btn-sm"><i class="fa fa-eye"></i> View</a> ';
					$html .= '&nbsp;<a href="javascript:;" class="btn btn-danger btn-delete btn-sm" data-toggle="tooltip" data-original-title="Delete" data-container="body" title="" onclick="return record_delete(\''.route('state.destroy', $row->id).'\');" ><i class="fa fa-trash" aria-hidden="true"></i> Delete</a>';
					if($row->status == 1){
                		$html .= '<a href="'.route('inactive.state',array('id'=>$row->id)).'" onClick="return alertconfirm(\'Are you sure you want to Inactive this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-success"></i></a>';
                	}else{
                        $html .= '<a href="'.route('active.state',array('id'=>$row->id)).'" onClick="return alertconfirm(\'Are you sure you want to Activate this?\');" rel="tooltip" title="" class="btn btn-outline-light ml-1 btn-sm"><i class="fa fa-circle text-muted"></i></a>';
                    }
					$html .= '';
					
					$html .= '<a href="" class="</a>';
                    return $html;
                })->toJson();
        }
        $return_data = array();
        $return_data['page_condition'] = 'state_page';
		$return_data['site_title'] = 'State | ' . config('constants.SITE_NAME');
		return view('admin.state.index', array_merge($return_data));
    }
    public function create(){
		$return_data = array();
		$country = Country::where('status','1')->get();
		$states = State::with('Country')->get();
		$return_data['country'] = $country;
		$return_data['states'] = $states;
		$return_data['page_condition'] = 'state_page';
		$return_data['site_title'] = 'State | ' . config('constants.SITE_NAME');
		return view('admin.state.form', array_merge($return_data));
	}
    public function store(Request $request)
    {
        $id = 0;
		$validate = $request->validate([
			'name' => "required",
			'country_id' => 'required',
			// 'sequence' => "required|max:8",
		],[
            'name.required' => 'The state name is required.',
            'name.unique' => 'The state name has already been taken.',
			'country_id.required' => 'The country is required.',
            // 'sequence.required' => 'The sort order is required.',
            // 'sequence.max' => 'The sort order should be a valid 8-digit number.',
        ]
		);
		$stateCheck = 0;
		if($request->country_id && $request->name){
			$stateCheck = State::where('country_id',$request->country_id)->where('name',$request->name)->count();
		}
		if($stateCheck){
			return redirect()->back()->withErrors(['name' => 'The state name already exists in this country.'])->withInput();
		}
		if($validate){
			$all_data = $request->all();
			$all_data['status'] = 1;
            $state = State::create($all_data);
            //$request_data = array('new_data' => $_REQUEST);
			//$this->log_insert("State Created" , $request_data);
			if ($request->save) {	
				return redirect(route('state.edit',$state->id))->with('success_message', trans('Added Successfully'));
			}else{
	            return redirect(route('state.index'))->with('success_message', trans('Added Successfully'));
	        }
		}
    }

    public function show($id)
    {
        $state = State::find($id);
		$return_data = array();
        $return_data['state'] = $state;
		$return_data['page_condition'] = 'state_page';
		$return_data['site_title'] = 'State | ' . config('constants.SITE_NAME');
		return view('admin.state.view', array_merge($return_data));
    }

    public function edit($id){
		$states = State::get();
		$state = State::find($id);
		$country = Country::where('status','1')->get();
		$return_data = array();
        $return_data['states'] = $states;
        $return_data['state'] = $state;
		$return_data['country'] = $country;
		$return_data['page_condition'] = 'state_page';
		$return_data['site_title'] = 'State | ' . config('constants.SITE_NAME');
		return view('admin.state.form', array_merge($return_data));
	}
	public function update(Request $request, $id){

		$validate = $request->validate([
			'name' => "required",
			'country_id' => "required",
			// 'sequence' => "required|max:8",
			],[
			'name.required' => 'The state name is required.',
			'name.unique' => 'The state name has already been taken.',
			// 'country_id.required' => 'The country is required.',
			// 'sequence.required' => 'The sort order is required.',
			// 'sequence.max' => 'The sort order should be a valid 8-digit number.',
		]);

		$stateCheck = 0;
		if($request->country_id && $request->name){
			$stateCheck = State::where('id','!=',$id)->where('country_id',$request->country_id)->where('name',$request->name)->count();
		}
		if($stateCheck){
			return redirect()->back()->withErrors(['name' => 'The state name already exists in this country.'])->withInput();
		}

		if($validate){
			$state = State::find($id);
			$all_data = $request->all();
			//$request_data = array('old_data' => $state,'new_data' => $_REQUEST);
			//$this->log_insert("State Updated" , $request_data);
			$state->update($all_data); 
	        if ($request->save) {
				return redirect(route('state.edit',$state->id))->with('success_message', trans('Update Successfully'));
			}else{
	            return redirect(route('state.index'))->with('success_message', trans('Update Successfully'));
	        }
		}
	}
	public function destroy($id){
		$state = State::find($id);
		//$request_data = array('old_data' => $state,'new_data' => $_REQUEST);
		//$this->log_insert("State Deleted" , $request_data);
		$state->delete();
		return redirect()->route("state.index")->with('success_message', 'Delete Successfully!');
	}
    public function setActivate($id){
        $update_status = State::find($id);
        $update_status->status = 1;
        $update_status->save();
        //$request_data = array('old_data' => $update_status,'new_data' => $_REQUEST);
		//$this->log_insert("State Status Active" , $request_data);
        return redirect(route('state.index'))->with('success_message', trans('Active Successfully'));
    }
    public function setInactivate($id) {
        $update_status = State::find($id);
        $update_status->status = 0;
        $update_status->save();
        //$request_data = array('old_data' => $update_status,'new_data' => $_REQUEST);
		//$this->log_insert("State Status Inactive" , $request_data);
        return redirect(route('state.index'))->with('success_message', trans('Inactive Successfully'));
    }
}
