<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Datatables;
use Illuminate\Support\Facades\Hash;
class UserController extends Controller
{
    public function index(Request $request)
    {
        
    }
    public function create(){
		
	}
    public function store(Request $request)
    {
        
    }

    public function show($id)
    {
        return;
    }

    public function edit($id){
		
	}
	public function update(Request $request, $id){
		
	}
	public function destroy($id){
		
	}
    public function setActivate($id){
        
    }
    public function setInactivate($id) {
       
    }
	public function changePassword(Request $request)
    {
        $return_data = array();
        $return_data['page_condition'] = 'changepassword_page';
        $return_data['site_title'] = 'Change Password | ' . config('constants.SITE_NAME');
        return view('admin/users/changepassword', array_merge($return_data));
        // return view('admin/admin_users.changepassword');
    }
	public function postchangePassword(Request $request)
    {
        
        $this->validate($request, [
            'current_password' => 'required|string',
            'new_password' => 'required|min:6|without_spaces|confirmed|string'
        ],[
            'new_password.required' => 'The password is required.',
            'new_password.without_spaces' => 'The password does not allowed white space.',
        ]);
        $auth = auth()->user();
        if (!empty($auth->password) && !Hash::check($request->get('current_password'), $auth->password)){
            return back()->withInput()->with('error_current_password', "Current Password is Invalid");
        }
        if (strcmp($request->get('current_password'), $request->new_password) == 0){
            return back()->withInput()->with("error_not_match", "New Password cannot be same as your current password.");
        }
        $user =  User::find($auth->id);
        $user->password =  Hash::make($request->new_password);
        $user->save();
        return back()->with('success_message', "Password Changed Successfully");
    }
}
