<?php

namespace App\Http\Controllers;
use App\Models\User;
use App\Models\City;
use App\Models\State;
use App\Models\Country;
use App\Models\CustomerUser;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use App\Models\ReminderCustomerDocument;
use Illuminate\Http\Request;
use App\Models\EmailContent;
use App\Models\CustomerContactDetail;
use Illuminate\Support\Facades\Mail;
use App\Models\Reminder;
use App\Models\Document;
use App\Models\Assignment;
use App\Models\EmployeeUser;
use App\Helper\Helpers;
use App\Mail\EmailTemplete;
use App\Models\MailSendLog;
use App\Models\MailSendLogDocument;
use App\Models\ReminderAttachment;
use App\Models\SchedulerReminder;
use App\Models\SchedulerReminderAttachment;
use App\Models\SchedulerReminderCustomerDocument;
use ZipArchive;
use Carbon\Carbon;
use Intervention\Image\Facades\Image;

class CommonController extends Controller
{
    public function getState($id){
        
        $states = State::where('status','1')->where('country_id',$id)->get();       

        return response()->json($states);
    }
    public function getCustomerContactDetails(Request $request){
        $arrSelected = isset($_POST['arrSelected']) ? $_POST['arrSelected'] : array('no_found');
        $arremailSelected = isset($_POST['arremailSelected']) ? $_POST['arremailSelected'] : array('no_found');
        $action_flage = isset($_POST['action_flage']) ? $_POST['action_flage'] : '';
        $arrSelected_customer_to_email = isset($_POST['arrSelected_customer_to_email']) ? $_POST['arrSelected_customer_to_email'] : array();
        $arrSelected_customer_cc_email = isset($_POST['arrSelected_customer_cc_email']) ? $_POST['arrSelected_customer_cc_email'] : array();
        $customer_search = isset($_POST['customer_search']) ? $_POST['customer_search'] : '';
        $Customer = CustomerContactDetail::select('customer_contact_details.*','customer_users.name as customer_users_name')->where('customer_contact_details.id','!=',0);
        $Customer->join('customer_users', 'customer_users.id', '=', 'customer_contact_details.customer_id');
        if($action_flage == 'email_wise'){
            if(count($arremailSelected) > 0){
                $Customer->whereIn('customer_users.email_address',$arremailSelected);
            }
        }else{
            if(count($arrSelected) > 0){
                $Customer->whereIn('customer_contact_details.customer_id',$arrSelected);
            }
        }    
        if($customer_search != ''){
            $Customer->where('customer_contact_details.name','LIKE','%'.$customer_search.'%');
        }
        $Customer = $Customer->orderBy('customer_contact_details.id', 'ASC')->orderBy('customer_contact_details.name', 'ASC')->get(); 
        $Customer_array = array();
        if($Customer){
            foreach($Customer as $Customer_val){
                $customer_to_email_selected = '';
                if(in_array($Customer_val->id,$arrSelected_customer_to_email)){
                    $customer_to_email_selected = 'selected';
                }
                $customer_cc_email_selected = '';
                if(in_array($Customer_val->id,$arrSelected_customer_cc_email)){
                    $customer_cc_email_selected = 'selected';
                }
                $Customer_array[] = array(
                    'id' => $Customer_val->id,
                    'name' => $Customer_val->name,
                    'email' => $Customer_val->email.' - '.$Customer_val->customer_users_name,
                    'customer_to_email_selected' => $customer_to_email_selected,
                    'customer_cc_email_selected' => $customer_cc_email_selected,
                );
            }
        }
        return response()->json($Customer_array);
    }
    public function getCustomerSeleted(Request $request){
        $arrSelected = isset($_POST['arrSelected']) ? $_POST['arrSelected'] : array();
        $arrSelected_customer_to_email = isset($_POST['arrSelected_customer_to_email']) ? $_POST['arrSelected_customer_to_email'] : array();
        $arrSelected_customer_cc_email = isset($_POST['arrSelected_customer_cc_email']) ? $_POST['arrSelected_customer_cc_email'] : array();
        $customer_search = isset($_POST['customer_search']) ? $_POST['customer_search'] : '';
        $Customer = CustomerUser::with('Group')->where('status','1');
        if(count($arrSelected) > 0){
            $Customer->whereIn('id',$arrSelected);
        }
        if($customer_search != ''){
            $Customer->where('customer_users.name','LIKE','%'.$customer_search.'%');
        }
        $Customer = $Customer->orderBy('customer_users.group_id', 'ASC')->orderBy('customer_users.name', 'ASC')->get(); 
        $Customer_array = array();
        if($Customer){
            foreach($Customer as $Customer_val){
                $customer_to_email_selected = '';
                if(in_array($Customer_val->id,$arrSelected_customer_to_email)){
                    $customer_to_email_selected = 'selected';
                }
                $customer_cc_email_selected = '';
                if(in_array($Customer_val->id,$arrSelected_customer_cc_email)){
                    $customer_cc_email_selected = 'selected';
                }
                $Customer_array[] = array(
                    'id' => $Customer_val->id,
                    'name' => $Customer_val->name,
                    'email' => $Customer_val->email_address,
                    'customer_to_email_selected' => $customer_to_email_selected,
                    'customer_cc_email_selected' => $customer_cc_email_selected,
                );
            }
        }
        return response()->json($Customer_array);
    }
    public function getGroupByCustomer(Request $request,$id){
        $arrgroupSelected = isset($_POST['arrgroupSelected']) ? $_POST['arrgroupSelected'] : array();
        $arrSelected = isset($_POST['arrSelected']) ? $_POST['arrSelected'] : array();
        $arrcustomer_emailSelected = isset($_POST['arrcustomer_emailSelected']) ? $_POST['arrcustomer_emailSelected'] : array();
        $arrcustomerSelected = isset($_POST['arrcustomerSelected']) ? $_POST['arrcustomerSelected'] : array();
        $customer_search = isset($_POST['customer_search']) ? $_POST['customer_search'] : '';
        $Customer = CustomerUser::with('Group')->where('status','1');
        if($id == 0){
            $id = 'all';
        }
        if($id == 'all'){
                  
        }else{
            $Customer->where('group_id',$id);
        }
        if(count($arrSelected) > 0){
            $Customer->whereNotIn('id',$arrSelected);
        }
        if(count($arrgroupSelected) > 0){
            $Customer->whereIn('group_id',$arrgroupSelected);
        }
        if($customer_search != ''){
            $Customer->where('customer_users.name','LIKE','%'.$customer_search.'%');
        }
        $Customer = $Customer->orderBy('customer_users.group_id', 'ASC')->orderBy('customer_users.name', 'ASC')->get(); 
        $Customer_array = array();
        if($Customer){
            foreach($Customer as $Customer_val){
                $Groupname = '';
                if (is_object($Customer_val->Group)) {
                    $Groupname = $Customer_val->Group->name;
                }
                $customer_to_email_selected = '';
                if(in_array($Customer_val->email_address,$arrcustomer_emailSelected)){
                    $customer_to_email_selected = 'selected';
                }elseif(in_array($Customer_val->id,$arrcustomerSelected)){
                    $customer_to_email_selected = 'selected';
                }
                $Customer_array[] = array(
                    'id' => $Customer_val->id,
                    'name' => $Customer_val->name.' - '.$Groupname,
                    'email_address' => $Customer_val->email_address,
                    'customer_to_email_selected' =>  $customer_to_email_selected,
                );
            }
        }
        return response()->json($Customer_array);
    }
    public function getAssignmentByDocument(Request $request,$id){
        $arrSelected = isset($_POST['arrSelected']) ? $_POST['arrSelected'] : array();
        $Document_list = Document::where('status','1');
        if($id == 0){
            $id = 'all';
        }
        if($id == 'all'){
                  
        }else{
            $Document_list->where('assignment_id',$id);
        }
        if(count($arrSelected) > 0){
            $Document_list->whereNotIn('id',$arrSelected);
        }
        $Document_list = $Document_list->orderBy('documents.assignment_id', 'ASC')->get(); 
        $Document_array = array();
        if($Document_list){
            foreach($Document_list as $Document_val){
                $Document_array[] = array(
                    'id' => $Document_val->id,
                    'name' => $Document_val->name,
                );
            }
        }
        return response()->json($Document_array);
    }

    public function getCity($id){
       
        $states = City::where('status','1')->where('state_id',$id)->get();       
        return response()->json($states);
    }
    public function ReminderSend(){
        //	curl https://reminder.hollybollygossip.com/public/reminder_send
        echo '$current_date==>'.$current_date = date('Y-m-d');
        echo '<br>';
        $reminder_document_list = ReminderCustomerDocument::select('reminder_customer_documents.reminder_id','reminder_customer_documents.customer_id')->with('Reminder')->where('reminder_customer_documents.upload_status', 0)//->WhereNull('upload_document')
        ->join('reminders', 'reminders.id', '=', 'reminder_customer_documents.reminder_id')
        ->WhereNotNull('reminders.send_date')
        ->WhereNotNull('reminders.next_send_date')
        //->where('reminders.send_date', $current_date)
        ->whereDate('reminders.next_send_date','<=', $current_date)
        ->orderBy('reminder_customer_documents.reminder_id', 'ASC')
        ->where('reminders.status',1)
        ->groupBy('reminder_customer_documents.reminder_id','reminder_customer_documents.customer_id')->get();
        //dd($reminder_document_list);
        if($reminder_document_list){
            foreach($reminder_document_list as $reminder_document_list_val){
                if($reminder_document_list_val->Reminder){
                    echo '<br>reminder_period==>'.$reminder_period = $reminder_document_list_val->Reminder->reminder_period;
                    echo '<br>db_next_send_date==>'.$db_next_send_date = $reminder_document_list_val->Reminder->next_send_date;
                    if($reminder_period == 1){//Weekly
                        echo '<br>next_send_date=>'.$next_send_date = date('Y-m-d',strtotime("+ 8 day",strtotime($current_date)));       
                    }elseif($reminder_period == 2){//Monthly
                        echo '<br>next_send_date=>'.$next_send_date = date('Y-m-d',strtotime("+ 1 month",strtotime($current_date)));       
                    }else{//Daily
                        echo '<br>next_send_date=>'.$next_send_date = date('Y-m-d',strtotime("+ 1 day",strtotime($current_date)));
                    }
                    echo '<br>reminder_id==>'.$reminder_id = $reminder_document_list_val->reminder_id;
                    echo '<br>reminder name==>'.$reminder_name = $reminder_document_list_val->Reminder->name;
                    echo '<br>customer_id==>'.$customer_id = $reminder_document_list_val->customer_id;
                    Helpers::ReminderMail($reminder_id,$customer_id,'cron_run');
                    Reminder::where('id',$reminder_id)->update(['send_date' => $current_date,'next_send_date' => $next_send_date]); 
                    echo '<hr><hr>';
                }
            }
        }
    }
    public function SchedulerReminderMove(){
        //	curl https://reminder.hollybollygossip.com/public/scheduler_reminder_move
        echo '$current_date==>'.$current_date = date('Y-m-d');
        echo '$main_current_date==>'.$main_current_date = date('Y-m-d');
        echo '<br>';
        $scheduler_reminder_list = SchedulerReminder::select('scheduler_reminders.*')
        ->WhereNotNull('scheduler_reminders.send_date')
        ->WhereNotNull('scheduler_reminders.next_send_date')
        ->whereDate('scheduler_reminders.next_send_date','<=', $current_date)
        ->where('scheduler_reminders.status',1)
        ->orderBy('scheduler_reminders.id', 'ASC')
        ->get();
        //dd($reminder_document_list);
        if($scheduler_reminder_list){
            foreach($scheduler_reminder_list as $scheduler_reminder_list_val){
                echo '<br>reminder_name==>'.$reminder_period = $scheduler_reminder_list_val->name;
                echo '<br>reminder_period==>'.$reminder_period = $scheduler_reminder_list_val->reminder_period;
                echo '<br>db_next_send_date==>'.$db_next_send_date = $scheduler_reminder_list_val->next_send_date;
                if($reminder_period == 1){//Every Month
                    echo '<br>1 next_send_date=>'.$next_send_date = date('Y-m-d',strtotime("+ 1 month",strtotime($main_current_date)));       
                }else{//Once
                    echo '<br>0 next_send_date=>'.$next_send_date = date('Y-m-d',strtotime($main_current_date));
                    $current_date = NULL;
                }
                $reminder = new Reminder();
                $reminder->scheduler_reminder_id = $scheduler_reminder_list_val->id;
                $reminder->name = $scheduler_reminder_list_val->name;
                $reminder->login_user_id = $scheduler_reminder_list_val->login_user_id;
                $reminder->from_email = $scheduler_reminder_list_val->from_email;
                $reminder->current_date_value = $scheduler_reminder_list_val->current_date_value;
                $reminder->reminder_period = 0;
                $reminder->send_date = NULL;
                $reminder->next_send_date = NULL;
                $reminder->description = $scheduler_reminder_list_val->description;
                $reminder->assignment_id = $scheduler_reminder_list_val->assignment_id;
                $customer_to_email_insert = $scheduler_reminder_list_val->contact_customer_id_to;
                $reminder->contact_customer_id_to = $customer_to_email_insert;
                $customer_cc_email_insert = $scheduler_reminder_list_val->contact_customer_id_cc;
                $reminder->contact_customer_id_cc = $customer_cc_email_insert;
                $reminder->status = 1;
                $reminder->save();
                $destinationPath = public_path('images').config('constants.DOCUMENT');
                $attachment = SchedulerReminderAttachment::where('scheduler_reminder_id',$scheduler_reminder_list_val->id)->get();       
                if($attachment){
                    foreach($attachment as $key=>$image){
                        $org_upload_document = $image->org_upload_document;
                        if($org_upload_document != ''){
                            $upload_document = $image->upload_document;
                            $file_attachment = new ReminderAttachment();
                            $file_attachment->reminder_id = $reminder->id;
                            $file_attachment->org_upload_document = $org_upload_document;
                            $file_attachment->upload_document = $upload_document;
                            $file_attachment->status = $image->status;
                            $file_attachment->save();
                        }    
                    }
                }
                $scheduler_reminder_doc_list = SchedulerReminderCustomerDocument::where('scheduler_reminder_id',$scheduler_reminder_list_val->id)->get();   
                $customer_id = array();
                if($scheduler_reminder_doc_list){
                    foreach($scheduler_reminder_doc_list as $scheduler_reminder_doc_list_val){
                        $reminder_detail = new ReminderCustomerDocument();
                        $reminder_detail->reminder_id = $reminder->id;
                        $reminder_detail->login_user_id = $scheduler_reminder_doc_list_val->login_user_id;
                        $reminder_detail->customer_id = $scheduler_reminder_doc_list_val->customer_id;
                        $reminder_detail->document_id = $scheduler_reminder_doc_list_val->document_id;
                        $reminder_detail->doc_content = $scheduler_reminder_doc_list_val->doc_content;
                        $reminder_detail->doc_content_column = $scheduler_reminder_doc_list_val->doc_content_column;
                        $reminder_detail->save();
                        $customer_id[$scheduler_reminder_doc_list_val->customer_id] = $scheduler_reminder_doc_list_val->customer_id;
                    }
                }
                if(count($customer_id) > 0){
                    foreach($customer_id as $customer_id_val){
                       Helpers::ReminderMail($reminder->id,$customer_id_val,'scheduler_reminder_add');
                    }
                }
                echo '<br>scheduler_reminder_id==>'.$scheduler_reminder_id = $scheduler_reminder_list_val->id;
                SchedulerReminder::withTrashed()->where('id',$scheduler_reminder_id)->update(['send_date' => $current_date,'next_send_date' => $next_send_date]); 
                echo '<hr><hr>';
            }
        }
    }
    public function detail($reminder_id)
    {
        $customer_id = isset($_GET['customer_id']) ? $_GET['customer_id'] : 0;
        $return_data = array();
        $reminder_detail = Reminder::find($reminder_id);
        $return_data['reminder_detail'] = $reminder_detail;
        $document_list = ReminderCustomerDocument::with('Document')->where('customer_id',$customer_id)->where('reminder_id',$reminder_id)->get();
        $return_data['document_list'] = $document_list;
        $return_data['page_condition'] = 'document_page';
        $return_data['reminder_id'] = $reminder_id;
        $return_data['customer_id'] = $customer_id;
        $document_upload_status = 0;
        if($document_list){
            foreach ($document_list as $Document_val){
                if($Document_val->Document){
                    if($Document_val->upload_status == 0){
                        $document_upload_status = 1;
                    }
                }
            }
        }
        $return_data['document_upload_status'] = $document_upload_status;
        $return_data['document_attachment'] = 'images/'.config('constants.DOCUMENT');
        if($document_upload_status == 0){
            $return_data['site_title'] = 'Thank You | ' . config('constants.SITE_NAME');
            return view('thank-you', array_merge($return_data));
        }else{
            $return_data['site_title'] = 'Document | ' . config('constants.SITE_NAME');
            return view('upload_document_detail', array_merge($return_data));
        }
    }
    public function postdetail (Request $request,$reminder_id){
        $customer_id = isset($_POST['customer_id']) ? $_POST['customer_id'] : 0;
        $upload_comment = isset($_POST['upload_comment']) ? $_POST['upload_comment'] : array();
        if($upload_comment){
            foreach($upload_comment as $key=>$comment_val){
                if($comment_val != ''){
                    ReminderCustomerDocument::withTrashed()->where('id',$key)->where('customer_id',$customer_id)->update(['upload_comment' => $comment_val,'upload_datetime' => date('Y-m-d H:i:s'),'upload_status' => 1]);
                } 
            }
        }
        $upload_document = $request->file('upload_document');            
        $destinationPath = public_path('images').config('constants.DOCUMENT');
        if($upload_document){
            $ids = array();
            foreach($upload_document as $key=>$image){
                $image_count = count($image);
                if($image_count == 1){
                    $org_upload_document = $image[0]->getClientOriginalName();
                    if($org_upload_document != ''){
                         $ids[] = $key;
                         $upload_document = 'document-'.$key.'-'.time().'.'.$image[0]->getClientOriginalExtension();
                         $image[0]->move($destinationPath, $upload_document);
                         ReminderCustomerDocument::withTrashed()->where('id',$key)->where('customer_id',$customer_id)->update(['status' => 0,'org_upload_document' => $org_upload_document,'upload_document' => $upload_document,'upload_datetime' => date('Y-m-d H:i:s'),'upload_status' => 1]);
                    }  
                }else{
                    $zip = new ZipArchive;
                    $zipFileName = 'documentzip-'.$key.'-'.time().'.zip';
                    $filesToZip = array();
                    foreach($image as $image_val){
                        $org_upload_document = $image_val->getClientOriginalName();
                        if($org_upload_document != ''){
                            $ids[] = $key;
                            $upload_document = 'document-'.$key.'-'.time().'.'.$image_val->getClientOriginalExtension();
                            $image_val->move($destinationPath, $upload_document);
                            $filesToZip[] = $destinationPath.$upload_document;
                        } 
                    }
                    //echo $destinationPath.$zipFileName;exit;
                    if ($zip->open($destinationPath.$zipFileName, ZipArchive::CREATE) === TRUE) {
                        if(count($filesToZip) > 0){
                            foreach ($filesToZip as $file) {
                                $zip->addFile($file, basename($file));
                            }
                            ReminderCustomerDocument::withTrashed()->where('id',$key)->where('customer_id',$customer_id)->update(['status' => 0,'org_upload_document' => 'Zip File','upload_document' => $zipFileName,'upload_datetime' => date('Y-m-d H:i:s'),'upload_status' => 1]);
                        }    
                    }    
                    $zip->close();
                }
            }
            /////////////////////////////////////
            $EmailContent =  EmailContent::where('status','1')->where('id',config('constants.MAIL_TEMPLATE.Doument_Upload'))->first();
            $reminder_document_detail = ReminderCustomerDocument::with('CustomerUser')->with('Reminder')->with('Document')->whereIn('id', $ids)->where('customer_id',$customer_id)->get();//->where('id',$key)
            $document_ids = array();
            if(is_object($EmailContent) && is_object($reminder_document_detail)){
                $list_of_docs = '';
                $reminder_name = '';
                $send_email = '';
                $customer_name = '';
                $files = array();
                foreach($reminder_document_detail as $reminder_document_list_val){
                    $reminder_customer_documents_id = $reminder_document_list_val->id;
                    $status = $reminder_document_list_val->status;
                    $document_id = $reminder_document_list_val->document_id;
                    $document_ids[] = $document_id;
                    $reject_note = '';
                    if($status == 2){
                        $reject_note = ' : <span style="color:red;">Reject Note : '.$reminder_document_list_val->reject_notes.'</span>';
                    }
                    $db_file_name = 'Document';
                    if($reminder_document_list_val->Document){
                        $list_of_docs .= $reminder_document_list_val->Document->name.' '.$reject_note.'<br>';
                        $db_file_name = $reminder_document_list_val->Document->name;
                    }
                    if($reminder_document_list_val->Reminder){
                        $reminder_name = $reminder_document_list_val->Reminder->name;
                        $send_email = $reminder_document_list_val->Reminder->from_email;
                    }
                    if($reminder_document_list_val->CustomerUser){
                        $customer_name = $reminder_document_list_val->CustomerUser->name;
                        $customer_email = $reminder_document_list_val->CustomerUser->email_address;
                    }
                    if($reminder_document_list_val->upload_document != ''){
                        $files[] = $destinationPath.$reminder_document_list_val->upload_document;
                    }   
                }
                if($list_of_docs != '' && $send_email != ''){
                    $user_detail = User::withTrashed()->where('email',$send_email)->first();
                    $user_name = '';
                    if($user_detail){
                        $user_name = $user_detail->name;
                    }
                    $list_of_docs .= '<br><a href="' . route('customer.user.reminder_detail', array('customer_id'=>$customer_id,'reminder_id'=>$reminder_id)) . '">Click Here</a> ';
                    $email_body = $EmailContent->content;
                    $email_body = str_replace('{{DOCUMENTNAME}}',$list_of_docs,$email_body);
                    $email_body = str_replace('{{ReminderName}}',$reminder_name,$email_body);
                    $email_body = str_replace('{{CustomerName}}',$customer_name,$email_body);
                    $email_body = str_replace('{{UserName}}',$user_name,$email_body);
                    $mailData = [
                        'from_email' => '',
                        'title' => $EmailContent->title,
                        'body' => $email_body,
                        'subject' => $EmailContent->subject,
                        'files' => $files
                    ];
                    Mail::to($send_email)->send(new EmailTemplete($mailData));
                    $current_date_time = date('Y-m-d H:i:s');
                    $main_send_log = new MailSendLog();
                    $main_send_log->name = 'Customer Doument Upload';
                    $main_send_log->reminder_id = $reminder_id;
                    $main_send_log->customer_id = $customer_id;
                    $main_send_log->from_email = '';
                    $main_send_log->to_email = $send_email;
                    $main_send_log->send_date = $current_date_time;
                    $main_send_log->title = $EmailContent->title;
                    $main_send_log->subject = $EmailContent->subject;
                    $main_send_log->body = $email_body;
                    $main_send_log->action_flage = 'Customer_Doument_Upload';
                    $main_send_log->save();
                    if(count($document_ids) > 0){
                        foreach ($document_ids as $key => $document_id_value) {
                            $main_send_log_document = new MailSendLogDocument();
                            $main_send_log_document->mail_send_log_id = $main_send_log->id;
                            $main_send_log_document->document_id = $document_id_value;
                            $main_send_log_document->save();    
                        }
                    }
                } 
            }
            /////////////////////////////////////
        }
        return redirect(route('upload.document', array('reminder_id' => $reminder_id,'customer_id'=>$customer_id)))->with('success_message', trans('Update Successfully'));
    }
    public function getPhoneCodeValidation(Request $request){
        $phonecode = isset($_POST['phonecode']) ? $_POST['phonecode'] : '';
        $mobile_number = isset($_POST['mobile_number']) ? $_POST['mobile_number'] : '';
        $return_array = array();
        $return_array['return_msg'] = '';     
        $phonecode_val = '';
        if($phonecode != ''){
            $countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('id',$phonecode)->first();
            $phonecodedigit = 0;
            if($countryphonecode_detail){
                $phonecode_val = $countryphonecode_detail->phonecode;
            }
        }
        if($phonecode != '' && $mobile_number != ''){
            $countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('id',$phonecode)->first();
            $phonecodedigit = 0;
            if($countryphonecode_detail){
                $phonecodedigit = $countryphonecode_detail->phonecodedigit;
            }
            if(strlen($mobile_number) != $phonecodedigit){
                $return_array['status'] = 'error';   
                $return_array['return_msg'] = 'The mobile number must be '.$phonecodedigit.' digits.';     
            }else{
                $return_array['status'] = 'success';
            }
        }else{
            $return_array['status'] = 'success';
        }
        $return_array['phonecode_val'] = $phonecode_val;
        return response()->json($return_array);
    }
    public function BirthEmailSend(){
        $birth_date = date('Y-m-d');
        $today = Carbon::now()->format('m-d');

        $current_date_time = date('Y-m-d H:i:s');
        $main_send_log = new MailSendLog();
        $main_send_log->name = 'Cron Run';
        $main_send_log->reminder_id = 0;
        $main_send_log->customer_id = 0;
        $main_send_log->from_email = '';
        $main_send_log->to_email = '';
        $main_send_log->cc_email = '';
        $main_send_log->send_date = $current_date_time;
        $main_send_log->title = '';
        $main_send_log->subject = '';
        $main_send_log->body = 'today==>'.$today.'====';
        $main_send_log->action_flage = 'Cron Run';
        $main_send_log->action_type ='Cron Run';
        $main_send_log->deleted_at = $current_date_time;
        $main_send_log->save();
        $email_send_list = CustomerContactDetail::whereRaw("DATE_FORMAT(birth_date, '%m-%d') = ?", [$today])->whereNotNull('email')->get();
        if (is_object($email_send_list)) {            
            foreach($email_send_list as $email_send_list_val){
                $email = $email_send_list_val->email;
                if($email != ''){
                    $customer_detail = array();
                    $customer_detail['customer_contact_details'] = $email_send_list_val->id;
                    $customer_detail['name'] = $email_send_list_val->name;
                    $customer_detail['email'] = $email;
                    Helpers::BirthdayMail($customer_detail);   
                }    
            }
        }
    }
    public function getEmployeeDetail($emp_id = '')
    {
        $return_data = array();
        $emp_id = base64_decode($emp_id);
        $emp_detail = EmployeeUser::find($emp_id);
        $return_data['emp_detail'] = $emp_detail;
        $return_data['site_title'] = 'Emp Detail | ' . config('constants.SITE_NAME');
        return view('emp-detail', array_merge($return_data));
    }
    public function getEmployeeQrDownload($emp_id = '')
    {
        $return_data = array();
        $decode_emp_id = base64_decode($emp_id);
        $emp_detail = EmployeeUser::find($decode_emp_id);
        $qr_image_url = isset($emp_detail->qr_image_url) ? $emp_detail->qr_image_url : '';
        if($qr_image_url != ''){
            $path = public_path('images/employee_user_qr/'.$decode_emp_id.'.png');
            return response()->download($path, 'qr_code.png');
        }
         return redirect(route('employee_detail.get',$emp_id));
    }
    public function getAdminDetail($admin_id = '')
    {
        $return_data = array();
        $admin_id = base64_decode($admin_id);
        $admin_detail = User::find($admin_id);
        $return_data['admin_detail'] = $admin_detail;
        $return_data['site_title'] = 'Admin Detail | ' . config('constants.SITE_NAME');
        return view('admin-detail', array_merge($return_data));
    }
    public function getAdminQrDownload($admin_id = '')
    {
        $return_data = array();
        $decode_admin_id = base64_decode($admin_id);
        $admin_detail = User::find($decode_admin_id);
        $qr_image_url = isset($admin_detail->qr_image_url) ? $admin_detail->qr_image_url : '';
        if($qr_image_url != ''){
            $path = public_path('images/admin_user_qr/'.$decode_admin_id.'.png');
            return response()->download($path, 'qr_code.png');
        }
         return redirect(route('admin_detail.get',$admin_id));
    }
    public function generateCard()
    {
        $name = "11";
        $designation = "222";
        $code = "333 444";
        $phone = "+93673214567";
        $email = "66666@gmail.com";
        $code2 = "7777771";

        $img = Image::canvas(600, 800, '#ffffff');
        $fontPath = public_path('fonts/symbol.ttf');
        $logoPath = public_path('app-assets/images/logo/logo1.png'); // <- make sure image exists
        if (file_exists($logoPath)) {
            $logo = Image::make($logoPath)->resize(150, null, function ($constraint) {
            $constraint->aspectRatio();
            });
            $img->insert($logo, 'top-center', 0, 30); // Top center, 30px from top
        } else {
            $img->text('bakertilly', 300, 50, function($font) {
                $font->file(public_path('fonts/arial.ttf'));
                $font->size(24);
                $font->color('#000000');
                $font->align('center');
                $font->valign('top');
            });
        }
        $profilePath = public_path('images/default-user-logo.png'); // <- make sure image exists
        if (file_exists($profilePath)) {
            $profile = Image::make($profilePath)->fit(120, 120); // make square crop
            $mask = Image::canvas(100, 100);
            $mask->circle(100, 50, 50, function ($draw) {
                $draw->background('#ffffff');
            });
            $profile->mask($mask, true);
            $img->insert($profile, 'top-left', 250, 100); // position it
        } else {
            // fallback circle if no image
            $img->circle(100, 300, 150, function ($draw) {
                $draw->background('#cccccc'); // Placeholder
            });
        }
        $img->text($name, 300, 270, function($font) {
            $font->file(public_path('fonts/arial.ttf'));
            $font->size(23);
            $font->color('#000000');
            $font->align('center');
        });
        $img->text($designation, 300, 300, function($font) {
            $font->file(public_path('fonts/arial.ttf'));
            $font->size(20);
            $font->color('#555555');
            $font->align('center');
        });
        $img->text($code, 300, 330, function($font) {
            $font->file(public_path('fonts/arial.ttf'));
            $font->size(18);
            $font->color('#999999');
            $font->align('center');
        });
        $iconY = 360;
        // Phone icon + text
        $phoneIcon = Image::make(public_path('images/icons/phone.png'))->resize(25, 25);
        $img->insert($phoneIcon, 'top-left', 85, $iconY);
        $img->text($phone, 120, $iconY + 15, function($font) {
            $font->file(public_path('fonts/arial.ttf'));
            $font->size(18);
            $font->color('#000000');
        });
        // Email icon + text
        $iconY += 35;
        $emailIcon = Image::make(public_path('images/icons/email.png'))->resize(25, 25);
        $img->insert($emailIcon, 'top-left', 85, $iconY);
        $img->text($email, 120, $iconY + 15, function($font) {
            $font->file(public_path('fonts/arial.ttf'));
            $font->size(18);
            $font->color('#000000');
        });
        // Web icon + text
        $iconY += 35;
        $webIcon = Image::make(public_path('images/icons/web.png'))->resize(25, 25);
        $img->insert($webIcon, 'top-left', 85, $iconY);
        $img->text($code2, 120, $iconY + 15, function($font) {
            $font->file(public_path('fonts/arial.ttf'));
            $font->size(18);
            $font->color('#000000');
        });
        // Save the image
        $img->save(public_path('card.png'));
        echo '<img src="card.png" alt="Card Preview" />';
        //return response()->download(public_path('card.png'));
        
$img = Image::canvas(400, 600, '#ffffff');
// Optional: simulate card border/shadow (draw light gray rectangle)
$img->rectangle(10, 10, 390, 490, function($draw) {
    $draw->border(3, '#e0e0e0');
});
$logoPath = public_path('app-assets/images/logo/logo1.png');
// Insert logo at top
$logo = Image::make($logoPath)->resize(170, 50);
$img->insert($logo, 'top-center', 0, 30);
$profilePath = public_path('images/default-user-logo.png');
//////////////////////////////////////////////////
if (file_exists($profilePath)) {
    // Circular profile image
    $profile = Image::make($profilePath)->fit(120, 120);

    // Create circular mask
    $mask = Image::canvas(120, 120);
    $mask->circle(120, 60, 60, function ($draw) {
        $draw->background('#fff');
    });
    $profile->mask($mask, true);

    // Profile border
    $border = Image::canvas(130, 130, '#ffffff');
    $border->circle(130, 65, 65, function($draw) {
        $draw->border(3, '#dddddd');
    });
    $border->insert($profile, 'center');

    // Insert profile (centered)
    $img->insert($border, 'top-center', 0, 80);
    $footer_space = 240;
} else {
    $footer_space = 130;
}
////////////////////////////////////////////////////
// Font
$fontPath = public_path('fonts/arial.ttf');

// Name
$img->text('11', 200, $footer_space, function ($font) use ($fontPath) {
    $font->file($fontPath);
    $font->size(22);
    $font->color('#000000');
    $font->align('center');
});

// ID
$img->text('222', 200, $footer_space + 25, function ($font) use ($fontPath) {
    $font->file($fontPath);
    $font->size(16);
    $font->color('#444');
    $font->align('center');
});

// Sub ID
$img->text('333 444', 200, $footer_space + 55, function ($font) use ($fontPath) {
    $font->file($fontPath);
    $font->size(14);
    $font->color('#aaa');
    $font->align('center');
});

// Contact icons and text
$contacts = [
    ['icon' => 'phone.png', 'text' => '+93673214567'],
    ['icon' => 'email.png', 'text' => '66666@gmail.com'],
    ['icon' => 'web.png', 'text' => '7777771'],
];

$y = $footer_space + 70;
foreach ($contacts as $item) {
    $icon = Image::make(public_path('images/icons/' . $item['icon']))->resize(30, 30);
    $img->insert($icon, 'top-left', 40, $y);
    $img->text($item['text'], 80, $y + 10, function ($font) use ($fontPath) {
        $font->file($fontPath);
        $font->size(18);
        $font->color('#000000');
        $font->valign('top');
    });

    $y += 40;
}
$img->save(public_path('card_output.png'));
 echo '<img src="card_output.png" alt="Card Preview" />';
    }
}
