<?php 
  
namespace App\Http\Controllers\Customer\Auth; 
  
use App\Http\Controllers\Controller;
use Illuminate\Http\Request; 
use Illuminate\Support\Facades\DB; 
use Carbon\Carbon; 
use App\Mail\Customer\ForGotMail;
use App\Models\CustomerUser; 
use App\Models\EmailContent; 
use Illuminate\Support\Facades\Mail; 
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;
use Illuminate\Auth\Events\PasswordReset;
  
class CustomerForgotPasswordController extends Controller
{
      
      /**
       * Write code on Method
       *
       * @return response()
       */
      public function emailView() { 
         return view('customer.auth.passwords.email');
      }
      public function password_email(Request $request) { 
          $validate = $request->validate([
			'email' => "required|email:rfc,dns",
        	],[
            'email.required' => 'The email is required.',
            'email.email' => 'Please enter valid email',
            ]);
            if($validate){
                $email=$request->email;
                $user = CustomerUser::where('email_address', $request->email)->first();
               $EmailContent =  EmailContent::where('status','1')->where('id',config('constants.MAIL_TEMPLATE.CUSTOMER_FORGOT_PASSWORD'))->first();
               $username = !empty($user->name) ? $user->name : '';
               $url = route('customer.reset.password.get', $request->_token);
               if(is_object($EmailContent)){
                   $content = $EmailContent->content;
                   $content = str_replace('{{USER}}',$username,$content);
                   $content = str_replace('{{LINK}}',$url,$content);
                   $mailData = [
                        'title' => $EmailContent->title,
                        'body' => $content,
                        'subject' => $EmailContent->subject
                    ];
               } else {
                    $mailData = [
                        'title' => 'Mail from EHS.com',
                        'body' => 'You can reset password from bellow link: <a href="'.$url.'">Reset Password</a>',
                        'subject' => 'Forget Password Email',
                    ];
               }
                 
                 if(!$user){
                      return redirect('customer/forget')->with('error', 'Invalid user!');
                  }
                  
                 Mail::to($email)->send(new ForGotMail($mailData));
                 
                $user_data = CustomerUser::where('email_address', $request->email)
                              ->update(['remember_token' => $request->_token]);
                          
            
             return redirect('/customer/login')->with('success', 'email sucessfully send!');
            }
         return redirect('/customer/login')->with('error', 'Something went wrong.');   
      }
      
      public function showResetPasswordForm($token) {
          $email=CustomerUser::where('remember_token',$token)->pluck('email_address')->first();
         return view('customer.auth.passwords.forgetPasswordLink', compact('email'));
      }
  
      /**
       * Write code on Method
       *
       * @return response()
       */
      public function submitResetPasswordForm(Request $request)
      {
    
          $request->validate([
              'email' => 'required|email:rfc,dns',
              'password' => 'required|string|min:6|without_spaces|confirmed',
              'password_confirmation' => 'required'
          ],
          [ 
              'email' => 'The email is required.',
              'password.required' => 'The password is required.',
              'password.without_spaces' => 'The password does not allowed white space.',
          ]);
          
        // Manually check the second table
        $email = $request->input('email');
        $existsIncustomerUser = CustomerUser::where('email_address', $email)->first();
        
        if (is_object($existsIncustomerUser) && Hash::check($request->password, $existsIncustomerUser->password) ) {
            return redirect()->back()->withErrors(['password' => 'New Password cannot be same as your old password.'])->withInput();
        }
  
          $updatePassword = CustomerUser::where('email_address' , $request->email)->first();
          if(!$updatePassword){
              return redirect()->back()->with('error', 'Invalid user!');
          }
          
          $user =  CustomerUser::find($updatePassword->id);
          $user->password =  Hash::make($request->password);
          $user->save();
          event(new PasswordReset($user));
        
          return redirect('/customer/login')->with('success', 'Your password has been changed!');
      }
}