<?php

namespace App\Http\Controllers\Customer\Auth;

use App\Helper\Helpers;
use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB; 
use App\Models\CustomerUser;
use App\Models\EmailContent;
use Illuminate\Support\Facades\Mail; 
use Illuminate\Support\Str;
use App\Mail\Customer\ApprovalMail;
use App\Models\City;
use App\Models\Country;

class LoginController extends Controller
{

    public function showLoginForm()
    {
        return view('customer.auth.login');
    }
    public function login(Request $request)
    {
        $validate = $request->validate([
			'email' => "required|email:rfc,dns",
			'password' => "required",
		],[
            'email.required' => 'The email is required.',
            'email.email' => 'Please enter valid email',
            'password.required' => 'The password is required.',
        ]);
        if($validate){
            $credentials = $request->only('email', 'password');
    		$user = CustomerUser::where('email_address' ,$request->email)->first();
    		if($user){
    			
    			if(Hash::check($request->password,$user->password)){
    			    
    			    if($user->status == 1){
    			        
    					Session::put('customerlogin',$user->id);
    					Session::put('customer_name',$user->name);
    					Session::put('customer_email',$user->email_address);
    					Session::put('role','customer');
    					return redirect()->intended('/customer/dashboard');
    					
    	            } else {
    			         return redirect('/customer/login')->with('error', 'The user is inactive. Please contact the administrator.');
    		        }
    			} else {
    					// If the user does not have the 'customer' role, log them out
    					Auth::logout();
    					Session::flush();
    					return redirect('/customer/login')->with('error', 'Invalid credentials');
    			}
    		}

            return redirect()->back()->withInput($request->only('email'))->with('error', 'Invalid credentials');
        }
        return redirect()->back()->with('error', 'Something went wrong.');
    }
    public function dashboard()
    {
        $return_data = array();
        $return_data['page_condition'] = 'customer_dashboard';
		$return_data['site_title'] = 'Customer Dashboard | ' . config('constants.SITE_NAME');
        return view('customer.index', array_merge($return_data));
    }
    public function logout(Request $request)
    {
        /*Auth::guard('admin')->logout();
        $request->session()->invalidate();*/
		session_start();
		unset($_SESSION['customerlogin']);
		unset($_SESSION['customer_name']);
		unset($_SESSION['customer_email']);
        Session::flush(); // removes all session data
        return redirect('/customer/login');
    }
    
    public function showRegisterForm()
    {
        $country = Country::where('status','1')->get();
        return view('customer.auth.register',compact('country'));
    }

    public function register(Request $request)
    {
        $id = 0;
        $validate = $request->validate([
			'name' => "required",
			'email' => "required|email:rfc,dns|unique:customer_users,email_address," . $id . ",id,deleted_at,NULL",
			'city_id' => "required",
			'state_id' => "required",
			'country_id' => "required",
// 			'address' => "required",
			'mobile' => "required|max:10|min:10",
			'password' => "required|without_spaces|min:6",
			'district' => 'required|max:255',
            'pincode_number' => 'required|max:6|min:6',
		],[
            'name.required' => 'The full name is required.',
            'email.required' => 'The email is required.',
            'email.email' => 'Please enter valid email',
            'email.unique' => 'The email has been already taken.',
            'city_id.required' => 'The city is required',
            'state_id.required' => 'The state is required',
            'country_id.required' => 'The country is required',
            // 'address.required' => 'The address is required.',
            'mobile.required' => 'The phone number is required.',
            // 'mobile.numeric' => 'The mobile should be a numeric value, not a string..',
            'mobile.max' => 'The phone number should be 10 digits.',
            'mobile.min' => 'The phone number should be 10 digits.',
            'password.required' => 'The password is required.',
            'password.without_spaces' => 'The password does not allowed white space.',
           // 'password.min' => 'The password should be min 6 digits.',
            'district.required' => 'The district is required.',
            'pincode_number.required' => 'The pin code number is required.',
            'pincode_number.min' => 'The pin code number should be 6 digits.',
            'pincode_number.max' => 'The pin code number should be 6 digits.', 
        ]);
        
        // Manually check the second table
        $email = $request->input('email');
        
        if($validate){
            
            $credentials = $request->only('email', 'password');
    		$user = CustomerUser::where('email_address' ,$request->email)->count();
    		if($user > 0){
    		    return redirect('/customer/login')->with('error', 'Email already exist!');
    		}
    		$token = Str::random(64);
    		$customerUser = new CustomerUser();
    		$customerUser->name = $request->name;
    		$customerUser->email_address = $request->email;
    		$customerUser->address = $request->address;
    		$customerUser->city_id = $request->city_id;
    		$customerUser->state_id = $request->state_id;
    		$customerUser->country_id = $request->country_id;
    		$customerUser->phone_number = $request->mobile;
    		$customerUser->password = Hash::make($request->password);
    		$customerUser->remember_token = $token;
    		$customerUser->district = $request->district;
            $customerUser->pincode_number = $request->pincode_number;
    		$customerUser->status = 0;
    		$customerUser->save();
    		
    // 		$mailData = [
    //             'name' => $request->name,
    //             'token' => $token,
    //             'content' => "Please confirm that you want to use this as your customer account email address. Once it's done you will be able to start selling!",
    //         ];
            
                $EmailContent =  EmailContent::where('status',config('constants.MAIL_TEMPLATE.CUSTOMER_REGISETR'))->where('id',1)->first();
                $username = $request->name;
                $url = route('customer.approval', $token);
                
                if(is_object($EmailContent)){
                    $content = $EmailContent->content;
                    $content = str_replace('{{USER}}',$username,$content);
                    $content = str_replace('{{VERIFYLINK}}',$url,$content);
                    $mailData = [
                                'title' => $EmailContent->title,
                                'body' => $content,
                                'subject' => $EmailContent->subject
                            ];
               } else {
                    $mailData = [
                        'title' => 'Customer Sign Up',
                        'body' => 'Please confirm that you want to use this as your Customer account email address. Once its done you will be able to start access!: <a href="'.$url.'">Verify</a>',
                        'subject' => 'Customer Sign Up',
                    ];
               }
               
            Mail::to($request->email)->send(new ApprovalMail($mailData));
    
            return redirect('/customer/login')->with('success', "Please verify your email.");
        }
        return redirect()->back()->with('error', 'Something went wrong.');
    }
    
    public function approval($token) {
        
          $customerUser = CustomerUser::where('remember_token',$token)->first();
          $customerUser->status = 1;
          $customerUser->email_verified_at = date('Y-m-d H:i:s');
          $customerUser->save();
          
          return redirect('/customer/login')->with('success', "your account verified successfully");
    }
    
}








