<?php

namespace App\Http\Controllers\Customer;

use App\Helper\Helpers;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Reminder;
use App\Models\ReminderCustomerDocument;
use Datatables;
use App\Http\Requests\ImageUploadRequest;
use App\Models\EmailContent;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Session;
use Illuminate\Validation\ValidationException;
use App\Mail\EmailTemplete;

class CustomerDocumentController extends Controller
{
    public function index(Request $request)
    {
        $customer_id = Session::get('customerlogin');
        if ($request->ajax()) {

            //$reminder_detail = ReminderCustomerDocument::with('Reminder')->where('reminder_customer_documents.customer_id', $customer_id)->get();//->orderBy('reminder_customer_documents.id', 'DESC')->groupBy('reminder_id')
            //$reminder_ids = ReminderCustomerDocument::orderByDesc('created_at')->get()->toArray()->groupBy('reminder_id')->map(fn($type) => $type->pluck('reminder_id'));
            $reminder_ids = ReminderCustomerDocument::where('customer_id', $customer_id)->get()->pluck('reminder_id')->toArray();//->groupBy('reminder_id')
            //print_r($reminder_ids);
            $reminder_ids = array_unique($reminder_ids);
            $reminder_detail = Reminder::whereIn('id', $reminder_ids)->where('status', 1)->get();
            return datatables()->of($reminder_detail)
                ->addColumn('action', function ($row) {
                    $html = '<a href="' . route('customer.document.detail', $row->id) . '" class="btn badge-info text-white btn-sm"><i class="fa fa-eye"></i> View</a> ';
                    return $html;
                })->addColumn('date', function ($row) {
                    $date = '';
                    if (!empty($row->updated_at)) {
                        $date = date('Y-m-d', strtotime($row->updated_at));
                    }
                    return $date;
                })->addColumn('status', function ($row) use($customer_id) {
                    $total_document = Helpers::GetTotalDocument($row->id,$customer_id);
                    $Uploaded_document = Helpers::GetUploadedDocument($row->id,$customer_id);
                    $Pending_document = Helpers::GetPendingDocument($row->id,$customer_id);
                    return '<b>Total</b>:'.$total_document.'<br>'.'<b>Uploaded</b>:'.$Uploaded_document.'<br>'.'<b>Pending</b>:'.$Pending_document;
                })->addColumn('reminder_name', function ($row) {
                    $name = $row->name;
                    $description = $row->description;
                    return $name.'<br><small>'.$description.'</small>';
                }) ->rawColumns(['status','action','reminder_name'])->toJson();
        }
        $return_data = array();
        $return_data['page_condition'] = 'document_page';
        $return_data['site_title'] = 'Document | ' . config('constants.SITE_NAME');
        return view('customer.document.index', array_merge($return_data));
    }

    public function detail($reminder_id)
    {
        $customer_id = Session::get('customerlogin');
        $return_data = array();
        $reminder_detail = Reminder::find($reminder_id);
        $return_data['reminder_detail'] = $reminder_detail;
        $document_list = ReminderCustomerDocument::with('Document')->where('customer_id',$customer_id)->where('reminder_id',$reminder_id)->get();
        $return_data['document_list'] = $document_list;
        $return_data['page_condition'] = 'document_page';
        $return_data['reminder_id'] = $reminder_id;
        $return_data['document_attachment'] = 'images/'.config('constants.DOCUMENT');
        $return_data['site_title'] = 'Document | ' . config('constants.SITE_NAME');
        return view('customer.document.detail', array_merge($return_data));
    }
    public function postdetail (Request $request,$reminder_id){
        /*$customer_id = Session::get('customerlogin');
        $upload_document = $request->file('upload_document');            
        $destinationPath = public_path('images').config('constants.DOCUMENT');
        if($upload_document){
            $ids = array();
            foreach($upload_document as $key=>$image){
                $org_upload_document = $image->getClientOriginalName();
                if($org_upload_document != ''){
                    $ids[] = $key;
                    $upload_document = 'document-'.$key.'-'.time().'.'.$image->getClientOriginalExtension();
                    $image->move($destinationPath, $upload_document);
                    ReminderCustomerDocument::withTrashed()->where('id',$key)->where('customer_id',$customer_id)->update(['status' => 0,'org_upload_document' => $org_upload_document,'upload_document' => $upload_document,'upload_datetime' => date('Y-m-d H:i:s')]);
                }    
            }
            /////////////////////////////////////
            $EmailContent =  EmailContent::where('status','1')->where('id',config('constants.MAIL_TEMPLATE.Doument_Upload'))->first();
            $reminder_document_detail = ReminderCustomerDocument::with('CustomerUser')->with('Reminder')->with('Document')->whereIn('id', $ids)->where('customer_id',$customer_id)->first();//->where('id',$key)
            if(is_object($EmailContent) && is_object($reminder_document_detail)){
                $list_of_docs = '';
                if($reminder_document_detail->Document){
                    $list_of_docs .= $reminder_document_detail->Document->name.'<br>';
                }
                $reminder_name = '';
                $send_email = '';
                if($reminder_document_detail->Reminder){
                    $reminder_name = $reminder_document_detail->Reminder->name;
                    $send_email = $reminder_document_detail->Reminder->from_email;
                }
                $customer_name = '';
                if($reminder_document_detail->CustomerUser){
                    $customer_name = $reminder_document_detail->CustomerUser->name;
                }
                if($list_of_docs != '' && $send_email != ''){
                    $list_of_docs .= '<br><a href="' . route('customer.user.reminder_detail', array('customer_id'=>$customer_id,'reminder_id'=>$reminder_id)) . '">Click Here</a> ';
                    $email_body = $EmailContent->content;
                    $email_body = str_replace('{{DOCUMENTNAME}}',$list_of_docs,$email_body);
                    $email_body = str_replace('{{ReminderName}}',$reminder_name,$email_body);
                    $email_body = str_replace('{{CustomerName}}',$customer_name,$email_body);
                    $files = array();
                    if($reminder_document_detail->upload_document != ''){
                        $files[] = $destinationPath.$reminder_document_detail->upload_document;
                    }
                    $mailData = [
                        'from_email' => '',
                        'title' => $EmailContent->title,
                        'body' => $email_body,
                        'subject' => $EmailContent->subject,
                        'files' => $files
                    ];
                    Mail::to($send_email)->send(new EmailTemplete($mailData));
                } 
            }
            /////////////////////////////////////
        }*/
        return redirect(route('customer.document.postdetail',$reminder_id))->with('success_message', trans('Update Successfully'));
    }
}

