<?php

namespace App\Http\Controllers\Customer;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB; 
use App\Models\CustomerUser;
use App\Models\City;
use App\Models\Country;
use App\Models\Wallet;
use App\Models\WalletHistory;

class CustomerUserController extends Controller
{

    public function changePassword(Request $request)
    {
        $return_data = array();
        $return_data['page_condition'] = 'changepassword_page';
        $return_data['site_title'] = 'Change Password | ' . config('constants.SITE_NAME');
        return view('customer/users/changepassword', array_merge($return_data));
        // return view('admin/admin_users.changepassword');
    }
    
	public function postchangePassword(Request $request)
    {
        
        $this->validate($request, [
            'current_password' => 'required|string',
            'new_password' => 'required|without_spaces|min:6|string|confirmed'
        ],
        [
            'new_password.required' => 'The password is required.',
            'new_password.without_spaces' => 'The password does not allowed white space.',    
        ]);
        $customer_email = Session::get('customer_email');
        $auth = CustomerUser::where('email_address' ,$customer_email)->first();
        if (!Hash::check($request->get('current_password'), $auth->password)){
            return back()->withInput()->with('error_current_password', "Current Password is Invalid");
        }
        if (strcmp($request->get('current_password'), $request->new_password) == 0){
            return back()->withInput()->with("error_not_match", "New Password cannot be same as your current password.");
        }
        $user =  CustomerUser::find($auth->id);
        $user->password =  Hash::make($request->new_password);
        $user->save();
        return back()->with('success_message', "Password Changed Successfully");
    }
    
    public function profile()
    {
        $user_id = Session::get('customerlogin');
        $customer_user = CustomerUser::find($user_id);
        $city = City::where('status','1')->get();
        $country = Country::get();
        $return_data = array();
        $return_data['city'] = $city;
        $return_data['country'] = $country;
        $return_data['customer_user'] = $customer_user;
        $return_data['page_condition'] = 'edit_profile';
        $return_data['site_title'] = 'Edit Profile | ' . config('constants.SITE_NAME');
        return view('customer/users/profile', array_merge($return_data));
    }
    
    public function profileUpdate(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|max:255',
            'phone_number' => 'required|min:10|max:10',
            'country' => 'required',
            'state' => 'required',
            'city' => 'required',
            'district' => 'required|max:255',
            'pincode_number' => 'required|max:6|min:6',
            
        ],
        [
            'name.required' => 'The name is required.',
            'phone_number.required' => 'The phone number is required.',
            'phone_number.max' => 'The phone number should be 10 digits.', 
            'phone_number.min' => 'The phone number should be 10 digits.',
            'country.required' => 'The country is required.',
            'state.required' => 'The state is required.',
            'city.required' => 'The city is required.',
            'district.required' => 'The district is required.',
            'pincode_number.required' => 'The pin code number is required.',
            'pincode_number.min' => 'The pin code number should be 6 digits.',
            'pincode_number.max' => 'The pin code number should be 6 digits.', 
            
        ]);
        
        $user_id = $request->user_id;
        $customer_user = CustomerUser::find($user_id);
        $customer_user->name = $request->name;
        $customer_user->address = $request->address;
        $customer_user->phone_number = $request->phone_number;
        $customer_user->city_id = $request->city;
        $customer_user->country_id = $request->country;
        $customer_user->state_id = $request->state;
        $customer_user->district = $request->district;
        $customer_user->pincode_number = $request->pincode_number;

        $customer_user->save();
        
        return back()->with('success_message', "Profile Updated Successfully");
    }

    public function Walllet()
    {
        $return_data = array();
        $customer_user_id = Session::get('customerlogin');
        $Wallet = Wallet::with('WalletHistory','WalletHistory.Order')->where('customer_user_id',$customer_user_id)->first();
        $WalletHistory = is_object($Wallet) ? WalletHistory::with('Order')->where('wallet_id',$Wallet->id)->paginate(10) : [];
        $return_data['Wallet'] = $Wallet;
        $return_data['WalletHistory'] = $WalletHistory;
        $return_data['page_condition'] = 'wallet_page';
        $return_data['site_title'] = 'Wallet | ' . config('constants.SITE_NAME');
        return view('customer/wallet/index', array_merge($return_data));
    }
}