<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use App\Rules\MaxImagesPerProduct;

class ImageUploadRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'image' => ['required', 'array', new MaxImagesPerProduct($this->route('product'))],
            'image.*' => 'image|mimes:jpeg,png,jpg,',
        ];
    }

    public function messages()
    {
        return [
            // 'images.required' => 'Please upload at least one image.',
            // 'image.array' => 'Images should be an array.',
            'image.*.image' => 'Each file must be an image.',
            // 'image.*.mimes' => 'Allowed image types are jpeg, png, jpg, gif, svg.',
            // 'image.*.max' => 'Each image may not be greater than 2048 kilobytes.',
            'image.required' => 'The image is required.',
            'image.*.mimes' => 'The image must be a file of type: JPEG, PNG, or JPG.',
        ];
    }
}
