<?php
  
namespace App\Imports;
  
use App\Models\CustomerUser;
use App\Models\CustomerContactDetail;
use App\Models\Country;
use App\Models\Group;
use App\Models\State;
use App\Models\City;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithValidation;
use Maatwebsite\Excel\Events\BeforeImport;
use Hash;
use RegistersEventListeners;
  
class CustomerUserImport implements ToModel, WithHeadingRow, WithValidation
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
	private $allRows = []; // Property to store all rows
	private $RowData;
	public function registerEvents(): array
    {
        return [
            BeforeImport::class => function (BeforeImport $event) {
                // Capture all rows, including headers
                $sheet = $event->reader->getActiveSheet();
				$this->allRows = $sheet->toArray(null, true, true, true); // Headers as keys
            },
        ];
    }
    public function model(array $row)
    {
		// echo '<pre>';
		// print_r($row);
		// exit;
		$country = isset($row['country']) ? $row['country'] : 'India';
		$state = isset($row['state']) ? $row['state'] : 'Gujarat';
		$CountryDetail =  Country::select('id')->where('name',$country)->first();
		if($CountryDetail){
			$country_id = $CountryDetail->id;
		}else{
			$inset_data = new Country();
            $inset_data->name = $country;
            $inset_data->status = 1;
            $inset_data->save();
			$country_id = $inset_data->id;
		}
		$StateDetail =  State::select('id')->where('country_id',$country_id)->where('name',$state)->first();
		if($StateDetail){
			$state_id = $StateDetail->id;
		}else{
			$inset_data = new State();
			$inset_data->country_id = $country_id;
            $inset_data->name = $state;
            $inset_data->status = 1;
            $inset_data->save();
			$state_id = $inset_data->id;
		}
		$city_id = 0;
		$password = 123456;
		$group_name = isset($row['group_name']) ? $row['group_name'] : '';
		$GroupDetail =  Group::select('id')->where('name',$group_name)->first();
		if($GroupDetail){
			$group_id = $GroupDetail->id;
		}else{
			$inset_data = new Group();
            $inset_data->name = $group_name;
            $inset_data->status = 1;
            $inset_data->save();
			$group_id = $inset_data->id;
		}
		// echo '<pre>';
		// print_r($row['phone_number']);
		$excel_date = $row['year_end_dateddmmyyyy'];
		if($excel_date != ''){
			//$year_end_dateddmmyyyy = date('Y-m-d',strtotime($year_end_dateddmmyyyy));
			$unix_date = ($excel_date - 25569) * 86400;
			$excel_date = 25569 + ($unix_date / 86400);
			$unix_date = ($excel_date - 25569) * 86400;
			$excel_date = gmdate("Y-m-d", $unix_date);
		}
		$customerUser = new CustomerUser();
		$customerUser->group_id = $group_id;
		$customerUser->name = $row['name'];
		$customerUser->address = $row['address_line_1'];
		$customerUser->address_2 = $row['address_line_2'];
		$customerUser->address_3 = $row['address_line_3'];
		$customerUser->country_id = $country_id;
		$customerUser->state_id = $state_id;
		$customerUser->city_id = $city_id;
		$customerUser->district = '';
		$customerUser->pincode_number = '';
		$customerUser->phonecode = $row['phone_number_code'];
		$customerUser->phone_number = $row['phone_number'];
		$customerUser->email_address = $row['email'];
		$customerUser->password = Hash::make($password);
		$customerUser->year_end = $excel_date;
		$customerUser->status = 1;
		$customerUser->sequence = 1;
		$customerUser->save();
		$id = $customerUser->id;
		$contact_detail_name_1 = isset($row['contact_detail_name_1']) ? $row['contact_detail_name_1'] : '';
		$contact_detail_email_1 = isset($row['contact_detail_email_1']) ? $row['contact_detail_email_1'] : '';
		$contact_detail_phone_number_code_1 = isset($row['contact_detail_phone_number_code_1']) ? $row['contact_detail_phone_number_code_1'] : '';
		$contact_detail_phone_number_1 = isset($row['contact_detail_phone_number_1']) ? $row['contact_detail_phone_number_1'] : '';
		if($contact_detail_name_1 != '' && $contact_detail_email_1 != ''){
			$contact_detail_detail = new CustomerContactDetail();
			$contact_detail_detail->customer_id = $id;
			$contact_detail_detail->name = $contact_detail_name_1;
			$contact_detail_detail->email = $contact_detail_email_1;
			$contact_detail_detail->phonecode = $contact_detail_phone_number_code_1;
			$contact_detail_detail->mobile_number = $contact_detail_phone_number_1;
			$contact_detail_detail->save();
		}
		$contact_detail_name_2 = isset($row['contact_detail_name_2']) ? $row['contact_detail_name_2'] : '';
		$contact_detail_email_2 = isset($row['contact_detail_email_2']) ? $row['contact_detail_email_2'] : '';
		$contact_detail_phone_number_code_2 = isset($row['contact_detail_phone_number_code_2']) ? $row['contact_detail_phone_number_code_2'] : '';
		$contact_detail_phone_number_2 = isset($row['contact_detail_phone_number_2']) ? $row['contact_detail_phone_number_2'] : '';
		if($contact_detail_name_2 != '' && $contact_detail_email_2 != ''){
			$contact_detail_detail = new CustomerContactDetail();
			$contact_detail_detail->customer_id = $id;
			$contact_detail_detail->name = $contact_detail_name_2;
			$contact_detail_detail->email = $contact_detail_email_2;
			$contact_detail_detail->phonecode = $contact_detail_phone_number_code_2;
			$contact_detail_detail->mobile_number = $contact_detail_phone_number_2;
			$contact_detail_detail->save();
		}
		$contact_detail_name_3 = isset($row['contact_detail_name_3']) ? $row['contact_detail_name_3'] : '';
		$contact_detail_email_3 = isset($row['contact_detail_email_3']) ? $row['contact_detail_email_3'] : '';
		$contact_detail_phone_number_code_3 = isset($row['contact_detail_phone_number_code_3']) ? $row['contact_detail_phone_number_code_3'] : '';
		$contact_detail_phone_number_3 = isset($row['contact_detail_phone_number_3']) ? $row['contact_detail_phone_number_3'] : '';
		if($contact_detail_name_3 != '' && $contact_detail_email_3 != ''){
			$contact_detail_detail = new CustomerContactDetail();
			$contact_detail_detail->customer_id = $id;
			$contact_detail_detail->name = $contact_detail_name_3;
			$contact_detail_detail->email = $contact_detail_email_3;
			$contact_detail_detail->phonecode = $contact_detail_phone_number_code_3;
			$contact_detail_detail->mobile_number = $contact_detail_phone_number_3;
			$contact_detail_detail->save();
		}
		$contact_detail_name_4 = isset($row['contact_detail_name_4']) ? $row['contact_detail_name_4'] : '';
		$contact_detail_email_4 = isset($row['contact_detail_email_4']) ? $row['contact_detail_email_4'] : '';
		$contact_detail_phone_number_code_4 = isset($row['contact_detail_phone_number_code_4']) ? $row['contact_detail_phone_number_code_4'] : '';
		$contact_detail_phone_number_4 = isset($row['contact_detail_phone_number_4']) ? $row['contact_detail_phone_number_4'] : '';
		if($contact_detail_name_4 != '' && $contact_detail_email_4 != ''){
			$contact_detail_detail = new CustomerContactDetail();
			$contact_detail_detail->customer_id = $id;
			$contact_detail_detail->name = $contact_detail_name_4;
			$contact_detail_detail->email = $contact_detail_email_4;
			$contact_detail_detail->phonecode = $contact_detail_phone_number_code_4;
			$contact_detail_detail->mobile_number = $contact_detail_phone_number_4;
			$contact_detail_detail->save();
		}
		$contact_detail_name_5 = isset($row['contact_detail_name_5']) ? $row['contact_detail_name_5'] : '';
		$contact_detail_email_5 = isset($row['contact_detail_email_5']) ? $row['contact_detail_email_5'] : '';
		$contact_detail_phone_number_code_5 = isset($row['contact_detail_phone_number_code_5']) ? $row['contact_detail_phone_number_code_5'] : '';
		$contact_detail_phone_number_5 = isset($row['contact_detail_phone_number_5']) ? $row['contact_detail_phone_number_5'] : '';
		if($contact_detail_name_5 != '' && $contact_detail_email_5 != ''){
			$contact_detail_detail = new CustomerContactDetail();
			$contact_detail_detail->customer_id = $id;
			$contact_detail_detail->name = $contact_detail_name_5;
			$contact_detail_detail->email = $contact_detail_email_5;
			$contact_detail_detail->phonecode = $contact_detail_phone_number_code_5;
			$contact_detail_detail->mobile_number = $contact_detail_phone_number_5;
			$contact_detail_detail->save();
		}
		$contact_detail_name_6 = isset($row['contact_detail_name_6']) ? $row['contact_detail_name_6'] : '';
		$contact_detail_email_6 = isset($row['contact_detail_email_6']) ? $row['contact_detail_email_6'] : '';
		$contact_detail_phone_number_code_6 = isset($row['contact_detail_phone_number_code_6']) ? $row['contact_detail_phone_number_code_6'] : '';
		$contact_detail_phone_number_6 = isset($row['contact_detail_phone_number_6']) ? $row['contact_detail_phone_number_6'] : '';
		if($contact_detail_name_6 != '' && $contact_detail_email_6 != ''){
			$contact_detail_detail = new CustomerContactDetail();
			$contact_detail_detail->customer_id = $id;
			$contact_detail_detail->name = $contact_detail_name_6;
			$contact_detail_detail->email = $contact_detail_email_6;
			$contact_detail_detail->phonecode = $contact_detail_phone_number_code_6;
			$contact_detail_detail->mobile_number = $contact_detail_phone_number_6;
			$contact_detail_detail->save();
		}
		$contact_detail_name_7 = isset($row['contact_detail_name_7']) ? $row['contact_detail_name_7'] : '';
		$contact_detail_email_7 = isset($row['contact_detail_email_7']) ? $row['contact_detail_email_7'] : '';
		$contact_detail_phone_number_code_7 = isset($row['contact_detail_phone_number_code_7']) ? $row['contact_detail_phone_number_code_7'] : '';
		$contact_detail_phone_number_7 = isset($row['contact_detail_phone_number_7']) ? $row['contact_detail_phone_number_7'] : '';
		if($contact_detail_name_7 != '' && $contact_detail_email_7 != ''){
			$contact_detail_detail = new CustomerContactDetail();
			$contact_detail_detail->customer_id = $id;
			$contact_detail_detail->name = $contact_detail_name_7;
			$contact_detail_detail->email = $contact_detail_email_7;
			$contact_detail_detail->phonecode = $contact_detail_phone_number_code_7;
			$contact_detail_detail->mobile_number = $contact_detail_phone_number_7;
			$contact_detail_detail->save();
		}
		$contact_detail_name_8 = isset($row['contact_detail_name_8']) ? $row['contact_detail_name_8'] : '';
		$contact_detail_email_8 = isset($row['contact_detail_email_8']) ? $row['contact_detail_email_8'] : '';
		$contact_detail_phone_number_code_8 = isset($row['contact_detail_phone_number_code_8']) ? $row['contact_detail_phone_number_code_8'] : '';
		$contact_detail_phone_number_8 = isset($row['contact_detail_phone_number_8']) ? $row['contact_detail_phone_number_8'] : '';
		if($contact_detail_name_8 != '' && $contact_detail_email_8 != ''){
			$contact_detail_detail = new CustomerContactDetail();
			$contact_detail_detail->customer_id = $id;
			$contact_detail_detail->name = $contact_detail_name_8;
			$contact_detail_detail->email = $contact_detail_email_8;
			$contact_detail_detail->phonecode = $contact_detail_phone_number_code_8;
			$contact_detail_detail->mobile_number = $contact_detail_phone_number_8;
			$contact_detail_detail->save();
		}
		$contact_detail_name_9 = isset($row['contact_detail_name_9']) ? $row['contact_detail_name_9'] : '';
		$contact_detail_email_9 = isset($row['contact_detail_email_9']) ? $row['contact_detail_email_9'] : '';
		$contact_detail_phone_number_code_9 = isset($row['contact_detail_phone_number_code_9']) ? $row['contact_detail_phone_number_code_9'] : '';
		$contact_detail_phone_number_9 = isset($row['contact_detail_phone_number_9']) ? $row['contact_detail_phone_number_9'] : '';
		if($contact_detail_name_9 != '' && $contact_detail_email_9 != ''){
			$contact_detail_detail = new CustomerContactDetail();
			$contact_detail_detail->customer_id = $id;
			$contact_detail_detail->name = $contact_detail_name_9;
			$contact_detail_detail->email = $contact_detail_email_9;
			$contact_detail_detail->phonecode = $contact_detail_phone_number_code_9;
			$contact_detail_detail->mobile_number = $contact_detail_phone_number_9;
			$contact_detail_detail->save();
		}
		$contact_detail_name_10 = isset($row['contact_detail_name_10']) ? $row['contact_detail_name_10'] : '';
		$contact_detail_email_10 = isset($row['contact_detail_email_10']) ? $row['contact_detail_email_10'] : '';
		$contact_detail_phone_number_code_10 = isset($row['contact_detail_phone_number_code_10']) ? $row['contact_detail_phone_number_code_10'] : '';
		$contact_detail_phone_number_10 = isset($row['contact_detail_phone_number_10']) ? $row['contact_detail_phone_number_10'] : '';
		if($contact_detail_name_10 != '' && $contact_detail_email_10 != ''){
			$contact_detail_detail = new CustomerContactDetail();
			$contact_detail_detail->customer_id = $id;
			$contact_detail_detail->name = $contact_detail_name_10;
			$contact_detail_detail->email = $contact_detail_email_10;
			$contact_detail_detail->phonecode = $contact_detail_phone_number_code_10;
			$contact_detail_detail->mobile_number = $contact_detail_phone_number_10;
			$contact_detail_detail->save();
		}
    }
	public function rules(): array
    {
		$id = 0;
		$phonecodedigit = 0;
		//dd();
		return [
            'group_name' => "required",
			'name' => "required",
			'country' => "required",
			'state' => "required",
			//'city' => "required",
			//'district' => 'max:255',//required|
			//'pin_code_number' => 'required|max:6|min:6',
			//'phone_number_code' => "required",
			//'phone_number' => "required|digits:".$phonecodedigit,
			'email' => "required|email|unique:customer_users,email_address," . $id . ",id,deleted_at,NULL",
			//'password' => "required|min:6|without_spaces",
             // Can also use callback validation rules
            'phone_number_code' => [
				'required',
				function ($attribute, $phone_number_code, $fail) {
					$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$phone_number_code.'%')->first();
					$phonecodedigit = 0;
					if($countryphonecode_detail){
						$phonecodedigit = $countryphonecode_detail->phonecodedigit;
					}else{
						$fail('The phone number code not found.');
					}
				},
			],
			'phone_number' => [
				'required',
				'integer',
				function ($attribute, $phone_number, $fail) {
					$phone_number_code = $this->RowData['phone_number_code'];
					$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$phone_number_code.'%')->first();
					$phonecodedigit = 0;
					if($countryphonecode_detail){
						$phonecodedigit = $countryphonecode_detail->phonecodedigit;
						if ($phonecodedigit > 0 && ($phonecodedigit != strlen($phone_number))) {
							$fail('The mobile number must be '.$phonecodedigit.' digits.');
						}
					}
				},
			],
			///1////////////////////////////////////////////////////
			'contact_detail_phone_number_code_1' => [
				function ($attribute, $contact_detail_phone_number_code_1, $fail) {
					$contact_detail_phone_number_1 = $this->RowData['contact_detail_phone_number_1'];
					if($contact_detail_phone_number_1 != ''){
						$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$contact_detail_phone_number_code_1.'%')->first();
						$phonecodedigit = 0;
						if($countryphonecode_detail){
							$phonecodedigit = $countryphonecode_detail->phonecodedigit;
						}else{
							$fail('The Contact Detail Phone Number Code 1 not found.');
						}
					}	
				},
			],
			'contact_detail_phone_number_1' => [
				'nullable',
				'integer',
				function ($attribute, $contact_detail_phone_number_1, $fail) {
					$contact_detail_phone_number_code_1 = $this->RowData['contact_detail_phone_number_code_1'];
					if($contact_detail_phone_number_1 != ''){
						$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$contact_detail_phone_number_code_1.'%')->first();
						$phonecodedigit = 0;
						if($countryphonecode_detail){
							$phonecodedigit = $countryphonecode_detail->phonecodedigit;
							if ($phonecodedigit > 0 && ($phonecodedigit != strlen($contact_detail_phone_number_1))) {
								$fail('The Contact Detail Phone Number 1 must be '.$phonecodedigit.' digits.');
							}
						}
					}	
				},
			],
			///2////////////////////////////////////////////////////
			'contact_detail_phone_number_code_2' => [
				function ($attribute, $contact_detail_phone_number_code_2, $fail) {
					$contact_detail_phone_number_2 = $this->RowData['contact_detail_phone_number_2'];
					if($contact_detail_phone_number_2 != ''){
						$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$contact_detail_phone_number_code_2.'%')->first();
						$phonecodedigit = 0;
						if($countryphonecode_detail){
							$phonecodedigit = $countryphonecode_detail->phonecodedigit;
						}else{
							$fail('The Contact Detail Phone Number Code 2 not found.');
						}
					}	
				},
			],
			'contact_detail_phone_number_2' => [
				'nullable',
				'integer',
				function ($attribute, $contact_detail_phone_number_2, $fail) {
					$contact_detail_phone_number_code_2 = $this->RowData['contact_detail_phone_number_code_2'];
					if($contact_detail_phone_number_2 != ''){
						$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$contact_detail_phone_number_code_2.'%')->first();
						$phonecodedigit = 0;
						if($countryphonecode_detail){
							$phonecodedigit = $countryphonecode_detail->phonecodedigit;
							if ($phonecodedigit > 0 && ($phonecodedigit != strlen($contact_detail_phone_number_2))) {
								$fail('The Contact Detail Phone Number 2 must be '.$phonecodedigit.' digits.');
							}
						}
					}	
				},
			],
			///3////////////////////////////////////////////////////
			'contact_detail_phone_number_code_3' => [
				function ($attribute, $contact_detail_phone_number_code_3, $fail) {
					$contact_detail_phone_number_3 = $this->RowData['contact_detail_phone_number_3'];
					if($contact_detail_phone_number_3 != ''){
						$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$contact_detail_phone_number_code_3.'%')->first();
						$phonecodedigit = 0;
						if($countryphonecode_detail){
							$phonecodedigit = $countryphonecode_detail->phonecodedigit;
						}else{
							$fail('The Contact Detail Phone Number Code 3 not found.');
						}
					}	
				},
			],
			'contact_detail_phone_number_3' => [
				'nullable',
				'integer',
				function ($attribute, $contact_detail_phone_number_3, $fail) {
					$contact_detail_phone_number_code_3 = $this->RowData['contact_detail_phone_number_code_3'];
					if($contact_detail_phone_number_3 != ''){
						$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$contact_detail_phone_number_code_3.'%')->first();
						$phonecodedigit = 0;
						if($countryphonecode_detail){
							$phonecodedigit = $countryphonecode_detail->phonecodedigit;
							if ($phonecodedigit > 0 && ($phonecodedigit != strlen($contact_detail_phone_number_3))) {
								$fail('The Contact Detail Phone Number 3 must be '.$phonecodedigit.' digits.');
							}
						}
					}	
				},
			],
			////4///////////////////////////////////////////////////
			'contact_detail_phone_number_code_4' => [
				function ($attribute, $contact_detail_phone_number_code_4, $fail) {
					$contact_detail_phone_number_4 = $this->RowData['contact_detail_phone_number_4'];
					if($contact_detail_phone_number_4 != ''){
						$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$contact_detail_phone_number_code_4.'%')->first();
						$phonecodedigit = 0;
						if($countryphonecode_detail){
							$phonecodedigit = $countryphonecode_detail->phonecodedigit;
						}else{
							$fail('The Contact Detail Phone Number Code 4 not found.');
						}
					}	
				},
			],
			'contact_detail_phone_number_4' => [
				'nullable',
				'integer',
				function ($attribute, $contact_detail_phone_number_4, $fail) {
					$contact_detail_phone_number_code_4 = $this->RowData['contact_detail_phone_number_code_4'];
					if($contact_detail_phone_number_4 != ''){
						$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$contact_detail_phone_number_code_4.'%')->first();
						$phonecodedigit = 0;
						if($countryphonecode_detail){
							$phonecodedigit = $countryphonecode_detail->phonecodedigit;
							if ($phonecodedigit > 0 && ($phonecodedigit != strlen($contact_detail_phone_number_4))) {
								$fail('The Contact Detail Phone Number 4 must be '.$phonecodedigit.' digits.');
							}
						}
					}	
				},
			],
			///5////////////////////////////////////////////////////
			'contact_detail_phone_number_code_5' => [
				function ($attribute, $contact_detail_phone_number_code_5, $fail) {
					$contact_detail_phone_number_5 = $this->RowData['contact_detail_phone_number_5'];
					if($contact_detail_phone_number_5 != ''){
						$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$contact_detail_phone_number_code_5.'%')->first();
						$phonecodedigit = 0;
						if($countryphonecode_detail){
							$phonecodedigit = $countryphonecode_detail->phonecodedigit;
						}else{
							$fail('The Contact Detail Phone Number Code 5 not found.');
						}
					}	
				},
			],
			'contact_detail_phone_number_5' => [
				'nullable',
				'integer',
				function ($attribute, $contact_detail_phone_number_5, $fail) {
					$contact_detail_phone_number_code_5 = $this->RowData['contact_detail_phone_number_code_5'];
					if($contact_detail_phone_number_5 != ''){
						$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$contact_detail_phone_number_code_5.'%')->first();
						$phonecodedigit = 0;
						if($countryphonecode_detail){
							$phonecodedigit = $countryphonecode_detail->phonecodedigit;
							if ($phonecodedigit > 0 && ($phonecodedigit != strlen($contact_detail_phone_number_5))) {
								$fail('The Contact Detail Phone Number 5 must be '.$phonecodedigit.' digits.');
							}
						}
					}	
				},
			],
			///6////////////////////////////////////////////////////
			'contact_detail_phone_number_code_6' => [
				function ($attribute, $contact_detail_phone_number_code_6, $fail) {
					$contact_detail_phone_number_6 = $this->RowData['contact_detail_phone_number_6'];
					if($contact_detail_phone_number_6 != ''){
						$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$contact_detail_phone_number_code_6.'%')->first();
						$phonecodedigit = 0;
						if($countryphonecode_detail){
							$phonecodedigit = $countryphonecode_detail->phonecodedigit;
						}else{
							$fail('The Contact Detail Phone Number Code 6 not found.');
						}
					}	
				},
			],
			'contact_detail_phone_number_6' => [
				'nullable',
				'integer',
				function ($attribute, $contact_detail_phone_number_6, $fail) {
					$contact_detail_phone_number_code_6 = $this->RowData['contact_detail_phone_number_code_6'];
					if($contact_detail_phone_number_6 != ''){
						$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$contact_detail_phone_number_code_6.'%')->first();
						$phonecodedigit = 0;
						if($countryphonecode_detail){
							$phonecodedigit = $countryphonecode_detail->phonecodedigit;
							if ($phonecodedigit > 0 && ($phonecodedigit != strlen($contact_detail_phone_number_6))) {
								$fail('The Contact Detail Phone Number 6 must be '.$phonecodedigit.' digits.');
							}
						}
					}	
				},
			],
			///7////////////////////////////////////////////////////
			'contact_detail_phone_number_code_7' => [
				function ($attribute, $contact_detail_phone_number_code_7, $fail) {
					$contact_detail_phone_number_7 = $this->RowData['contact_detail_phone_number_7'];
					if($contact_detail_phone_number_7 != ''){
						$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$contact_detail_phone_number_code_7.'%')->first();
						$phonecodedigit = 0;
						if($countryphonecode_detail){
							$phonecodedigit = $countryphonecode_detail->phonecodedigit;
						}else{
							$fail('The Contact Detail Phone Number Code 7 not found.');
						}
					}	
				},
			],
			'contact_detail_phone_number_7' => [
				'nullable',
				'integer',
				function ($attribute, $contact_detail_phone_number_7, $fail) {
					$contact_detail_phone_number_code_7 = $this->RowData['contact_detail_phone_number_code_7'];
					if($contact_detail_phone_number_7 != ''){
						$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$contact_detail_phone_number_code_7.'%')->first();
						$phonecodedigit = 0;
						if($countryphonecode_detail){
							$phonecodedigit = $countryphonecode_detail->phonecodedigit;
							if ($phonecodedigit > 0 && ($phonecodedigit != strlen($contact_detail_phone_number_7))) {
								$fail('The Contact Detail Phone Number 7 must be '.$phonecodedigit.' digits.');
							}
						}
					}	
				},
			],
			///8////////////////////////////////////////////////////
			'contact_detail_phone_number_code_8' => [
				function ($attribute, $contact_detail_phone_number_code_8, $fail) {
					$contact_detail_phone_number_8 = $this->RowData['contact_detail_phone_number_8'];
					if($contact_detail_phone_number_8 != ''){
						$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$contact_detail_phone_number_code_8.'%')->first();
						$phonecodedigit = 0;
						if($countryphonecode_detail){
							$phonecodedigit = $countryphonecode_detail->phonecodedigit;
						}else{
							$fail('The Contact Detail Phone Number Code 8 not found.');
						}
					}	
				},
			],
			'contact_detail_phone_number_8' => [
				'nullable',
				'integer',
				function ($attribute, $contact_detail_phone_number_8, $fail) {
					$contact_detail_phone_number_code_8 = $this->RowData['contact_detail_phone_number_code_8'];
					if($contact_detail_phone_number_8 != ''){
						$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$contact_detail_phone_number_code_8.'%')->first();
						$phonecodedigit = 0;
						if($countryphonecode_detail){
							$phonecodedigit = $countryphonecode_detail->phonecodedigit;
							if ($phonecodedigit > 0 && ($phonecodedigit != strlen($contact_detail_phone_number_8))) {
								$fail('The Contact Detail Phone Number 8 must be '.$phonecodedigit.' digits.');
							}
						}
					}	
				},
			],
			///9////////////////////////////////////////////////////
			'contact_detail_phone_number_code_9' => [
				function ($attribute, $contact_detail_phone_number_code_9, $fail) {
					$contact_detail_phone_number_9 = $this->RowData['contact_detail_phone_number_9'];
					if($contact_detail_phone_number_9 != ''){
						$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$contact_detail_phone_number_code_9.'%')->first();
						$phonecodedigit = 0;
						if($countryphonecode_detail){
							$phonecodedigit = $countryphonecode_detail->phonecodedigit;
						}else{
							$fail('The Contact Detail Phone Number Code 9 not found.');
						}
					}	
				},
			],
			'contact_detail_phone_number_9' => [
				'nullable',
				'integer',
				function ($attribute, $contact_detail_phone_number_9, $fail) {
					$contact_detail_phone_number_code_9 = $this->RowData['contact_detail_phone_number_code_9'];
					if($contact_detail_phone_number_9 != ''){
						$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$contact_detail_phone_number_code_9.'%')->first();
						$phonecodedigit = 0;
						if($countryphonecode_detail){
							$phonecodedigit = $countryphonecode_detail->phonecodedigit;
							if ($phonecodedigit > 0 && ($phonecodedigit != strlen($contact_detail_phone_number_9))) {
								$fail('The Contact Detail Phone Number 9 must be '.$phonecodedigit.' digits.');
							}
						}
					}	
				},
			],
			///10////////////////////////////////////////////////////
			'contact_detail_phone_number_code_10' => [
				function ($attribute, $contact_detail_phone_number_code_10, $fail) {
					$contact_detail_phone_number_10 = $this->RowData['contact_detail_phone_number_10'];
					if($contact_detail_phone_number_10 != ''){
						$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$contact_detail_phone_number_code_10.'%')->first();
						$phonecodedigit = 0;
						if($countryphonecode_detail){
							$phonecodedigit = $countryphonecode_detail->phonecodedigit;
						}else{
							$fail('The Contact Detail Phone Number Code 10 not found.');
						}
					}	
				},
			],
			'contact_detail_phone_number_10' => [
				'nullable',
				'integer',
				function ($attribute, $contact_detail_phone_number_10, $fail) {
					$contact_detail_phone_number_code_10 = $this->RowData['contact_detail_phone_number_code_10'];
					if($contact_detail_phone_number_10 != ''){
						$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode','LIKE','%'.$contact_detail_phone_number_code_10.'%')->first();
						$phonecodedigit = 0;
						if($countryphonecode_detail){
							$phonecodedigit = $countryphonecode_detail->phonecodedigit;
							if ($phonecodedigit > 0 && ($phonecodedigit != strlen($contact_detail_phone_number_10))) {
								$fail('The Contact Detail Phone Number 10 must be '.$phonecodedigit.' digits.');
							}
						}
					}	
				},
			],
        ];
    }
	public function prepareForValidation(array $row): array
    {
        // Store current row data for use in the validation logic
        $this->RowData = $row;

        return $row; // Return the row unaltered
    }
	/*public function rules(): array{
		$id = 0;
		$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode',$this->request->get("phone_number_code"))->first();
        $phonecodedigit = 0;
        if($countryphonecode_detail){
            $phonecodedigit = $countryphonecode_detail->phonecodedigit;
        }
		return [
			'group_name' => "required",
			'name' => "required",
			'country' => "required",
			'state' => "required",
			//'city' => "required",
			//'district' => 'max:255',//required|
			//'pin_code_number' => 'required|max:6|min:6',
			'phone_number_code' => "required",
			'phone_number' => "required|digits:".$phonecodedigit,
			'email' => "required|email|unique:customer_users,email_address," . $id . ",id,deleted_at,NULL",
			//'password' => "required|min:6|without_spaces",
		];
	}
		*/

	public function customValidationMessages()
    {
		//$countryphonecode_detail = Country::select('name','phonecode','phonecodedigit')->where('phonecode',$this->phone_number_code)->first();
        $phonecodedigit = 0;
       // if($countryphonecode_detail){
        //    $phonecodedigit = $countryphonecode_detail->phonecodedigit;
       // }
        return [
			'group_name.required' => 'The group name is required.',
            'name.required' => 'The name is required.',
			'country.required' => 'The country is required.',
			'state.required' => 'The state is required.',
			'city.required' => 'The city is required.',
			'district.required' => 'The district is required.',
			'pin_code_number.required' => 'The pin code number is required.',
			'pin_code_number.min' => 'The pin code number should be 6 digits.',
			'pin_code_number.max' => 'The pin code number should be 6 digits.',
			'phonecode.required' => 'The phone code is required.',
			'phone_number.required' => 'The phone number is required.',
			'phone_number.integer' => 'The phone number should be digits.',
			'phone_number.digits' => 'The mobile number must be '.$phonecodedigit.' digits.',
			//'phone_number.min' => 'The phone number should be 10 digits.',
			//'phone_number.max' => 'The phone number should be 10 digits.',
			'email' => 'The email is required.',
			'email.email' => 'Please enter valid email.',
			'email.unique' => 'The email has been already taken.',
			'password.required' => 'The password is required.',
			'password.without_spaces' => 'The password does not allowed white space.',
			'contact_detail_phone_number_1.integer' => 'The Contact Detail Phone Number 1 should be digits.',
			'contact_detail_phone_number_2.integer' => 'The Contact Detail Phone Number 2 should be digits.',
			'contact_detail_phone_number_3.integer' => 'The Contact Detail Phone Number 3 should be digits.',
			'contact_detail_phone_number_4.integer' => 'The Contact Detail Phone Number 4 should be digits.',
			'contact_detail_phone_number_5.integer' => 'The Contact Detail Phone Number 5 should be digits.',
			'contact_detail_phone_number_6.integer' => 'The Contact Detail Phone Number 6 should be digits.',
			'contact_detail_phone_number_7.integer' => 'The Contact Detail Phone Number 7 should be digits.',
			'contact_detail_phone_number_8.integer' => 'The Contact Detail Phone Number 8 should be digits.',
			'contact_detail_phone_number_9.integer' => 'The Contact Detail Phone Number 9 should be digits.',
			'contact_detail_phone_number_10.integer' => 'The Contact Detail Phone Number 10 should be digits.',
        ];
    }
}
