<?php
  
namespace App\Mail;
  
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
  
class EmailTemplete extends Mailable
{
    use Queueable, SerializesModels;
  
    public $mailData;
  
    /**
     * Create a new message instance.
     */

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($mailData)
    {
        $this->mailData = $mailData;
    }
  
    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $data=$this->mailData;
        $subject=$data['subject'];
        $from_email='reminder@bakertilly-ug.com';//$data['from_email'];
        $body=$data['body'];
        $pdf_file=isset($data['pdf_file']) ? $data['pdf_file'] : '';
        $pdf_file_name=isset($data['pdf_file_name']) ? $data['pdf_file_name'] : '';
        $ccEmails=isset($data['customer_cc_email']) ? $data['customer_cc_email'] : array();
        $files=isset($data['files']) ? $data['files'] : array();
        $this->from($from_email,env('APP_NAME', 'Bakertilly'))->subject($subject)->view('email.email_templete',compact('body'));
        if($pdf_file != ''){
            $this->attachData($pdf_file->output(),$pdf_file_name);
        }    
        if(count($ccEmails) > 0){
            $this->cc($ccEmails);
        }    
        if(count($files) > 0){
            foreach ($files as $file){
                $this->attach($file);
            }
        }    
        return $this;
     }
}