<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class Company extends Model
{
    use SoftDeletes;

    protected $table = 'companys';

    protected $dates = ['deleted_at'];
    protected $softDelete = true;

    protected $fillable = [
       'id','name','address','country_id','state_id','city_id','phone_number','pincode_number','year_end','email_address','password','sequence','status', 'district'
    ];
    public static function boot()
    {
        parent::boot();
        self::creating(function ($model) {
            $final = mt_rand(100000,999999); 
            $model->attributes['uuid'] = $final;
        });
    }
    public function City()
    {
        return $this->belongsTo(City::class, 'city_id', 'id');
    }

    public function Country()
    {
        return $this->belongsTo(Country::class, 'country_id', 'id');
    }

    public function State()
    {
        return $this->belongsTo(State::class, 'state_id', 'id');
    }
}
