<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class CustomerContactDetail extends Model
{
    use SoftDeletes;

    protected $table = 'customer_contact_details';

    protected $dates = ['deleted_at'];
    protected $softDelete = true;

    protected $fillable = [
       'id','customer_id','name','email','mobile_number','status'
    ];
    public static function boot()
    {
        parent::boot();
        self::creating(function ($model) {
            $final = mt_rand(100000,999999); 
            $model->attributes['uuid'] = $final;
        });
    }
    public function Reminder()
    {
        return $this->belongsTo(Reminder::class, 'reminder_id', 'id');
    }
    public function Document()
    {
        return $this->belongsTo(Document::class, 'document_id', 'id');
    }
    public function CustomerUser()
    {
        return $this->belongsTo(CustomerUser::class, 'customer_id', 'id');
    }
    public function DocumentList()
    {
        return $this->hasMany(Document::class, 'id', 'document_id');
    }
}
