<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class CustomerUser extends Model
{
    use SoftDeletes;

    protected $table = 'customer_users';

    protected $dates = ['deleted_at'];
    protected $softDelete = true;

    protected $fillable = [
       'id','group_id','name','address','country_id','state_id','city_id','phone_number','pincode_number','year_end','email_address','password','sequence','status', 'district'
    ];
    public static function boot()
    {
        parent::boot();
        self::creating(function ($model) {
            $final = mt_rand(100000,999999); 
            $model->attributes['uuid'] = $final;
        });
    }
    public function Group()
    {
        return $this->belongsTo(Group::class, 'group_id', 'id');
    }
    public function City()
    {
        return $this->belongsTo(City::class, 'city_id', 'id');
    }

    public function Country()
    {
        return $this->belongsTo(Country::class, 'country_id', 'id');
    }

    public function State()
    {
        return $this->belongsTo(State::class, 'state_id', 'id');
    }
}
