<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class EmailContent extends Model
{
    use SoftDeletes;

    protected $table = 'email_contents';

    protected $dates = ['deleted_at'];
    protected $softDelete = true;

    protected $fillable = [
       'title','subject','content','status'
    ];
    public static function boot()
    {
        parent::boot();
        self::creating(function ($model) {
            $final = mt_rand(100000,999999); 
            $model->attributes['uuid'] = $final;
        });
    }

}
