<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class EmailContentAttachment extends Model
{
    use SoftDeletes;

    protected $table = 'email_contents_attachments';

    protected $dates = ['deleted_at'];
    protected $softDelete = true;

    protected $fillable = [
       'email_contents_id','org_upload_document','upload_document','status'
    ];
    public static function boot()
    {
        parent::boot();
        self::creating(function ($model) {
            $final = mt_rand(100000,999999); 
            $model->attributes['uuid'] = $final;
        });
    }

}
