<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class EmployeeUser extends Model
{
    use SoftDeletes;

    protected $table = 'employee_users';

    protected $dates = ['deleted_at'];
     protected $appends = ['logo_image_url','qr_image_url','profile_image_url'];
    protected $softDelete = true;

    protected $fillable = [
       'id','designation','name','address','phone_number','email_address','sequence','status'
    ];
    public static function boot()
    {
        parent::boot();
        self::creating(function ($model) {
            $final = mt_rand(100000,999999); 
            $model->attributes['uuid'] = $final;
        });
    }
    public function getLogoImageUrlAttribute()
    {
        $logo_image_url = '';
        $destinationPath = 'images/employee_user/';
        if ($this->logo_image != '') {
            $image = $destinationPath.$this->logo_image;
            if(file_exists($image)){
                $logo_image_url = url('/') .'/'.$image;    
            }
        }
        if($logo_image_url == ''){
            $logo_image_url = asset("images/default-user-logo.png");
        }
        return $logo_image_url;
    }
    public function getQrImageUrlAttribute()
    {
        $qr_image_url = '';
        $destinationPath = 'images/employee_user_qr/';
        if ($this->qr_image != '') {
            $image = $destinationPath.$this->qr_image;
            if(file_exists($image)){
                $qr_image_url = url('/') .'/'.$image;    
            }
        }
        return $qr_image_url;
    }
    public function getProfileImageUrlAttribute()
    {
        $profile_image_url = '';
        $destinationPath = 'images/profile/';
        if ($this->profile_image != '') {
            $image = $destinationPath.$this->profile_image;
            if(file_exists($image)){
                $profile_image_url = url('/') .'/'.$image;    
            }
        }
        return $profile_image_url;
    }
}
