<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class MailSendLog extends Model
{
    use SoftDeletes;

    protected $table = 'mail_send_logs';

    protected $dates = ['deleted_at'];
    protected $softDelete = true;

    protected $fillable = [
       'id','name'
    ];
    public static function boot()
    {
        parent::boot();
        self::creating(function ($model) {
            $final = mt_rand(100000,999999); 
            $model->attributes['uuid'] = $final;
        });
    }
    public function Reminder()
    {
        return $this->belongsTo(Reminder::class, 'reminder_id', 'id');
    }
    public function DocumentList(){
        return $this->hasMany(MailSendLogDocument::class);//
    }
}
