<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class MailSendLogDocument extends Model
{
    use SoftDeletes;

    protected $table = 'mail_send_log_documents';

    protected $dates = ['deleted_at'];
    protected $softDelete = true;

    protected $fillable = [
       'id','mail_send_log_id','document_id'
    ];
    public static function boot()
    {
        parent::boot();
        self::creating(function ($model) {
            $final = mt_rand(100000,999999); 
            $model->attributes['uuid'] = $final;
        });
    }
    public function Document()
    {
        return $this->belongsTo(Document::class, 'document_id', 'id');
    }
}
