<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class MassEmail extends Model
{
    use SoftDeletes;

    protected $table = 'mass_emails';

    protected $dates = ['deleted_at'];
    protected $softDelete = true;

    protected $fillable = [
       'title','subject','content','login_user_id','from_email','status'
    ];
    public static function boot()
    {
        parent::boot();
        self::creating(function ($model) {
            $final = mt_rand(100000,999999); 
            $model->attributes['uuid'] = $final;
        });
    }

}
