<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class MassEmailAttachment extends Model
{
    use SoftDeletes;

    protected $table = 'mass_email_attachments';

    protected $dates = ['deleted_at'];
    protected $softDelete = true;

    protected $fillable = [
       'mass_email_id','org_upload_document','upload_document','status'
    ];
    public static function boot()
    {
        parent::boot();
        self::creating(function ($model) {
            $final = mt_rand(100000,999999); 
            $model->attributes['uuid'] = $final;
        });
    }

}
