<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class Quotation extends Model
{
    use SoftDeletes;

    protected $table = 'quotations';

    protected $dates = ['deleted_at'];
    protected $softDelete = true;

    protected $fillable = [
       'id','name','description','status'
    ];
    public static function boot()
    {
        parent::boot();
        self::creating(function ($model) {
            $final = mt_rand(100000,999999); 
            $model->attributes['uuid'] = $final;
        });
    }
    public function Currency()
    {
        return $this->belongsTo(Currency::class, 'currency_id', 'id');
    }
    public function Company()
    {
        return $this->belongsTo(Company::class, 'company_id', 'id');
    }
    public function QuotationServiceList()
    {
        return $this->hasMany(QuotationService::class, 'quotation_id', 'id');
    }
}
