<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class QuotationService extends Model
{
    use SoftDeletes;

    protected $table = 'quotation_service';

    protected $dates = ['deleted_at'];
    protected $softDelete = true;

    protected $fillable = [
       'id','quotation_id','customer_id','service_id','status'
    ];
    public static function boot()
    {
        parent::boot();
        self::creating(function ($model) {
            $final = mt_rand(100000,999999); 
            $model->attributes['uuid'] = $final;
        });
    }
    public function Quotation()
    {
        return $this->belongsTo(Quotation::class, 'quotation_id', 'id');
    }
    public function Service()
    {
        return $this->belongsTo(Service::class, 'service_id', 'id');
    }
    public function CustomerUser()
    {
        return $this->belongsTo(CustomerUser::class, 'customer_id', 'id');
    }
}
