<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class SchedulerReminderCustomerDocument extends Model
{
    use SoftDeletes;

    protected $table = 'scheduler_reminder_customer_documents';

    protected $dates = ['deleted_at'];
    protected $softDelete = true;

    protected $fillable = [
       'id','scheduler_reminder_id','customer_id','document_id','upload_document','org_upload_document','upload_datetime','status'
    ];
    public static function boot()
    {
        parent::boot();
        self::creating(function ($model) {
            $final = mt_rand(100000,999999); 
            $model->attributes['uuid'] = $final;
        });
    }
}
