<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class State extends Model
{
    use SoftDeletes;

    protected $table = 'state';

    protected $dates = ['deleted_at'];
    protected $softDelete = true;

    protected $fillable = [
       'id','country_id','name','sequence','status'
    ];
    public static function boot()
    {
        parent::boot();
        self::creating(function ($model) {
            $final = mt_rand(100000,999999); 
            $model->attributes['uuid'] = $final;
        });
    }

    public function Country()
    {
        return $this->belongsTo(Country::class, 'country_id', 'id');
    }
}
