<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable,SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $dates = ['deleted_at'];
    protected $softDelete = true;
    protected $fillable = [
        'name',
        'email',
        'password',
    ];
    protected $appends = ['logo_image_url','qr_image_url','profile_image_url'];
    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];
    public function getLogoImageUrlAttribute()
    {
        $logo_image_url = '';
        $destinationPath = 'images/admin_user/';
        if ($this->logo_image != '') {
            $image = $destinationPath.$this->logo_image;
            if(file_exists($image)){
                $logo_image_url = url('/') .'/'.$image;    
            }
        }
        if($logo_image_url == ''){
            $logo_image_url = asset("images/default-user-logo.png");
        }
        return $logo_image_url;
    }
    public function getQrImageUrlAttribute()
    {
        $qr_image_url = '';
        $destinationPath = 'images/admin_user_qr/';
        if ($this->qr_image != '') {
            $image = $destinationPath.$this->qr_image;
            if(file_exists($image)){
                $qr_image_url = url('/') .'/'.$image;    
            }
        }
        return $qr_image_url;
    }
    public function getProfileImageUrlAttribute()
    {
        $profile_image_url = '';
        $destinationPath = 'images/profile/';
        if ($this->profile_image != '') {
            $image = $destinationPath.$this->profile_image;
            if(file_exists($image)){
                $profile_image_url = url('/') .'/'.$image;    
            }
        }
        return $profile_image_url;
    }
}
