<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;
use App\Models\ProductImage;

class MaxImagesPerProduct implements Rule
{
    protected $productId;

    public function __construct($productId)
    {
        $this->productId = $productId;
    }

    public function passes($attribute, $value)
    {
        $product = ProductImage::where('product_id',$this->productId)->count();
        if (!$product) {
            return false; // If the product does not exist, validation fails
        }
        
        $existingImagesCount = $product;
        $newImagesCount = count($value);

        return ($existingImagesCount + $newImagesCount) <= 4;
    }

    public function message()
    {
        return 'A product can have a maximum of 4 images.';
    }
}
