@extends('admin.layout.main')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-8 col-12 mb-2">
                <h3 class="content-header-title">
                    @if(isset($data)) 
                        Edit 
                    @else 
                        Add 
                    @endif
                    Admin User Management
                </h3>
            </div>
            <div class="content-header-right col-md-4 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('admin.user.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                
                            </div>
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    <form method="POST" onsubmit="return fun_frm_submit();" enctype="multipart/form-data" action="@if(isset($data)){{ route('admin.user.update',$data->id) }} @else{{ route('admin.user.store') }}@endif">
                                        @csrf
                                        @if(isset($data))
                                            <input type="hidden" name="id" value="{{ $data->id }}" />
                                        @endif
                                        <div class="form-body">	 
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="role_name">Role<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <?php 
                                                    $role_array = config('constants.ROLE_LIST');
                                                    ?>
                                                    <select class="select2-size-lg form-control large-select"  id="role_name" name="role_name">
                                                        <option value="">Select Role</option>
                                                        @if($role_array)
                                                            @foreach ($role_array as $value_data)
                                                            <option value="{{$value_data}}"
                                                            @if(old('role_name', isset($data) ? $data->role_name : null) == $value_data) selected @endif>{{$value_data}}</option>
                                                            @endforeach  
                                                        @endif  
                                                    </select>
                                                    @if ($errors->has('role_name')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('role_name') }}</div>
                                                    @endif
                                                </div>
                                            </div>                   		
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">Name<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" id="name" class="form-control" name="name" value="{{{ old('name', isset($data) ? $data->name : null) }}}">
                                                    @if ($errors->has('name')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('name') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="designation">Designation<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text" id="designation" class="form-control" name="designation" value="{{{ old('designation', isset($data) ? $data->designation : null) }}}">
                                                    @if ($errors->has('designation')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('designation') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="phonecode">Mobile Number<span class="required">*</span></label>
                                                <div class="col-md-2">
                                                    <select class="select2-size-lg form-control large-select"  id="phonecode" name="phonecode">
                                                    <option value="">Select Phone Code</option>
                                                        @if(is_object($countryphonecode) && count($countryphonecode) > 0)
                                                            @foreach($countryphonecode as $countryphonecode_val)
                                                                <option value="{{$countryphonecode_val->phonecode}}" @if(old('phonecode', isset($data) ? $data->phonecode : null) == $countryphonecode_val->phonecode) selected @endif>{{$countryphonecode_val->phonecode}} ({{$countryphonecode_val->name}})</option>
                                                            @endforeach 
                                                        @endif    
                                                    </select>
                                                    @if ($errors->has('phonecode')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('phonecode') }}</div>
                                                    @endif
                                                </div>
                                                <div class="col-md-7">
                                                    <input type="number" id="mobile" class="form-control" name="mobile" value="{{{ old('mobile', isset($data) ? $data->mobile : null) }}}">
                                                    @if ($errors->has('phonecode')) 
                                                        
                                                    @elseif ($errors->has('mobile')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('mobile') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="email">Email<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="email" id="email" class="form-control" name="email" value="{{{ old('email', isset($data) ? $data->email : null) }}}">
                                                    @if ($errors->has('email')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('email') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">Logo Image</label>
                                                <div class="col-md-9">
                                                    <input type="file" id="logo_image" class="form-control" name="logo_image" value="">
                                                    @if ($errors->has('logo_image'))
                                                        <div class="errors_msg text-danger">{{ $errors->first('logo_image') }}</div>
                                                    @endif
                                                    <p>Allow type: jpeg, png, jpg.</p>
                                                    <?php 
                                                    $logo_image_url = isset($data) ? $data->logo_image_url : '';
                                                    ?>
                                                    @if($logo_image_url != '')
                                                        <img src="{{$logo_image_url  }}" width="100">
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="password">Password @if(empty($data->id))<span class="required">*</span>@endif</label>
                                                <div class="col-md-9">
                                                    <input type="text" id="password" class="form-control" name="password" value="{{{ old('password', null) }}}">
                                                    @if(!empty($data->id))
                                                        <span>If you enter the password, it will update; otherwise, it will not.</span>
                                                    @endif
                                                    @if ($errors->has('password')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('password') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <?php 
                                            $Menu_permision_array = config('constants.Menu_permision');
                                            ?>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="password">Permision</label>
                                                <div class="col-md-9 row">
                                                    @foreach ($Menu_permision_array as $value_key=>$value_data_array)
                                                        @if(count($value_data_array) > 0)
                                                            <div class="col-md-12 row form-actions" style="margin-top: 0px;padding: 6px 0px;">
                                                                <div class="col-md-2">    
                                                                    <strong>{{$value_key}}</strong>
                                                                </div>
                                                                <div class="col-md-9 row">    
                                                                    @foreach ($value_data_array as $inner_value_key=>$inner_value_data)
                                                                        <div class="col-md-4"> 
                                                                            <input type="checkbox" id="permision_{{$inner_value_key}}" class="form-control1" name="permision[]" value="{{$inner_value_key}}"
                                                                            @if(old('permision') != '')
                                                                                @if(in_array($inner_value_key,old('permision')))
                                                                                    checked
                                                                                @endif
                                                                            @elseif(isset($selected_permision))
                                                                                @if(in_array($inner_value_key,$selected_permision))
                                                                                    checked
                                                                                @endif
                                                                            @endif
                                                                            >
                                                                            <label for="permision_{{$inner_value_key}}">{{$inner_value_data}}</label>
                                                                        </div>
                                                                    @endforeach   
                                                                </div>
                                                            </div>   
                                                        @endif    
                                                    @endforeach  
                                        </div>
                                            </div>
                                            <div class="form-actions center">
                                                <input class="btn btn-primary submit btn-sm" name="save_exit" type="submit" value="Save & Exit">
                                                <input class="btn btn-primary submit btn-sm" name="save" type="submit" value="Save">
                                                <a href="{{URL::full()}}" class="btn btn-danger mr-1 btn-sm">Reset</a>
                                            </div>
                                        </div>    
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection
@section('js')
<script type="text/javascript">
$(document).ready(function() {
    $('#role_name').select2({
        placeholder: "Select Role", // Optional: add a placeholder
        allowClear: true // Optional: allows the user to clear the selection
    });
    $('#phonecode').select2({
        placeholder: "Select Phone Code", // Optional: add a placeholder
        allowClear: true // Optional: allows the user to clear the selection
    });
});
function fun_frm_submit(){
    $('.loader_block').show();
}
</script>
@endsection
