@extends('admin.layout.main')
@section('content')
<!-- BEGIN: Content-->
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before"></div>
        <div class="content-header row">
            <div class="content-header-left col-md-4 col-12 mb-2">
                <h3 class="content-header-title">
                    @if(isset($city)) 
                        Edit 
                    @else 
                        Add 
                    @endif
                    City Management
                </h3>
            </div>
            <div class="content-header-right col-md-8 col-12">
                <div class="breadcrumbs-top float-md-right">
                    <div class="breadcrumb-wrapper mr-1">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{ route('city.index') }}"><button type="button" class="btn btn-glow btn-bg-gradient-x-purple-red back_btn btn-sm"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button></a>
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-body">
            <section id="horizontal-form-layouts">
                <div class="row">
                    <div class="col-xl-12 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                
                            </div>
                            <div class="card-content collpase show">
                                <div class="card-body">
                                    <form method="POST" onsubmit="return fun_frm_submit();" enctype="multipart/form-data" action="@if(isset($city)){{ route('city.update',$city->id) }} @else{{ route('city.store') }}@endif">
                                        @csrf
                                        @if(isset($city))
                                            @method('PUT')
                                            <input type="hidden" name="id" value="{{ $city->id }}" />
                                        @endif
                                        <div class="form-body">	                    		
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">City Name<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="text"  autocomplete="off" id="name" class="form-control input-suggestion" name="name" value="{{{ old('name', isset($city) ? $city->name : null) }}}">
                                                    @if(is_object($cities) && count($cities) > 0)
                                                    <datalist role="listbox" class="suggetion-datalist">
                                                        @foreach($cities as $city)
                                                        <option value="{{ $city->name }}">{{$city->name}}, {{$city->State->name}}, {{$city->Country->name}}.</option>
                                                        @endforeach
                                                    </datalist>
                                                    @endif
                                                    @if ($errors->has('name')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('name') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">Country<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <select class="select2-size-lg form-control large-select"  id="country_id" name="country_id">
                                                        <option value="">Select Country</option>
                                                        @if(is_object($country))
                                                            @foreach ($country as $value)
                                                            <option value="{{$value->id}}"
                                                            @if(old('country_id', isset($city) ? $city->country_id : null) == $value->id) selected @elseif($value->name == 'India') selected @endif>{{$value->name}}</option>
                                                            @endforeach  
                                                        @endif  
                                                    </select>
                                                    @if ($errors->has('country_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('country_id') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="name">State<span class="required">*</span></label>
                                                <div class="col-md-9" id="state_section">
                                                    <select class="select2-size-lg form-control large-select"  id="state_id" name="state_id">
                                                        
                                                    </select>
                                                    @if ($errors->has('state_id')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('state_id') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label class="col-md-2 label-control" for="sequence">Sort order<span class="required">*</span></label>
                                                <div class="col-md-9">
                                                    <input type="number" id="sequence" class="form-control" name="sequence" value="{{{ old('sequence', isset($city) ? $city->sequence : null) }}}">
                                                    @if ($errors->has('sequence')) 
                                                        <div class="errors_msg text-danger">{{ $errors->first('sequence') }}</div>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="form-actions center">
                                                <input class="btn btn-primary submit btn-sm" name="save_exit" type="submit" value="Save & Exit">
                                                <input class="btn btn-primary submit btn-sm" name="save" type="submit" value="Save">
                                                <a href="{{URL::full()}}" class="btn btn-danger mr-1 btn-sm">Reset</a>
                                            </div>
                                        </div>    
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
@endsection
@section('js')
<script type="text/javascript">
function fun_frm_submit(){
    $('.loader_block').show();
}
$('#country_id').select2({
    placeholder: "Select Country", // Optional: add a placeholder
    allowClear: true // Optional: allows the user to clear the selection
});

$('#state_id').select2({
    placeholder: "Select State", // Optional: add a placeholder
    allowClear: true // Optional: allows the user to clear the selection
});

function getState(country_id,state_id=null){
    if(country_id){
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url : "{{ url('getState') }}" +'/'+ country_id,        
            type : 'GET',
            dataType : 'json',
            success : function(data){

                $('#state_id').empty();
                $('#state_id').append('<option value="">Select State</option>');
                $.each(data, function(key, state) {
                    var selected = state.id == state_id ? 'selected' : '';
                    $('#state_id').append('<option value="' + state.id + '" '+selected+ '>' + state.name + '</option>');
                });
                $('#state_id').prop('disabled', false);

            }
        });
    } else {
        $('#state_id').empty();
        $('#state_id').append('<option value="">Select State</option>');
        $('#state_id').prop('disabled', true);
    }
}
$('#country_id').on('change',function(){
    var country_id = this.value;
    getState(country_id);
});

@if(old('country_id'))
    getState('{{old("country_id")}}','{{old("state_id")}}');
@elseif(isset($city) && $city->country_id)
    getState('{{$city->country_id}}','{{$city->state_id}}');
@else
    getState('1');
@endif
</script>
@endsection
